/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.printing.ui.utils;

import com.thinkbuzan.gaia.printing.ui.i18n.PrintingUII18N;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class JFontDialog
extends JDialog {
    private static final long serialVersionUID = -2719422175776167358L;
    private transient JList fontFamilyList = null;
    private transient JList fontStyleList = null;
    private transient JList fontSizeList = null;
    private transient JColorChooser colorChooser = null;
    private static final JLabel PREVIEW_LABEL = new JLabel(PrintingUII18N.getLocalizedText("com.thinkbuzan.i18n.printingui.winlinux.fontdialog.previewlabel"));
    private transient Font font = null;
    private transient Color fontColor = null;
    private static final int DIALOG_WIDTH = 450;
    private static final int DIALOG_HEIGHT = 400;

    public JFontDialog(Font fontIn, Color colorIn) {
        super(JOptionPane.getRootFrame(), PrintingUII18N.getLocalizedText("com.thinkbuzan.i18n.printingui.winlinux.fontdialog"), true);
        this.setLayout(new BorderLayout());
        this.setSize(450, 400);
        this.font = fontIn;
        this.fontColor = colorIn;
        this.initComplete();
    }

    private void initComplete() {
        this.initFontLists();
        this.add((Component)this.getFontChooserPane(), "North");
        this.add((Component)this.getColorPanel(), "Center");
        JPanel southPanel = new JPanel(new BorderLayout());
        int southPanelWidth = 100;
        southPanel.setPreferredSize(new Dimension(450, 100));
        southPanel.add((Component)this.getFontPreviewPane(), "North");
        southPanel.add((Component)this.getButtonsPanel(), "South");
        this.add((Component)southPanel, "South");
        this.addFontSelectListeners();
        this.initFont();
    }

    private void initFontLists() {
        String[] fontStyles = new String[]{PrintingUII18N.getLocalizedText("com.thinkbuzan.i18n.common.plain"), PrintingUII18N.getLocalizedText("com.thinkbuzan.i18n.common.bold"), PrintingUII18N.getLocalizedText("com.thinkbuzan.i18n.common.italic"), PrintingUII18N.getLocalizedText("com.thinkbuzan.i18n.common.italicBold")};
        String[] fontSizes = new String[]{"8", "9", "10", "11", "12", "13", "14", "15", "16", "18", "20", "22", "24", "28", "32", "36", "40", "44", "48"};
        String[] fontFamilies = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        this.fontFamilyList = new JList<String>(fontFamilies);
        this.fontStyleList = new JList<String>(fontStyles);
        this.fontSizeList = new JList<String>(fontSizes);
    }

    private void initFont() {
        if (null == this.fontColor) {
            this.fontColor = Color.BLACK;
        }
        this.fontColorSelection();
        if (null == this.font) {
            this.fontFamilyList.setSelectedIndex(0);
            this.fontStyleList.setSelectedIndex(0);
            this.fontSizeList.setSelectedIndex(0);
            return;
        }
        this.fontFamilyList.setSelectedValue(this.font.getFamily(), true);
        this.fontStyleList.setSelectedIndex(this.font.getStyle());
        this.fontSizeList.setSelectedValue(Integer.toString(this.font.getSize()), true);
    }

    private void addFontSelectListeners() {
        this.fontFamilyList.addListSelectionListener(this.getFontFamilySelectionListener());
        this.fontStyleList.addListSelectionListener(this.getFontStyleSelectionListener());
        this.fontSizeList.addListSelectionListener(this.getFontSizeSelectionListener());
        this.colorChooser.getSelectionModel().addChangeListener(this.getFontColorSelectionListener());
    }

    private ListSelectionListener getFontFamilySelectionListener() {
        return new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent arg) {
                String family = (String)JFontDialog.this.fontFamilyList.getSelectedValue();
                Font tempFont = JFontDialog.this.font;
                JFontDialog.this.font = new Font(family, tempFont.getStyle(), tempFont.getSize());
                PREVIEW_LABEL.setFont(JFontDialog.this.font);
            }
        };
    }

    private ListSelectionListener getFontStyleSelectionListener() {
        return new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent arg0) {
                int style = 0;
                switch (JFontDialog.this.fontStyleList.getSelectedIndex()) {
                    case 0: {
                        style = 0;
                        break;
                    }
                    case 1: {
                        style = 1;
                        break;
                    }
                    case 2: {
                        style = 2;
                        break;
                    }
                    default: {
                        style = 3;
                    }
                }
                Font tempFont = JFontDialog.this.font;
                JFontDialog.this.font = new Font(tempFont.getFamily(), style, tempFont.getSize());
                PREVIEW_LABEL.setFont(JFontDialog.this.font);
            }
        };
    }

    private ListSelectionListener getFontSizeSelectionListener() {
        return new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent arg0) {
                Font tempFont = JFontDialog.this.font;
                int size = Integer.parseInt((String)JFontDialog.this.fontSizeList.getSelectedValue());
                JFontDialog.this.font = new Font(tempFont.getFamily(), tempFont.getStyle(), size);
                PREVIEW_LABEL.setFont(JFontDialog.this.font);
            }
        };
    }

    private ChangeListener getFontColorSelectionListener() {
        return new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                JFontDialog.this.fontColorSelection();
            }
        };
    }

    private void fontColorSelection() {
        this.fontColor = this.colorChooser.getColor();
        PREVIEW_LABEL.setForeground(this.colorChooser.getColor());
        PREVIEW_LABEL.repaint();
    }

    private JPanel getFontChooserPane() {
        JPanel panel = new JPanel(new GridLayout(1, 3));
        int fontChoosePaneHeight = 110;
        panel.setPreferredSize(new Dimension(450, 110));
        panel.add(this.getFontFamiliesPane());
        panel.add(this.getFontStylesPane());
        panel.add(this.getFontSizesPane());
        return panel;
    }

    private JScrollPane getFontFamiliesPane() {
        JScrollPane scrollPane = new JScrollPane(this.fontFamilyList);
        scrollPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.GRAY), PrintingUII18N.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.family")));
        scrollPane.setHorizontalScrollBarPolicy(31);
        return scrollPane;
    }

    private JScrollPane getFontStylesPane() {
        JScrollPane scrollPane = new JScrollPane(this.fontStyleList);
        scrollPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.GRAY), PrintingUII18N.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.style")));
        scrollPane.setHorizontalScrollBarPolicy(31);
        return scrollPane;
    }

    private JScrollPane getFontSizesPane() {
        JScrollPane scrollPane = new JScrollPane(this.fontSizeList);
        scrollPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.GRAY), PrintingUII18N.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.size")));
        scrollPane.setHorizontalScrollBarPolicy(31);
        return scrollPane;
    }

    private JPanel getFontPreviewPane() {
        JPanel panel = new JPanel(new FlowLayout());
        int fontPreviewPaneHeight = 70;
        panel.setPreferredSize(new Dimension(450, 70));
        panel.add(PREVIEW_LABEL);
        return panel;
    }

    private JPanel getButtonsPanel() {
        JPanel panel = new JPanel(new FlowLayout(1, 10, 0));
        panel.add(Box.createGlue());
        JButton okButton = new JButton(PrintingUII18N.getLocalizedText("com.thinkbuzan.i18n.printingui.winlinux.button.ok"));
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                JFontDialog.this.setVisible(false);
            }
        });
        panel.add(okButton);
        JButton cancelButton = new JButton(PrintingUII18N.getLocalizedText("com.thinkbuzan.i18n.printingui.winlinux.button.cancel"));
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                JFontDialog.this.setVisible(false);
            }
        });
        panel.add(cancelButton);
        return panel;
    }

    private JComponent getColorPanel() {
        this.colorChooser = new JColorChooser(this.fontColor);
        this.colorChooser.setPreviewPanel(new JPanel());
        return this.colorChooser;
    }

    public final Font getFont(Component componentIn) {
        super.setLocationRelativeTo(componentIn);
        super.setVisible(true);
        return this.font;
    }

    public final Color getFontColor() {
        return this.fontColor;
    }
}

