/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.layout;

import com.mxgraph.layout.mxGraphLayout;
import com.mxgraph.model.mxIGraphModel;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.view.mxGraph;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;

public class mxFastOrganicLayout
extends mxGraphLayout {
    protected boolean useInputOrigin = true;
    protected boolean resetEdges = true;
    protected boolean disableEdgeStyle = true;
    protected double forceConstant = 50.0;
    protected double forceConstantSquared = 0.0;
    protected double minDistanceLimit = 2.0;
    protected double minDistanceLimitSquared = 0.0;
    protected double initialTemp = 200.0;
    protected double temperature = 0.0;
    protected int maxIterations = 0;
    protected int iteration = 0;
    protected Object[] vertexArray;
    protected double[] dispX;
    protected double[] dispY;
    protected double[][] cellLocation;
    protected double[] radius;
    protected double[] radiusSquared;
    protected boolean[] isMoveable;
    protected int[][] neighbours;
    protected boolean allowedToRun = true;
    protected Hashtable<Object, Integer> indices = new Hashtable();

    public mxFastOrganicLayout(mxGraph mxGraph2) {
        super(mxGraph2);
    }

    @Override
    public boolean isVertexIgnored(Object object) {
        return super.isVertexIgnored(object) || this.graph.getConnections(object).length == 0;
    }

    public boolean isUseInputOrigin() {
        return this.useInputOrigin;
    }

    public void setUseInputOrigin(boolean bl) {
        this.useInputOrigin = bl;
    }

    public boolean isResetEdges() {
        return this.resetEdges;
    }

    public void setResetEdges(boolean bl) {
        this.resetEdges = bl;
    }

    public boolean isDisableEdgeStyle() {
        return this.disableEdgeStyle;
    }

    public void setDisableEdgeStyle(boolean bl) {
        this.disableEdgeStyle = bl;
    }

    public int getMaxIterations() {
        return this.maxIterations;
    }

    public void setMaxIterations(int n2) {
        this.maxIterations = n2;
    }

    public double getForceConstant() {
        return this.forceConstant;
    }

    public void setForceConstant(double d2) {
        this.forceConstant = d2;
    }

    public double getMinDistanceLimit() {
        return this.minDistanceLimit;
    }

    public void setMinDistanceLimit(double d2) {
        this.minDistanceLimit = d2;
    }

    public double getInitialTemp() {
        return this.initialTemp;
    }

    public void setInitialTemp(double d2) {
        this.initialTemp = d2;
    }

    protected void reduceTemperature() {
        this.temperature = this.initialTemp * (1.0 - (double)(this.iteration / this.maxIterations));
    }

    @Override
    public void moveCell(Object object, double d2, double d3) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Object object) {
        double d2;
        double d3;
        Object[] objectArray;
        Object object2;
        int n2;
        int n3 = mxGraphLayout.a;
        mxIGraphModel mxIGraphModel2 = this.graph.getModel();
        Object[] objectArray2 = this.graph.getChildVertices(object);
        ArrayList<Object> arrayList = new ArrayList<Object>(objectArray2.length);
        for (int i2 = 0; i2 < objectArray2.length; ++i2) {
            if (this.isVertexIgnored(objectArray2[i2])) continue;
            arrayList.add(objectArray2[i2]);
            if (n3 == 0) continue;
        }
        this.vertexArray = arrayList.toArray();
        mxRectangle mxRectangle2 = this.useInputOrigin ? this.graph.getBoundsForCells(this.vertexArray, false, false, true) : null;
        int n4 = this.vertexArray.length;
        this.dispX = new double[n4];
        this.dispY = new double[n4];
        this.cellLocation = new double[n4][];
        this.isMoveable = new boolean[n4];
        this.neighbours = new int[n4][];
        this.radius = new double[n4];
        this.radiusSquared = new double[n4];
        this.minDistanceLimitSquared = this.minDistanceLimit * this.minDistanceLimit;
        if (this.forceConstant < 0.001) {
            this.forceConstant = 0.001;
        }
        this.forceConstantSquared = this.forceConstant * this.forceConstant;
        for (n2 = 0; n2 < this.vertexArray.length; ++n2) {
            object2 = this.vertexArray[n2];
            this.cellLocation[n2] = new double[2];
            this.indices.put(object2, new Integer(n2));
            objectArray = this.getVertexBounds(object2);
            double d4 = objectArray.getWidth();
            d3 = objectArray.getHeight();
            d2 = objectArray.getX();
            double d5 = objectArray.getY();
            this.cellLocation[n2][0] = d2 + d4 / 2.0;
            this.cellLocation[n2][1] = d5 + d3 / 2.0;
            this.radius[n2] = Math.min(d4, d3);
            this.radiusSquared[n2] = this.radius[n2] * this.radius[n2];
            if (n3 == 0) continue;
        }
        mxIGraphModel2.beginUpdate();
        try {
            double d6;
            Serializable serializable;
            for (n2 = 0; n2 < n4; ++n2) {
                this.dispX[n2] = 0.0;
                this.dispY[n2] = 0.0;
                this.isMoveable[n2] = this.isVertexMovable(this.vertexArray[n2]);
                object2 = this.graph.getConnections(this.vertexArray[n2], object);
                for (int i3 = 0; i3 < ((Object[])object2).length; ++i3) {
                    if (this.isResetEdges()) {
                        this.graph.resetEdge(object2[i3]);
                    }
                    if (!this.isDisableEdgeStyle()) continue;
                    this.setEdgeStyleEnabled(object2[i3], false);
                    if (n3 == 0) continue;
                }
                objectArray = this.graph.getOpposites((Object[])object2, this.vertexArray[n2]);
                this.neighbours[n2] = new int[objectArray.length];
                for (int i4 = 0; i4 < objectArray.length; ++i4) {
                    serializable = this.indices.get(objectArray[i4]);
                    if (serializable != null) {
                        this.neighbours[n2][i4] = (Integer)serializable;
                        if (n3 == 0) continue;
                    }
                    this.neighbours[n2][i4] = n2;
                    if (n3 == 0) continue;
                }
                if (n3 == 0) continue;
            }
            this.temperature = this.initialTemp;
            if (this.maxIterations == 0) {
                this.maxIterations = (int)(20.0 * Math.sqrt(n4));
            }
            this.iteration = 0;
            while (this.iteration < this.maxIterations) {
                if (!this.allowedToRun) {
                    return;
                }
                this.calcRepulsion();
                this.calcAttraction();
                this.calcPositions();
                this.reduceTemperature();
                ++this.iteration;
                if (n3 == 0) continue;
            }
            Double d7 = null;
            object2 = null;
            for (int i5 = 0; i5 < this.vertexArray.length; ++i5) {
                block24: {
                    block23: {
                        Object object3 = this.vertexArray[i5];
                        serializable = mxIGraphModel2.getGeometry(object3);
                        if (serializable == null) continue;
                        double[] dArray = this.cellLocation[i5];
                        dArray[0] = dArray[0] - ((mxRectangle)serializable).getWidth() / 2.0;
                        double[] dArray2 = this.cellLocation[i5];
                        dArray2[1] = dArray2[1] - ((mxRectangle)serializable).getHeight() / 2.0;
                        d3 = this.graph.snap(this.cellLocation[i5][0]);
                        d2 = this.graph.snap(this.cellLocation[i5][1]);
                        this.setVertexLocation(object3, d3, d2);
                        if (d7 != null) break block23;
                        d7 = new Double(d3);
                        if (n3 == 0) break block24;
                    }
                    d7 = new Double(Math.min(d7, d3));
                }
                if (object2 == null) {
                    object2 = new Double(d2);
                    if (n3 == 0) continue;
                }
                object2 = new Double(Math.min(object2.doubleValue(), d2));
                if (n3 == 0) continue;
            }
            double d8 = d7 != null ? -d7.doubleValue() - 1.0 : 0.0;
            double d9 = d6 = object2 != null ? -object2.doubleValue() - 1.0 : 0.0;
            if (mxRectangle2 != null) {
                d8 += mxRectangle2.getX();
                d6 += mxRectangle2.getY();
            }
            this.graph.moveCells(this.vertexArray, d8, d6);
        }
        finally {
            mxIGraphModel2.endUpdate();
        }
        if (mxPoint.a != 0) {
            mxGraphLayout.a = ++n3;
        }
    }

    protected void calcPositions() {
        int n2 = mxGraphLayout.a;
        for (int i2 = 0; i2 < this.vertexArray.length; ++i2) {
            if (!this.isMoveable[i2]) continue;
            double d2 = Math.sqrt(this.dispX[i2] * this.dispX[i2] + this.dispY[i2] * this.dispY[i2]);
            if (d2 < 0.001) {
                d2 = 0.001;
            }
            double d3 = this.dispX[i2] / d2 * Math.min(d2, this.temperature);
            double d4 = this.dispY[i2] / d2 * Math.min(d2, this.temperature);
            this.dispX[i2] = 0.0;
            this.dispY[i2] = 0.0;
            double[] dArray = this.cellLocation[i2];
            dArray[0] = dArray[0] + d3;
            double[] dArray2 = this.cellLocation[i2];
            dArray2[1] = dArray2[1] + d4;
            if (n2 == 0) continue;
        }
    }

    protected void calcAttraction() {
        int n2 = mxGraphLayout.a;
        for (int i2 = 0; i2 < this.vertexArray.length; ++i2) {
            for (int i3 = 0; i3 < this.neighbours[i2].length; ++i3) {
                int n3 = this.neighbours[i2][i3];
                if (i2 == n3) continue;
                double d2 = this.cellLocation[i2][0] - this.cellLocation[n3][0];
                double d3 = this.cellLocation[i2][1] - this.cellLocation[n3][1];
                double d4 = d2 * d2 + d3 * d3 - this.radiusSquared[i2] - this.radiusSquared[n3];
                if (d4 < this.minDistanceLimitSquared) {
                    d4 = this.minDistanceLimitSquared;
                }
                double d5 = Math.sqrt(d4);
                double d6 = d4 / this.forceConstant;
                double d7 = d2 / d5 * d6;
                double d8 = d3 / d5 * d6;
                if (this.isMoveable[i2]) {
                    int n4 = i2;
                    this.dispX[n4] = this.dispX[n4] - d7;
                    int n5 = i2;
                    this.dispY[n5] = this.dispY[n5] - d8;
                }
                if (!this.isMoveable[n3]) continue;
                int n6 = n3;
                this.dispX[n6] = this.dispX[n6] + d7;
                int n7 = n3;
                this.dispY[n7] = this.dispY[n7] + d8;
                if (n2 == 0) continue;
            }
            if (n2 == 0) continue;
        }
    }

    protected void calcRepulsion() {
        int n2 = mxGraphLayout.a;
        int n3 = this.vertexArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            for (int i3 = i2; i3 < n3; ++i3) {
                double d2;
                double d3;
                if (!this.allowedToRun) {
                    return;
                }
                if (i3 == i2) continue;
                double d4 = this.cellLocation[i2][0] - this.cellLocation[i3][0];
                double d5 = this.cellLocation[i2][1] - this.cellLocation[i3][1];
                if (d4 == 0.0) {
                    d4 = 0.01 + Math.random();
                }
                if (d5 == 0.0) {
                    d5 = 0.01 + Math.random();
                }
                if ((d3 = (d2 = Math.sqrt(d4 * d4 + d5 * d5)) - this.radius[i2] - this.radius[i3]) < this.minDistanceLimit) {
                    d3 = this.minDistanceLimit;
                }
                double d6 = this.forceConstantSquared / d3;
                double d7 = d4 / d2 * d6;
                double d8 = d5 / d2 * d6;
                if (this.isMoveable[i2]) {
                    int n4 = i2;
                    this.dispX[n4] = this.dispX[n4] + d7;
                    int n5 = i2;
                    this.dispY[n5] = this.dispY[n5] + d8;
                }
                if (!this.isMoveable[i3]) continue;
                int n6 = i3;
                this.dispX[n6] = this.dispX[n6] - d7;
                int n7 = i3;
                this.dispY[n7] = this.dispY[n7] - d8;
                if (n2 == 0) continue;
            }
            if (n2 == 0) continue;
        }
    }
}

