/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.swing.handler;

import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.view.mxCellState;
import com.mxgraph.view.mxGraph;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;

public class mxCellHandler {
    protected mxGraphComponent graphComponent;
    protected mxCellState state;
    protected Rectangle[] handles;
    protected boolean handlesVisible = true;
    protected transient Rectangle bounds;
    protected transient JComponent preview;
    protected transient Point first;
    protected transient int index;
    public static boolean a;

    public mxCellHandler(mxGraphComponent mxGraphComponent2, mxCellState mxCellState2) {
        this.graphComponent = mxGraphComponent2;
        this.refresh(mxCellState2);
    }

    public boolean isActive() {
        return this.first != null;
    }

    public void refresh(mxCellState mxCellState2) {
        boolean bl = a;
        this.state = mxCellState2;
        this.handles = this.createHandles();
        mxGraph mxGraph2 = this.graphComponent.getGraph();
        mxRectangle mxRectangle2 = mxGraph2.getBoundingBox(mxCellState2.getCell());
        if (mxRectangle2 != null) {
            this.bounds = mxRectangle2.getRectangle();
            if (this.handles != null) {
                for (int i2 = 0; i2 < this.handles.length; ++i2) {
                    if (!this.isHandleVisible(i2)) continue;
                    this.bounds.add(this.handles[i2]);
                    if (!bl) continue;
                }
            }
        }
    }

    public mxGraphComponent getGraphComponent() {
        return this.graphComponent;
    }

    public mxCellState getState() {
        return this.state;
    }

    public int getIndex() {
        return this.index;
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public boolean isLabelMovable() {
        mxGraph mxGraph2 = this.graphComponent.getGraph();
        String string = mxGraph2.getLabel(this.state.getCell());
        return mxGraph2.isLabelMovable(this.state.getCell()) && string != null && string.length() > 0;
    }

    public boolean isHandlesVisible() {
        return this.handlesVisible;
    }

    public void setHandlesVisible(boolean bl) {
        this.handlesVisible = bl;
    }

    public boolean isLabel(int n2) {
        return n2 == this.getHandleCount() - 1;
    }

    protected Rectangle[] createHandles() {
        return null;
    }

    protected int getHandleCount() {
        return this.handles != null ? this.handles.length : 0;
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        return null;
    }

    public int getIndexAt(int n2, int n3) {
        boolean bl = a;
        if (this.handles != null && this.isHandlesVisible()) {
            int n4 = this.graphComponent.getTolerance();
            Rectangle rectangle = new Rectangle(n2 - n4 / 2, n3 - n4 / 2, n4, n4);
            for (int i2 = this.handles.length - 1; i2 >= 0; --i2) {
                if (!this.isHandleVisible(i2) || !this.handles[i2].intersects(rectangle)) continue;
                return i2;
            }
        }
        return -1;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!mouseEvent.isConsumed()) {
            int n2 = this.getIndexAt(mouseEvent.getX(), mouseEvent.getY());
            if (!this.isIgnoredEvent(mouseEvent) && n2 >= 0 && this.isHandleEnabled(n2)) {
                this.graphComponent.stopEditing(true);
                this.start(mouseEvent, n2);
                mouseEvent.consume();
            }
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        block2: {
            block3: {
                int n2;
                if (mouseEvent.isConsumed() || this.handles == null || (n2 = this.getIndexAt(mouseEvent.getX(), mouseEvent.getY())) < 0 || !this.isHandleEnabled(n2)) break block2;
                Cursor cursor = this.getCursor(mouseEvent, n2);
                if (cursor == null) break block3;
                this.graphComponent.getGraphControl().setCursor(cursor);
                mouseEvent.consume();
                if (!a) break block2;
            }
            this.graphComponent.getGraphControl().setCursor(new Cursor(12));
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.reset();
    }

    public void start(MouseEvent mouseEvent, int n2) {
        this.index = n2;
        this.first = mouseEvent.getPoint();
        this.preview = this.createPreview();
        if (this.preview != null) {
            this.graphComponent.getGraphControl().add((Component)this.preview, 0);
        }
    }

    protected boolean isIgnoredEvent(MouseEvent mouseEvent) {
        return this.graphComponent.isEditEvent(mouseEvent);
    }

    protected JComponent createPreview() {
        return null;
    }

    public void reset() {
        if (this.preview != null) {
            this.preview.setVisible(false);
            this.preview.getParent().remove(this.preview);
            this.preview = null;
        }
        this.first = null;
    }

    protected Cursor getCursor(MouseEvent mouseEvent, int n2) {
        return null;
    }

    public void paint(Graphics graphics) {
        boolean bl = a;
        if (this.handles != null && this.isHandlesVisible()) {
            for (int i2 = 0; i2 < this.handles.length; ++i2) {
                if (!this.isHandleVisible(i2) || !graphics.hitClip(this.handles[i2].x, this.handles[i2].y, this.handles[i2].width, this.handles[i2].height)) continue;
                graphics.setColor(this.getHandleFillColor(i2));
                graphics.fillRect(this.handles[i2].x, this.handles[i2].y, this.handles[i2].width, this.handles[i2].height);
                graphics.setColor(this.getHandleBorderColor(i2));
                graphics.drawRect(this.handles[i2].x, this.handles[i2].y, this.handles[i2].width - 1, this.handles[i2].height - 1);
                if (!bl) continue;
            }
        }
    }

    public Color getSelectionColor() {
        return null;
    }

    public Stroke getSelectionStroke() {
        return null;
    }

    protected boolean isHandleEnabled(int n2) {
        return true;
    }

    protected boolean isHandleVisible(int n2) {
        return !this.isLabel(n2) || this.isLabelMovable();
    }

    protected Color getHandleFillColor(int n2) {
        if (this.isLabel(n2)) {
            return mxConstants.LABEL_HANDLE_FILLCOLOR;
        }
        return mxConstants.HANDLE_FILLCOLOR;
    }

    protected Color getHandleBorderColor(int n2) {
        return mxConstants.HANDLE_BORDERCOLOR;
    }
}

