/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.util.svg;

import com.mxgraph.util.svg.ExtendedGeneralPath;
import com.mxgraph.util.svg.ParseException;
import com.mxgraph.util.svg.PathHandler;
import com.mxgraph.util.svg.PathParser;
import com.mxgraph.util.svg.ShapeProducer;
import java.awt.Shape;
import java.awt.geom.Point2D;

public class AWTPathProducer
implements PathHandler,
ShapeProducer {
    protected ExtendedGeneralPath path;
    protected float currentX;
    protected float currentY;
    protected float xCenter;
    protected float yCenter;
    protected int windingRule;

    public static Shape createShape(String string, int n2) throws ParseException {
        AWTPathProducer aWTPathProducer = new AWTPathProducer();
        aWTPathProducer.setWindingRule(n2);
        PathParser pathParser = new PathParser(aWTPathProducer);
        pathParser.parse(string);
        return aWTPathProducer.getShape();
    }

    @Override
    public void setWindingRule(int n2) {
        this.windingRule = n2;
    }

    @Override
    public int getWindingRule() {
        return this.windingRule;
    }

    @Override
    public Shape getShape() {
        return this.path;
    }

    @Override
    public void startPath() throws ParseException {
        this.currentX = 0.0f;
        this.currentY = 0.0f;
        this.xCenter = 0.0f;
        this.yCenter = 0.0f;
        this.path = new ExtendedGeneralPath(this.windingRule);
    }

    @Override
    public void endPath() throws ParseException {
    }

    @Override
    public void movetoRel(float f2, float f3) throws ParseException {
        this.xCenter = this.currentX += f2;
        this.yCenter = this.currentY += f3;
        this.path.moveTo(this.currentX, this.currentY);
    }

    @Override
    public void movetoAbs(float f2, float f3) throws ParseException {
        this.xCenter = this.currentX = f2;
        this.yCenter = this.currentY = f3;
        this.path.moveTo(this.currentX, this.currentY);
    }

    @Override
    public void closePath() throws ParseException {
        this.path.closePath();
        Point2D point2D = this.path.getCurrentPoint();
        this.currentX = (float)point2D.getX();
        this.currentY = (float)point2D.getY();
    }

    @Override
    public void linetoRel(float f2, float f3) throws ParseException {
        this.xCenter = this.currentX += f2;
        this.yCenter = this.currentY += f3;
        this.path.lineTo(this.currentX, this.currentY);
    }

    @Override
    public void linetoAbs(float f2, float f3) throws ParseException {
        this.xCenter = this.currentX = f2;
        this.yCenter = this.currentY = f3;
        this.path.lineTo(this.currentX, this.currentY);
    }

    @Override
    public void linetoHorizontalRel(float f2) throws ParseException {
        this.xCenter = this.currentX += f2;
        this.yCenter = this.currentY;
        this.path.lineTo(this.currentX, this.yCenter);
    }

    @Override
    public void linetoHorizontalAbs(float f2) throws ParseException {
        this.xCenter = this.currentX = f2;
        this.yCenter = this.currentY;
        this.path.lineTo(this.currentX, this.yCenter);
    }

    @Override
    public void linetoVerticalRel(float f2) throws ParseException {
        this.xCenter = this.currentX;
        this.yCenter = this.currentY += f2;
        this.path.lineTo(this.xCenter, this.currentY);
    }

    @Override
    public void linetoVerticalAbs(float f2) throws ParseException {
        this.xCenter = this.currentX;
        this.yCenter = this.currentY = f2;
        this.path.lineTo(this.xCenter, this.currentY);
    }

    @Override
    public void curvetoCubicRel(float f2, float f3, float f4, float f5, float f6, float f7) throws ParseException {
        this.xCenter = this.currentX + f4;
        this.yCenter = this.currentY + f5;
        this.path.curveTo(this.currentX + f2, this.currentY + f3, this.xCenter, this.yCenter, this.currentX += f6, this.currentY += f7);
    }

    @Override
    public void curvetoCubicAbs(float f2, float f3, float f4, float f5, float f6, float f7) throws ParseException {
        this.xCenter = f4;
        this.yCenter = f5;
        this.currentX = f6;
        this.currentY = f7;
        this.path.curveTo(f2, f3, this.xCenter, this.yCenter, this.currentX, this.currentY);
    }

    @Override
    public void curvetoCubicSmoothRel(float f2, float f3, float f4, float f5) throws ParseException {
        this.xCenter = this.currentX + f2;
        this.yCenter = this.currentY + f3;
        this.path.curveTo(this.currentX * 2.0f - this.xCenter, this.currentY * 2.0f - this.yCenter, this.xCenter, this.yCenter, this.currentX += f4, this.currentY += f5);
    }

    @Override
    public void curvetoCubicSmoothAbs(float f2, float f3, float f4, float f5) throws ParseException {
        this.xCenter = f2;
        this.yCenter = f3;
        this.currentX = f4;
        this.currentY = f5;
        this.path.curveTo(this.currentX * 2.0f - this.xCenter, this.currentY * 2.0f - this.yCenter, this.xCenter, this.yCenter, this.currentX, this.currentY);
    }

    @Override
    public void curvetoQuadraticRel(float f2, float f3, float f4, float f5) throws ParseException {
        this.xCenter = this.currentX + f2;
        this.yCenter = this.currentY + f3;
        this.path.quadTo(this.xCenter, this.yCenter, this.currentX += f4, this.currentY += f5);
    }

    @Override
    public void curvetoQuadraticAbs(float f2, float f3, float f4, float f5) throws ParseException {
        this.xCenter = f2;
        this.yCenter = f3;
        this.currentX = f4;
        this.currentY = f5;
        this.path.quadTo(this.xCenter, this.yCenter, this.currentX, this.currentY);
    }

    @Override
    public void curvetoQuadraticSmoothRel(float f2, float f3) throws ParseException {
        this.xCenter = this.currentX * 2.0f - this.xCenter;
        this.yCenter = this.currentY * 2.0f - this.yCenter;
        this.path.quadTo(this.xCenter, this.yCenter, this.currentX += f2, this.currentY += f3);
    }

    @Override
    public void curvetoQuadraticSmoothAbs(float f2, float f3) throws ParseException {
        this.xCenter = this.currentX * 2.0f - this.xCenter;
        this.yCenter = this.currentY * 2.0f - this.yCenter;
        this.currentX = f2;
        this.currentY = f3;
        this.path.quadTo(this.xCenter, this.yCenter, this.currentX, this.currentY);
    }

    @Override
    public void arcRel(float f2, float f3, float f4, boolean bl, boolean bl2, float f5, float f6) throws ParseException {
        this.xCenter = this.currentX += f5;
        this.yCenter = this.currentY += f6;
        this.path.arcTo(f2, f3, f4, bl, bl2, this.currentX, this.currentY);
    }

    @Override
    public void arcAbs(float f2, float f3, float f4, boolean bl, boolean bl2, float f5, float f6) throws ParseException {
        this.xCenter = this.currentX = f5;
        this.yCenter = this.currentY = f6;
        this.path.arcTo(f2, f3, f4, bl, bl2, this.currentX, this.currentY);
    }
}

