/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.pascal.ui.sidepanel.images.ui.list;

import com.thinkbuzan.gaia.editor.IEditorComponent;
import com.thinkbuzan.gaia.editor.listeners.EditorListener;
import com.thinkbuzan.gaia.ui.ButtonIconUtilities;
import com.thinkbuzan.pascal.services.images.model.IImage;
import com.thinkbuzan.pascal.ui.sidepanel.images.controller.ImageDndController;
import com.thinkbuzan.pascal.ui.sidepanel.images.license.BundleLicenser;
import com.thinkbuzan.pascal.ui.sidepanel.images.osgi.ServiceManager;
import com.thinkbuzan.pascal.ui.sidepanel.images.ui.list.ImagesListCellRenderer;
import com.thinkbuzan.pascal.ui.sidepanel.images.ui.list.ImagesListElement;
import com.thinkbuzan.pascal.ui.sidepanel.images.ui.list.ImagesListPanel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ImagesList
extends JList {
    private static final long serialVersionUID = 8884598223363402278L;
    private final transient DefaultListModel a;
    private final transient JPopupMenu b;
    private final transient JMenuItem c;
    private final transient JMenuItem d;
    private final transient JMenuItem e;
    private final transient JMenuItem f;
    private final transient ImagesListPanel g;
    private final transient boolean h;
    private transient ImagesListElement i;
    private transient boolean j;
    public static boolean k;
    private static final String[] z;

    public ImagesList(ImagesListPanel imagesListPanel) {
        block5: {
            block4: {
                this.a = new DefaultListModel();
                this.b = new JPopupMenu();
                this.a(imagesListPanel);
                this.g = imagesListPanel;
                this.setModel(this.a);
                this.setTransferHandler(new ImageDndController());
                this.setDragEnabled(true);
                this.setToolTipText(ServiceManager.getLocalizedText(z[5]));
                int n = 6;
                this.setFixedCellWidth(126);
                this.setFixedCellHeight(126);
                this.setLayoutOrientation(2);
                this.setCellRenderer(new ImagesListCellRenderer(this));
                this.h = BundleLicenser.isMultiMapLicensed();
                this.c = new JMenuItem(ServiceManager.getLocalizedText(z[1]));
                this.d = new JMenuItem(ServiceManager.getLocalizedText(z[3]));
                this.c.setEnabled(false);
                if (!this.h) break block4;
                this.d.setEnabled(false);
                if (!k) break block5;
            }
            this.d.setIcon(ButtonIconUtilities.getInstance().getDefaultUnlicensedIcon());
        }
        this.e = new JMenuItem(ServiceManager.getLocalizedText(z[4]));
        this.f = new JMenuItem(ServiceManager.getLocalizedText(z[2]));
        this.e();
        this.d();
        this.c();
        ServiceManager.getEditorManager().addEditorListener(new EditorListener(){

            public void editorChanged(IEditorComponent iEditorComponent) {
                ImagesList.this.a(iEditorComponent);
            }
        });
        try {
            this.a(ServiceManager.getEditorManager().getCurrentEditorComponent());
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private void a(ImagesListPanel imagesListPanel) {
        if (imagesListPanel == null) {
            throw new IllegalArgumentException(z[6]);
        }
    }

    private void a(boolean bl) {
        block3: {
            Object e;
            block2: {
                e = this.getSelectedValue();
                if (!(e instanceof ImagesListElement)) break block2;
                this.g.insertImage(((ImagesListElement)e).getImage(), bl);
                if (!k) break block3;
            }
            throw new IllegalArgumentException(z[0] + e);
        }
    }

    private void a() {
        block3: {
            Object e;
            block2: {
                e = this.getSelectedValue();
                if (!(e instanceof ImagesListElement)) break block2;
                this.g.insertImage(((ImagesListElement)e).getImage());
                if (!k) break block3;
            }
            throw new IllegalArgumentException(z[0] + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearImages() {
        DefaultListModel defaultListModel = this.a;
        synchronized (defaultListModel) {
            this.a.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addImages(List<IImage> list) {
        boolean bl = k;
        if (list != null) {
            DefaultListModel defaultListModel = this.a;
            synchronized (defaultListModel) {
                for (IImage iImage : list) {
                    this.a.addElement(new ImagesListElement(this, iImage));
                    if (!bl) continue;
                }
            }
        }
    }

    private final void a(IEditorComponent iEditorComponent) {
        this.j = iEditorComponent != null;
        this.c.setEnabled(this.j);
        if (this.h) {
            this.d.setEnabled(this.j);
        }
    }

    protected final ImagesListElement b() {
        return this.i;
    }

    private void c() {
        this.addMouseMotionListener(new MouseMotionListener(){

            public void mouseMoved(MouseEvent mouseEvent) {
                if (ImagesList.this.b.isVisible()) {
                    return;
                }
                ImagesList.this.a(mouseEvent.getPoint());
                ImagesList.this.repaint();
            }

            public void mouseDragged(MouseEvent mouseEvent) {
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                block5: {
                    block7: {
                        block8: {
                            boolean bl;
                            block6: {
                                bl = k;
                                super.mouseClicked(mouseEvent);
                                if (ImagesList.this.b.isVisible() && ImagesList.this.i == null) {
                                    return;
                                }
                                if (mouseEvent.getClickCount() != 1) break block5;
                                if (!SwingUtilities.isRightMouseButton(mouseEvent)) break block6;
                                ImagesList.this.f();
                                ImagesList.this.b.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                                if (!bl) break block7;
                            }
                            if (ImagesList.this.i == null || !SwingUtilities.isLeftMouseButton(mouseEvent)) break block7;
                            Rectangle rectangle = ImagesList.this.i.getFavIconBounds();
                            if (rectangle == null || !rectangle.contains(mouseEvent.getPoint())) break block8;
                            ImagesList.this.j();
                            ImagesList.this.repaint();
                            if (!bl) break block7;
                        }
                        if (ImagesList.this.j) {
                            ImagesList.this.a();
                        }
                    }
                    mouseEvent.consume();
                }
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                super.mouseEntered(mouseEvent);
                if (ImagesList.this.b.isVisible()) {
                    return;
                }
                ImagesList.this.a(mouseEvent.getPoint());
            }

            public void mouseExited(MouseEvent mouseEvent) {
                super.mouseExited(mouseEvent);
                if (ImagesList.this.b.isVisible()) {
                    return;
                }
                ImagesList.this.i = null;
                ImagesList.this.removeSelectionInterval(0, ImagesList.this.getModel().getSize() - 1);
                ImagesList.this.repaint();
            }
        });
    }

    private void a(Point point) {
        block6: {
            block5: {
                int n = this.locationToIndex(point);
                if (n < 0) break block5;
                ImagesListElement imagesListElement = (ImagesListElement)this.getModel().getElementAt(n);
                if (this.i != imagesListElement) {
                    this.i = imagesListElement;
                    this.setSelectedIndex(n);
                }
                if (!k) break block6;
            }
            if (this.i != null) {
                this.i = null;
            }
        }
    }

    private void d() {
        this.c.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ImagesList.this.a(false);
            }
        });
        this.d.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ImagesList.this.a(true);
            }
        });
    }

    private void e() {
        this.e.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ImagesList.this.h();
            }
        });
        this.f.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ImagesList.this.i();
            }
        });
    }

    private final void f() {
        block3: {
            block2: {
                this.b.removeAll();
                this.b.add(this.c);
                this.b.add(this.d);
                this.b.addSeparator();
                if (!this.g()) break block2;
                this.b.add(this.f);
                if (!k) break block3;
            }
            this.b.add(this.e);
        }
    }

    private boolean g() {
        boolean bl;
        block3: {
            block2: {
                Object e = this.getSelectedValue();
                if (!(e instanceof ImagesListElement) || !this.isFavourite((ImagesListElement)e)) break block2;
                bl = true;
                if (!k) break block3;
            }
            bl = false;
        }
        return bl;
    }

    public boolean isFavourite(ImagesListElement imagesListElement) {
        return imagesListElement != null && ServiceManager.getImageService().getFavouriteImagesService().isImageCached(imagesListElement.getImage());
    }

    private void h() {
        if (this.i != null) {
            ServiceManager.getImageService().getFavouriteImagesService().addImageToCache(this.i.getImage());
        }
    }

    private void i() {
        if (this.i != null) {
            ServiceManager.getImageService().getFavouriteImagesService().removeImageFromCache(this.i.getImage());
        }
    }

    private void j() {
        block2: {
            block3: {
                if (this.i == null) break block2;
                if (!this.isFavourite(this.i)) break block3;
                ServiceManager.getImageService().getFavouriteImagesService().removeImageFromCache(this.i.getImage());
                if (!k) break block2;
            }
            ServiceManager.getImageService().getFavouriteImagesService().addImageToCache(this.i.getImage());
        }
    }

    public final void relayout() {
        block9: {
            int n;
            int n2;
            int n3;
            block8: {
                n3 = this.g.getListPanelWidth() - this.g.getVerticalScrollBarWidth();
                n2 = this.getModel().getSize();
                if (n2 <= 0) {
                    return;
                }
                n = n3 / 120;
                if (n2 < n) {
                    n = n2;
                }
                if (n < 1) {
                    n = 1;
                }
                if (n != 1) break block8;
                this.setVisibleRowCount(n2);
                this.setFixedCellWidth(n3);
                if (!k) break block9;
            }
            int n4 = n2 / n;
            int n5 = n2 % n;
            if (n5 != 0) {
                ++n4;
            }
            int n6 = n2 % n4;
            int n7 = n2 / n4;
            if (n6 != 0) {
                ++n7;
            }
            this.setFixedCellWidth(n3 / n7);
            this.setVisibleRowCount(n4);
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        String[] stringArray;
        block76: {
            int n;
            int n2;
            char[] cArray2;
            int n3;
            block75: {
                char[] cArray3;
                Object var0;
                block74: {
                    int n4;
                    int n5;
                    char[] cArray4;
                    block73: {
                        char[] cArray5;
                        block72: {
                            int n6;
                            int n7;
                            char[] cArray6;
                            block71: {
                                char[] cArray7;
                                block70: {
                                    int n8;
                                    int n9;
                                    char[] cArray8;
                                    block69: {
                                        char[] cArray9;
                                        block68: {
                                            int n10;
                                            int n11;
                                            char[] cArray10;
                                            block67: {
                                                char[] cArray11;
                                                block66: {
                                                    int n12;
                                                    int n13;
                                                    char[] cArray12;
                                                    block65: {
                                                        char[] cArray13;
                                                        block64: {
                                                            int n14;
                                                            int n15;
                                                            char[] cArray14;
                                                            block63: {
                                                                stringArray = new String[7];
                                                                var0 = null;
                                                                char[] cArray15 = "\u000b5m}\u0015<tj}\t-&w3\u001b&tj~\u001b/1#u\b'9#z\u0014>5oz\u001eh'f\u007f\u001f+ j|\u0014u".toCharArray();
                                                                n3 = 0;
                                                                int n16 = cArray15.length;
                                                                cArray14 = cArray15;
                                                                n15 = n16;
                                                                if (n16 <= 1) break block63;
                                                                cArray13 = cArray14;
                                                                n14 = n15;
                                                                if (n15 <= n3) break block64;
                                                            }
                                                            do {
                                                                char[] cArray16 = cArray14;
                                                                char[] cArray17 = cArray14;
                                                                int n17 = n3;
                                                                while (true) {
                                                                    int n18;
                                                                    char c = cArray16[n17];
                                                                    switch (n3 % 5) {
                                                                        case 0: {
                                                                            n18 = 72;
                                                                            break;
                                                                        }
                                                                        case 1: {
                                                                            n18 = 84;
                                                                            break;
                                                                        }
                                                                        case 2: {
                                                                            n18 = 3;
                                                                            break;
                                                                        }
                                                                        case 3: {
                                                                            n18 = 19;
                                                                            break;
                                                                        }
                                                                        default: {
                                                                            n18 = 122;
                                                                        }
                                                                    }
                                                                    cArray16[n17] = (char)(c ^ n18);
                                                                    ++n3;
                                                                    cArray14 = cArray17;
                                                                    n15 = n15;
                                                                    if (n15 != 0) break;
                                                                    cArray17 = cArray14;
                                                                    n14 = n15;
                                                                    n17 = n15;
                                                                    cArray16 = cArray14;
                                                                }
                                                                cArray13 = cArray14;
                                                                n14 = n15;
                                                            } while (n15 > n3);
                                                        }
                                                        stringArray[0] = new String(cArray13).intern();
                                                        var0 = null;
                                                        char[] cArray18 = "+;n=\u000e =mx\u0018=.b}T!e;}T+;n~\u0015&zj}\t-&w".toCharArray();
                                                        n3 = 0;
                                                        int n19 = cArray18.length;
                                                        cArray12 = cArray18;
                                                        n13 = n19;
                                                        if (n19 <= 1) break block65;
                                                        cArray11 = cArray12;
                                                        n12 = n13;
                                                        if (n13 <= n3) break block66;
                                                    }
                                                    do {
                                                        char[] cArray19 = cArray12;
                                                        char[] cArray20 = cArray12;
                                                        int n20 = n3;
                                                        while (true) {
                                                            int n21;
                                                            char c = cArray19[n20];
                                                            switch (n3 % 5) {
                                                                case 0: {
                                                                    n21 = 72;
                                                                    break;
                                                                }
                                                                case 1: {
                                                                    n21 = 84;
                                                                    break;
                                                                }
                                                                case 2: {
                                                                    n21 = 3;
                                                                    break;
                                                                }
                                                                case 3: {
                                                                    n21 = 19;
                                                                    break;
                                                                }
                                                                default: {
                                                                    n21 = 122;
                                                                }
                                                            }
                                                            cArray19[n20] = (char)(c ^ n21);
                                                            ++n3;
                                                            cArray12 = cArray20;
                                                            n13 = n13;
                                                            if (n13 != 0) break;
                                                            cArray20 = cArray12;
                                                            n12 = n13;
                                                            n20 = n13;
                                                            cArray19 = cArray12;
                                                        }
                                                        cArray11 = cArray12;
                                                        n12 = n13;
                                                    } while (n13 > n3);
                                                }
                                                stringArray[1] = new String(cArray11).intern();
                                                var0 = null;
                                                char[] cArray21 = "+;n=\u000e =mx\u0018=.b}T!e;}T!9bt\u001f$=aa\u001b:-sr\u0014-8-a\u001f%;uv<:;nU\u001b>;va\u0013<1p".toCharArray();
                                                n3 = 0;
                                                int n22 = cArray21.length;
                                                cArray10 = cArray21;
                                                n11 = n22;
                                                if (n22 <= 1) break block67;
                                                cArray9 = cArray10;
                                                n10 = n11;
                                                if (n11 <= n3) break block68;
                                            }
                                            do {
                                                char[] cArray22 = cArray10;
                                                char[] cArray23 = cArray10;
                                                int n23 = n3;
                                                while (true) {
                                                    int n24;
                                                    char c = cArray22[n23];
                                                    switch (n3 % 5) {
                                                        case 0: {
                                                            n24 = 72;
                                                            break;
                                                        }
                                                        case 1: {
                                                            n24 = 84;
                                                            break;
                                                        }
                                                        case 2: {
                                                            n24 = 3;
                                                            break;
                                                        }
                                                        case 3: {
                                                            n24 = 19;
                                                            break;
                                                        }
                                                        default: {
                                                            n24 = 122;
                                                        }
                                                    }
                                                    cArray22[n23] = (char)(c ^ n24);
                                                    ++n3;
                                                    cArray10 = cArray23;
                                                    n11 = n11;
                                                    if (n11 != 0) break;
                                                    cArray23 = cArray10;
                                                    n10 = n11;
                                                    n23 = n11;
                                                    cArray22 = cArray10;
                                                }
                                                cArray9 = cArray10;
                                                n10 = n11;
                                            } while (n11 > n3);
                                        }
                                        stringArray[2] = new String(cArray9).intern();
                                        var0 = null;
                                        char[] cArray24 = "+;n=\u000e =mx\u0018=.b}T!e;}T+;n~\u0015&zj}\t-&wR\t\u000b1mg\b)8Jw\u001f)".toCharArray();
                                        n3 = 0;
                                        int n25 = cArray24.length;
                                        cArray8 = cArray24;
                                        n9 = n25;
                                        if (n25 <= 1) break block69;
                                        cArray7 = cArray8;
                                        n8 = n9;
                                        if (n9 <= n3) break block70;
                                    }
                                    do {
                                        char[] cArray25 = cArray8;
                                        char[] cArray26 = cArray8;
                                        int n26 = n3;
                                        while (true) {
                                            int n27;
                                            char c = cArray25[n26];
                                            switch (n3 % 5) {
                                                case 0: {
                                                    n27 = 72;
                                                    break;
                                                }
                                                case 1: {
                                                    n27 = 84;
                                                    break;
                                                }
                                                case 2: {
                                                    n27 = 3;
                                                    break;
                                                }
                                                case 3: {
                                                    n27 = 19;
                                                    break;
                                                }
                                                default: {
                                                    n27 = 122;
                                                }
                                            }
                                            cArray25[n26] = (char)(c ^ n27);
                                            ++n3;
                                            cArray8 = cArray26;
                                            n9 = n9;
                                            if (n9 != 0) break;
                                            cArray26 = cArray8;
                                            n8 = n9;
                                            n26 = n9;
                                            cArray25 = cArray8;
                                        }
                                        cArray7 = cArray8;
                                        n8 = n9;
                                    } while (n9 > n3);
                                }
                                stringArray[3] = new String(cArray7).intern();
                                var0 = null;
                                char[] cArray27 = "+;n=\u000e =mx\u0018=.b}T!e;}T!9bt\u001f$=aa\u001b:-sr\u0014-8-r\u001e,\u0000lU\u001b>;va\u0013<1p".toCharArray();
                                n3 = 0;
                                int n28 = cArray27.length;
                                cArray6 = cArray27;
                                n7 = n28;
                                if (n28 <= 1) break block71;
                                cArray5 = cArray6;
                                n6 = n7;
                                if (n7 <= n3) break block72;
                            }
                            do {
                                char[] cArray28 = cArray6;
                                char[] cArray29 = cArray6;
                                int n29 = n3;
                                while (true) {
                                    int n30;
                                    char c = cArray28[n29];
                                    switch (n3 % 5) {
                                        case 0: {
                                            n30 = 72;
                                            break;
                                        }
                                        case 1: {
                                            n30 = 84;
                                            break;
                                        }
                                        case 2: {
                                            n30 = 3;
                                            break;
                                        }
                                        case 3: {
                                            n30 = 19;
                                            break;
                                        }
                                        default: {
                                            n30 = 122;
                                        }
                                    }
                                    cArray28[n29] = (char)(c ^ n30);
                                    ++n3;
                                    cArray6 = cArray29;
                                    n7 = n7;
                                    if (n7 != 0) break;
                                    cArray29 = cArray6;
                                    n6 = n7;
                                    n29 = n7;
                                    cArray28 = cArray6;
                                }
                                cArray5 = cArray6;
                                n6 = n7;
                            } while (n7 > n3);
                        }
                        stringArray[4] = new String(cArray5).intern();
                        var0 = null;
                        char[] cArray30 = "+;n=\u000e =mx\u0018=.b}T!e;}T+;n~\u0015&zj~\u001b/1p=\u0013&'fa\u000e)'`z".toCharArray();
                        n3 = 0;
                        int n31 = cArray30.length;
                        cArray4 = cArray30;
                        n5 = n31;
                        if (n31 <= 1) break block73;
                        cArray3 = cArray4;
                        n4 = n5;
                        if (n5 <= n3) break block74;
                    }
                    do {
                        char[] cArray31 = cArray4;
                        char[] cArray32 = cArray4;
                        int n32 = n3;
                        while (true) {
                            int n33;
                            char c = cArray31[n32];
                            switch (n3 % 5) {
                                case 0: {
                                    n33 = 72;
                                    break;
                                }
                                case 1: {
                                    n33 = 84;
                                    break;
                                }
                                case 2: {
                                    n33 = 3;
                                    break;
                                }
                                case 3: {
                                    n33 = 19;
                                    break;
                                }
                                default: {
                                    n33 = 122;
                                }
                            }
                            cArray31[n32] = (char)(c ^ n33);
                            ++n3;
                            cArray4 = cArray32;
                            n5 = n5;
                            if (n5 != 0) break;
                            cArray32 = cArray4;
                            n4 = n5;
                            n32 = n5;
                            cArray31 = cArray4;
                        }
                        cArray3 = cArray4;
                        n4 = n5;
                    } while (n5 > n3);
                }
                stringArray[5] = new String(cArray3).intern();
                var0 = null;
                char[] cArray33 = "85qv\u0014<\u001dm3\u0019):m|\u000eh6f3\u0014=8o2".toCharArray();
                n3 = 0;
                int n34 = cArray33.length;
                cArray2 = cArray33;
                n2 = n34;
                if (n34 <= 1) break block75;
                cArray = cArray2;
                n = n2;
                if (n2 <= n3) break block76;
            }
            do {
                char[] cArray34 = cArray2;
                char[] cArray35 = cArray2;
                int n35 = n3;
                while (true) {
                    int n36;
                    char c = cArray34[n35];
                    switch (n3 % 5) {
                        case 0: {
                            n36 = 72;
                            break;
                        }
                        case 1: {
                            n36 = 84;
                            break;
                        }
                        case 2: {
                            n36 = 3;
                            break;
                        }
                        case 3: {
                            n36 = 19;
                            break;
                        }
                        default: {
                            n36 = 122;
                        }
                    }
                    cArray34[n35] = (char)(c ^ n36);
                    ++n3;
                    cArray2 = cArray35;
                    n2 = n2;
                    if (n2 != 0) break;
                    cArray35 = cArray2;
                    n = n2;
                    n35 = n2;
                    cArray34 = cArray2;
                }
                cArray = cArray2;
                n = n2;
            } while (n2 > n3);
        }
        stringArray[6] = new String(cArray).intern();
        z = stringArray;
    }
}

