/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.pascal.guielements.toolbar;

import com.thinkbuzan.pascal.guielements.toolbar.AbstractBodyBar;
import com.thinkbuzan.pascal.services.editor.DrawTool;
import com.thinkbuzan.pascal.services.editor.DrawToolListener;
import com.thinkbuzan.pascal.services.editor.IEditorManager;
import com.thinkbuzan.pascal.services.editor.IEditorView;
import com.thinkbuzan.pascal.services.editor.SketchModeListener;
import com.thinkbuzan.pascal.services.editor.listeners.IEditorViewListener;
import com.thinkbuzan.pascal.services.editor.listeners.IViewListener;
import com.thinkbuzan.pascal.services.editor.pallet.IPalletListener;
import java.util.ArrayList;
import java.util.List;

public final class EditorSupport {
    private static final IViewListener a;
    private static final DrawToolListener b;
    private static final SketchModeListener c;
    private static final IPalletListener d;
    private static final List<IViewListener> e;
    private static final List<DrawToolListener> f;
    private static final List<SketchModeListener> g;
    private static final List<IPalletListener> h;
    private static IEditorView i;
    private static final String z;

    private EditorSupport() {
    }

    protected static void notifyPalletModeChanged() {
        int n = AbstractBodyBar.h;
        for (IPalletListener iPalletListener : h) {
            iPalletListener.palletModeChanged();
            if (n == 0) continue;
        }
    }

    protected static void notifyPalletActiveStateChanged() {
        int n = AbstractBodyBar.h;
        for (IPalletListener iPalletListener : h) {
            iPalletListener.palletActiveStateChanged();
            if (n == 0) continue;
        }
    }

    protected static void notifyDrawToolChanged(DrawTool drawTool, DrawTool drawTool2) {
        int n = AbstractBodyBar.h;
        for (DrawToolListener drawToolListener : f) {
            drawToolListener.drawToolChanged(drawTool, drawTool2);
            if (n == 0) continue;
        }
    }

    protected static void notifyViewChanged(String string) {
        int n = AbstractBodyBar.h;
        for (IViewListener iViewListener : e) {
            iViewListener.viewChanged(string);
            if (n == 0) continue;
        }
    }

    protected static void notifySketchToolStateChanged(boolean bl) {
        int n = AbstractBodyBar.h;
        for (SketchModeListener sketchModeListener : g) {
            sketchModeListener.sketchToolStateChanged(bl);
            if (n == 0) continue;
        }
    }

    public static void setEditor(IEditorManager iEditorManager) {
        iEditorManager.addEditorViewListener(new IEditorViewListener(){

            public void editorChanged(IEditorView iEditorView) {
                if (i != null) {
                    i.removeViewTypeListener(a);
                    i.removeDrawToolListener(b);
                    i.removeSketchModeListener(c);
                    i.getPalletController().removePalletListener(d);
                }
                i = iEditorView;
                if (i != null) {
                    i.addViewTypeListener(a);
                    a.viewChanged(EditorSupport.getCurrentView());
                    i.addDrawToolListener(b);
                    b.drawToolChanged(i.getDrawTool(), i.getDrawTool());
                    i.addSketchModeListener(c);
                    c.sketchToolStateChanged(i.isInSketchMode());
                    i.getPalletController().addPalletListener(d);
                    d.palletModeChanged();
                }
            }
        });
    }

    public static void addDrawToolListener(DrawToolListener drawToolListener) {
        f.add(drawToolListener);
    }

    public static void addViewListener(IViewListener iViewListener) {
        e.add(iViewListener);
    }

    public static void addSketchModeListener(SketchModeListener sketchModeListener) {
        g.add(sketchModeListener);
    }

    public static void addPalletModeListener(IPalletListener iPalletListener) {
        h.add(iPalletListener);
    }

    public static IEditorView getCurrentEditor() {
        return i;
    }

    public static String getCurrentView() {
        if (i != null) {
            return i.getView().getId();
        }
        return z;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        block10: {
            int n;
            int n2;
            char[] cArray2;
            int n3;
            block9: {
                Object var0 = null;
                char[] cArray3 = "<QT\u0001 7WWD6*DXAz8_PNz)W\\Xz2WWK9>N\u0017b=1ZtN$\tW\\X".toCharArray();
                n3 = 0;
                int n4 = cArray3.length;
                cArray2 = cArray3;
                n2 = n4;
                if (n4 <= 1) break block9;
                cArray = cArray2;
                n = n2;
                if (n2 <= n3) break block10;
            }
            do {
                char[] cArray4 = cArray2;
                char[] cArray5 = cArray2;
                int n5 = n3;
                while (true) {
                    int n6;
                    char c = cArray4[n5];
                    switch (n3 % 5) {
                        case 0: {
                            n6 = 95;
                            break;
                        }
                        case 1: {
                            n6 = 62;
                            break;
                        }
                        case 2: {
                            n6 = 57;
                            break;
                        }
                        case 3: {
                            n6 = 47;
                            break;
                        }
                        default: {
                            n6 = 84;
                        }
                    }
                    cArray4[n5] = (char)(c ^ n6);
                    ++n3;
                    cArray2 = cArray5;
                    n2 = n2;
                    if (n2 != 0) break;
                    cArray5 = cArray2;
                    n = n2;
                    n5 = n2;
                    cArray4 = cArray2;
                }
                cArray = cArray2;
                n = n2;
            } while (n2 > n3);
        }
        z = new String(cArray).intern();
        a = new IViewListener(){

            public void viewChanged(String string) {
                EditorSupport.notifyViewChanged(string);
            }
        };
        b = new DrawToolListener(){

            public void drawToolChanged(DrawTool drawTool, DrawTool drawTool2) {
                EditorSupport.notifyDrawToolChanged(drawTool, drawTool2);
            }
        };
        c = new SketchModeListener(){

            public void sketchToolStateChanged(boolean bl) {
                EditorSupport.notifySketchToolStateChanged(bl);
            }
        };
        d = new IPalletListener(){

            public void palletModeChanged() {
                EditorSupport.notifyPalletModeChanged();
            }

            public void palletActiveStateChanged() {
                EditorSupport.notifyPalletActiveStateChanged();
            }
        };
        e = new ArrayList<IViewListener>();
        f = new ArrayList<DrawToolListener>();
        g = new ArrayList<SketchModeListener>();
        h = new ArrayList<IPalletListener>();
    }
}

