/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.export.spreadsheet;

import com.mxgraph.mindmap.model.mmBranchCell;
import com.mxgraph.mindmap.model.mmFloatingIdeaCell;
import com.mxgraph.mindmap.model.mmIStructureCell;
import com.mxgraph.mindmap.util.mmUtils;
import com.thinkbuzan.gaia.editor.IEditorComponent;
import com.thinkbuzan.gaia.export.AbstractTemplateExporter;
import com.thinkbuzan.gaia.export.Category;
import com.thinkbuzan.gaia.export.IExporterListener;
import com.thinkbuzan.gaia.export.spreadsheet.i18n.SpreadsheetExporterI18N;
import com.thinkbuzan.gaia.export.spreadsheet.options.impl.SpreadsheetOptionsComponent;
import com.thinkbuzan.gaia.export.spreadsheet.util.ProcessProgressor;
import com.thinkbuzan.gaia.export.template.ITemplate;
import com.thinkbuzan.gaia.export.template.ITemplateComponentListener;
import java.io.File;
import java.util.List;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSpreadsheetExporter
extends AbstractTemplateExporter {
    private transient File outputFile;
    private transient IExporterListener exporterListener;
    private transient ProcessProgressor progressor;
    private transient IEditorComponent editorComponent;
    private transient SpreadsheetOptionsComponent optionsComponent;
    private static final transient Logger LOGGER = Logger.getLogger(AbstractSpreadsheetExporter.class);

    public AbstractSpreadsheetExporter() {
        super(SpreadsheetExporterI18N.getI18n());
    }

    public final Category.CategoryId getCategoryId() {
        return Category.CategoryId.SPREADSHEET;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SpreadsheetOptionsComponent lazyGetOptionsComponent() {
        AbstractSpreadsheetExporter abstractSpreadsheetExporter = this;
        synchronized (abstractSpreadsheetExporter) {
            if (this.optionsComponent == null) {
                this.optionsComponent = new SpreadsheetOptionsComponent();
            }
        }
        return this.optionsComponent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void export(IEditorComponent editorComponentIn, File outputFileIn, IExporterListener exporterListenerIn) {
        this.validateExport(editorComponentIn, outputFileIn, exporterListenerIn);
        this.exporterListener = exporterListenerIn;
        this.outputFile = outputFileIn;
        this.editorComponent = editorComponentIn;
        try {
            List floatingIdeas = this.editorComponent.getFloatingIdeas();
            mmUtils.sortByOrder((List)floatingIdeas);
            this.progressor = new ProcessProgressor(this.editorComponent, this.exporterListener);
            this.progressor.startProcess();
            this.beginDocument();
            this.progressor.beforeProcessing();
            for (mmFloatingIdeaCell mxICell : floatingIdeas) {
                this.writeCentralIdea(mxICell);
                this.writeMainBranches(mmUtils.getSortedChildBranches((mmIStructureCell)mxICell));
            }
            this.progressor.afterProcessing();
            this.endDocument();
            this.progressor.endProcess();
        }
        catch (Exception e) {
            this.exporterListener.exportErrorOccurred(SpreadsheetExporterI18N.getLocalizedText("com.thinkbuzan.i18n.spreadsheetexporter.errorDuringExport"));
            LOGGER.error((Object)e);
        }
        finally {
            this.editorComponent = null;
            this.exporterListener = null;
        }
    }

    private void validateExport(IEditorComponent editorComponentIn, File outputFileIn, IExporterListener exporterListenerIn) {
        if (editorComponentIn == null) {
            throw new IllegalArgumentException("Editor component can't be null!");
        }
        if (outputFileIn == null) {
            throw new IllegalArgumentException("Out put file can't be null!");
        }
        if (exporterListenerIn == null) {
            throw new IllegalArgumentException("Exporter listener can't be null!");
        }
    }

    private void writeMainBranches(List<mmBranchCell> mainBranches) {
        if (null == mainBranches || mainBranches.isEmpty()) {
            return;
        }
        for (mmBranchCell branchCell : mainBranches) {
            this.writeBranch(branchCell);
        }
    }

    public final IExporterListener getExporterListener() {
        return this.exporterListener;
    }

    public final File getOutputFile() {
        return this.outputFile;
    }

    public final void updateProgress() {
        this.progressor.processing();
    }

    public final IEditorComponent getEditorComponent() {
        return this.editorComponent;
    }

    protected abstract void beginDocument();

    protected abstract void writeCentralIdea(mmFloatingIdeaCell var1);

    protected abstract void writeBranch(mmBranchCell var1);

    protected abstract void endDocument();

    public void export(IEditorComponent editorComponent, File outputFile, IExporterListener exporterListener, Object ... objects) {
        this.export(editorComponent, outputFile, exporterListener);
    }

    public ITemplateComponentListener getTemplateComponentListener() {
        return null;
    }

    public JComponent getOptionsComponent() {
        return this.lazyGetOptionsComponent();
    }

    public JComponent getTemplateComponent() {
        return null;
    }

    public List<ITemplate> getTemplates() {
        return null;
    }

    public final boolean isFlatLayout() {
        return this.optionsComponent.isFlatLayout();
    }

    public final boolean isNestedLayout() {
        return this.optionsComponent.isNestedLayout();
    }

    public boolean isIncludeFinanceInfo() {
        return this.optionsComponent.isIncludeFinanceInfo();
    }

    public boolean isIncludeProjectInfo() {
        return this.optionsComponent.isIncludeProjectInfo();
    }

    public boolean isIncludeSpacing() {
        return this.optionsComponent.isIncludeSpacing();
    }
}

