/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.gaia.export.spreadsheet.options.impl;

import com.thinkbuzan.apollo.ui.core.factory.CoreUIFactory;
import com.thinkbuzan.gaia.export.spreadsheet.i18n.SpreadsheetExporterI18N;
import com.thinkbuzan.gaia.export.spreadsheet.options.ISpreadsheetOptions;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SpreadsheetOptionsComponent
extends JComponent
implements ISpreadsheetOptions {
    private static final long serialVersionUID = 7988985256231786359L;
    private static final String flat = SpreadsheetExporterI18N.getLocalizedText("com.thinkbuzan.i18n.spreadsheetexporter.template.layout.flat");
    private static final String nested = SpreadsheetExporterI18N.getLocalizedText("com.thinkbuzan.i18n.spreadsheetexporter.template.layout.nested");
    private final transient JComboBox<String> structureCombo;
    private final transient JCheckBox includeProject;
    private final transient JCheckBox includeFinance;
    private final transient JCheckBox includeSpaces;

    public SpreadsheetOptionsComponent() {
        this.setOpaque(false);
        this.includeFinance = CoreUIFactory.createCheckBox((String)SpreadsheetExporterI18N.getLocalizedText("com.thinkbuzan.i18n.export.spreadsheet.options.includefinance"));
        this.includeProject = CoreUIFactory.createCheckBox((String)SpreadsheetExporterI18N.getLocalizedText("com.thinkbuzan.i18n.export.spreadsheet.options.includeproject"));
        this.includeSpaces = CoreUIFactory.createCheckBox((String)SpreadsheetExporterI18N.getLocalizedText("com.thinkbuzan.i18n.export.spreadsheet.options.includespaces"));
        this.structureCombo = new JComboBox<String>(new String[]{flat, nested});
        this.structureCombo.setSelectedItem(flat);
        this.structureCombo.setMinimumSize(new Dimension(140, 10));
        this.structureCombo.setPreferredSize(new Dimension(140, this.structureCombo.getPreferredSize().height));
        this.structureCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!(SpreadsheetOptionsComponent.this.structureCombo.getSelectedItem() instanceof String) || flat.equalsIgnoreCase((String)SpreadsheetOptionsComponent.this.structureCombo.getSelectedItem()) || nested.equalsIgnoreCase((String)SpreadsheetOptionsComponent.this.structureCombo.getSelectedItem())) {
                    // empty if block
                }
            }
        });
        this.init();
    }

    private void init() {
        this.includeProject.setSelected(false);
        this.includeFinance.setSelected(false);
        this.includeSpaces.setSelected(true);
        this.setLayout(new BoxLayout(this, 1));
        JLabel layout = new JLabel(SpreadsheetExporterI18N.getLocalizedText("com.thinkbuzan.i18n.common.windows.layout"));
        layout.setOpaque(false);
        this.add(this.createWapperPanel(layout, this.structureCombo));
        this.add(this.createWapperPanel(this.includeProject));
        this.add(this.createWapperPanel(this.includeFinance));
        this.add(this.createWapperPanel(this.includeSpaces));
    }

    private JPanel createWapperPanel(JComponent checkBox) {
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.setOpaque(false);
        panel.add(checkBox);
        return panel;
    }

    private JPanel createWapperPanel(JComponent label, JComponent checkBox) {
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.setOpaque(false);
        panel.add(label);
        panel.add(checkBox);
        return panel;
    }

    public final boolean isIncludeProjectInfo() {
        return this.includeProject.isSelected();
    }

    public final boolean isIncludeFinanceInfo() {
        return this.includeFinance.isSelected();
    }

    public final boolean isNestedLayout() {
        return nested.equalsIgnoreCase((String)this.structureCombo.getSelectedItem());
    }

    public final boolean isFlatLayout() {
        return flat.equalsIgnoreCase((String)this.structureCombo.getSelectedItem());
    }

    public final void setIncludeProjectInfo(boolean selected) {
        this.includeProject.setSelected(selected);
    }

    public final void setIncludeFinanceInfo(boolean selected) {
        this.includeFinance.setSelected(selected);
    }

    public final void setFlatLayout() {
        this.structureCombo.setSelectedItem(flat);
    }

    public final void setNestedLayout() {
        this.structureCombo.setSelectedItem(nested);
    }

    public final boolean isIncludeSpacing() {
        return this.includeSpaces.isSelected();
    }

    public final void setIncludeSpacing(boolean selected) {
        this.includeSpaces.setSelected(selected);
    }
}

