/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.converter;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.ObjectConverter;
import com.jidesoft.converter.Resource;
import java.awt.Font;
import java.util.Locale;
import java.util.ResourceBundle;

public class FontConverter
implements ObjectConverter {
    @Override
    public String toString(Object object, ConverterContext converterContext) {
        if (object instanceof Font) {
            Font font = (Font)object;
            return font.getName() + ", " + this.getResourceString(font.getStyle()) + ", " + font.getSize();
        }
        return null;
    }

    protected String getResourceString(int n2) {
        ResourceBundle resourceBundle = Resource.getResourceBundle(Locale.getDefault());
        switch (n2) {
            case 0: {
                return resourceBundle.getString("Font.plain");
            }
            case 1: {
                return resourceBundle.getString("Font.bold");
            }
            case 2: {
                return resourceBundle.getString("Font.italic");
            }
            case 3: {
                return resourceBundle.getString("Font.boldItalic");
            }
        }
        return "";
    }

    protected int getStyleValue(String string) {
        ResourceBundle resourceBundle = Resource.getResourceBundle(Locale.getDefault());
        if (resourceBundle.getString("Font.italic").equalsIgnoreCase(string)) {
            return 2;
        }
        if (resourceBundle.getString("Font.bold").equalsIgnoreCase(string)) {
            return 1;
        }
        if (resourceBundle.getString("Font.boldItalic").equalsIgnoreCase(string)) {
            return 3;
        }
        return 0;
    }

    @Override
    public boolean supportToString(Object object, ConverterContext converterContext) {
        return true;
    }

    @Override
    public Object fromString(String string, ConverterContext converterContext) {
        if (string == null || string.length() == 0) {
            return null;
        }
        String string2 = null;
        int n2 = 0;
        int n3 = 10;
        String[] stringArray = string.split(",");
        if (stringArray.length > 0) {
            string2 = stringArray[0].trim();
        }
        if (stringArray.length > 1) {
            n2 = this.getStyleValue(stringArray[1].trim());
        }
        if (stringArray.length > 2) {
            try {
                double d2 = Double.parseDouble(stringArray[2].trim());
                n3 = (int)d2;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (string2 != null) {
            return new Font(string2, n2, n3);
        }
        return null;
    }

    @Override
    public boolean supportFromString(String string, ConverterContext converterContext) {
        return true;
    }
}

