/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.gantt;

import com.jidesoft.gantt.DefaultGanttEntryRenderer;
import com.jidesoft.gantt.GanttChartPane;
import com.jidesoft.gantt.GanttEntry;
import com.jidesoft.gantt.GanttEntryRelationEvent;
import com.jidesoft.gantt.GanttEntryRelationListener;
import com.jidesoft.gantt.GanttEntryRenderer;
import com.jidesoft.gantt.GanttLabelRenderer;
import com.jidesoft.gantt.GanttModel;
import com.jidesoft.gantt.GanttModelEvent;
import com.jidesoft.gantt.GanttModelListener;
import com.jidesoft.gantt.GanttResources;
import com.jidesoft.gantt.PeriodBackgroundPainter;
import com.jidesoft.gantt.SubEntryGanttEntry;
import com.jidesoft.grid.TreeTable;
import com.jidesoft.plaf.GanttChartUI;
import com.jidesoft.plaf.GanttEntryRelationPainter;
import com.jidesoft.plaf.GanttUIDefaultsCustomizer;
import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.BasicGanttChartUI;
import com.jidesoft.range.Range;
import com.jidesoft.scale.ScaleArea;
import com.jidesoft.scale.ScaleModel;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import com.jidesoft.utils.SystemInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.Scrollable;
import javax.swing.SizeSequence;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.table.JTableHeader;

public class GanttChart<T, S extends GanttEntry<T>>
extends JComponent
implements Scrollable,
GanttModelListener,
GanttEntryRelationListener,
ListSelectionListener,
PropertyChangeListener {
    private static final long serialVersionUID = -9094319801088118704L;
    public static final String PROPERTY_SCALE_AREA = "scaleArea";
    public static final String PROPERTY_GANTT_MODEL = "ganttModel";
    public static final String PROPERTY_EDITABLE = "editable";
    public static final String PROPERTY_VIEW_MODE = "viewMode";
    public static final String PROPERTY_ROW_HEIGHT = "rowHeight";
    public static final String PROPERTY_ROW_MARGIN = "rowMargin";
    public static final String PROPERTY_GRID_COLOR = "gridColor";
    public static final String PROPERTY_SHOW_GRID = "showGrid";
    public static final String PROPERTY_LABEL_POSITION = "labelPosition";
    public static final String PROPERTY_LABEL_ENTRY_GAP = "labelEntryGap";
    public static final int VIEW_MODE_EDITING = 0;
    public static final int VIEW_MODE_PANNING = 1;
    private final Map<Integer, GanttEntryRelationPainter> a = new HashMap<Integer, GanttEntryRelationPainter>();
    private final List<PeriodBackgroundPainter<T>> b = new ArrayList<PeriodBackgroundPainter<T>>();
    private ScaleArea<T> c;
    private GanttModel<T, S> d;
    private SizeSequence e;
    private ListSelectionModel f;
    private Color g;
    private Color h;
    private int i;
    private int j;
    private boolean k;
    private Color l;
    private boolean m;
    private Dimension n;
    private boolean o = true;
    private int p;
    private GanttEntryRenderer q = new DefaultGanttEntryRenderer();
    private GanttLabelRenderer r;
    private int s = 11;
    private int t = 8;
    private boolean u = true;
    private int v = 4;
    private static final Insets w;
    private boolean x;
    public static int y;

    public GanttChart() {
        this(new ScaleArea());
    }

    public GanttChart(GanttModel<T, S> ganttModel) {
        this(ganttModel, new ScaleArea());
    }

    public GanttChart(ScaleArea<T> scaleArea) {
        this(null, scaleArea);
    }

    public GanttChart(GanttModel<T, S> ganttModel, ScaleArea<T> scaleArea) {
        this.setScaleArea(scaleArea);
        this.setModel(ganttModel);
        this.setRowHeight(16);
        this.setAutoscrolls(true);
        this.setSelectionModel(this.createDefaultSelectionModel());
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        toolTipManager.registerComponent(this);
        this.updateUI();
    }

    public void setScaleArea(ScaleArea<T> scaleArea) {
        ScaleArea<T> scaleArea2;
        block24: {
            Container container;
            block26: {
                Container container2;
                int n2;
                block20: {
                    TreeTable treeTable;
                    block25: {
                        ScaleArea<T> scaleArea3;
                        block23: {
                            block19: {
                                block21: {
                                    Container container3;
                                    block22: {
                                        n2 = y;
                                        container3 = scaleArea2 = this.c;
                                        if (n2 == 0) {
                                            if (container3 == scaleArea) {
                                                return;
                                            }
                                            container3 = this.c;
                                        }
                                        if (n2 == 0) {
                                            if (container3 != null) {
                                                this.c.removePropertyChangeListener(this);
                                            }
                                            this.c = scaleArea;
                                            container3 = this.c;
                                        }
                                        if (n2 == 0) {
                                            if (container3 != null) {
                                                this.c.removePropertyChangeListener(this);
                                                this.c.addPropertyChangeListener(this);
                                            }
                                            container3 = this.c;
                                        }
                                        if (n2 != 0) break block21;
                                        if (container3 == null) break block22;
                                        container3 = this;
                                        if (n2 != 0) break block21;
                                        if (((GanttChart)container3).d != null) {
                                            this.c.setScaleModel(this.d.getScaleModel());
                                        }
                                    }
                                    this.e();
                                    this.configureEnclosingScrollPane();
                                    container3 = container2 = this.getParent();
                                }
                                while (container2 != null) {
                                    scaleArea3 = container2;
                                    if (n2 == 0 && n2 == 0) {
                                        if (scaleArea3 instanceof GanttChartPane) break;
                                        container2 = container2.getParent();
                                        if (n2 == 0) continue;
                                    }
                                    break block19;
                                }
                                scaleArea3 = container2;
                            }
                            if (n2 != 0) break block23;
                            if (scaleArea3 == null) break block24;
                            scaleArea3 = container2;
                        }
                        treeTable = ((GanttChartPane)((Object)scaleArea3)).getTreeTable();
                        if (n2 != 0) break block25;
                        if (treeTable == null) break block24;
                        treeTable = ((GanttChartPane)container2).getTreeTable();
                    }
                    JTableHeader jTableHeader = treeTable.getTableHeader();
                    for (container2 = jTableHeader.getParent(); container2 != null; container2 = container2.getParent()) {
                        container = container2;
                        if (n2 == 0 && n2 == 0) {
                            if (container instanceof JViewport) break;
                            if (n2 == 0) continue;
                        }
                        break block20;
                    }
                    container = container2;
                }
                if (n2 != 0) break block26;
                if (container == null) break block24;
                container2.invalidate();
                container2.repaint();
                container = container2;
            }
            container.doLayout();
        }
        this.firePropertyChange(PROPERTY_SCALE_AREA, scaleArea2, this.c);
        this.resizeAndRepaint();
    }

    public ScaleArea<T> getScaleArea() {
        return this.c;
    }

    public GanttModel<T, S> getModel() {
        return this.d;
    }

    public boolean isEditable() {
        return this.o;
    }

    public void setEditable(boolean bl) {
        block5: {
            GanttChart ganttChart;
            int n2;
            block4: {
                n2 = y;
                ganttChart = this;
                if (n2 != 0) break block4;
                if (ganttChart.o == bl) break block5;
                this.o = bl;
                ganttChart = this;
            }
            boolean bl2 = bl;
            if (n2 == 0) {
                bl2 = !bl2;
            }
            ganttChart.firePropertyChange(PROPERTY_EDITABLE, bl2, bl);
        }
    }

    @Override
    public void ganttEntryRelationChanged(GanttEntryRelationEvent ganttEntryRelationEvent) {
        this.resizeAndRepaint();
    }

    @Override
    public void ganttChartChanged(GanttModelEvent ganttModelEvent) {
        block4: {
            block3: {
                int n2;
                int n3;
                block2: {
                    n3 = ganttModelEvent.getFirstRow();
                    n2 = -2;
                    if (y != 0) break block2;
                    if (n3 == n2) break block3;
                    n3 = ganttModelEvent.getLastRow();
                    n2 = -2;
                }
                if (n3 != n2) break block4;
            }
            this.a();
        }
        this.resizeAndRepaint();
    }

    private void a() {
        block8: {
            GanttChart ganttChart;
            int n2;
            Rectangle rectangle;
            block12: {
                boolean bl;
                Range<T> range;
                int n3;
                block11: {
                    Object object;
                    T t;
                    block9: {
                        block10: {
                            T t2;
                            GanttChart ganttChart2;
                            block7: {
                                n3 = y;
                                ganttChart2 = this;
                                if (n3 != 0) break block7;
                                if (ganttChart2.c == null) break block8;
                                ganttChart2 = this;
                            }
                            range = ganttChart2.d.getRange();
                            t = t2 = this.c.getStart();
                            if (n3 != 0) break block9;
                            if (t.equals(range.lower())) break block10;
                            object = this.c.getVisibleRect();
                            boolean bl2 = ((Rectangle)object).contains(this.c.getX(range.lower()), ((Rectangle)object).y);
                            this.c.setStart(range.lower());
                            bl = bl2;
                            if (n3 != 0) break block11;
                            if (bl) {
                                this.scrollSpanToVisible(range.lower(), range.upper());
                            }
                        }
                        t = this.c.getEnd();
                    }
                    object = t;
                    bl = object.equals(range.upper());
                }
                if (bl) break block8;
                rectangle = this.getVisibleRect();
                n2 = this.c.getX(range.upper());
                boolean bl3 = rectangle.contains(n2, rectangle.y);
                ganttChart = this;
                if (n3 != 0) break block12;
                ganttChart.c.setEnd(range.upper());
                if (!bl3) break block8;
                ganttChart = this;
            }
            ganttChart.scrollRectToVisible(new Rectangle(n2, rectangle.y, rectangle.width, rectangle.height));
        }
    }

    public void setModel(GanttModel<T, S> ganttModel) {
        GanttChart ganttChart;
        block8: {
            GanttModel<T, S> ganttModel2;
            block9: {
                int n2;
                block6: {
                    block7: {
                        GanttModel<T, S> ganttModel3;
                        block5: {
                            n2 = y;
                            ganttModel2 = this.d;
                            ganttModel3 = this.d;
                            if (n2 != 0) break block5;
                            if (ganttModel3 != null) {
                                this.d.removeGanttModelListener(this);
                                this.d.getGanttEntryRelationModel().removeGanttEntryRelationListener(this);
                            }
                            this.d = ganttModel;
                            ganttChart = this;
                            if (n2 != 0) break block6;
                            ganttModel3 = ganttChart.d;
                        }
                        if (ganttModel3 == null) break block7;
                        this.d.addGanttModelListener(this);
                        this.d.getGanttEntryRelationModel().addGanttEntryRelationListener(this);
                        ganttChart = this;
                        if (n2 != 0) break block8;
                        if (ganttChart.c == null) break block9;
                        this.c.setScaleModel(this.d.getScaleModel());
                        if (n2 == 0) break block9;
                    }
                    ganttChart = this;
                }
                if (n2 != 0) break block8;
                if (ganttChart.c != null) {
                    this.c.setScaleModel(null);
                }
            }
            this.e();
            this.firePropertyChange(PROPERTY_GANTT_MODEL, ganttModel2, this.d);
            ganttChart = this;
        }
        ganttChart.resizeAndRepaint();
    }

    private void e() {
        block5: {
            ScaleModel<T> scaleModel;
            Object object;
            block10: {
                GanttChart ganttChart;
                int n2;
                block6: {
                    block7: {
                        block9: {
                            block8: {
                                block4: {
                                    n2 = y;
                                    ganttChart = this;
                                    if (n2 != 0) break block4;
                                    if (ganttChart.c == null) break block5;
                                    ganttChart = this;
                                }
                                if (n2 != 0) break block6;
                                if (ganttChart.d == null) break block7;
                                object = this.d.getRange();
                                if (n2 != 0) break block8;
                                if (object == null) break block9;
                                this.c.setStart(object.lower());
                            }
                            this.c.setEnd(object.upper());
                        }
                        if (n2 == 0) break block5;
                    }
                    ganttChart = this;
                }
                scaleModel = ganttChart.c.getScaleModel();
                if (n2 != 0) break block10;
                if (scaleModel == null) break block5;
                scaleModel = this.c.getScaleModel();
            }
            object = scaleModel;
            this.c.setStart(object.getDefaultStart());
            this.c.setEnd(object.getDefaultEnd());
        }
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        int n2;
        block11: {
            ScaleArea<T> scaleArea;
            block10: {
                int n3;
                block9: {
                    GanttChartUI ganttChartUI;
                    block8: {
                        GanttChartUI ganttChartUI2;
                        n3 = y;
                        GanttChart ganttChart = this;
                        if (n3 == 0) {
                            if (ganttChart.n != null) {
                                return this.n;
                            }
                            ganttChart = this;
                        }
                        ganttChartUI = ganttChartUI2 = ganttChart.getUI();
                        if (n3 != 0) break block8;
                        if (ganttChartUI == null) break block9;
                        ganttChartUI = ganttChartUI2;
                    }
                    return ganttChartUI.getPreferredScrollableViewportSize(this);
                }
                n2 = 400;
                scaleArea = this.c;
                if (n3 != 0) break block10;
                if (scaleArea == null) break block11;
                scaleArea = this.c;
            }
            n2 = scaleArea.getPreferredPeriodSize().width * this.c.getVisiblePeriodCount();
        }
        return new Dimension(n2, 400);
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle rectangle, int n2, int n3) {
        block7: {
            TreeTable treeTable;
            block8: {
                ScaleArea<T> scaleArea;
                int n4;
                block6: {
                    block5: {
                        int n5;
                        block4: {
                            n4 = y;
                            n5 = n2;
                            if (n4 != 0) break block4;
                            if (n5 != 0) break block5;
                            n5 = rectangle.width;
                        }
                        return n5;
                    }
                    scaleArea = this.c;
                    if (n4 != 0) break block6;
                    if (scaleArea == null) break block7;
                    scaleArea = this.c;
                }
                treeTable = scaleArea.getTreeTable();
                if (n4 != 0) break block8;
                if (treeTable == null) break block7;
                treeTable = this.c.getTreeTable();
            }
            return treeTable.getScrollableBlockIncrement(rectangle, n2, n3);
        }
        return rectangle.height;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean getScrollableTracksViewportHeight() {
        int n2 = y;
        int n3 = this.getParent() instanceof JViewport;
        if (n2 == 0) {
            if (n3 == 0) return 0 != 0;
            n3 = this.getParent().getHeight();
        }
        if (n2 != 0) return n3 != 0;
        if (n3 <= this.getPreferredSize().height) return 0 != 0;
        return 1 != 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean getScrollableTracksViewportWidth() {
        int n2 = y;
        int n3 = this.getParent() instanceof JViewport;
        if (n2 == 0) {
            if (n3 == 0) return 0 != 0;
            n3 = this.getParent().getWidth();
        }
        if (n2 != 0) return n3 != 0;
        if (n3 <= this.getPreferredSize().width) return 0 != 0;
        return 1 != 0;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public int getScrollableUnitIncrement(Rectangle var1_1, int var2_2, int var3_3) {
        var4_4 = GanttChart.y;
        switch (var2_2) {
            case 0: {
                v0 = this.c;
                if (var4_4 != 0) ** GOTO lbl8
                if (v0 == null) ** GOTO lbl9
                v0 = this.c;
lbl8:
                // 2 sources

                return v0.getPreferredPeriodSize().width;
lbl9:
                // 1 sources

                return Math.max(1, var1_1.width / 100);
            }
        }
        v1 = this;
        if (var4_4 == 0) {
            if (v1.c != null) {
                v1 = this;
                if (var4_4 == 0) {
                    if (v1.c.getTreeTable() != null) {
                        return this.c.getTreeTable().getScrollableUnitIncrement(var1_1, var2_2, var3_3);
                    } else {
                        ** GOTO lbl-1000
                    }
                }
            } else lbl-1000:
            // 3 sources

            {
                v1 = this;
            }
        }
        v2 = v1.isRowHeightSet();
        if (var4_4 == 0) {
            if (v2 != 0) {
                return this.getRowHeight();
            }
            v2 = Math.max(1, var1_1.height / 100);
        }
        return v2;
    }

    protected void setUI(GanttChartUI ganttChartUI) {
        super.setUI(ganttChartUI);
    }

    @Override
    public String getUIClassID() {
        return "GanttChartUI";
    }

    @Override
    public GanttChartUI getUI() {
        return (GanttChartUI)this.ui;
    }

    @Override
    public void updateUI() {
        if (UIDefaultsLookup.get("GanttChartUI") == null) {
            LookAndFeelFactory.installJideExtension();
            new GanttUIDefaultsCustomizer().customize(UIManager.getLookAndFeelDefaults());
        }
        this.setUI((GanttChartUI)UIManager.getUI(this));
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.configureEnclosingScrollPane();
    }

    protected void configureEnclosingScrollPane() {
        block5: {
            JScrollPane jScrollPane;
            block9: {
                block8: {
                    Component component;
                    block7: {
                        JViewport jViewport;
                        Container container;
                        int n2;
                        block6: {
                            Container container2;
                            Container container3;
                            block4: {
                                Container container4;
                                n2 = y;
                                container3 = container4 = this.getParent();
                                if (n2 != 0) break block4;
                                if (!(container3 instanceof JViewport)) break block5;
                                container3 = container4.getParent();
                            }
                            container = container2 = container3;
                            if (n2 != 0) break block6;
                            if (!(container instanceof JScrollPane)) break block5;
                            container = container2;
                        }
                        jScrollPane = (JScrollPane)container;
                        component = jViewport = jScrollPane.getViewport();
                        if (n2 != 0) break block7;
                        if (component == null) break block8;
                        component = jViewport.getView();
                    }
                    if (component == this) break block9;
                }
                return;
            }
            ScaleArea<T> scaleArea = this.getScaleArea();
            if (scaleArea != null) {
                jScrollPane.setColumnHeaderView(scaleArea);
            }
        }
    }

    public int getEntryCount() {
        block3: {
            GanttModel<T, S> ganttModel;
            block2: {
                GanttModel<T, S> ganttModel2;
                ganttModel = ganttModel2 = this.getModel();
                if (y != 0) break block2;
                if (ganttModel == null) break block3;
                ganttModel = ganttModel2;
            }
            return ganttModel.getEntryCount();
        }
        return 0;
    }

    public S getEntryAt(Point point) {
        S s;
        block11: {
            S s2;
            block12: {
                Rectangle rectangle;
                block13: {
                    GanttChart ganttChart;
                    int n2;
                    int n3;
                    int n4;
                    block10: {
                        block9: {
                            int n5;
                            block8: {
                                n4 = y;
                                n3 = this.rowAtPoint(point);
                                n2 = -1;
                                n5 = n3;
                                if (n4 != 0) break block8;
                                if (n5 == -1) break block9;
                                ganttChart = this;
                                if (n4 != 0) break block10;
                                n5 = ganttChart.getUI() instanceof BasicGanttChartUI;
                            }
                            if (n5 != 0) {
                                n2 = ((BasicGanttChartUI)this.getUI()).getSubEntryIndex(n3, point);
                            }
                        }
                        ganttChart = this;
                    }
                    s2 = ganttChart.getEntryAt(n3, n2);
                    Rectangle rectangle2 = this.getEntryRect((GanttEntry<T>)s2, n3);
                    s = s2;
                    if (n4 != 0) break block11;
                    if (s == null || n2 >= 0) break block12;
                    rectangle = rectangle2;
                    if (n4 != 0) break block13;
                    if (rectangle == null) break block12;
                    rectangle = rectangle2;
                }
                if (!rectangle.contains(point)) {
                    s2 = null;
                }
            }
            s = s2;
        }
        return s;
    }

    public S getEntryAt(int n2) {
        block3: {
            GanttModel<T, S> ganttModel;
            block2: {
                GanttModel<T, S> ganttModel2;
                ganttModel = ganttModel2 = this.getModel();
                if (y != 0) break block2;
                if (ganttModel == null) break block3;
                ganttModel = ganttModel2;
            }
            return ganttModel.getEntryAt(n2);
        }
        return null;
    }

    public S getEntryAt(int n2, int n3) {
        block6: {
            Object object;
            block7: {
                S s;
                block8: {
                    int n4;
                    List list;
                    block9: {
                        GanttModel<T, S> ganttModel;
                        int n5;
                        block5: {
                            GanttModel<T, S> ganttModel2;
                            n5 = y;
                            if (n3 < 0) {
                                return this.getEntryAt(n2);
                            }
                            ganttModel = ganttModel2 = this.getModel();
                            if (n5 != 0) break block5;
                            if (ganttModel == null) break block6;
                            ganttModel = ganttModel2;
                        }
                        s = ganttModel.getEntryAt(n2);
                        object = s;
                        if (n5 != 0) break block7;
                        if (!(object instanceof SubEntryGanttEntry)) break block8;
                        object = (SubEntryGanttEntry)s;
                        if (n5 != 0) break block7;
                        list = object.getSubEntries();
                        if (list == null) break block8;
                        n4 = n3;
                        if (n5 != 0) break block9;
                        if (n4 < 0) break block8;
                        n4 = n3;
                    }
                    if (n4 < list.size()) {
                        return (S)list.get(n3);
                    }
                }
                object = s;
            }
            return (S)object;
        }
        return null;
    }

    public int getIndexOf(S s) {
        block3: {
            GanttModel<T, S> ganttModel;
            block2: {
                GanttModel<T, S> ganttModel2;
                ganttModel = ganttModel2 = this.getModel();
                if (y != 0) break block2;
                if (ganttModel == null) break block3;
                ganttModel = ganttModel2;
            }
            return ganttModel.getIndexOf(s);
        }
        return -1;
    }

    protected void resizeAndRepaint() {
        this.revalidate();
        this.repaint();
    }

    public void setRowHeight(int n2) {
        int n3 = n2;
        if (y == 0) {
            if (n3 <= 0) {
                throw new IllegalArgumentException("New row height less than 1");
            }
            n3 = this.i;
        }
        int n4 = n3;
        this.i = n2;
        this.e = null;
        this.m = true;
        this.resizeAndRepaint();
        this.firePropertyChange(PROPERTY_ROW_HEIGHT, n4, n2);
    }

    public boolean isRowHeightSet() {
        return this.m;
    }

    public int getRowHeight() {
        return this.i;
    }

    public int getTotalRowHeight() {
        int n2 = this.isRowHeightSet();
        if (y == 0) {
            if (n2 != 0) {
                return this.getEntryCount() * this.getRowHeight();
            }
            n2 = this.b(this.e.getSizes());
        }
        return n2;
    }

    private int b(int ... nArray) {
        int n2;
        block2: {
            int n3 = y;
            int n4 = 0;
            for (int n5 : nArray) {
                n2 = n4 + n5;
                if (n3 == 0) {
                    n4 = n2;
                    if (n3 == 0) continue;
                }
                break block2;
            }
            n2 = n4;
        }
        return n2;
    }

    private SizeSequence f() {
        SizeSequence sizeSequence = this.e;
        if (y == 0) {
            if (sizeSequence == null) {
                this.e = new SizeSequence(this.getEntryCount(), this.getRowHeight());
            }
            sizeSequence = this.e;
        }
        return sizeSequence;
    }

    public void setRowHeight(int n2, int n3) {
        if (n3 <= 0) {
            throw new IllegalArgumentException("New row height less than 1");
        }
        this.f().setSize(n2, n3);
        this.resizeAndRepaint();
    }

    /*
     * Enabled aggressive block sorting
     */
    public int getRowHeight(int n2) {
        int n3;
        SizeSequence sizeSequence = this.e;
        if (y == 0) {
            if (sizeSequence == null) {
                n3 = this.getRowHeight();
                return n3;
            }
            sizeSequence = this.e;
        }
        n3 = sizeSequence.getSize(n2);
        return n3;
    }

    public void setRowMargin(int n2) {
        int n3 = this.j;
        this.j = n2;
        this.resizeAndRepaint();
        this.firePropertyChange(PROPERTY_ROW_MARGIN, n3, n2);
    }

    public int getRowMargin() {
        return this.j;
    }

    public void setGridColor(Color color) {
        Color color2 = color;
        if (y == 0) {
            if (color2 == null) {
                throw new IllegalArgumentException("New color is null");
            }
            color2 = this.l;
        }
        Color color3 = color2;
        this.l = color;
        this.firePropertyChange(PROPERTY_GRID_COLOR, color3, color);
        this.repaint();
    }

    public Color getGridColor() {
        return this.l;
    }

    public void setShowGrid(boolean bl) {
        boolean bl2 = this.k;
        this.k = bl;
        this.firePropertyChange(PROPERTY_SHOW_GRID, bl2, bl);
        this.repaint();
    }

    public boolean isShowGrid() {
        return this.k;
    }

    public void setViewMode(int n2) {
        block3: {
            int n3;
            block2: {
                n3 = n2;
                if (y != 0) break block2;
                if (n3 == this.p) break block3;
                n3 = this.p;
            }
            int n4 = n3;
            this.p = n2;
            this.firePropertyChange(PROPERTY_VIEW_MODE, n4, this.p);
        }
    }

    public int getViewMode() {
        return this.p;
    }

    /*
     * Unable to fully structure code
     */
    public int rowAtPoint(Point var1_1) {
        var4_2 = GanttChart.y;
        var2_3 = var1_1.y;
        v0 = this.e;
        if (var4_2 != 0) ** GOTO lbl9
        if (v0 == null) {
            v1 = var2_3 / this.getRowHeight();
        } else {
            v0 = this.e;
lbl9:
            // 2 sources

            v1 = v0.getIndex(var2_3);
        }
        v2 = var3_4 = v1;
        if (var4_2 == 0) {
            if (v2 < 0) {
                return -1;
            }
            v2 = var3_4;
        }
        if (var4_2 == 0) {
            if (v2 >= this.getEntryCount()) {
                return -1;
            }
            v2 = var3_4;
        }
        return v2;
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        String string;
        int n2;
        block10: {
            MouseEvent mouseEvent2;
            Component component;
            block17: {
                Point point;
                block16: {
                    int n3;
                    block15: {
                        int n4;
                        block14: {
                            Rectangle rectangle;
                            block13: {
                                block12: {
                                    Rectangle rectangle2;
                                    block11: {
                                        GanttEntryRenderer ganttEntryRenderer;
                                        int n5;
                                        int n6;
                                        block9: {
                                            n2 = y;
                                            string = null;
                                            point = mouseEvent.getPoint();
                                            n5 = n6 = this.rowAtPoint(point);
                                            if (n2 != 0) break block9;
                                            if (n5 == -1) break block10;
                                            n5 = -1;
                                        }
                                        int n7 = n5;
                                        GanttChart ganttChart = this;
                                        if (n2 == 0) {
                                            if (ganttChart.getUI() instanceof BasicGanttChartUI) {
                                                n7 = ((BasicGanttChartUI)this.getUI()).getSubEntryIndex(n6, point);
                                            }
                                            ganttChart = this;
                                        }
                                        if (!((component = this.prepareRenderer(ganttEntryRenderer = ganttChart.getEntryRenderer(n6, n7), n6, n7, w)) instanceof JComponent)) break block10;
                                        rectangle2 = rectangle = this.getEntryRect(n6);
                                        if (n2 != 0) break block11;
                                        if (rectangle2 == null) break block10;
                                        rectangle2 = rectangle;
                                    }
                                    n3 = rectangle2.width;
                                    if (n2 == 0) {
                                        if (n3 == 0) {
                                            rectangle.x -= 2;
                                            rectangle.width += 4;
                                        }
                                        point.translate(-rectangle.x, -rectangle.y);
                                        n3 = point.x;
                                    }
                                    if (n2 != 0) break block12;
                                    if (n3 < 0) break block10;
                                    n3 = point.y;
                                }
                                if (n2 != 0) break block13;
                                if (n3 < 0) break block10;
                                n3 = point.x;
                            }
                            n4 = rectangle.width;
                            if (n2 != 0) break block14;
                            if (n3 >= n4) break block10;
                            n3 = point.y;
                            if (n2 != 0) break block15;
                            n4 = rectangle.height;
                        }
                        if (n3 >= n4) break block10;
                        n3 = SystemInfo.isJdk6Above() ? 1 : 0;
                    }
                    if (n3 == 0) break block16;
                    mouseEvent2 = new MouseEvent(component, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getXOnScreen(), mouseEvent.getYOnScreen(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), 0);
                    if (n2 == 0) break block17;
                }
                mouseEvent2 = new MouseEvent(component, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), 0);
            }
            string = ((JComponent)component).getToolTipText(mouseEvent2);
        }
        String string2 = string;
        if (n2 == 0) {
            if (string2 == null) {
                string = this.getToolTipText();
            }
            string2 = string;
        }
        return string2;
    }

    public Rectangle getEntryRect(int n2) {
        S s = this.getEntryAt(n2);
        return this.getEntryRect((GanttEntry<T>)s, n2);
    }

    public Rectangle getEntryRect(GanttEntry<T> ganttEntry, int n2) {
        block9: {
            int n3;
            int n4;
            int n5;
            int n6;
            block14: {
                int n7;
                block13: {
                    Range<T> range;
                    int n8;
                    block12: {
                        GanttChart ganttChart;
                        block10: {
                            block11: {
                                GanttEntry<T> ganttEntry2;
                                block8: {
                                    n8 = y;
                                    ganttEntry2 = ganttEntry;
                                    if (n8 != 0) break block8;
                                    if (ganttEntry2 == null) break block9;
                                    ganttEntry2 = ganttEntry;
                                }
                                range = ganttEntry2.getRange();
                                ganttChart = this;
                                if (n8 == 0) {
                                    if (!ganttChart.a(range)) {
                                        return null;
                                    }
                                    ganttChart = this;
                                }
                                if (n8 != 0) break block10;
                                if (ganttChart.e == null) break block11;
                                n6 = this.e.getPosition(n2);
                                n5 = this.getRowHeight(n2);
                                if (n8 == 0) break block12;
                            }
                            ganttChart = this;
                        }
                        n5 = ganttChart.getRowHeight();
                        n6 = n2 * n5;
                    }
                    ScaleArea<T> scaleArea = this.getScaleArea();
                    n4 = scaleArea.getX(range.lower());
                    n3 = scaleArea.getX(range.upper());
                    n7 = n4;
                    if (n8 != 0) break block13;
                    if (n7 <= n3) break block14;
                    n7 = n3;
                }
                int n9 = n7;
                n3 = n4;
                n4 = n9;
            }
            return new Rectangle(n4, n6, n3 - n4, n5);
        }
        return null;
    }

    public Rectangle getRowRect(int n2, boolean bl) {
        int n3;
        int n4;
        block6: {
            GanttChart ganttChart;
            block4: {
                block5: {
                    int n5 = y;
                    ganttChart = this;
                    if (n5 != 0) break block4;
                    if (ganttChart.e == null) break block5;
                    n4 = this.e.getPosition(n2);
                    n3 = this.getRowHeight(n2);
                    if (n5 == 0) break block6;
                }
                ganttChart = this;
            }
            n3 = ganttChart.getRowHeight();
            n4 = n2 * n3;
        }
        int n6 = this.getRowMargin();
        if (bl) {
            return new Rectangle(0, n4, this.getWidth(), n3);
        }
        return new Rectangle(0, n4, this.getWidth(), n3 - n6);
    }

    public void autoResizePeriods(boolean n2) {
        block15: {
            GanttChart ganttChart;
            Range range;
            Object object;
            block13: {
                Object object2;
                block26: {
                    Object object3;
                    GanttChart ganttChart2;
                    int n3;
                    block19: {
                        block18: {
                            int n4;
                            int n5;
                            ScaleModel<GanttChart> scaleModel;
                            block21: {
                                int n6;
                                int n7;
                                block20: {
                                    int n8;
                                    block17: {
                                        ScaleModel<GanttChart> scaleModel2;
                                        block16: {
                                            ScaleArea<T> scaleArea;
                                            block14: {
                                                n3 = y;
                                                scaleArea = this.c;
                                                if (n3 != 0) break block14;
                                                if (scaleArea == null) break block15;
                                                scaleArea = this.c;
                                            }
                                            scaleModel2 = scaleArea.getScaleModel();
                                            if (n3 != 0) break block16;
                                            if (scaleModel2 == null) break block15;
                                            scaleModel2 = this.getScaleArea().getScaleModel();
                                        }
                                        scaleModel = scaleModel2;
                                        object2 = scaleModel.getDefaultStart();
                                        object = scaleModel.getDefaultEnd();
                                        n8 = n2;
                                        if (n3 != 0) break block17;
                                        if (n8 == 0) break block18;
                                        ganttChart2 = this;
                                        if (n3 != 0) break block19;
                                        n8 = ganttChart2.getEntryCount();
                                    }
                                    if (n8 <= 0) break block18;
                                    object3 = this.getVisibleRect();
                                    Point point = ((Rectangle)object3).getLocation();
                                    n5 = this.rowAtPoint(point);
                                    point.x += ((Rectangle)object3).width;
                                    point.y += ((Rectangle)object3).height;
                                    n7 = n4 = this.rowAtPoint(point);
                                    n6 = -1;
                                    if (n3 != 0) break block20;
                                    if (n7 != n6) break block21;
                                    n7 = this.getEntryCount();
                                    n6 = 1;
                                }
                                n4 = n7 - n6;
                            }
                            long l2 = Long.MAX_VALUE;
                            long l3 = Long.MIN_VALUE;
                            int n9 = n5;
                            while (n9 <= n4) {
                                block25: {
                                    block23: {
                                        long l4;
                                        long l5;
                                        GanttChart<T, S> ganttChart3;
                                        block24: {
                                            GanttChart<T, S> ganttChart4;
                                            Range range2;
                                            block22: {
                                                range2 = this.getEntryAt(n9).getRange();
                                                ganttChart4 = this;
                                                if (n3 != 0) break block22;
                                                range = range2;
                                                if (n3 != 0) break block13;
                                                if (!ganttChart4.a(range)) break block23;
                                                ganttChart4 = range2.lower();
                                            }
                                            ganttChart3 = ganttChart4;
                                            l5 = scaleModel.getPosition(ganttChart3);
                                            l4 = l5 == l2 ? 0 : (l5 < l2 ? -1 : 1);
                                            if (n3 != 0) break block24;
                                            if (l4 < 0) {
                                                l2 = l5;
                                                object2 = ganttChart3;
                                            }
                                            ganttChart3 = range2.upper();
                                            l5 = scaleModel.getPosition(ganttChart3);
                                            if (n3 != 0) break block25;
                                            l4 = l5 == l3 ? 0 : (l5 < l3 ? -1 : 1);
                                        }
                                        if (l4 > 0) {
                                            l3 = l5;
                                            object = ganttChart3;
                                        }
                                    }
                                    ++n9;
                                }
                                if (n3 == 0) continue;
                            }
                            if (n3 == 0) break block26;
                        }
                        ganttChart2 = this;
                    }
                    object3 = ganttChart2.d.getRange();
                    ganttChart = this;
                    range = object3;
                    if (n3 != 0) break block13;
                    if (ganttChart.a(range)) {
                        object2 = object3.lower();
                        object = object3.upper();
                    }
                }
                ganttChart = this;
                range = object2;
            }
            ganttChart.zoomPeriods(range, object);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean a(Range<T> range) {
        int n2 = y;
        Range<T> range2 = range;
        if (n2 == 0) {
            if (range2 == null) return false;
            range2 = range.lower();
        }
        if (n2 == 0) {
            if (range2 == null) return false;
            range2 = range.upper();
        }
        if (range2 == null) return false;
        return true;
    }

    public void zoomPeriods(T t, T t2) {
        ScaleArea<T> scaleArea = this.getScaleArea();
        if (scaleArea != null) {
            int n2 = this.getVisibleRect().width;
            if (y == 0) {
                if (n2 <= 0) {
                    n2 = this.getPreferredScrollableViewportSize().width;
                }
                scaleArea.setVisiblePeriodsToFit(t, t2, n2);
                this.resizeAndRepaint();
            }
            this.scrollSpanToVisible(t, t2);
        }
    }

    public void zoomInPeriods() {
        this.zoomPeriods(1.2);
    }

    public void zoomOutPeriods() {
        this.zoomPeriods(0.8);
    }

    public void zoomPeriods(double d2) {
        block3: {
            ScaleArea<T> scaleArea;
            block2: {
                ScaleArea<T> scaleArea2;
                scaleArea = scaleArea2 = this.getScaleArea();
                if (y != 0) break block2;
                if (scaleArea == null) break block3;
                scaleArea = scaleArea2;
            }
            scaleArea.zoomPeriodWidth(d2);
            this.resizeAndRepaint();
            this.scrollRowToVisible(this.getSelectedRow());
        }
    }

    public void scrollSpanToVisible(Range<T> range) {
        this.scrollSpanToVisible(range.lower(), range.upper());
    }

    public void scrollSpanToVisible(T t, T t2) {
        block6: {
            int n2;
            int n3;
            Rectangle rectangle;
            block8: {
                int n4;
                int n5;
                int n6;
                block7: {
                    GanttChart ganttChart;
                    int n7;
                    block5: {
                        n7 = y;
                        ganttChart = this;
                        if (n7 != 0) break block5;
                        if (ganttChart.c == null) break block6;
                        ganttChart = this;
                    }
                    rectangle = ganttChart.getVisibleRect();
                    int n8 = this.c.getX(t);
                    int n9 = this.c.getX(t2);
                    int n10 = n8;
                    if (n7 == 0) {
                        if (n10 > n9) {
                            n6 = n9;
                            n9 = n8;
                            n8 = n6;
                        }
                        n10 = rectangle.width;
                    }
                    n6 = n10;
                    int n11 = this.c.getPeriodMargin();
                    n3 = n8 - n11;
                    n5 = n2 = n9 - n8 + n11 * 2;
                    n4 = n6;
                    if (n7 != 0) break block7;
                    if (n5 >= n4) break block8;
                    n5 = 0;
                    n4 = n3 - (n6 - n2) / 2;
                }
                n3 = Math.max(n5, n4);
                n2 = n6;
            }
            this.scrollRectToVisible(new Rectangle(n3, rectangle.y, n2, rectangle.height));
        }
    }

    public void scrollRowToVisible(int n2) {
        block7: {
            Rectangle rectangle;
            int n3;
            int n4;
            block6: {
                n4 = y;
                n3 = n2;
                if (n4 != 0) break block6;
                if (n3 < 0) break block7;
                n3 = n2;
            }
            if (n3 < this.getEntryCount() && (rectangle = this.getEntryRect(n2)) != null) {
                int n5 = this.getRowHeight(n2);
                rectangle.y = Math.max(0, rectangle.y - n5);
                rectangle.height = Math.min(this.getHeight(), rectangle.height + n5 * 2);
                GanttChart ganttChart = this;
                if (n4 == 0) {
                    if (ganttChart.c != null) {
                        int n6 = this.c.getPeriodMargin();
                        rectangle.x -= n6;
                        rectangle.width += n6 * 2;
                    }
                    ganttChart = this;
                }
                ganttChart.scrollRectToVisible(rectangle);
            }
        }
    }

    public GanttEntryRenderer getEntryRenderer(int n2) {
        return this.getDefaultEntryRenderer();
    }

    public GanttEntryRenderer getEntryRenderer(int n2, int n3) {
        return this.getEntryRenderer(n2);
    }

    public GanttEntryRenderer getDefaultEntryRenderer() {
        return this.q;
    }

    public void setDefaultEntryRenderer(GanttEntryRenderer ganttEntryRenderer) {
        this.q = ganttEntryRenderer;
    }

    public GanttLabelRenderer getLabelRenderer(int n2) {
        return this.getDefaultLabelRenderer();
    }

    public GanttLabelRenderer getLabelRenderer(int n2, int n3) {
        return this.getDefaultLabelRenderer();
    }

    public GanttLabelRenderer getDefaultLabelRenderer() {
        return this.r;
    }

    public void setDefaultLabelRenderer(GanttLabelRenderer ganttLabelRenderer) {
        this.r = ganttLabelRenderer;
    }

    public int getLabelPosition() {
        return this.s;
    }

    public void setLabelPosition(int n2) {
        block3: {
            int n3;
            block2: {
                n3 = this.s;
                if (y != 0) break block2;
                if (n3 == n2) break block3;
                this.s = n2;
            }
            this.firePropertyChange(PROPERTY_LABEL_POSITION, n3, this.s);
        }
    }

    public int getLabelEntryGap() {
        return this.t;
    }

    public void setLabelEntryGap(int n2) {
        block3: {
            int n3;
            block2: {
                n3 = this.t;
                if (y != 0) break block2;
                if (n3 == n2) break block3;
                this.t = n2;
            }
            this.firePropertyChange(PROPERTY_LABEL_ENTRY_GAP, n3, this.t);
        }
    }

    @Deprecated
    public Component prepareRenderer(GanttEntryRenderer ganttEntryRenderer, int n2, Insets insets) {
        return this.prepareRenderer(ganttEntryRenderer, n2, -1, insets);
    }

    public Component prepareRenderer(GanttEntryRenderer ganttEntryRenderer, int n2, int n3, Insets insets) {
        S s = this.getEntryAt(n2, n3);
        boolean bl = false;
        boolean bl2 = false;
        return ganttEntryRenderer.getGanttEntryRendererComponent(this, (GanttEntry<?>)s, bl, bl2, n2, n3, insets);
    }

    public Component prepareLabelRenderer(GanttLabelRenderer ganttLabelRenderer, int n2) {
        return this.prepareLabelRenderer(ganttLabelRenderer, n2, -1);
    }

    public Component prepareLabelRenderer(GanttLabelRenderer ganttLabelRenderer, int n2, int n3) {
        S s = this.getEntryAt(n2, n3);
        boolean bl = false;
        boolean bl2 = false;
        return ganttLabelRenderer.getGanttLabelRendererComponent(this, (GanttEntry<?>)s, bl, bl2, n2, n3);
    }

    public GanttEntryRelationPainter getRelationPainter(int n2) {
        return this.a.get(n2);
    }

    public void setRelationPainter(int n2, GanttEntryRelationPainter ganttEntryRelationPainter) {
        this.a.put(n2, ganttEntryRelationPainter);
    }

    public List<PeriodBackgroundPainter<T>> getPeriodBackgroundPainters() {
        return this.b;
    }

    public void addPeriodBackgroundPainter(PeriodBackgroundPainter<T> periodBackgroundPainter) {
        this.addPeriodBackgroundPainter(this.b.size(), periodBackgroundPainter);
    }

    public void addPeriodBackgroundPainter(int n2, PeriodBackgroundPainter<T> periodBackgroundPainter) {
        this.b.add(Math.min(n2, this.b.size()), periodBackgroundPainter);
    }

    public void removePeriodBackgroundPainter(PeriodBackgroundPainter<T> periodBackgroundPainter) {
        this.b.remove(periodBackgroundPainter);
    }

    public int getSelectionMode() {
        return this.getSelectionModel().getSelectionMode();
    }

    public ListSelectionModel getSelectionModel() {
        return this.f;
    }

    public void setSelectionModel(ListSelectionModel listSelectionModel) {
        block8: {
            ListSelectionModel listSelectionModel2;
            ListSelectionModel listSelectionModel3;
            int n2;
            block7: {
                n2 = y;
                ListSelectionModel listSelectionModel4 = listSelectionModel;
                if (n2 == 0) {
                    if (listSelectionModel4 == null) {
                        throw new IllegalArgumentException("Cannot set a null SelectionModel");
                    }
                    listSelectionModel4 = this.f;
                }
                listSelectionModel3 = listSelectionModel4;
                listSelectionModel2 = listSelectionModel;
                if (n2 != 0) break block7;
                if (listSelectionModel2 == listSelectionModel3) break block8;
                listSelectionModel2 = listSelectionModel3;
            }
            if (n2 == 0) {
                if (listSelectionModel2 != null) {
                    listSelectionModel3.removeListSelectionListener(this);
                }
                listSelectionModel2 = this.f = listSelectionModel;
            }
            listSelectionModel2.addListSelectionListener(this);
            this.firePropertyChange("selectionModel", listSelectionModel3, this.f);
            this.repaint();
        }
    }

    public void setSelectionMode(int n2) {
        this.clearSelection();
        this.getSelectionModel().setSelectionMode(n2);
    }

    public void clearSelection() {
        this.f.clearSelection();
    }

    private int a(int n2) {
        int n3 = this.getEntryCount();
        int n4 = n2;
        if (y == 0) {
            n4 = n4 < n3 ? n2 : -1;
        }
        return n4;
    }

    public void selectAll() {
        block3: {
            GanttChart ganttChart;
            block2: {
                ganttChart = this;
                if (y != 0) break block2;
                if (ganttChart.getEntryCount() <= 0) break block3;
                ganttChart = this;
            }
            ListSelectionModel listSelectionModel = ganttChart.f;
            listSelectionModel.setValueIsAdjusting(true);
            this.setSelectionInterval(0, this.getEntryCount() - 1);
            listSelectionModel.setValueIsAdjusting(false);
            listSelectionModel.setValueIsAdjusting(false);
        }
    }

    private int b(int n2) throws IllegalArgumentException {
        int n3;
        block4: {
            block5: {
                block3: {
                    int n4;
                    block2: {
                        n4 = y;
                        n3 = n2;
                        if (n4 != 0) break block2;
                        if (n3 < 0) break block3;
                        n3 = n2;
                    }
                    if (n4 != 0) break block4;
                    if (n3 < this.getEntryCount()) break block5;
                }
                throw new IllegalArgumentException("Entry index out of range");
            }
            n3 = n2;
        }
        return n3;
    }

    public void setSelectedIndex(int n2) {
        if (n2 >= this.getEntryCount()) {
            return;
        }
        this.getSelectionModel().setSelectionInterval(n2, n2);
    }

    public void setSelectionInterval(int n2, int n3) {
        this.f.setSelectionInterval(this.b(n2), this.b(n3));
    }

    public void addSelectionInterval(int n2, int n3) {
        this.f.addSelectionInterval(this.b(n2), this.b(n3));
    }

    public void removeSelectionInterval(int n2, int n3) {
        this.f.removeSelectionInterval(this.b(n2), this.b(n3));
    }

    public int getSelectedRow() {
        return this.f.getMinSelectionIndex();
    }

    public int[] getSelectedRows() {
        int n2;
        int n3;
        int[] nArray;
        block6: {
            int n4;
            int n5;
            int n6;
            int n7;
            block9: {
                int n8;
                block10: {
                    int n9;
                    block7: {
                        block8: {
                            n7 = y;
                            n8 = this.f.getMinSelectionIndex();
                            n6 = this.f.getMaxSelectionIndex();
                            n9 = n8;
                            if (n7 != 0) break block7;
                            if (n9 == -1) break block8;
                            n5 = n6;
                            n4 = -1;
                            if (n7 != 0) break block9;
                            if (n5 != n4) break block10;
                        }
                        n9 = 0;
                    }
                    return new int[n9];
                }
                n5 = 1;
                n4 = n6 - n8;
            }
            nArray = new int[n5 + n4];
            n3 = 0;
            for (int i2 = n8; i2 <= n6; ++i2) {
                n2 = this.f.isSelectedIndex(i2) ? 1 : 0;
                if (n7 == 0) {
                    if (n2 == 0) continue;
                    nArray[n3++] = i2;
                    if (n7 == 0) continue;
                }
                break block6;
            }
            n2 = n3;
        }
        int[] nArray2 = new int[n2];
        System.arraycopy(nArray, 0, nArray2, 0, n3);
        return nArray2;
    }

    public int getSelectedRowCount() {
        int n2;
        block2: {
            int n3 = y;
            int n4 = this.f.getMinSelectionIndex();
            int n5 = this.f.getMaxSelectionIndex();
            int n6 = 0;
            for (int i2 = n4; i2 <= n5; ++i2) {
                n2 = this.f.isSelectedIndex(i2) ? 1 : 0;
                if (n3 == 0) {
                    if (n2 == 0) continue;
                    ++n6;
                    if (n3 == 0) continue;
                }
                break block2;
            }
            n2 = n6;
        }
        return n2;
    }

    public int getAnchorSelectionIndex() {
        return this.getSelectionModel().getAnchorSelectionIndex();
    }

    public int getLeadSelectionIndex() {
        return this.getSelectionModel().getLeadSelectionIndex();
    }

    public int getMinSelectionIndex() {
        return this.getSelectionModel().getMinSelectionIndex();
    }

    public int getMaxSelectionIndex() {
        return this.getSelectionModel().getMaxSelectionIndex();
    }

    public void setValueIsAdjusting(boolean bl) {
        this.getSelectionModel().setValueIsAdjusting(bl);
    }

    public boolean getValueIsAdjusting() {
        return this.getSelectionModel().getValueIsAdjusting();
    }

    public boolean isRowSelected(int n2) {
        return this.f.isSelectedIndex(n2);
    }

    private void a(ListSelectionModel listSelectionModel, int n2, boolean bl, boolean bl2, boolean bl3, int n3, boolean bl4) {
        block7: {
            block10: {
                int n4;
                block11: {
                    boolean bl5;
                    block9: {
                        block2: {
                            block3: {
                                block5: {
                                    block8: {
                                        block6: {
                                            boolean bl6;
                                            block4: {
                                                n4 = y;
                                                bl5 = bl2;
                                                if (n4 != 0) break block2;
                                                if (!bl5) break block3;
                                                bl6 = bl;
                                                if (n4 != 0) break block4;
                                                if (!bl6) break block5;
                                                bl6 = bl4;
                                            }
                                            if (!bl6) break block6;
                                            listSelectionModel.addSelectionInterval(n3, n2);
                                            if (n4 == 0) break block7;
                                        }
                                        listSelectionModel.removeSelectionInterval(n3, n2);
                                        if (n4 != 0) break block8;
                                        if (Boolean.TRUE != this.getClientProperty("Table.isFileList")) break block7;
                                        listSelectionModel.addSelectionInterval(n2, n2);
                                        listSelectionModel.setAnchorSelectionIndex(n3);
                                    }
                                    if (n4 == 0) break block7;
                                }
                                listSelectionModel.setSelectionInterval(n3, n2);
                                if (n4 == 0) break block7;
                            }
                            bl5 = bl;
                        }
                        if (n4 != 0) break block9;
                        if (!bl5) break block10;
                        bl5 = bl3;
                    }
                    if (!bl5) break block11;
                    listSelectionModel.removeSelectionInterval(n2, n2);
                    if (n4 == 0) break block7;
                }
                listSelectionModel.addSelectionInterval(n2, n2);
                if (n4 == 0) break block7;
            }
            listSelectionModel.setSelectionInterval(n2, n2);
        }
    }

    /*
     * Exception decompiling
     */
    public void changeSelection(int var1_1, boolean var2_2, boolean var3_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Statement already marked as first in another block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.markFirstStatementInBlock(Op03SimpleStatement.java:461)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Misc.markWholeBlock(Misc.java:251)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.considerAsSimpleIf(ConditionalRewriter.java:673)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.identifyNonjumpingConditionals(ConditionalRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:722)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Color getSelectionForeground() {
        return this.g;
    }

    public void setSelectionForeground(Color color) {
        block3: {
            GanttChart ganttChart;
            block2: {
                Color color2 = this.g;
                this.g = color;
                ganttChart = this;
                if (y != 0) break block2;
                ganttChart.firePropertyChange("selectionForeground", color2, color);
                if (color.equals(color2)) break block3;
                ganttChart = this;
            }
            ganttChart.repaint();
        }
    }

    public Color getSelectionBackground() {
        return this.h;
    }

    public void setSelectionBackground(Color color) {
        block3: {
            GanttChart ganttChart;
            block2: {
                Color color2 = this.h;
                this.h = color;
                ganttChart = this;
                if (y != 0) break block2;
                ganttChart.firePropertyChange("selectionBackground", color2, color);
                if (color.equals(color2)) break block3;
                ganttChart = this;
            }
            ganttChart.repaint();
        }
    }

    protected ListSelectionModel createDefaultSelectionModel() {
        return new DefaultListSelectionModel();
    }

    private int a(int n2, int n3, int n4) {
        return Math.min(n4, Math.max(n2, n3));
    }

    public void ensureRowIsVisible(int n2) {
        Rectangle rectangle = this.getRowRect(n2, true);
        if (rectangle != null) {
            this.scrollRectToVisible(rectangle);
        }
    }

    @Override
    public void repaint(long l2, int n2, int n3, int n4, int n5) {
        super.repaint(l2, n2, n3, n4, n5);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void valueChanged(ListSelectionEvent var1_1) {
        var8_2 = GanttChart.y;
        var2_3 = var1_1.getValueIsAdjusting();
        v0 = this.x;
        if (var8_2 == 0) {
            if (v0 != 0) {
                v0 = var2_3;
                if (var8_2 == 0) {
                    if (v0 == 0) {
                        this.x = false;
                        return;
                    } else {
                        ** GOTO lbl-1000
                    }
                }
            } else lbl-1000:
            // 3 sources

            {
                this.x = var2_3;
                v0 = this.getEntryCount();
            }
        }
        if (var8_2 == 0) {
            if (v0 <= 0) {
                return;
            }
            v0 = this.a(var1_1.getFirstIndex(), 0, this.getEntryCount() - 1);
        }
        var3_4 = v0;
        var4_5 = this.a(var1_1.getLastIndex(), 0, this.getEntryCount() - 1);
        v1 = this.isShowGrid();
        if (var8_2 == 0) {
            v1 = v1 == false;
        }
        var5_6 = this.getRowRect(var3_4, v1);
        v2 = this.isShowGrid();
        if (var8_2 == 0) {
            v2 = v2 == false;
        }
        var6_7 = this.getRowRect(var4_5, v2);
        var7_8 = var5_6.union(var6_7);
        this.repaint(var7_8);
    }

    public String getResourceString(String string) {
        return GanttResources.getResourceBundle(this.getLocale()).getString(string);
    }

    public boolean isAllowMoveEntry() {
        return this.u;
    }

    public void setAllowMoveEntry(boolean bl) {
        this.u = bl;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        block5: {
            FocusListener[] focusListenerArray;
            int n2 = y;
            if (!"treeTable".equals(propertyChangeEvent.getPropertyName())) break block5;
            FocusListener[] focusListenerArray2 = focusListenerArray = this.getFocusListeners();
            int n3 = focusListenerArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                block6: {
                    block7: {
                        Object object;
                        FocusListener focusListener;
                        block12: {
                            boolean bl;
                            block11: {
                                block10: {
                                    block9: {
                                        block8: {
                                            focusListener = focusListenerArray2[n4];
                                            if (n2 != 0) break block6;
                                            if (!(focusListener instanceof KeyListener)) break block7;
                                            bl = focusListener instanceof TreeWillExpandListener;
                                            if (n2 != 0) break block8;
                                            if (!bl) break block7;
                                            bl = focusListener instanceof TreeExpansionListener;
                                        }
                                        if (n2 != 0) break block9;
                                        if (!bl) break block7;
                                        bl = focusListener instanceof PropertyChangeListener;
                                    }
                                    if (n2 != 0) break block10;
                                    if (!bl) break block7;
                                    bl = propertyChangeEvent.getOldValue() instanceof TreeTable;
                                }
                                if (n2 != 0) break block11;
                                if (bl) {
                                    ((TreeTable)propertyChangeEvent.getOldValue()).removeTreeExpansionListener((TreeExpansionListener)((Object)focusListener));
                                    ((TreeTable)propertyChangeEvent.getOldValue()).removeTreeWillExpandListener((TreeWillExpandListener)((Object)focusListener));
                                }
                                object = propertyChangeEvent.getNewValue();
                                if (n2 != 0) break block12;
                                bl = object instanceof TreeTable;
                            }
                            if (!bl) break;
                            ((TreeTable)propertyChangeEvent.getNewValue()).addTreeExpansionListener((TreeExpansionListener)((Object)focusListener));
                            object = propertyChangeEvent.getNewValue();
                        }
                        ((TreeTable)object).addTreeWillExpandListener((TreeWillExpandListener)((Object)focusListener));
                        if (n2 == 0) break;
                    }
                    ++n4;
                }
                if (n2 == 0) continue;
            }
        }
    }

    public int getResizeAreaWidth() {
        return this.v;
    }

    public void setResizeAreaWidth(int n2) {
        this.v = n2;
    }

    public boolean isResizeWestArea(Point point, Rectangle rectangle) {
        int n2 = point.x;
        if (y == 0) {
            n2 = n2 < rectangle.x ? 1 : 0;
        }
        return n2 != 0;
    }

    public boolean isResizeEastArea(Point point, Rectangle rectangle) {
        int n2 = point.x;
        if (y == 0) {
            n2 = n2 >= rectangle.x + rectangle.width ? 1 : 0;
        }
        return n2 != 0;
    }

    public boolean isAllowResizeEntry(GanttEntry<T> ganttEntry, T t, T t2) {
        return true;
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29) {
                System.err.println("The Lm class is invalid, exiting ...");
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(8192)) {
            Lm.showInvalidProductMessage(GanttChart.class.getName(), 8192);
        }
        w = UIDefaultsLookup.getInsets("TaskBar.padding");
    }
}

