/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.gantt;

import com.jidesoft.gantt.GanttChart;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.TexturePaint;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public abstract class PaintedTexture {
    private final int a;
    private final int b;

    public PaintedTexture(int n2, int n3) {
        this.a = n2;
        this.b = n3;
    }

    public int getWidth() {
        return this.a;
    }

    public int getHeight() {
        return this.b;
    }

    protected abstract void drawTexture(Graphics2D var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TexturePaint createTexturePaint() {
        BufferedImage bufferedImage = new BufferedImage(this.a, this.b, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        try {
            this.drawTexture(graphics2D);
        }
        finally {
            graphics2D.dispose();
        }
        return new TexturePaint(bufferedImage, new Rectangle2D.Double(0.0, 0.0, this.a, this.b));
    }

    public static TexturePaint createDiagonalLines(int n2, int n3, final Paint paint, final boolean bl, final boolean bl2) {
        return new PaintedTexture(n2, n3){

            @Override
            protected void drawTexture(Graphics2D graphics2D) {
                graphics2D.setPaint(paint);
                boolean bl3 = bl;
                if (GanttChart.y == 0) {
                    if (bl3) {
                        graphics2D.drawLine(0, this.getHeight() - 1, this.getWidth() - 1, 0);
                    }
                    bl3 = bl2;
                }
                if (bl3) {
                    graphics2D.drawLine(0, 0, this.getWidth() - 1, this.getHeight() - 1);
                }
            }
        }.createTexturePaint();
    }

    public static TexturePaint createLines(int n2, int n3, final Paint paint, final boolean bl, final boolean bl2) {
        return new PaintedTexture(n2, n3){

            @Override
            protected void drawTexture(Graphics2D graphics2D) {
                graphics2D.setPaint(paint);
                boolean bl3 = bl;
                if (GanttChart.y == 0) {
                    if (bl3) {
                        graphics2D.drawLine(0, this.getHeight() / 2, this.getWidth() - 1, this.getHeight() / 2);
                    }
                    bl3 = bl2;
                }
                if (bl3) {
                    graphics2D.drawLine(this.getWidth() / 2, 0, this.getWidth() / 2, this.getHeight() - 1);
                }
            }
        }.createTexturePaint();
    }
}

