/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.FontUtils;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.StyleRange;
import com.jidesoft.swing.StyledLabel;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicLabelUI;
import javax.swing.text.View;

public class BasicStyledLabelUI
extends BasicLabelUI
implements SwingConstants {
    public static Comparator<StyleRange> _comparator;
    protected static BasicStyledLabelUI styledLabelUI;
    private final List<StyledText> _styledTexts = new ArrayList<StyledText>();
    private int _preferredRowCount = 1;
    private boolean _gettingPreferredSize;

    public static ComponentUI createUI(JComponent jComponent) {
        return styledLabelUI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        super.propertyChange(propertyChangeEvent);
        if ("styleRange".equals(propertyChangeEvent.getPropertyName())) {
            List<StyledText> list = this._styledTexts;
            synchronized (list) {
                this._styledTexts.clear();
            }
            if (propertyChangeEvent.getSource() instanceof StyledLabel) {
                ((StyledLabel)propertyChangeEvent.getSource()).revalidate();
                ((StyledLabel)propertyChangeEvent.getSource()).repaint();
            }
        } else if ("ignoreColorSettings".equals(propertyChangeEvent.getPropertyName()) && propertyChangeEvent.getSource() instanceof StyledLabel) {
            ((StyledLabel)propertyChangeEvent.getSource()).repaint();
        }
    }

    @Override
    protected void paintEnabledText(JLabel jLabel, Graphics graphics, String string, int n2, int n3) {
        View view;
        View view2 = view = jLabel != null ? (View)jLabel.getClientProperty("html") : null;
        if (view != null) {
            super.paintEnabledText(jLabel, graphics, string, n2, n3);
        } else {
            this.paintStyledText((StyledLabel)jLabel, graphics, n2, n3);
        }
    }

    @Override
    protected void paintDisabledText(JLabel jLabel, Graphics graphics, String string, int n2, int n3) {
        View view;
        View view2 = view = jLabel != null ? (View)jLabel.getClientProperty("html") : null;
        if (view != null) {
            super.paintDisabledText(jLabel, graphics, string, n2, n3);
        } else {
            this.paintStyledText((StyledLabel)jLabel, graphics, n2, n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void buildStyledText(StyledLabel styledLabel) {
        List<StyledText> list = this._styledTexts;
        synchronized (list) {
            this._styledTexts.clear();
            StyleRange[] styleRangeArray = styledLabel.getStyleRanges();
            if (_comparator == null) {
                _comparator = new Comparator<StyleRange>(){

                    @Override
                    public int compare(StyleRange styleRange, StyleRange styleRange2) {
                        if (styleRange.getStart() < styleRange2.getStart()) {
                            return -1;
                        }
                        if (styleRange.getStart() > styleRange2.getStart()) {
                            return 1;
                        }
                        return 0;
                    }
                };
            }
            Arrays.sort(styleRangeArray, _comparator);
            String string = styledLabel.getText();
            if (string != null && string.length() > 0) {
                int n2 = 0;
                for (StyleRange styleRange : styleRangeArray) {
                    String string2;
                    if (n2 >= string.length()) break;
                    if (styleRange.getStart() > n2) {
                        string2 = string.substring(n2, Math.min(styleRange.getStart(), string.length()));
                        StyleRange styleRange2 = new StyleRange(n2, styleRange.getStart() - n2, -1);
                        this.addStyledTexts(string2, styleRange2, styledLabel);
                        n2 = styleRange.getStart();
                    }
                    if (styleRange.getStart() == n2) {
                        if (styleRange.getLength() == -1) {
                            string2 = string.substring(n2);
                            this.addStyledTexts(string2, styleRange, styledLabel);
                            n2 = string.length();
                            continue;
                        }
                        string2 = string.substring(n2, Math.min(n2 + styleRange.getLength(), string.length()));
                        this.addStyledTexts(string2, styleRange, styledLabel);
                        n2 += styleRange.getLength();
                        continue;
                    }
                    if (styleRange.getStart() >= n2) continue;
                }
                if (n2 < string.length()) {
                    String string3 = string.substring(n2, string.length());
                    StyleRange styleRange = new StyleRange(n2, string.length() - n2, -1);
                    this.addStyledTexts(string3, styleRange, styledLabel);
                }
            }
        }
    }

    private void addStyledTexts(String string, StyleRange styleRange, StyledLabel styledLabel) {
        styleRange = new StyleRange(styleRange);
        int n2 = string.indexOf(13);
        int n3 = string.indexOf(10);
        while (n2 >= 0 || n3 >= 0) {
            int n4;
            int n5 = n4 = n2 >= 0 ? n2 : -1;
            if (n3 >= 0 && (n3 < n2 || n4 < 0)) {
                n4 = n3;
            }
            String string2 = string.substring(0, n4);
            StyleRange styleRange2 = new StyleRange(styleRange);
            styleRange2.setStart(styleRange.getStart());
            styleRange2.setLength(n4);
            this._styledTexts.add(new StyledText(string2, styleRange2));
            int n6 = 1;
            if (string.charAt(n4) == '\r' && n4 + 1 < string.length() && string.charAt(n4 + 1) == '\n') {
                ++n6;
            }
            styleRange2 = new StyleRange(styleRange);
            styleRange2.setStart(styleRange.getStart() + n4);
            styleRange2.setLength(n6);
            this._styledTexts.add(new StyledText(string.substring(n4, n4 + n6), styleRange2));
            string = string.substring(n4 + n6);
            styleRange.setStart(styleRange.getStart() + n4 + n6);
            styleRange.setLength(styleRange.getLength() - n4 - n6);
            n2 = string.indexOf(13);
            n3 = string.indexOf(10);
        }
        if (string.length() > 0) {
            this._styledTexts.add(new StyledText(string, styleRange));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension;
        this._gettingPreferredSize = true;
        try {
            dimension = super.getPreferredSize(jComponent);
        }
        finally {
            this._gettingPreferredSize = false;
        }
        return dimension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    protected String layoutCL(JLabel var1_1, FontMetrics var2_2, String var3_3, Icon var4_4, Rectangle var5_5, Rectangle var6_6, Rectangle var7_7) {
        var8_8 = null;
        if (var1_1 instanceof StyledLabel) {
            var9_9 = ((StyledLabel)var1_1).getPreferredWidth();
            var10_10 = ((StyledLabel)var1_1).getRows();
            try {
                if (((StyledLabel)var1_1).isLineWrap() && var1_1.getWidth() > 0) {
                    ((StyledLabel)var1_1).setPreferredWidth(var1_1.getWidth());
                }
                var8_8 = this.getPreferredSize((StyledLabel)var1_1);
                if (var9_9 > 0 && var9_9 < var1_1.getWidth()) {
                    ((StyledLabel)var1_1).setPreferredWidth(var9_9);
                    var8_8 = this.getPreferredSize((StyledLabel)var1_1);
                }
                if (!((StyledLabel)var1_1).isLineWrap() || ((StyledLabel)var1_1).getMinRows() <= 0) ** GOTO lbl25
                ((StyledLabel)var1_1).setPreferredWidth(0);
                ((StyledLabel)var1_1).setRows(0);
                var11_11 = this.getPreferredSize((StyledLabel)var1_1);
                if (var11_11.height <= var8_8.height) ** GOTO lbl25
                var8_8 = var11_11;
            }
            finally {
                ((StyledLabel)var1_1).setPreferredWidth(var9_9);
                ((StyledLabel)var1_1).setRows(var10_10);
            }
        } else {
            var8_8 = var1_1.getPreferredSize();
        }
lbl25:
        // 5 sources

        var7_7.width = var8_8.width;
        var7_7.height = var8_8.height;
        if (var1_1.getIcon() != null) {
            var7_7.width -= var1_1.getIcon().getIconWidth() + var1_1.getIconTextGap();
        }
        return BasicStyledLabelUI.layoutCompoundLabel(var1_1, var2_2, var3_3, var4_4, var1_1.getVerticalAlignment(), var1_1.getHorizontalAlignment(), var1_1.getVerticalTextPosition(), var1_1.getHorizontalTextPosition(), var5_5, var6_6, var7_7, var1_1.getIconTextGap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Dimension getPreferredSize(StyledLabel styledLabel) {
        this.buildStyledText(styledLabel);
        Font font = this.getFont(styledLabel);
        FontMetrics fontMetrics = styledLabel.getFontMetrics(font);
        int n2 = font.getSize();
        boolean bl = styledLabel.isLineWrap() || styledLabel.getText() != null && (styledLabel.getText().contains("\r") || styledLabel.getText().contains("\n"));
        List<StyledText> list = this._styledTexts;
        synchronized (list) {
            int n3;
            Object object;
            FontMetrics fontMetrics2;
            Object object2;
            StyledText[] styledTextArray = this._styledTexts.toArray(new StyledText[this._styledTexts.size()]);
            int n4 = fontMetrics.getHeight();
            for (StyledText styledText : styledTextArray) {
                object2 = styledText.styleRange;
                int n5 = object2 != null && (((StyleRange)object2).isSuperscript() || ((StyleRange)object2).isSubscript()) ? Math.round((float)n2 / ((StyleRange)object2).getFontShrinkRatio()) : n2;
                font = this.getFont(styledLabel);
                int n6 = fontMetrics.getHeight();
                if (object2 != null && (((StyleRange)object2).getFontStyle() != -1 && font.getStyle() != ((StyleRange)object2).getFontStyle() || font.getSize() != n5)) {
                    font = FontUtils.getCachedDerivedFont(font, ((StyleRange)object2).getFontStyle() == -1 ? font.getStyle() : ((StyleRange)object2).getFontStyle(), n5);
                    fontMetrics2 = styledLabel.getFontMetrics(font);
                    n6 = fontMetrics2.getHeight();
                }
                n4 = Math.max(n4, ++n6);
            }
            int n7 = 1;
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            object2 = new ArrayList();
            for (StyledText styledText : this._styledTexts) {
                object = styledText.styleRange;
                int n11 = object != null && (((StyleRange)object).isSuperscript() || ((StyleRange)object).isSubscript()) ? Math.round((float)n2 / ((StyleRange)object).getFontShrinkRatio()) : n2;
                font = this.getFont(styledLabel);
                String string = styledText.text.substring(n8);
                if (string.startsWith("\r") || string.startsWith("\n")) {
                    object2.add(n9);
                    n10 = Math.max(n9, n10);
                    n9 = 0;
                    if (styledLabel.getMaxRows() <= 0 || ++n7 < styledLabel.getMaxRows()) continue;
                    break;
                }
                if (object != null && (((StyleRange)object).getFontStyle() != -1 && font.getStyle() != ((StyleRange)object).getFontStyle() || font.getSize() != n11)) {
                    font = FontUtils.getCachedDerivedFont(font, ((StyleRange)object).getFontStyle() == -1 ? font.getStyle() : ((StyleRange)object).getFontStyle(), n11);
                    fontMetrics2 = styledLabel.getFontMetrics(font);
                    n9 += fontMetrics2.stringWidth(string);
                    continue;
                }
                n9 += fontMetrics.stringWidth(string);
            }
            object2.add(n9);
            int n12 = n10 = Math.max(n9, n10);
            this._preferredRowCount = n7;
            if (bl && styledLabel.getPreferredWidth() <= 0 && styledLabel.getRows() > 0) {
                n10 = this.getMaximumWidth(styledLabel, n10, n7, styledLabel.getRows());
            }
            if ((n3 = styledLabel.getPreferredWidth()) > 0 && styledLabel.getInsets() != null) {
                n3 -= styledLabel.getInsets().left + styledLabel.getInsets().right;
            }
            if (styledLabel.getIcon() != null && styledLabel.getHorizontalTextPosition() != 0) {
                n3 -= styledLabel.getIcon().getIconWidth() + styledLabel.getIconTextGap();
            }
            if (bl && n3 > 0 && n10 > n3) {
                n10 = this.getLayoutWidth(styledLabel, n3);
            }
            if (bl && styledLabel.getMaxRows() > 0 && this._preferredRowCount > styledLabel.getMaxRows()) {
                if (styledLabel.getPreferredWidth() <= 0) {
                    n10 = this.getMaximumWidth(styledLabel, n10, n7, styledLabel.getMaxRows());
                } else {
                    this._preferredRowCount = styledLabel.getMaxRows();
                }
            }
            if (bl && styledLabel.getPreferredWidth() <= 0 && styledLabel.getMinRows() > 0 && this._preferredRowCount < styledLabel.getMinRows()) {
                n10 = this.getMaximumWidth(styledLabel, n10, n7, styledLabel.getMinRows());
            }
            if (this._gettingPreferredSize && styledLabel.getRows() > 0 && this._preferredRowCount > styledLabel.getRows() && (styledLabel.getPreferredWidth() <= 0 || styledLabel.getPreferredWidth() >= n12 || n7 > styledLabel.getRows())) {
                this._preferredRowCount = styledLabel.getRows();
                n12 = 0;
                for (int i2 = 0; i2 < object2.size() && i2 < this._preferredRowCount; ++i2) {
                    n12 = Math.max(n12, (Integer)object2.get(i2));
                }
            }
            object = new Dimension(Math.min(n10, n12), (n4 + Math.max(0, styledLabel.getRowGap())) * this._preferredRowCount);
            if (styledLabel.getIcon() != null) {
                object = new Dimension(((Dimension)object).width + styledLabel.getIconTextGap() + styledLabel.getIcon().getIconWidth(), ((Dimension)object).height);
            }
            return object;
        }
    }

    private int getLayoutWidth(StyledLabel styledLabel, int n2) {
        Font font = this.getFont(styledLabel);
        int n3 = font.getSize();
        FontMetrics fontMetrics = styledLabel.getFontMetrics(font);
        int n4 = 0;
        int n5 = 0;
        this._preferredRowCount = 1;
        for (int i2 = 0; i2 < this._styledTexts.size(); ++i2) {
            FontMetrics fontMetrics2;
            StyledText styledText = this._styledTexts.get(i2);
            StyleRange styleRange = styledText.styleRange;
            if (styledText.text.contains("\r") || styledText.text.contains("\n")) {
                n5 = 0;
                ++this._preferredRowCount;
                continue;
            }
            int n6 = styleRange != null && (styleRange.isSuperscript() || styleRange.isSubscript()) ? Math.round((float)n3 / styleRange.getFontShrinkRatio()) : n3;
            font = this.getFont(styledLabel);
            if (styleRange != null && (styleRange.getFontStyle() != -1 && font.getStyle() != styleRange.getFontStyle() || font.getSize() != n6)) {
                font = FontUtils.getCachedDerivedFont(font, styleRange.getFontStyle() == -1 ? font.getStyle() : styleRange.getFontStyle(), n6);
                fontMetrics2 = styledLabel.getFontMetrics(font);
            } else {
                fontMetrics2 = fontMetrics;
            }
            String string = styledText.text.substring(n4);
            int n7 = fontMetrics2.stringWidth(string);
            boolean bl = false;
            int n8 = n2 - n5;
            if (n8 < n7) {
                String string2;
                int n9;
                bl = true;
                int n10 = string.length() * n8 / n7 + 1;
                int n11 = 0;
                boolean bl2 = false;
                boolean bl3 = false;
                int n12 = 0;
                do {
                    String string3;
                    int n13;
                    int n14 = n9 = (n13 = this.findFirstRowWordEndIndex(string2 = string.substring(0, Math.min(n10, string.length())))) < 0 ? 0 : this.findNextWordStartIndex(string, n13);
                    if (n13 < 0) {
                        if (n5 != 0) {
                            n5 = 0;
                            --i2;
                            ++this._preferredRowCount;
                            if (styledLabel.getMaxRows() > 0 && this._preferredRowCount >= styledLabel.getMaxRows()) {
                                bl2 = true;
                            }
                            bl3 = true;
                            break;
                        }
                        n13 = 0;
                        n9 = Math.min(string.length(), n10);
                    }
                    if ((n7 = fontMetrics2.stringWidth(string3 = string.substring(0, Math.min(n11 = n13 + 1, string.length())))) > n8) {
                        n10 = string2.length() * n8 / n7;
                    }
                    if (++n12 <= 50) continue;
                    System.err.println("Painting Styled Label Error: " + styledText);
                    break;
                } while (n7 > n8 && n10 > 0);
                if (bl2) break;
                if (bl3) continue;
                while (n11 < n9 && (n7 += fontMetrics2.charWidth(string.charAt(n11))) < n8) {
                    ++n11;
                }
                string2 = string.substring(0, Math.min(n11, string.length()));
                n7 = fontMetrics2.stringWidth(string2);
                while (n11 < n9 && (n7 += fontMetrics2.charWidth(string.charAt(n11))) < n8) {
                    ++n11;
                }
                string = string.substring(0, Math.min(n11, string.length()));
                n7 = fontMetrics2.stringWidth(string);
                n4 += n11;
            } else {
                n4 = 0;
            }
            if (bl) {
                ++this._preferredRowCount;
                n5 = 0;
                --i2;
                continue;
            }
            n5 += n7;
        }
        return n2;
    }

    private int getMaximumWidth(StyledLabel styledLabel, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7 = styledLabel.getWidth() - styledLabel.getInsets().left - styledLabel.getInsets().right;
        if (styledLabel.getIcon() != null) {
            n7 -= styledLabel.getIcon().getIconWidth() + styledLabel.getIconTextGap();
        }
        if (n3 > 1) {
            int n8 = 1;
            int n9 = n2;
            this._preferredRowCount = n3;
            while (n8 < n9) {
                int n10 = (n9 + n8) / 2;
                n2 = this.getLayoutWidth(styledLabel, n10);
                if (this._preferredRowCount > n4) {
                    n8 = n10 + 1;
                    this._preferredRowCount = n3;
                    continue;
                }
                n9 = n10 - 1;
            }
            return n2 + n2 / 20;
        }
        int n11 = n2 / n4 + 1;
        int n12 = 0;
        int n13 = 0;
        Font font = this.getFont(styledLabel);
        FontMetrics fontMetrics = styledLabel.getFontMetrics(font);
        int n14 = font.getSize();
        for (n6 = 0; n6 < this._styledTexts.size(); ++n6) {
            FontMetrics fontMetrics2;
            StyledText styledText = this._styledTexts.get(n6);
            StyleRange styleRange = styledText.styleRange;
            int n15 = styleRange != null && (styleRange.isSuperscript() || styleRange.isSubscript()) ? Math.round((float)n14 / styleRange.getFontShrinkRatio()) : n14;
            font = this.getFont(styledLabel);
            if (styleRange != null && (styleRange.getFontStyle() != -1 && font.getStyle() != styleRange.getFontStyle() || font.getSize() != n15)) {
                font = FontUtils.getCachedDerivedFont(font, styleRange.getFontStyle() == -1 ? font.getStyle() : styleRange.getFontStyle(), n15);
                fontMetrics2 = styledLabel.getFontMetrics(font);
            } else {
                fontMetrics2 = fontMetrics;
            }
            String string = styledText.text.substring(n13);
            int n16 = fontMetrics2.stringWidth(string);
            int n17 = n11 - n12;
            if (n17 < n16) {
                int n18 = string.length() * n17 / n16 + 1;
                String string2 = string.substring(0, Math.min(n18, string.length()));
                int n19 = this.findFirstRowWordEndIndex(string2);
                int n20 = this.findNextWordStartIndex(string, n19);
                if (n19 < 0) {
                    n19 = n20 < string.length() ? this.findFirstRowWordEndIndex(string.substring(0, n20)) : n20;
                }
                int n21 = n19 + 1;
                String string3 = string.substring(0, Math.min(n21, string.length()));
                n16 = fontMetrics2.stringWidth(string3);
                while (n21 < n20 && (n16 += fontMetrics2.charWidth(string.charAt(++n21))) < n17) {
                }
                string = string.substring(0, Math.min(n21, string.length()));
                n16 = fontMetrics2.stringWidth(string);
                n13 += n21;
                if (n12 + n16 >= n2) {
                    n12 = Math.max(n12, n16);
                    break;
                }
                if (n12 + n16 >= n11) {
                    n12 += n16;
                    break;
                }
                --n6;
            }
            n12 += n16;
        }
        n6 = n12;
        if (styledLabel.getInsets() != null) {
            n6 += styledLabel.getInsets().left + styledLabel.getInsets().right;
        }
        if ((n5 = this.internalPaintStyledText(styledLabel, null, 0, 0, n6)) != n4) {
            n2 = Math.min(n2, n7);
            while (n5 > n4 && n6 < n2) {
                n5 = this.internalPaintStyledText(styledLabel, null, 0, 0, n6 += 2);
            }
            while (n5 < n4 && n6 > 0) {
                n5 = this.internalPaintStyledText(styledLabel, null, 0, 0, n6 -= 2);
            }
            n12 = n6;
            if (styledLabel.getInsets() != null) {
                n12 -= styledLabel.getInsets().left + styledLabel.getInsets().right;
            }
        }
        this._preferredRowCount = n4;
        return n12;
    }

    protected Font getFont(StyledLabel styledLabel) {
        Font font = styledLabel.getFont();
        if (font == null) {
            font = UIDefaultsLookup.getFont("Label.font");
        }
        return font;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintStyledText(StyledLabel styledLabel, Graphics graphics, int n2, int n3) {
        int n4;
        styledLabel.setTruncated(false);
        int n5 = styledLabel.getWidth();
        if (styledLabel.isLineWrap()) {
            int n6 = styledLabel.getPreferredWidth();
            n4 = styledLabel.getRows();
            try {
                styledLabel.setRows(0);
                n5 = this.getPreferredSize((StyledLabel)styledLabel).width;
                styledLabel.setPreferredWidth(n6 > 0 ? Math.min(styledLabel.getWidth(), n6) : styledLabel.getWidth());
                Dimension dimension = this.getPreferredSize(styledLabel);
                if (dimension.width < n5) {
                    n5 = dimension.width;
                }
            }
            finally {
                styledLabel.setPreferredWidth(n6);
                styledLabel.setRows(n4);
            }
        }
        Color color = graphics.getColor();
        n4 = styledLabel.getWidth();
        if (styledLabel.getInsets() != null) {
            n4 -= styledLabel.getInsets().left + styledLabel.getInsets().right;
        }
        if (styledLabel.getIcon() != null && styledLabel.getHorizontalTextPosition() != 0) {
            n4 -= styledLabel.getIcon().getIconWidth() + styledLabel.getIconTextGap();
        }
        n5 = Math.min(n5, n4);
        this.internalPaintStyledText(styledLabel, graphics, n2, n3, n5);
        graphics.setColor(color);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private int internalPaintStyledText(StyledLabel styledLabel, Graphics graphics, int n2, int n3, int n4) {
        int n5;
        Insets insets;
        int n6 = styledLabel.getHeight();
        if (n6 <= 0) {
            n6 = Integer.MAX_VALUE;
        }
        if ((insets = styledLabel.getInsets()) != null) {
            n6 -= insets.top + insets.bottom;
        }
        int n7 = 0;
        if (insets != null) {
            n7 += insets.left;
        }
        if (styledLabel.getIcon() != null) {
            n5 = styledLabel.getHorizontalTextPosition();
            if (n5 == 11 && styledLabel.getComponentOrientation().isLeftToRight() || n5 == 10 && !styledLabel.getComponentOrientation().isLeftToRight()) {
                n5 = 4;
            }
            if (n5 == 4) {
                n7 += styledLabel.getIcon().getIconWidth() + styledLabel.getIconTextGap();
            }
        }
        n5 = n2 < n7 ? n7 : n2;
        int n8 = n4 + n5;
        int n9 = n5;
        int n10 = styledLabel.getDisplayedMnemonicIndex();
        if (UIManager.getLookAndFeel() instanceof WindowsLookAndFeel && WindowsLookAndFeel.isMnemonicHidden()) {
            n10 = -1;
        }
        int n11 = 0;
        int n12 = 0;
        Font font = this.getFont(styledLabel);
        FontMetrics fontMetrics = styledLabel.getFontMetrics(font);
        FontMetrics fontMetrics2 = null;
        int n13 = font.getSize();
        List<StyledText> list = this._styledTexts;
        synchronized (list) {
            FontMetrics fontMetrics3;
            int n14;
            int n15 = fontMetrics.getHeight();
            int n16 = fontMetrics.getAscent();
            int n17 = styledLabel.getHorizontalAlignment();
            switch (n17) {
                case 10: {
                    n17 = styledLabel.getComponentOrientation().isLeftToRight() ? 2 : 4;
                    break;
                }
                case 11: {
                    n17 = styledLabel.getComponentOrientation().isLeftToRight() ? 4 : 2;
                }
            }
            for (StyledText object : this._styledTexts) {
                StyleRange styleRange = object.styleRange;
                n14 = styleRange != null && (styleRange.isSuperscript() || styleRange.isSubscript()) ? Math.round((float)n13 / styleRange.getFontShrinkRatio()) : n13;
                font = this.getFont(styledLabel);
                if (styleRange == null || (styleRange.getFontStyle() == -1 || font.getStyle() == styleRange.getFontStyle()) && font.getSize() == n14) continue;
                font = FontUtils.getCachedDerivedFont(font, styleRange.getFontStyle() == -1 ? font.getStyle() : styleRange.getFontStyle(), n14);
                fontMetrics3 = styledLabel.getFontMetrics(font);
                n15 = Math.max(n15, fontMetrics3.getHeight());
                n16 = Math.max(n16, fontMetrics3.getAscent());
            }
            boolean bl = styledLabel.isLineWrap();
            if (!bl) {
                for (StyledText styledText : this._styledTexts) {
                    if (!styledText.text.endsWith("\n")) continue;
                    bl = true;
                    break;
                }
            }
            if (bl && n3 < n16) {
                n3 = n16;
            }
            boolean bl2 = false;
            boolean bl3 = false;
            n14 = 0;
            for (int i2 = 0; i2 < this._styledTexts.size(); ++i2) {
                int n18;
                void var29_35;
                int n19;
                boolean bl4;
                int n20;
                StyledText styledText = this._styledTexts.get(i2);
                StyleRange styleRange = styledText.styleRange;
                if (n10 >= 0 && styledText.text.length() - n20 > n10 - n11) {
                    bl4 = true;
                    n12 = n10 - n11;
                } else {
                    bl4 = false;
                }
                n11 += styledText.text.length() - n20;
                if (styledText.text.contains("\r") || styledText.text.contains("\n")) {
                    int n21 = n19 = styledLabel.getMaxRows() > 0 && var29_35 >= styledLabel.getMaxRows() - 1 || n3 + n15 + Math.max(0, styledLabel.getRowGap()) > n6 ? 1 : 0;
                    if (n17 != 2 && graphics != null) {
                        if (n19 != 0 && i2 != this._styledTexts.size() - 1) {
                            n9 += fontMetrics.stringWidth("...");
                        }
                        this.paintRow(styledLabel, graphics, n5, n9, n8, n3, n14, styleRange.getStart() + styledText.text.length(), n19 != 0);
                    }
                    n14 = styleRange.getStart();
                    n20 = 0;
                    fontMetrics2 = null;
                    if (n19 == 0) {
                        n14 += styleRange.getLength();
                        ++var29_35;
                        n9 = n5;
                        n3 += n15 + Math.max(0, styledLabel.getRowGap());
                        continue;
                    }
                    if (n17 != 2 && graphics != null) break;
                }
                int n22 = n3;
                if (fontMetrics2 == null) {
                    n19 = styleRange != null && (styleRange.isSuperscript() || styleRange.isSubscript()) ? Math.round((float)n13 / styleRange.getFontShrinkRatio()) : n13;
                    font = this.getFont(styledLabel);
                    if (styleRange != null && (styleRange.getFontStyle() != -1 && font.getStyle() != styleRange.getFontStyle() || font.getSize() != n19)) {
                        font = FontUtils.getCachedDerivedFont(font, styleRange.getFontStyle() == -1 ? font.getStyle() : styleRange.getFontStyle(), n19);
                        fontMetrics3 = styledLabel.getFontMetrics(font);
                    } else {
                        fontMetrics3 = fontMetrics;
                    }
                } else {
                    fontMetrics3 = fontMetrics2;
                }
                if (graphics != null) {
                    graphics.setFont(font);
                }
                n19 = 0;
                String string = styledText.text.substring(Math.min(n20, styledText.text.length()));
                if (string.contains("\r") || string.contains("\n")) {
                    string = "...";
                    n19 = 1;
                }
                int n23 = fontMetrics3.stringWidth(string);
                boolean bl5 = false;
                int n24 = n8 - n9;
                if (n24 < n23 && n24 >= 0) {
                    if (styledLabel.isLineWrap() && (styledLabel.getMaxRows() > 0 && var29_35 < styledLabel.getMaxRows() - 1 || styledLabel.getMaxRows() <= 0) && n22 + n15 + Math.max(0, styledLabel.getRowGap()) <= n6) {
                        int n25;
                        bl5 = true;
                        int n26 = string.length() * n24 / n23 + 1;
                        int n36 = 0;
                        n18 = 0;
                        boolean bl6 = false;
                        int n27 = 0;
                        do {
                            String string2;
                            String string3;
                            int n28;
                            int n29 = n25 = (n28 = this.findFirstRowWordEndIndex(string3 = string.substring(0, Math.max(0, Math.min(n26, string.length()))))) < 0 ? 0 : this.findNextWordStartIndex(string, n28);
                            if (n28 < 0) {
                                if (n9 != n5) {
                                    boolean bl7;
                                    boolean bl8 = bl7 = styledLabel.getMaxRows() > 0 && var29_35 >= styledLabel.getMaxRows() - 1;
                                    if (n17 != 2 && graphics != null) {
                                        this.paintRow(styledLabel, graphics, n5, n9, n8, n3, n14, styleRange.getStart() + Math.min(n20, styledText.text.length()), bl7);
                                    }
                                    n3 += n15 + Math.max(0, styledLabel.getRowGap());
                                    n9 = n5;
                                    --i2;
                                    ++var29_35;
                                    n14 = styleRange.getStart() + Math.min(n20, styledText.text.length());
                                    if (bl7) {
                                        n18 = 1;
                                    }
                                    bl6 = true;
                                    break;
                                }
                                n28 = 0;
                                n25 = Math.min(string.length(), n26);
                            }
                            if ((n23 = fontMetrics3.stringWidth(string2 = string.substring(0, Math.min(n36 = n28 + 1, string.length())))) > n24) {
                                n26 = string3.length() * n24 / n23;
                            }
                            if (++n27 <= 15) continue;
                            System.err.println("Painting Styled Label Error: " + styledText);
                            break;
                        } while (n23 > n24 && n26 > 0);
                        if (n18 != 0) break;
                        if (bl6) continue;
                        while (n36 < n25 && (n23 += fontMetrics3.charWidth(string.charAt(n36))) < n24) {
                            ++n36;
                        }
                        string = string.substring(0, Math.min(n36, string.length()));
                        n23 = fontMetrics3.stringWidth(string);
                        n11 -= styledText.text.length() - n20;
                        if (bl4) {
                            if (n10 >= 0 && string.length() > n10 - n11) {
                                bl4 = true;
                                n12 = n10 - n11;
                            } else {
                                bl4 = false;
                            }
                        }
                        n11 += string.length();
                        n20 += n36;
                    } else {
                        string = SwingUtilities.layoutCompoundLabel(styledLabel, fontMetrics3, string, null, styledLabel.getVerticalAlignment(), styledLabel.getHorizontalAlignment(), styledLabel.getVerticalTextPosition(), styledLabel.getHorizontalTextPosition(), new Rectangle(n9, n22, n24, n6), new Rectangle(), new Rectangle(), 0);
                        n23 = fontMetrics3.stringWidth(string);
                    }
                    n19 = !bl || n22 + n15 + Math.max(0, styledLabel.getRowGap()) > n6 || styledLabel.getMaxRows() > 0 && var29_35 >= styledLabel.getMaxRows() - 1 ? 1 : 0;
                } else if (bl) {
                    n20 = 0;
                } else if (i2 < this._styledTexts.size() - 1) {
                    String string4;
                    StyledText styledText2 = this._styledTexts.get(i2 + 1);
                    String string5 = styledText2.text;
                    StyleRange styleRange2 = styledText2.styleRange;
                    n18 = styleRange2 != null && (styleRange2.isSuperscript() || styleRange2.isSubscript()) ? Math.round((float)n13 / styleRange2.getFontShrinkRatio()) : n13;
                    font = this.getFont(styledLabel);
                    if (styleRange2 != null && (styleRange2.getFontStyle() != -1 && font.getStyle() != styleRange2.getFontStyle() || font.getSize() != n18)) {
                        font = FontUtils.getCachedDerivedFont(font, styleRange2.getFontStyle() == -1 ? font.getStyle() : styleRange2.getFontStyle(), n18);
                        fontMetrics2 = styledLabel.getFontMetrics(font);
                    } else {
                        fontMetrics2 = fontMetrics;
                    }
                    if (fontMetrics2.stringWidth(string5) > n24 - n23 && fontMetrics2.stringWidth(string4 = SwingUtilities.layoutCompoundLabel(styledLabel, fontMetrics2, string5, null, styledLabel.getVerticalAlignment(), styledLabel.getHorizontalAlignment(), styledLabel.getVerticalTextPosition(), styledLabel.getHorizontalTextPosition(), new Rectangle(n9 + n23, n22, n24 - n23, n6), new Rectangle(), new Rectangle(), 0)) > n24 - n23) {
                        string = SwingUtilities.layoutCompoundLabel(styledLabel, fontMetrics3, string, null, styledLabel.getVerticalAlignment(), styledLabel.getHorizontalAlignment(), styledLabel.getVerticalTextPosition(), styledLabel.getHorizontalTextPosition(), new Rectangle(n9, n22, n23 - 1, n6), new Rectangle(), new Rectangle(), 0);
                        n23 = fontMetrics3.stringWidth(string);
                        n19 = 1;
                    }
                }
                if (var29_35 > 0 && n9 == n5 && string.startsWith(" ")) {
                    string = string.substring(1);
                    n23 = fontMetrics3.stringWidth(string);
                }
                if (n17 == 2 && graphics != null) {
                    Color color;
                    if (styleRange != null && styleRange.isSuperscript()) {
                        n22 -= fontMetrics.getHeight() - fontMetrics3.getHeight();
                    }
                    if (styleRange != null && styleRange.getBackgroundColor() != null) {
                        graphics.setColor(styleRange.getBackgroundColor());
                        graphics.fillRect(n9, n22 - fontMetrics3.getHeight(), n23, fontMetrics3.getHeight() + 4);
                    }
                    Color color2 = color = styleRange != null && !styledLabel.isIgnoreColorSettings() && styleRange.getFontColor() != null ? styleRange.getFontColor() : styledLabel.getForeground();
                    if (!styledLabel.isEnabled()) {
                        color = UIDefaultsLookup.getColor("Label.disabledForeground");
                    }
                    graphics.setColor(color);
                    if (bl4) {
                        JideSwingUtilities.drawStringUnderlineCharAt(styledLabel, graphics, string, n12, n9, n22);
                    } else {
                        JideSwingUtilities.drawString(styledLabel, graphics, string, n9, n22);
                    }
                    if (styleRange != null) {
                        Stroke stroke = ((Graphics2D)graphics).getStroke();
                        if (styleRange.getLineStroke() != null) {
                            ((Graphics2D)graphics).setStroke(styleRange.getLineStroke());
                        }
                        if (!styledLabel.isIgnoreColorSettings() && styleRange.getLineColor() != null) {
                            graphics.setColor(styleRange.getLineColor());
                        }
                        if (styleRange.isStrikethrough()) {
                            int n30 = n22 + (fontMetrics3.getDescent() - fontMetrics3.getAscent()) / 2;
                            graphics.drawLine(n9, n30, n9 + n23 - 1, n30);
                        }
                        if (styleRange.isDoublestrikethrough()) {
                            int n31 = n22 + (fontMetrics3.getDescent() - fontMetrics3.getAscent()) / 2;
                            graphics.drawLine(n9, n31 - 1, n9 + n23 - 1, n31 - 1);
                            graphics.drawLine(n9, n31 + 1, n9 + n23 - 1, n31 + 1);
                        }
                        if (styleRange.isUnderlined()) {
                            int n32 = n22 + 1;
                            graphics.drawLine(n9, n32, n9 + n23 - 1, n32);
                        }
                        if (styleRange.isDotted()) {
                            int n33 = n22 + 1;
                            for (n18 = n9; n18 < n9 + n23; n18 += 4) {
                                graphics.drawRect(n18, n33, 1, 1);
                            }
                        }
                        if (styleRange.isWaved()) {
                            int n34 = n22 + 1;
                            for (n18 = n9; n18 < n9 + n23; n18 += 4) {
                                if (n18 + 2 <= n9 + n23 - 1) {
                                    graphics.drawLine(n18, n34 + 2, n18 + 2, n34);
                                }
                                if (n18 + 4 > n9 + n23 - 1) continue;
                                graphics.drawLine(n18 + 3, n34 + 1, n18 + 4, n34 + 2);
                            }
                        }
                        if (styleRange.getLineStroke() != null) {
                            ((Graphics2D)graphics).setStroke(stroke);
                        }
                    }
                }
                if (n19 != 0) {
                    if (n17 != 2 && graphics != null) {
                        this.paintRow(styledLabel, graphics, n5, n9 += n23, n8, n3, n14, styledLabel.getText().length(), true);
                    }
                    styledLabel.setTruncated(true);
                    break;
                }
                if (bl5) {
                    boolean bl9;
                    boolean bl10 = bl9 = styledLabel.getMaxRows() > 0 && var29_35 >= styledLabel.getMaxRows() - 1 || n3 + n15 + Math.max(0, styledLabel.getRowGap()) > n6;
                    if (n17 != 2 && graphics != null) {
                        this.paintRow(styledLabel, graphics, n5, n9 += n23, n8, n3, n14, styleRange.getStart() + Math.min(n20, styledText.text.length()), bl9);
                    }
                    n3 += n15 + Math.max(0, styledLabel.getRowGap());
                    n9 = n5;
                    --i2;
                    ++var29_35;
                    n14 = styleRange.getStart() + Math.min(n20, styledText.text.length());
                    if (bl9) {
                        break;
                    }
                } else {
                    n9 += n23;
                }
                if (i2 != this._styledTexts.size() - 1 || n17 == 2 || graphics == null) continue;
                this.paintRow(styledLabel, graphics, n5, n9, n8, n3, n14, -1, true);
            }
            return (int)Math.ceil((double)n3 / (double)n15);
        }
    }

    private void paintRow(StyledLabel styledLabel, Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) {
        int n8;
        int n9;
        if (graphics == null) {
            return;
        }
        int n10 = styledLabel.getHorizontalTextPosition();
        int n11 = styledLabel.getHorizontalAlignment();
        if (n10 == 11 && !styledLabel.getComponentOrientation().isLeftToRight() || n10 == 10 && styledLabel.getComponentOrientation().isLeftToRight()) {
            n10 = 2;
        }
        if (n10 == 10 && !styledLabel.getComponentOrientation().isLeftToRight() || n10 == 11 && styledLabel.getComponentOrientation().isLeftToRight()) {
            n10 = 4;
        }
        if (n11 == 11 && !styledLabel.getComponentOrientation().isLeftToRight() || n11 == 10 && styledLabel.getComponentOrientation().isLeftToRight()) {
            n11 = 2;
        }
        if (n11 == 10 && !styledLabel.getComponentOrientation().isLeftToRight() || n11 == 11 && styledLabel.getComponentOrientation().isLeftToRight()) {
            n11 = 4;
        }
        Insets insets = styledLabel.getInsets();
        int n12 = n2;
        int n13 = n3 - n2;
        if (n11 == 4) {
            n13 = n3 - n12;
            n12 = styledLabel.getWidth() - n13;
            if (insets != null) {
                n12 -= insets.right;
            }
            if (styledLabel.getIcon() != null && n10 == 2) {
                n12 -= styledLabel.getIcon().getIconWidth() + styledLabel.getIconTextGap();
            }
        } else if (n11 == 0) {
            n9 = 0;
            if (n10 == 4 && styledLabel.getIcon() != null) {
                n9 += styledLabel.getIcon().getIconWidth() + styledLabel.getIconTextGap();
            }
            n8 = styledLabel.getWidth();
            if (insets != null) {
                n8 -= insets.right + insets.left;
                n9 += insets.left;
            }
            if (styledLabel.getIcon() != null && n10 != 0) {
                n8 -= styledLabel.getIcon().getIconWidth() + styledLabel.getIconTextGap();
            }
            n12 = n9 + (n8 - n13) / 2;
        }
        n13 = Math.min(n13, n4 - n2);
        n9 = styledLabel.getDisplayedMnemonicIndex();
        if (UIManager.getLookAndFeel() instanceof WindowsLookAndFeel && WindowsLookAndFeel.isMnemonicHidden()) {
            n9 = -1;
        }
        n8 = 0;
        int n14 = 0;
        Font font = this.getFont(styledLabel);
        FontMetrics fontMetrics = styledLabel.getFontMetrics(font);
        FontMetrics fontMetrics2 = null;
        int n15 = font.getSize();
        int n16 = n12;
        for (int i2 = 0; i2 < this._styledTexts.size() && (n7 < 0 || n8 < n7); ++i2) {
            Object object;
            int n17;
            String string;
            int n18;
            int n19;
            int n20;
            FontMetrics fontMetrics3;
            boolean bl2;
            StyledText styledText = this._styledTexts.get(i2);
            StyleRange styleRange = styledText.styleRange;
            int n21 = styleRange.getLength();
            if (n21 < 0) {
                n21 = styledText.text.length();
            }
            if (styleRange.getStart() + n21 <= n6) {
                n8 += n21;
                continue;
            }
            int n22 = styleRange.getStart() >= n6 ? 0 : n6 - styleRange.getStart();
            if (n9 >= 0 && styledText.text.length() - n22 > n9 - (n8 += n22)) {
                bl2 = true;
                n14 = n9 - n8;
            } else {
                bl2 = false;
            }
            int n23 = styledText.text.length() - n22;
            if (n7 >= 0 && n8 + n23 >= n7) {
                n23 = n7 - n8;
            }
            n8 += n23;
            int n24 = n5;
            if (fontMetrics2 == null) {
                int n25 = styleRange != null && (styleRange.isSuperscript() || styleRange.isSubscript()) ? Math.round((float)n15 / styleRange.getFontShrinkRatio()) : n15;
                font = this.getFont(styledLabel);
                if (styleRange != null && (styleRange.getFontStyle() != -1 && font.getStyle() != styleRange.getFontStyle() || font.getSize() != n25)) {
                    font = FontUtils.getCachedDerivedFont(font, styleRange.getFontStyle() == -1 ? font.getStyle() : styleRange.getFontStyle(), n25);
                    fontMetrics3 = styledLabel.getFontMetrics(font);
                } else {
                    fontMetrics3 = fontMetrics;
                }
            } else {
                fontMetrics3 = fontMetrics2;
            }
            graphics.setFont(font);
            String string2 = styledText.text.substring(Math.min(n22, styledText.text.length()));
            if (n6 > 0 && n16 == n12 && string2.startsWith(" ")) {
                string2 = string2.substring(1);
            }
            if (string2.length() > n23) {
                string2 = string2.substring(0, n23);
            }
            if (string2.contains("\r") || string2.contains("\n")) {
                if (styledText.styleRange.getStart() + styledText.styleRange.getLength() >= n7) break;
                string2 = "...";
            }
            if ((n20 = n13 + n12 - n16) < (n19 = fontMetrics3.stringWidth(string2))) {
                if (n19 <= 0) {
                    return;
                }
                if (styledLabel.isLineWrap() && !bl) {
                    int n26;
                    int n27 = string2.length() * n20 / n19 + 1;
                    n18 = 0;
                    do {
                        String string3;
                        int n28;
                        int n29 = n26 = (n28 = this.findFirstRowWordEndIndex(string = string2.substring(0, Math.max(0, Math.min(n27, string2.length()))))) < 0 ? 0 : this.findNextWordStartIndex(string2, n28);
                        if (n28 < 0 && n16 == n12) {
                            n28 = 0;
                            n26 = Math.min(string2.length(), n27);
                        }
                        if ((n19 = fontMetrics3.stringWidth(string3 = string2.substring(0, Math.min(n17 = n28 + 1, string2.length())))) > n20) {
                            n27 = string.length() * n20 / n19;
                        }
                        if (++n18 <= 50) continue;
                        System.err.println("Painting Styled Label Error: " + styledText);
                        break;
                    } while (n19 > n20 && n27 > 0);
                    while (n17 < n26 && (n19 += fontMetrics3.charWidth(string2.charAt(n17))) < n20) {
                        ++n17;
                    }
                    string2 = string2.substring(0, Math.min(n17, string2.length()));
                    n19 = fontMetrics3.stringWidth(string2);
                    n8 -= styledText.text.length() - n22;
                    if (bl2) {
                        if (n9 >= 0 && string2.length() > n9 - n8) {
                            bl2 = true;
                            n14 = n9 - n8;
                        } else {
                            bl2 = false;
                        }
                    }
                    n8 += string2.length();
                    n22 += n17;
                } else {
                    string2 = SwingUtilities.layoutCompoundLabel(styledLabel, fontMetrics3, string2, null, styledLabel.getVerticalAlignment(), styledLabel.getHorizontalAlignment(), styledLabel.getVerticalTextPosition(), styledLabel.getHorizontalTextPosition(), new Rectangle(n16, n24, n20, styledLabel.getHeight()), new Rectangle(), new Rectangle(), 0);
                    n19 = fontMetrics3.stringWidth(string2);
                }
            } else if (styledLabel.isLineWrap()) {
                n22 = 0;
            } else if (i2 < this._styledTexts.size() - 1) {
                object = this._styledTexts.get(i2 + 1);
                String string4 = ((StyledText)object).text;
                StyleRange styleRange2 = ((StyledText)object).styleRange;
                n18 = styleRange2 != null && (styleRange2.isSuperscript() || styleRange2.isSubscript()) ? Math.round((float)n15 / styleRange2.getFontShrinkRatio()) : n15;
                font = this.getFont(styledLabel);
                if (styleRange2 != null && (styleRange2.getFontStyle() != -1 && font.getStyle() != styleRange2.getFontStyle() || font.getSize() != n18)) {
                    font = FontUtils.getCachedDerivedFont(font, styleRange2.getFontStyle() == -1 ? font.getStyle() : styleRange2.getFontStyle(), n18);
                    fontMetrics2 = styledLabel.getFontMetrics(font);
                } else {
                    fontMetrics2 = fontMetrics;
                }
                if (fontMetrics2.stringWidth(string4) > n20 - n19 && fontMetrics2.stringWidth(string = SwingUtilities.layoutCompoundLabel(styledLabel, fontMetrics2, string4, null, styledLabel.getVerticalAlignment(), styledLabel.getHorizontalAlignment(), styledLabel.getVerticalTextPosition(), styledLabel.getHorizontalTextPosition(), new Rectangle(n16 + n19, n24, n20 - n19, styledLabel.getHeight()), new Rectangle(), new Rectangle(), 0)) > n20 - n19) {
                    string2 = SwingUtilities.layoutCompoundLabel(styledLabel, fontMetrics3, string2, null, styledLabel.getVerticalAlignment(), styledLabel.getHorizontalAlignment(), styledLabel.getVerticalTextPosition(), styledLabel.getHorizontalTextPosition(), new Rectangle(n16, n24, n19 - 1, styledLabel.getHeight()), new Rectangle(), new Rectangle(), 0);
                    n19 = fontMetrics3.stringWidth(string2);
                }
            }
            if (styleRange != null && styleRange.isSuperscript()) {
                n24 -= fontMetrics.getHeight() - fontMetrics3.getHeight();
            }
            if (styleRange != null && styleRange.getBackgroundColor() != null) {
                graphics.setColor(styleRange.getBackgroundColor());
                graphics.fillRect(n16, n24 - fontMetrics3.getHeight(), n19, fontMetrics3.getHeight() + 4);
            }
            Object object2 = object = styleRange != null && !styledLabel.isIgnoreColorSettings() && styleRange.getFontColor() != null ? styleRange.getFontColor() : styledLabel.getForeground();
            if (!styledLabel.isEnabled()) {
                object = UIDefaultsLookup.getColor("Label.disabledForeground");
            }
            graphics.setColor((Color)object);
            if (bl2) {
                JideSwingUtilities.drawStringUnderlineCharAt(styledLabel, graphics, string2, n14, n16, n24);
            } else {
                JideSwingUtilities.drawString(styledLabel, graphics, string2, n16, n24);
            }
            if (styleRange != null) {
                Stroke stroke = ((Graphics2D)graphics).getStroke();
                if (styleRange.getLineStroke() != null) {
                    ((Graphics2D)graphics).setStroke(styleRange.getLineStroke());
                }
                if (!styledLabel.isIgnoreColorSettings() && styleRange.getLineColor() != null) {
                    graphics.setColor(styleRange.getLineColor());
                }
                if (styleRange.isStrikethrough()) {
                    n17 = n24 + (fontMetrics3.getDescent() - fontMetrics3.getAscent()) / 2;
                    graphics.drawLine(n16, n17, n16 + n19 - 1, n17);
                }
                if (styleRange.isDoublestrikethrough()) {
                    n17 = n24 + (fontMetrics3.getDescent() - fontMetrics3.getAscent()) / 2;
                    graphics.drawLine(n16, n17 - 1, n16 + n19 - 1, n17 - 1);
                    graphics.drawLine(n16, n17 + 1, n16 + n19 - 1, n17 + 1);
                }
                if (styleRange.isUnderlined()) {
                    n17 = n24 + 1;
                    graphics.drawLine(n16, n17, n16 + n19 - 1, n17);
                }
                if (styleRange.isDotted()) {
                    n17 = n24 + 1;
                    for (n18 = n16; n18 < n16 + n19; n18 += 4) {
                        graphics.drawRect(n18, n17, 1, 1);
                    }
                }
                if (styleRange.isWaved()) {
                    n17 = n24 + 1;
                    for (n18 = n16; n18 < n16 + n19; n18 += 4) {
                        if (n18 + 2 <= n16 + n19 - 1) {
                            graphics.drawLine(n18, n17 + 2, n18 + 2, n17);
                        }
                        if (n18 + 4 > n16 + n19 - 1) continue;
                        graphics.drawLine(n18 + 3, n17 + 1, n18 + 4, n17 + 2);
                    }
                }
                if (styleRange.getLineStroke() != null) {
                    ((Graphics2D)graphics).setStroke(stroke);
                }
            }
            n16 += n19;
        }
    }

    private int findNextWordStartIndex(String string, int n2) {
        boolean bl = n2 < 0;
        for (int i2 = n2 + 1; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 != ' ' && c2 != '\t' && c2 != '\r' && c2 != '\n') {
                if (bl) continue;
                return i2;
            }
            bl = false;
        }
        return string.length();
    }

    private int findFirstRowWordEndIndex(String string) {
        boolean bl = false;
        for (int i2 = string.length() - 1; i2 >= 0; --i2) {
            char c2 = string.charAt(i2);
            if (!bl) {
                if (c2 != ' ' && c2 != '\t' && c2 != '\r' && c2 != '\n') continue;
                bl = true;
                continue;
            }
            if (c2 == ' ' || c2 == '\t' || c2 == '\r' || c2 == '\n') continue;
            return i2;
        }
        return -1;
    }

    public static String layoutCompoundLabel(JComponent jComponent, FontMetrics fontMetrics, String string, Icon icon, int n2, int n3, int n4, int n5, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, int n6) {
        boolean bl = true;
        int n7 = n3;
        int n8 = n5;
        if (jComponent != null && !jComponent.getComponentOrientation().isLeftToRight()) {
            bl = false;
        }
        switch (n3) {
            case 10: {
                n7 = bl ? 2 : 4;
                break;
            }
            case 11: {
                n7 = bl ? 4 : 2;
            }
        }
        switch (n5) {
            case 10: {
                n8 = bl ? 2 : 4;
                break;
            }
            case 11: {
                n8 = bl ? 4 : 2;
            }
        }
        return BasicStyledLabelUI.layoutCompoundLabelImpl(jComponent, fontMetrics, string, icon, n2, n7, n4, n8, rectangle, rectangle2, rectangle3, n6);
    }

    public static String layoutCompoundLabel(FontMetrics fontMetrics, String string, Icon icon, int n2, int n3, int n4, int n5, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, int n6) {
        return BasicStyledLabelUI.layoutCompoundLabelImpl(null, fontMetrics, string, icon, n2, n3, n4, n5, rectangle, rectangle2, rectangle3, n6);
    }

    private static String layoutCompoundLabelImpl(JComponent jComponent, FontMetrics fontMetrics, String string, Icon icon, int n2, int n3, int n4, int n5, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, int n6) {
        int n7;
        int n8;
        if (icon != null) {
            rectangle2.width = icon.getIconWidth();
            rectangle2.height = icon.getIconHeight();
        } else {
            rectangle2.height = 0;
            rectangle2.width = 0;
        }
        boolean bl = string == null || string.equals("");
        int n9 = 0;
        if (bl) {
            rectangle3.height = 0;
            rectangle3.width = 0;
            string = "";
            n8 = 0;
        } else {
            View view;
            n8 = icon == null ? 0 : n6;
            n7 = n5 == 0 ? rectangle.width : rectangle.width - (rectangle2.width + n8);
            View view2 = view = jComponent != null ? (View)jComponent.getClientProperty("html") : null;
            if (view != null) {
                rectangle3.width = Math.min(n7, (int)view.getPreferredSpan(0));
                rectangle3.height = (int)view.getPreferredSpan(1);
            }
        }
        rectangle3.y = n4 == 1 ? (n5 != 0 ? 0 : -(rectangle3.height + n8)) : (n4 == 0 ? rectangle2.height / 2 - rectangle3.height / 2 : (n5 != 0 ? rectangle2.height - rectangle3.height : rectangle2.height + n8));
        rectangle3.x = n5 == 2 ? -(rectangle3.width + n8) : (n5 == 0 ? rectangle2.width / 2 - rectangle3.width / 2 : rectangle2.width + n8);
        n7 = Math.min(rectangle2.x, rectangle3.x);
        int n10 = Math.max(rectangle2.x + rectangle2.width, rectangle3.x + rectangle3.width) - n7;
        int n11 = Math.min(rectangle2.y, rectangle3.y);
        int n12 = Math.max(rectangle2.y + rectangle2.height, rectangle3.y + rectangle3.height) - n11;
        int n13 = n2 == 1 ? rectangle.y - n11 : (n2 == 0 ? rectangle.y + rectangle.height / 2 - (n11 + n12 / 2) : rectangle.y + rectangle.height - (n11 + n12));
        int n14 = n3 == 2 ? rectangle.x - n7 : (n3 == 4 ? rectangle.x + rectangle.width - (n7 + n10) : rectangle.x + rectangle.width / 2 - (n7 + n10 / 2));
        rectangle3.x += n14;
        rectangle3.y += n13;
        rectangle2.x += n14;
        rectangle2.y += n13;
        if (n9 < 0) {
            rectangle3.x -= n9;
        }
        int n15 = rectangle.height / 2;
        Insets insets = jComponent.getInsets();
        int n16 = rectangle.x;
        int n17 = rectangle.width;
        n17 -= rectangle2.width;
        if (n5 == 0) {
            if (rectangle.width < rectangle3.width) {
                rectangle2.x = (n16 + n17) / 2;
            } else {
                int n18 = rectangle3.x;
                int n19 = rectangle3.x + rectangle3.width - rectangle2.width;
                rectangle2.x = rectangle3.x + (rectangle3.width - rectangle2.width) / 2;
            }
        } else if (rectangle2.x < n16) {
            rectangle3.x += n16 - rectangle2.x;
            rectangle2.x = n16;
        } else if (rectangle2.x > n17 && n3 != 2) {
            rectangle2.x = n17;
            rectangle3.x -= rectangle2.x - n17;
        }
        if (insets != null) {
            n15 -= (insets.bottom + insets.top) / 2;
        }
        if (icon != null) {
            n15 -= icon.getIconHeight() / 2;
        }
        if (n2 == 1) {
            rectangle2.y = Math.min(n15, rectangle2.y);
        } else if (n2 == 3) {
            rectangle2.y = Math.max(n15, rectangle2.y);
        }
        return string;
    }

    static {
        styledLabelUI = new BasicStyledLabelUI();
    }

    class StyledText {
        StyleRange styleRange;
        String text;

        public StyledText(String string) {
            this.text = string;
        }

        public StyledText(String string, StyleRange styleRange) {
            this.text = string;
            this.styleRange = styleRange;
        }
    }
}

