/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.metal;

import com.jidesoft.icons.IconsFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.LazyActionMap;
import com.jidesoft.plaf.basic.ThemePainter;
import com.jidesoft.plaf.basic.UIAction;
import com.jidesoft.plaf.metal.MetalMenuUI;
import com.jidesoft.swing.ComponentStateSupport;
import com.jidesoft.swing.DefaultSplitButtonModel;
import com.jidesoft.swing.JideSplitButton;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.SplitButtonModel;
import com.jidesoft.utils.SecurityUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.text.View;

public class MetalJideSplitButtonUI
extends MetalMenuUI {
    protected ThemePainter _painter;
    protected Color _shadowColor;
    protected Color _darkShadowColor;
    protected Color _highlight;
    protected Color _lightHighlightColor;
    private int _splitButtonMargin = 12;
    private int _splitButtonMarginOnMenu = 18;
    protected PropertyChangeListener _propertyChangeListener;
    private FocusListener _focusListener;

    @Override
    protected String getPropertyPrefix() {
        return "JideSplitButton";
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new MetalJideSplitButtonUI();
    }

    @Override
    protected void installDefaults() {
        this._painter = (ThemePainter)UIDefaultsLookup.get("Theme.painter");
        this._shadowColor = UIDefaultsLookup.getColor("controlShadow");
        this._darkShadowColor = UIDefaultsLookup.getColor("controlDkShadow");
        this._highlight = UIDefaultsLookup.getColor("controlHighlight");
        this._lightHighlightColor = UIDefaultsLookup.getColor("controlLtHighlight");
        this.menuItem.setRolloverEnabled(true);
        super.installDefaults();
    }

    @Override
    protected void uninstallDefaults() {
        this._painter = null;
        this._shadowColor = null;
        this._highlight = null;
        this._lightHighlightColor = null;
        this._darkShadowColor = null;
        super.uninstallDefaults();
    }

    @Override
    protected void installListeners() {
        if (this._propertyChangeListener == null) {
            this._propertyChangeListener = this.createSplitButtonPropertyChangeListener(this.menuItem);
        }
        if (this._propertyChangeListener != null) {
            this.menuItem.addPropertyChangeListener(this._propertyChangeListener);
        }
        super.installListeners();
        if (this._focusListener == null) {
            this._focusListener = new FocusListener(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    MetalJideSplitButtonUI.this.menuItem.repaint();
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    MetalJideSplitButtonUI.this.menuItem.repaint();
                }
            };
        }
        this.menuItem.addFocusListener(this._focusListener);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        if (this._propertyChangeListener != null) {
            this.menuItem.removePropertyChangeListener(this._propertyChangeListener);
        }
        this._propertyChangeListener = null;
        if (this._focusListener != null) {
            this.menuItem.removeFocusListener(this._focusListener);
        }
        this._focusListener = null;
    }

    protected PropertyChangeListener createSplitButtonPropertyChangeListener(JComponent jComponent) {
        return new PropertyChangeHandler();
    }

    static Object getUIOfType(ComponentUI componentUI, Class clazz) {
        if (clazz.isInstance(componentUI)) {
            return componentUI;
        }
        return null;
    }

    public InputMap getInputMap(int n2, JComponent jComponent) {
        MetalJideSplitButtonUI metalJideSplitButtonUI;
        if (n2 == 0 && (metalJideSplitButtonUI = (MetalJideSplitButtonUI)MetalJideSplitButtonUI.getUIOfType(((JideSplitButton)jComponent).getUI(), MetalJideSplitButtonUI.class)) != null) {
            return (InputMap)UIDefaultsLookup.get(metalJideSplitButtonUI.getPropertyPrefix() + ".focusInputMap");
        }
        return null;
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
        JMenuItem jMenuItem = this.menuItem;
        LazyActionMap.installLazyActionMap(jMenuItem, MetalJideSplitButtonUI.class, "JideSplitButton.actionMap");
        InputMap inputMap = this.getInputMap(0, jMenuItem);
        SwingUtilities.replaceUIInputMap(jMenuItem, 0, inputMap);
    }

    @Override
    protected void uninstallKeyboardActions() {
        JMenuItem jMenuItem = this.menuItem;
        SwingUtilities.replaceUIInputMap(jMenuItem, 2, null);
        SwingUtilities.replaceUIInputMap(jMenuItem, 0, null);
        SwingUtilities.replaceUIActionMap(jMenuItem, null);
        super.uninstallKeyboardActions();
    }

    @Override
    protected MouseInputListener createMouseInputListener(JComponent jComponent) {
        return new MouseInputHandler();
    }

    @Override
    protected void paintBackground(Graphics graphics, JMenuItem jMenuItem, Color color) {
        int n2;
        int n3;
        ButtonModel buttonModel = jMenuItem.getModel();
        int n4 = JideSwingUtilities.getOrientationOf(jMenuItem);
        if (n4 == 0) {
            n3 = jMenuItem.getWidth();
            n2 = jMenuItem.getHeight();
        } else {
            n3 = jMenuItem.getHeight();
            n2 = jMenuItem.getWidth();
        }
        n4 = 0;
        Object object = jMenuItem.getClientProperty("JideSplitButton.alwaysPaintBackground");
        boolean bl = object instanceof Boolean ? ((Boolean)object).booleanValue() : jMenuItem.isOpaque();
        JideSplitButton jideSplitButton = (JideSplitButton)jMenuItem;
        if (!((JMenu)jMenuItem).isTopLevelMenu()) {
            super.paintBackground(graphics, jMenuItem, color);
            if (jMenuItem.isEnabled()) {
                if (buttonModel.isArmed() || buttonModel.isPressed() || this.isMouseOver()) {
                    graphics.setColor(this.selectionForeground);
                    graphics.drawLine(n3 - this._splitButtonMarginOnMenu, 0, n3 - this._splitButtonMarginOnMenu, n2 - 2);
                    JideSwingUtilities.paintArrow(graphics, this.selectionForeground, n3 - this._splitButtonMarginOnMenu / 2 - 2, n2 / 2 - 3, 7, 1);
                } else {
                    graphics.setColor(this.getForegroundOfState(jMenuItem));
                    graphics.drawLine(n3 - this._splitButtonMarginOnMenu, 0, n3 - this._splitButtonMarginOnMenu, n2 - 2);
                    JideSwingUtilities.paintArrow(graphics, this.getForegroundOfState(jMenuItem), n3 - this._splitButtonMarginOnMenu / 2 - 2, n2 / 2 - 3, 7, 1);
                }
            } else {
                graphics.setColor(UIDefaultsLookup.getColor("controlDkShadow"));
                graphics.drawLine(n3 - this._splitButtonMarginOnMenu, 0, n3 - this._splitButtonMarginOnMenu, n2 - 2);
                JideSwingUtilities.paintArrow(graphics, UIDefaultsLookup.getColor("controlDkShadow"), n3 - this._splitButtonMarginOnMenu / 2 - 2, n2 / 2 - 3, 7, 1);
            }
            return;
        }
        if (bl) {
            if (jMenuItem.getParent() != null) {
                graphics.setColor(jMenuItem.getParent().getBackground());
            } else {
                graphics.setColor(jMenuItem.getBackground());
            }
            graphics.fillRect(0, 0, n3, n2);
        }
        if (jideSplitButton.getButtonStyle() == 0) {
            Object object2 = jideSplitButton.getClientProperty("JButton.segmentPosition");
            if (buttonModel.isSelected()) {
                if (this.isAlwaysDropdown(jideSplitButton)) {
                    Rectangle rectangle = new Rectangle(0, 0, n3, n2);
                    this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n4, 2);
                } else if (object2 != null) {
                    Rectangle rectangle = this.getButtonRect(jideSplitButton, n4, n3, n2);
                    if (jideSplitButton.isButtonEnabled()) {
                        this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n4, 2);
                    } else if (bl) {
                        this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n4, 6);
                    }
                    rectangle = this.getDropDownRect(jideSplitButton, n4, n3, n2);
                    this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n4, 1);
                } else {
                    Rectangle rectangle = this.getButtonRect(jideSplitButton, n4, n3, n2);
                    if (jideSplitButton.isButtonEnabled()) {
                        this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n4, 3);
                    } else if (bl) {
                        this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n4, 5);
                    }
                    rectangle = this.getDropDownRect(jideSplitButton, n4, n3, n2);
                    this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n4, 3);
                    this.getPainter().paintSelectedMenu(jideSplitButton, graphics, new Rectangle(0, 0, n3, n2), n4, 3);
                }
            } else if (buttonModel.isArmed() || buttonModel.isPressed()) {
                Rectangle rectangle = this.getButtonRect(jideSplitButton, n4, n3, n2);
                if (jideSplitButton.isButtonEnabled()) {
                    this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n4, 1);
                } else if (bl) {
                    this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n4, 4);
                }
                rectangle = this.getDropDownRect(jideSplitButton, n4, n3, n2);
                this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n4, 2);
            } else if (buttonModel instanceof SplitButtonModel && ((DefaultSplitButtonModel)buttonModel).isButtonSelected()) {
                if ((this.isMouseOver() || jideSplitButton.hasFocus()) && buttonModel.isEnabled()) {
                    Rectangle rectangle = this.getDropDownRect(jideSplitButton, n4, n3, n2);
                    this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n4, 2);
                    rectangle = this.getButtonRect(jideSplitButton, n4, n3, n2);
                    if (jideSplitButton.isButtonEnabled()) {
                        this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n4, 1);
                    } else if (bl) {
                        this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n4, 4);
                    }
                } else {
                    Rectangle rectangle = this.getDropDownRect(jideSplitButton, n4, n3, n2);
                    this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n4, 0);
                    rectangle = this.getButtonRect(jideSplitButton, n4, n3, n2);
                    if (jideSplitButton.isButtonEnabled()) {
                        this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n4, 3);
                    } else if (bl) {
                        this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n4, 5);
                    }
                }
            } else if ((jideSplitButton.isRolloverEnabled() && this.isMouseOver() || jideSplitButton.hasFocus()) && buttonModel.isEnabled()) {
                if (this.isAlwaysDropdown(jideSplitButton)) {
                    Rectangle rectangle = new Rectangle(0, 0, n3, n2);
                    this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n4, 2);
                } else {
                    Rectangle rectangle = this.getButtonRect(jideSplitButton, n4, n3, n2);
                    if (jideSplitButton.isButtonEnabled()) {
                        this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n4, 2);
                    } else if (bl) {
                        this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n4, 6);
                    }
                    rectangle = this.getDropDownRect(jideSplitButton, n4, n3, n2);
                    this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n4, 2);
                }
            } else if (bl) {
                Rectangle rectangle = this.getButtonRect(jideSplitButton, n4, n3, n2);
                if (jideSplitButton.isEnabled() && jideSplitButton.isButtonEnabled()) {
                    this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, 0, 0);
                } else {
                    this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, 0, 4);
                }
                if ("true".equals(SecurityUtils.getProperty("shadingtheme", "false"))) {
                    JideSwingUtilities.fillGradient(graphics, rectangle, 0);
                }
                rectangle = this.getDropDownRect(jideSplitButton, n4, n3, n2);
                if (jideSplitButton.isEnabled()) {
                    this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, 0, 0);
                } else {
                    this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, 0, 4);
                }
                if ("true".equals(SecurityUtils.getProperty("shadingtheme", "false"))) {
                    JideSwingUtilities.fillGradient(graphics, rectangle, 0);
                }
            }
        } else if (jideSplitButton.getButtonStyle() == 2) {
            if (buttonModel.isSelected()) {
                this.getPainter().paintSelectedMenu(jideSplitButton, graphics, new Rectangle(0, 0, n3, n2), n4, 3);
            } else if (buttonModel.isArmed() || buttonModel.isPressed()) {
                Rectangle rectangle = this.getButtonRect(jideSplitButton, n4, n3, n2);
                if (jideSplitButton.isButtonEnabled()) {
                    JideSwingUtilities.paintBackground(graphics, rectangle, this._highlight, this._highlight);
                }
                rectangle = this.getDropDownRect(jideSplitButton, n4, n3, n2);
                JideSwingUtilities.paintBackground(graphics, rectangle, this._highlight, this._highlight);
                if (!jideSplitButton.isOpaque()) {
                    rectangle = this.getButtonRect(jideSplitButton, n4, n3, n2);
                    this.paintSunkenBorder(graphics, rectangle);
                    rectangle = this.getDropDownRect(jideSplitButton, n4, n3, n2);
                    this.paintRaisedBorder(graphics, rectangle);
                }
            } else if (buttonModel instanceof SplitButtonModel && ((DefaultSplitButtonModel)buttonModel).isButtonSelected()) {
                if ((this.isMouseOver() || jideSplitButton.hasFocus()) && buttonModel.isEnabled()) {
                    Rectangle rectangle = this.getDropDownRect(jideSplitButton, n4, n3, n2);
                    JideSwingUtilities.paintBackground(graphics, rectangle, this._highlight, this._highlight);
                    rectangle = this.getButtonRect(jideSplitButton, n4, n3, n2);
                    if (jideSplitButton.isButtonEnabled()) {
                        JideSwingUtilities.paintBackground(graphics, rectangle, this._highlight, this._highlight);
                    }
                    if (!jideSplitButton.isOpaque()) {
                        rectangle = this.getButtonRect(jideSplitButton, n4, n3, n2);
                        this.paintSunkenBorder(graphics, rectangle);
                        rectangle = this.getDropDownRect(jideSplitButton, n4, n3, n2);
                        this.paintRaisedBorder(graphics, rectangle);
                    }
                } else {
                    Rectangle rectangle;
                    if (jideSplitButton.isOpaque()) {
                        rectangle = this.getDropDownRect(jideSplitButton, n4, n3, n2);
                        JideSwingUtilities.paintBackground(graphics, rectangle, this._highlight, this._highlight);
                    }
                    rectangle = this.getButtonRect(jideSplitButton, n4, n3, n2);
                    JideSwingUtilities.paintBackground(graphics, rectangle, this._highlight, this._highlight);
                    if (!jideSplitButton.isOpaque()) {
                        rectangle = this.getButtonRect(jideSplitButton, n4, n3, n2);
                        this.paintSunkenBorder(graphics, rectangle);
                    }
                }
            } else if ((jideSplitButton.isRolloverEnabled() && this.isMouseOver() || jideSplitButton.hasFocus()) && buttonModel.isEnabled()) {
                Rectangle rectangle = this.getButtonRect(jideSplitButton, n4, n3, n2);
                if (jideSplitButton.isButtonEnabled()) {
                    JideSwingUtilities.paintBackground(graphics, rectangle, this._highlight, this._highlight);
                }
                rectangle = this.getDropDownRect(jideSplitButton, n4, n3, n2);
                JideSwingUtilities.paintBackground(graphics, rectangle, this._highlight, this._highlight);
                if (this.isAlwaysDropdown(jideSplitButton)) {
                    rectangle = new Rectangle(0, 0, n3, n2);
                    this.paintRaisedBorder(graphics, rectangle);
                } else {
                    rectangle = this.getButtonRect(jideSplitButton, n4, n3, n2);
                    this.paintRaisedBorder(graphics, rectangle);
                    rectangle = this.getDropDownRect(jideSplitButton, n4, n3, n2);
                    this.paintRaisedBorder(graphics, rectangle);
                }
            } else if (jideSplitButton.isOpaque()) {
                Rectangle rectangle = this.getButtonRect(jideSplitButton, n4, n3, n2);
                if (jideSplitButton.isButtonEnabled()) {
                    this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n4, 0);
                }
                rectangle = this.getDropDownRect(jideSplitButton, n4, n3, n2);
                this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n4, 0);
            }
        } else if (jideSplitButton.getButtonStyle() == 1) {
            if (buttonModel.isSelected()) {
                this.getPainter().paintSelectedMenu(jideSplitButton, graphics, new Rectangle(0, 0, n3, n2), n4, 3);
            } else if (buttonModel.isArmed() || buttonModel.isPressed()) {
                Rectangle rectangle = this.getButtonRect(jideSplitButton, n4, n3, n2);
                if (jideSplitButton.isButtonEnabled()) {
                    this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n4, 1);
                }
                rectangle = this.getDropDownRect(jideSplitButton, n4, n3, n2);
                this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n4, 2);
                if (!jideSplitButton.isOpaque()) {
                    rectangle = this.getButtonRect(jideSplitButton, n4, n3, n2);
                    this.paintSunken2Border(graphics, rectangle);
                    rectangle = this.getDropDownRect(jideSplitButton, n4, n3, n2);
                    this.paintRaisedBorder(graphics, rectangle);
                }
            } else if (buttonModel instanceof SplitButtonModel && ((DefaultSplitButtonModel)buttonModel).isButtonSelected()) {
                if (this.isMouseOver() && buttonModel.isEnabled()) {
                    Rectangle rectangle = this.getDropDownRect(jideSplitButton, n4, n3, n2);
                    this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n4, 2);
                    rectangle = this.getButtonRect(jideSplitButton, n4, n3, n2);
                    if (jideSplitButton.isButtonEnabled()) {
                        this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n4, 1);
                    }
                    if (!jideSplitButton.isOpaque()) {
                        rectangle = this.getButtonRect(jideSplitButton, n4, n3, n2);
                        this.paintSunken2Border(graphics, rectangle);
                        rectangle = this.getDropDownRect(jideSplitButton, n4, n3, n2);
                        this.paintRaisedBorder(graphics, rectangle);
                    }
                } else {
                    Rectangle rectangle;
                    if (jideSplitButton.isOpaque()) {
                        rectangle = this.getDropDownRect(jideSplitButton, n4, n3, n2);
                        this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n4, 0);
                    }
                    rectangle = this.getButtonRect(jideSplitButton, n4, n3, n2);
                    this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n4, 3);
                    if (!jideSplitButton.isOpaque()) {
                        rectangle = this.getButtonRect(jideSplitButton, n4, n3, n2);
                        this.paintSunken2Border(graphics, rectangle);
                        rectangle = this.getDropDownRect(jideSplitButton, n4, n3, n2);
                        this.paintRaisedBorder(graphics, rectangle);
                    }
                }
            } else if (jideSplitButton.isRolloverEnabled() && this.isMouseOver() && buttonModel.isEnabled()) {
                if (this.isAlwaysDropdown(jideSplitButton)) {
                    Rectangle rectangle = new Rectangle(0, 0, n3, n2);
                    this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n4, 2);
                    this.paintRaised2Border(graphics, rectangle);
                } else {
                    Rectangle rectangle = this.getButtonRect(jideSplitButton, n4, n3, n2);
                    if (jideSplitButton.isButtonEnabled()) {
                        this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n4, 2);
                    }
                    rectangle = this.getDropDownRect(jideSplitButton, n4, n3, n2);
                    this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n4, 2);
                    rectangle = this.getButtonRect(jideSplitButton, n4, n3, n2);
                    this.paintRaised2Border(graphics, rectangle);
                    rectangle = this.getDropDownRect(jideSplitButton, n4, n3, n2);
                    this.paintRaised2Border(graphics, rectangle);
                }
            } else if (jideSplitButton.isOpaque()) {
                Rectangle rectangle = this.getButtonRect(jideSplitButton, n4, n3, n2);
                if (jideSplitButton.isButtonEnabled()) {
                    this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n4, 0);
                }
                rectangle = this.getDropDownRect(jideSplitButton, n4, n3, n2);
                this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n4, 0);
            } else if (this.isAlwaysDropdown(jideSplitButton)) {
                Rectangle rectangle = new Rectangle(0, 0, n3, n2);
                this.paintRaisedBorder(graphics, rectangle);
            } else {
                Rectangle rectangle = this.getButtonRect(jideSplitButton, n4, n3, n2);
                this.paintRaisedBorder(graphics, rectangle);
                rectangle = this.getDropDownRect(jideSplitButton, n4, n3, n2);
                this.paintRaisedBorder(graphics, rectangle);
            }
        }
        jMenuItem.putClientProperty("JButton.segmentPosition", null);
        this.paintArrow(jMenuItem, graphics);
    }

    protected Rectangle getDropDownRect(JComponent jComponent, int n2, int n3, int n4) {
        Object object = jComponent.getClientProperty("JButton.segmentPosition");
        Rectangle rectangle = jComponent.getComponentOrientation().isLeftToRight() ? new Rectangle(n3 - this._splitButtonMargin - 1 + this.getOffset(), 0, this._splitButtonMargin - this.getOffset(), n4) : new Rectangle(0, 0, this._splitButtonMargin - this.getOffset(), n4);
        if (object != null && !"only".equals(object)) {
            if ("first".equals(object)) {
                if (n2 == 0) {
                    ++rectangle.width;
                } else {
                    ++rectangle.height;
                }
            } else if ("middle".equals(object)) {
                if (n2 == 0) {
                    ++rectangle.width;
                } else {
                    ++rectangle.height;
                }
            } else if ("last".equals(object)) {
                // empty if block
            }
        }
        jComponent.putClientProperty("JButton.segmentPosition", "last");
        return rectangle;
    }

    protected void paintArrow(JMenuItem jMenuItem, Graphics graphics) {
        int n2;
        int n3;
        int n4 = JideSwingUtilities.getOrientationOf(jMenuItem);
        if (n4 == 0) {
            n3 = jMenuItem.getWidth();
            n2 = jMenuItem.getHeight();
        } else {
            n3 = jMenuItem.getHeight();
            n2 = jMenuItem.getWidth();
        }
        int n5 = jMenuItem.getComponentOrientation().isLeftToRight() ? n3 - 9 : 4;
        if (jMenuItem.isEnabled()) {
            JideSwingUtilities.paintArrow(graphics, this.getForegroundOfState(jMenuItem), n5, n2 / 2 - 1, 5, 0);
        } else {
            JideSwingUtilities.paintArrow(graphics, UIDefaultsLookup.getColor("controlShadow"), n5, n2 / 2 - 1, 5, 0);
        }
    }

    protected Rectangle getButtonRect(JComponent jComponent, int n2, int n3, int n4) {
        Rectangle rectangle = n2 == 0 && jComponent.getComponentOrientation().isLeftToRight() ? new Rectangle(0, 0, n3 - this._splitButtonMargin, n4) : new Rectangle(this._splitButtonMargin - 1, 0, n3 - this._splitButtonMargin, n4);
        jComponent.putClientProperty("JButton.segmentPosition", "first");
        return rectangle;
    }

    private void paintSunkenBorder(Graphics graphics, Rectangle rectangle) {
        Color color = graphics.getColor();
        graphics.setColor(this._shadowColor);
        graphics.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y);
        graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height - 1);
        graphics.setColor(this._lightHighlightColor);
        graphics.drawLine(rectangle.x, rectangle.y + rectangle.height - 1, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
        graphics.drawLine(rectangle.x + rectangle.width - 1, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
        graphics.setColor(color);
    }

    private void paintSunken2Border(Graphics graphics, Rectangle rectangle) {
        Color color = graphics.getColor();
        graphics.setColor(this._darkShadowColor);
        graphics.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width - 2, rectangle.y);
        graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height - 2);
        graphics.setColor(this._shadowColor);
        graphics.drawLine(rectangle.x + 1, rectangle.y + 1, rectangle.x + rectangle.width - 3, rectangle.y + 1);
        graphics.drawLine(rectangle.x + 1, rectangle.y + 1, rectangle.x + 1, rectangle.y + rectangle.height - 3);
        graphics.setColor(this._lightHighlightColor);
        graphics.drawLine(rectangle.x, rectangle.y + rectangle.height - 1, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
        graphics.drawLine(rectangle.x + rectangle.width - 1, rectangle.x, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
        graphics.setColor(color);
    }

    private void paintRaised2Border(Graphics graphics, Rectangle rectangle) {
        Color color = graphics.getColor();
        graphics.setColor(this._lightHighlightColor);
        graphics.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y);
        graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height - 1);
        graphics.setColor(this._shadowColor);
        graphics.drawLine(rectangle.x + 1, rectangle.y + rectangle.height - 2, rectangle.x + rectangle.width - 2, rectangle.y + rectangle.height - 2);
        graphics.drawLine(rectangle.x + rectangle.width - 2, 1, rectangle.x + rectangle.width - 2, rectangle.y + rectangle.height - 2);
        graphics.setColor(this._darkShadowColor);
        graphics.drawLine(rectangle.x, rectangle.y + rectangle.height - 1, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
        graphics.drawLine(rectangle.x + rectangle.width - 1, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
        graphics.setColor(color);
    }

    private void paintRaisedBorder(Graphics graphics, Rectangle rectangle) {
        Color color = graphics.getColor();
        graphics.setColor(this._lightHighlightColor);
        graphics.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y);
        graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height - 1);
        graphics.setColor(this._shadowColor);
        graphics.drawLine(rectangle.x, rectangle.y + rectangle.height - 1, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
        graphics.drawLine(rectangle.x + rectangle.width - 1, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
        graphics.setColor(color);
    }

    @Override
    protected void paintText(Graphics graphics, JMenuItem jMenuItem, Rectangle rectangle, String string) {
        ButtonModel buttonModel = jMenuItem.getModel();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n2 = jMenuItem.getDisplayedMnemonicIndex();
        if (!(buttonModel.isEnabled() && jMenuItem instanceof JideSplitButton && ((JideSplitButton)jMenuItem).isButtonEnabled())) {
            if (UIDefaultsLookup.get("MenuItem.disabledForeground") instanceof Color) {
                graphics.setColor(UIDefaultsLookup.getColor("MenuItem.disabledForeground"));
                JideSwingUtilities.drawStringUnderlineCharAt(jMenuItem, graphics, string, n2, rectangle.x, rectangle.y + fontMetrics.getAscent());
            } else {
                graphics.setColor(jMenuItem.getBackground().brighter());
                JideSwingUtilities.drawStringUnderlineCharAt(jMenuItem, graphics, string, n2, rectangle.x, rectangle.y + fontMetrics.getAscent());
                graphics.setColor(jMenuItem.getBackground().darker());
                JideSwingUtilities.drawStringUnderlineCharAt(jMenuItem, graphics, string, n2, rectangle.x - 1, rectangle.y + fontMetrics.getAscent() - 1);
            }
        } else {
            if (buttonModel.isArmed() || buttonModel.isSelected()) {
                graphics.setColor(this.selectionForeground);
            }
            JideSwingUtilities.drawStringUnderlineCharAt(jMenuItem, graphics, string, n2, rectangle.x, rectangle.y + fontMetrics.getAscent());
        }
    }

    @Override
    public Dimension getMinimumSize(JComponent jComponent) {
        if (!(jComponent instanceof JMenu) || !((JMenu)jComponent).isTopLevelMenu()) {
            return super.getMinimumSize(jComponent);
        }
        Dimension dimension = this.getPreferredSize(jComponent);
        View view = (View)jComponent.getClientProperty("html");
        if (view != null) {
            if (JideSwingUtilities.getOrientationOf(jComponent) == 0) {
                dimension.width = (int)((float)dimension.width - (view.getPreferredSpan(0) - view.getMinimumSpan(0)));
            } else {
                dimension.height = (int)((float)dimension.height - (view.getPreferredSpan(0) - view.getMinimumSpan(0)));
            }
        }
        int n2 = ((JMenu)this.menuItem).isTopLevelMenu() ? this._splitButtonMargin : this._splitButtonMarginOnMenu;
        dimension.width += n2;
        return dimension;
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        if (!(jComponent instanceof JMenu) || !((JMenu)jComponent).isTopLevelMenu()) {
            return super.getPreferredSize(jComponent);
        }
        AbstractButton abstractButton = (AbstractButton)jComponent;
        boolean bl = true;
        if (JideSwingUtilities.getOrientationOf(jComponent) == 1) {
            bl = false;
        }
        Dimension dimension = BasicGraphicsUtils.getPreferredButtonSize(abstractButton, this.defaultTextIconGap);
        int n2 = ((JMenu)this.menuItem).isTopLevelMenu() ? this._splitButtonMargin : this._splitButtonMarginOnMenu;
        dimension.width += n2;
        if (bl) {
            return dimension;
        }
        return new Dimension(dimension.height, dimension.width);
    }

    @Override
    public Dimension getMaximumSize(JComponent jComponent) {
        int n2;
        if (!(jComponent instanceof JMenu) || !((JMenu)jComponent).isTopLevelMenu()) {
            return super.getMaximumSize(jComponent);
        }
        Dimension dimension = this.getPreferredSize(jComponent);
        View view = (View)jComponent.getClientProperty("html");
        if (view != null) {
            dimension.width = (int)((float)dimension.width + (view.getMaximumSpan(0) - view.getPreferredSpan(0)));
        }
        boolean bl = true;
        if (JideSwingUtilities.getOrientationOf(jComponent) == 1) {
            bl = false;
        }
        int n3 = n2 = ((JMenu)this.menuItem).isTopLevelMenu() ? this._splitButtonMargin : this._splitButtonMarginOnMenu;
        if (bl) {
            dimension.width += n2;
        } else {
            dimension.height += n2;
        }
        return dimension;
    }

    private Color getForegroundOfState(JMenuItem jMenuItem) {
        int n2 = JideSwingUtilities.getButtonState(jMenuItem);
        Color color = null;
        if (jMenuItem instanceof ComponentStateSupport) {
            color = ((ComponentStateSupport)((Object)jMenuItem)).getForegroundOfState(n2);
        }
        if (color == null || color instanceof UIResource) {
            color = jMenuItem.getForeground();
        }
        return color;
    }

    protected void paintIcon(JMenuItem jMenuItem, Graphics graphics) {
        ButtonModel buttonModel = jMenuItem.getModel();
        if (jMenuItem.getIcon() != null) {
            Icon icon;
            if (JideSwingUtilities.getOrientationOf(jMenuItem) == 1) {
                graphics.translate(0, jMenuItem.getWidth() - 1);
                ((Graphics2D)graphics).rotate(-1.5707963267948966);
            }
            if (!buttonModel.isEnabled()) {
                icon = jMenuItem.getDisabledIcon();
                if (icon == null) {
                    icon = jMenuItem.getIcon();
                    icon = icon instanceof ImageIcon ? IconsFactory.createGrayImage(((ImageIcon)icon).getImage()) : IconsFactory.createGrayImage(jMenuItem, icon);
                }
            } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
                icon = jMenuItem.getPressedIcon();
                if (icon == null) {
                    icon = jMenuItem.getIcon();
                }
            } else {
                icon = jMenuItem.getIcon();
            }
            if (icon != null) {
                icon.paintIcon(jMenuItem, graphics, MetalJideSplitButtonUI.iconRect.x, MetalJideSplitButtonUI.iconRect.y);
            }
            if (JideSwingUtilities.getOrientationOf(jMenuItem) == 1) {
                ((Graphics2D)graphics).rotate(1.5707963267948966);
                graphics.translate(0, -jMenuItem.getHeight() + 1);
            }
        }
    }

    protected int getOffset() {
        return 0;
    }

    protected boolean isAlwaysDropdown(JMenuItem jMenuItem) {
        return jMenuItem instanceof JideSplitButton && ((JideSplitButton)jMenuItem).isAlwaysDropdown();
    }

    public static void loadActionMap(LazyActionMap lazyActionMap) {
        lazyActionMap.put(new Actions("pressed"));
        lazyActionMap.put(new Actions("released"));
        lazyActionMap.put(new Actions("downPressed"));
        lazyActionMap.put(new Actions("downReleased"));
    }

    @Override
    protected void updateMnemonicBinding() {
        super.updateMnemonicBinding();
        int n2 = this.menuItem.getModel().getMnemonic();
        if (n2 != 0 && this.windowInputMap != null) {
            int[] nArray = (int[])UIDefaultsLookup.get("Menu.shortcutKeys");
            if (nArray == null) {
                nArray = new int[]{8};
            }
            for (int n3 : nArray) {
                this.windowInputMap.put(KeyStroke.getKeyStroke(n2, n3, false), "pressed");
                this.windowInputMap.put(KeyStroke.getKeyStroke(n2, n3, true), "released");
            }
        }
    }

    protected static void downButtonPressed(JMenu jMenu) {
        Object object;
        MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
        if (jMenu.isTopLevelMenu()) {
            if (jMenu.isSelected()) {
                menuSelectionManager.clearSelectedPath();
            } else {
                object = MetalJideSplitButtonUI.getFirstParentMenuElement(jMenu);
                if (object != null && object instanceof MenuElement) {
                    ArrayList<MenuElement[]> arrayList = new ArrayList<MenuElement[]>();
                    while (object instanceof MenuElement) {
                        arrayList.add(0, (MenuElement[])object);
                        if (object instanceof JPopupMenu) {
                            object = (Container)((JPopupMenu)object).getInvoker();
                            continue;
                        }
                        object = MetalJideSplitButtonUI.getFirstParentMenuElement((Component)object);
                    }
                    MenuElement[] menuElementArray = new MenuElement[arrayList.size() + 1];
                    for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                        Container container = (Container)arrayList.get(i2);
                        menuElementArray[i2] = (MenuElement)((Object)container);
                    }
                    menuElementArray[arrayList.size()] = jMenu;
                    menuSelectionManager.setSelectedPath(menuElementArray);
                } else {
                    MenuElement[] menuElementArray = new MenuElement[]{jMenu};
                    menuSelectionManager.setSelectedPath(menuElementArray);
                }
            }
        }
        if (((MenuElement[])(object = menuSelectionManager.getSelectedPath())).length > 0 && object[((MenuElement[])object).length - 1] != jMenu.getPopupMenu()) {
            if (jMenu.isTopLevelMenu() || jMenu.getDelay() == 0) {
                MetalJideSplitButtonUI.appendPath(object, jMenu.getPopupMenu());
            } else {
                MetalJideSplitButtonUI.setupPostTimer(jMenu);
            }
        }
    }

    protected static Container getFirstParentMenuElement(Component component) {
        for (Container container = component.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof MenuElement)) continue;
            return container;
        }
        return null;
    }

    @Override
    protected int getRightMargin() {
        return this._splitButtonMargin - 1;
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("buttonStyle")) {
                AbstractButton abstractButton = (AbstractButton)propertyChangeEvent.getSource();
                abstractButton.repaint();
            }
        }
    }

    private static class Actions
    extends UIAction {
        private static final String PRESS = "pressed";
        private static final String RELEASE = "released";
        private static final String DOWN_PRESS = "downPressed";
        private static final String DOWN_RELEASE = "downReleased";

        Actions(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            String string = this.getName();
            if (PRESS.equals(string) && ((JideSplitButton)abstractButton).isAlwaysDropdown()) {
                string = DOWN_PRESS;
            }
            if (PRESS.equals(string)) {
                ButtonModel buttonModel = abstractButton.getModel();
                buttonModel.setArmed(true);
                buttonModel.setPressed(true);
                if (!abstractButton.hasFocus()) {
                    abstractButton.requestFocus();
                }
            } else if (RELEASE.equals(string)) {
                ButtonModel buttonModel = abstractButton.getModel();
                buttonModel.setPressed(false);
                buttonModel.setArmed(false);
            } else if (DOWN_PRESS.equals(string)) {
                MetalJideSplitButtonUI.downButtonPressed((JMenu)abstractButton);
            } else if (DOWN_RELEASE.equals(string)) {
                // empty if block
            }
        }

        @Override
        public boolean isEnabled(Object object) {
            return object == null || !(object instanceof AbstractButton) || ((AbstractButton)object).getModel().isEnabled();
        }
    }

    protected class MouseInputHandler
    implements MouseInputListener {
        protected MouseInputHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            this.cancelMenuIfNecessary(mouseEvent);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            JMenu jMenu = (JMenu)MetalJideSplitButtonUI.this.menuItem;
            if (!jMenu.isEnabled()) {
                return;
            }
            MetalJideSplitButtonUI.this.setMouseOver(true);
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return;
            }
            if (this.isClickOnButton(mouseEvent, jMenu)) {
                if (((JideSplitButton)MetalJideSplitButtonUI.this.menuItem).isButtonEnabled()) {
                    jMenu.getModel().setArmed(true);
                    jMenu.getModel().setPressed(true);
                }
                if (!jMenu.hasFocus() && jMenu.isRequestFocusEnabled()) {
                    jMenu.requestFocus();
                }
            } else {
                MetalJideSplitButtonUI.downButtonPressed(jMenu);
            }
        }

        private boolean isClickOnButton(MouseEvent mouseEvent, JMenu jMenu) {
            int n2;
            if (((JideSplitButton)jMenu).isAlwaysDropdown()) {
                return false;
            }
            boolean bl = false;
            int n3 = n2 = ((JMenu)MetalJideSplitButtonUI.this.menuItem).isTopLevelMenu() ? MetalJideSplitButtonUI.this._splitButtonMargin : MetalJideSplitButtonUI.this._splitButtonMarginOnMenu;
            if (JideSwingUtilities.getOrientationOf(MetalJideSplitButtonUI.this.menuItem) == 0) {
                if (mouseEvent.getPoint().getX() < (double)(jMenu.getWidth() - n2)) {
                    bl = true;
                }
            } else if (mouseEvent.getPoint().getY() < (double)(jMenu.getHeight() - n2)) {
                bl = true;
            }
            return bl;
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            JMenu jMenu = (JMenu)MetalJideSplitButtonUI.this.menuItem;
            if (!jMenu.isEnabled()) {
                return;
            }
            if (!this.isClickOnButton(mouseEvent, jMenu)) {
                MetalJideSplitButtonUI.this.menuItem.getModel().setArmed(false);
                MetalJideSplitButtonUI.this.menuItem.getModel().setPressed(false);
            }
            this.cancelMenuIfNecessary(mouseEvent);
        }

        private void cancelMenuIfNecessary(MouseEvent mouseEvent) {
            JMenu jMenu = (JMenu)MetalJideSplitButtonUI.this.menuItem;
            if (!jMenu.isEnabled()) {
                return;
            }
            if (this.isClickOnButton(mouseEvent, jMenu) && ((JideSplitButton)MetalJideSplitButtonUI.this.menuItem).isButtonEnabled()) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    jMenu.getModel().setPressed(false);
                    jMenu.getModel().setArmed(false);
                } else {
                    jMenu.getModel().setArmed(false);
                    jMenu.getModel().setPressed(false);
                }
                MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
                MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
                for (int i2 = menuElementArray.length - 1; i2 >= 0; --i2) {
                    MenuElement menuElement = menuElementArray[i2];
                    if (!(menuElement instanceof JPopupMenu) || !((JPopupMenu)menuElement).isAncestorOf(jMenu)) continue;
                    jMenu.getModel().setRollover(false);
                    MetalJideSplitButtonUI.this.setMouseOver(false);
                    menuSelectionManager.clearSelectedPath();
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            JMenu jMenu = (JMenu)MetalJideSplitButtonUI.this.menuItem;
            if (!jMenu.isEnabled()) {
                return;
            }
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            if (!jMenu.isTopLevelMenu()) {
                if (menuElementArray.length <= 0 || menuElementArray[menuElementArray.length - 1] != jMenu.getPopupMenu()) {
                    if (jMenu.getDelay() == 0) {
                        MetalMenuUI.appendPath(MetalJideSplitButtonUI.this.getPath(), jMenu.getPopupMenu());
                    } else {
                        menuSelectionManager.setSelectedPath(MetalJideSplitButtonUI.this.getPath());
                        MetalMenuUI.setupPostTimer(jMenu);
                    }
                }
            } else if (menuElementArray.length > 0 && menuElementArray[0] == jMenu.getParent()) {
                MenuElement[] menuElementArray2 = new MenuElement[]{(MenuElement)((Object)jMenu.getParent()), jMenu, jMenu.getPopupMenu()};
                menuSelectionManager.setSelectedPath(menuElementArray2);
            }
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                MetalJideSplitButtonUI.this.setMouseOver(true);
            }
            MetalJideSplitButtonUI.this.menuItem.repaint();
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            MetalJideSplitButtonUI.this.setMouseOver(false);
            MetalJideSplitButtonUI.this.menuItem.repaint();
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            JMenu jMenu = (JMenu)MetalJideSplitButtonUI.this.menuItem;
            if (!jMenu.isEnabled()) {
                return;
            }
            MenuSelectionManager.defaultManager().processMouseEvent(mouseEvent);
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }
}

