/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.range;

import com.jidesoft.range.CategoryRange;
import com.jidesoft.range.Positionable;
import java.io.Serializable;

public class Category<T>
implements Positionable,
Serializable {
    private static final long serialVersionUID = -273502456506105902L;
    private String _name;
    private T _value;
    private CategoryRange<T> _range;

    public Category(String string, T t) {
        this.setName(string);
        this._value = t;
    }

    public Category(String string, T t, CategoryRange<T> categoryRange) {
        this.setName(string);
        this._value = t;
        this._range = categoryRange;
    }

    public Category(T t) {
        this._value = t;
    }

    public Category(T t, CategoryRange<T> categoryRange) {
        this._value = t;
        this._range = categoryRange;
    }

    public CategoryRange<T> getRange() {
        return this._range;
    }

    public void setRange(CategoryRange<T> categoryRange) {
        this._range = categoryRange;
    }

    @Override
    public double position() {
        if (this._range == null) {
            throw new IllegalStateException("Cannot compute position for a category that does not belong to a range");
        }
        return this._range.position(this._value);
    }

    public T getValue() {
        return this._value;
    }

    public String getName() {
        if (this._name == null) {
            return this._value.toString();
        }
        return this._name;
    }

    private void setName(String string) {
        this._name = string;
    }

    @Override
    public int compareTo(Positionable positionable) {
        double d2 = positionable.position();
        double d3 = this.position();
        if (d3 < d2) {
            return -1;
        }
        if (d3 > d2) {
            return 1;
        }
        return 0;
    }

    public int hashCode() {
        int n2 = 1;
        n2 = 31 * n2 + (this._name == null ? 0 : this._name.hashCode());
        n2 = 31 * n2 + (this._value == null ? 0 : this._value.hashCode());
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Category category = (Category)object;
        if (this._name == null ? category._name != null : !this._name.equals(category._name)) {
            return false;
        }
        return !(this._value == null ? category._value != null : !this._value.equals(category._value));
    }

    public String toString() {
        return String.format("#<Category name='%s' value='%s'>", this._name, this._value.toString());
    }
}

