/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.IContour;
import com.jidesoft.swing.JideCursors;
import com.jidesoft.swing.JideSplitPaneDivider;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;

public class Contour
extends JComponent
implements IContour {
    public static final int PARTIAL_OUTLINE_MODE = 0;
    public static final int MIX_OUTLINE_MODE = 1;
    public static final int FULL_OUTLINE_MODE = 2;
    private int _thickness = 4;
    private static final int TAB_WIDTH = 42;
    private static final int TAB_LEADING = 8;
    private Color _lineColor = new Color(136, 136, 136);
    private int _tabHeight = 22;
    private boolean _allowDocking = true;
    private boolean _tabDocking;
    private int _tabSide;
    private boolean _floating;
    private Component _attachedComponent;
    private int _attachedSide;
    private boolean _single;
    private JComponent _saveDraggedComponent;
    private int _saveX;
    private int _saveY;
    private int _saveMouseModifier;
    private Container _relativeContainer;
    private int _outlineMode = 0;
    private Outline _topOutline;
    private Outline _bottomOutline;
    private Outline _leftOutline;
    private Outline _rightOutline;
    private boolean _ghost = false;
    private Component _glassPane;
    private boolean _changeCursor = false;

    public Contour() {
        this(22);
        this.setOpaque(false);
        this.setDoubleBuffered(true);
    }

    public Contour(int n2) {
        this._thickness = UIDefaultsLookup.getInt("Contour.thickness") == 0 ? 4 : UIDefaultsLookup.getInt("Contour.thickness");
        this._lineColor = UIDefaultsLookup.getColor("Contour.color") == null ? new Color(136, 136, 136) : UIDefaultsLookup.getColor("Contour.color");
        this.setTabHeight(n2);
        if (this.getOutlineMode() != 0) {
            this.initOutline();
        }
    }

    private void initOutline() {
        this._topOutline = new Outline();
        this._bottomOutline = new Outline();
        this._leftOutline = new Outline();
        this._rightOutline = new Outline();
    }

    @Override
    public boolean isDoubleBuffered() {
        return true;
    }

    @Override
    public void paint(Graphics graphics) {
        if (!this._ghost) {
            this.paintOutline(graphics, false);
        }
    }

    private void paintOutline(Graphics graphics, boolean bl) {
        Rectangle rectangle = this.getBounds();
        graphics.translate(-rectangle.x, -rectangle.y);
        if (bl) {
            rectangle = SwingUtilities.convertRectangle(this, rectangle, this.getRelativeContainer() != null ? this.getRelativeContainer() : this.getParent());
        } else {
            graphics.setColor(this._lineColor);
        }
        if (this.getOutlineMode() != 2 && this.isTabDocking()) {
            Contour.drawTab(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height - 1, this._tabHeight - 1, 42, 8, this._thickness, this.getTabSide());
        } else {
            Contour.drawRect(graphics, rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1, this._thickness);
        }
    }

    private static void drawLine(Graphics graphics, int n2, int n3, int n4, int n5, int n6) {
        if (n2 == n4) {
            if (n5 > n3) {
                graphics.fillRect(n2, n3, n6, n5 - n3);
            } else {
                graphics.fillRect(n2, n5, n6, n3 - n5);
            }
        } else if (n3 == n5) {
            if (n4 > n2) {
                graphics.fillRect(n2, n3, n4 - n2, n6);
            } else {
                graphics.fillRect(n4, n3, n2 - n4, n6);
            }
        }
    }

    private static void drawRect(Graphics graphics, int n2, int n3, int n4, int n5, int n6) {
        if (n4 <= n6) {
            Contour.drawLine(graphics, n2, n3, n2, n3 + n5, n6);
        } else if (n5 <= n6) {
            Contour.drawLine(graphics, n2, n3, n2 + n4, n3, n6);
        } else {
            Contour.drawLine(graphics, n2, n3, n2 + n4 - n6, n3, n6);
            Contour.drawLine(graphics, n2 + n4 - n6, n3, n2 + n4 - n6, n3 + n5 - n6, n6);
            Contour.drawLine(graphics, n2 + n4, n3 + n5 - n6, n2 + n6, n3 + n5 - n6, n6);
            Contour.drawLine(graphics, n2, n3 + n5, n2, n3 + n6, n6);
        }
    }

    private static void drawTab(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        switch (n10) {
            case 1: {
                Contour.drawTopTab(graphics, n2, n3, n4, n5, n6, n7, n8, n9);
                break;
            }
            case 3: {
                Contour.drawBottomTab(graphics, n2, n3, n4, n5, n6, n7, n8, n9);
            }
        }
    }

    private static void drawTopTab(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        Contour.drawLine(graphics, n2 + n4 - n9, n3 + n6, n2 + n4 - n9, n3 + n5 - 1, n9);
        Contour.drawLine(graphics, n2 + n8 + n9, n3 + n6, n2, n3 + n6, n9);
        Contour.drawLine(graphics, n2 + n7 + n8, n3 + n6, n2 + n7 + n8, n3, n9);
        Contour.drawLine(graphics, n2 + n7 + n8, n3, n2 + n8 + 1, n3, n9);
        Contour.drawLine(graphics, n2 + n8, n3, n2 + n8, n3 + n6, n9);
        Contour.drawLine(graphics, n2 + n4, n3 + n6, n2 + n7 + n8, n3 + n6, n9);
        Contour.drawLine(graphics, n2, n3 + n6, n2, n3 + n5, n9);
        Contour.drawLine(graphics, n2, n3 + n5 - n9, n2 + n4, n3 + n5 - n9, n9);
    }

    private static void drawBottomTab(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        Contour.drawLine(graphics, n2, n3, n2 + n4 - 1, n3, n9);
        Contour.drawLine(graphics, n2 + n4 - n9, n3, n2 + n4 - n9, n3 + n5 - n6 - 1, n9);
        Contour.drawLine(graphics, n2 + n4, n3 + n5 - n6 - n9, n2 + n7 + n8, n3 + n5 - n6 - n9, n9);
        Contour.drawLine(graphics, n2 + n7 + n8, n3 + n5 - n6, n2 + n7 + n8, n3 + n5, n9);
        Contour.drawLine(graphics, n2 + n7 + n8, n3 + n5 - n9, n2 + n8 + 1, n3 + n5 - n9, n9);
        Contour.drawLine(graphics, n2 + n8, n3 + n5, n2 + n8, n3 + n5 - n6, n9);
        Contour.drawLine(graphics, n2 + n8 + n9, n3 + n5 - n6 - n9, n2 + 1, n3 + n5 - n6 - n9, n9);
        Contour.drawLine(graphics, n2, n3 + n5 - n6, n2, n3 + 1, n9);
    }

    @Override
    public void setBounds(Rectangle rectangle) {
        this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    @Override
    public void setBounds(int n2, int n3, int n4, int n5) {
        if (this.isLightweight()) {
            if (this.getOutlineMode() == 0) {
                if (this._ghost && (this.getRelativeContainer() != null || this.getParent() != null)) {
                    Graphics graphics = (this.getRelativeContainer() != null ? this.getRelativeContainer() : this.getParent()).getGraphics();
                    graphics.setXORMode(this._lineColor);
                    this.paintOutline(graphics, true);
                    super.setBounds(n2, n3, n4 % 2 == 0 ? n4 + 1 : n4, n5 % 2 == 0 ? n5 + 1 : n5);
                } else {
                    super.setBounds(n2, n3, n4 % 2 == 0 ? n4 + 1 : n4, n5 % 2 == 0 ? n5 + 1 : n5);
                }
            } else {
                Rectangle rectangle = new Rectangle(n2, n3, n4 % 2 == 0 ? n4 + 1 : n4, n5 % 2 == 0 ? n5 + 1 : n5);
                if (this.getParent() != null) {
                    Rectangle rectangle2 = this.getParent().getBounds();
                    super.setBounds(n2, n3, n4 % 2 == 0 ? n4 + 1 : n4, n5 % 2 == 0 ? n5 + 1 : n5);
                    if (this.getOutlineMode() == 1 && rectangle2.contains(rectangle)) {
                        this._leftOutline.setVisible(false);
                        this._rightOutline.setVisible(false);
                        this._topOutline.setVisible(false);
                        this._bottomOutline.setVisible(false);
                    } else {
                        super.setVisible(false);
                        Point point = rectangle.getLocation();
                        SwingUtilities.convertPointToScreen(point, this.getParent());
                        this.arrangeOutline(rectangle, point);
                    }
                }
            }
        } else if (this.getRelativeContainer() != null) {
            Point point = new Point(n2, n3);
            SwingUtilities.convertPointToScreen(point, this.getRelativeContainer());
            super.setBounds(point.x, point.y, n4 % 2 == 0 ? n4 + 1 : n4, n5 % 2 == 0 ? n5 + 1 : n5);
        }
    }

    private void arrangeOutline(Rectangle rectangle, Point point) {
        this._leftOutline.setBounds(point.x, point.y, this._thickness, rectangle.height - this._thickness);
        this._topOutline.setBounds(point.x + this._thickness, point.y, rectangle.width - this._thickness - 1, this._thickness);
        this._rightOutline.setBounds(point.x + rectangle.width - this._thickness - 1, point.y + this._thickness, this._thickness, rectangle.height - this._thickness);
        this._bottomOutline.setBounds(point.x, point.y + rectangle.height - this._thickness, rectangle.width - 1, this._thickness);
        if (!this._topOutline.isVisible()) {
            this._topOutline.setVisible(true);
        }
        if (!this._leftOutline.isVisible()) {
            this._leftOutline.setVisible(true);
        }
        if (!this._rightOutline.isVisible()) {
            this._rightOutline.setVisible(true);
        }
        if (!this._bottomOutline.isVisible()) {
            this._bottomOutline.setVisible(true);
        }
    }

    @Override
    public int getTabHeight() {
        return this._tabHeight;
    }

    @Override
    public void setTabHeight(int n2) {
        this._tabHeight = n2;
    }

    @Override
    public boolean isTabDocking() {
        return this._tabDocking;
    }

    @Override
    public void setTabDocking(boolean bl) {
        this._tabDocking = bl;
        this.updateCursor();
    }

    @Override
    public int getTabSide() {
        return this._tabSide;
    }

    @Override
    public void setTabSide(int n2) {
        this._tabSide = n2;
    }

    @Override
    public boolean isFloating() {
        return this._floating;
    }

    @Override
    public void setFloating(boolean bl) {
        this._floating = bl;
        this.updateCursor();
    }

    @Override
    public Component getAttachedComponent() {
        return this._attachedComponent;
    }

    @Override
    public void setAttachedComponent(Component component) {
        this._attachedComponent = component;
    }

    @Override
    public int getAttachedSide() {
        return this._attachedSide;
    }

    @Override
    public void setAttachedSide(int n2) {
        this._attachedSide = n2;
        this.updateCursor();
    }

    private void updateCursor() {
        if (this.getGlassPane() == null) {
            return;
        }
        if (!this.isVisible() && this._floating) {
            this.getGlassPane().setCursor(JideCursors.getPredefinedCursor(23));
            return;
        }
        this.getGlassPane().setCursor(Cursor.getDefaultCursor());
        if (!this._changeCursor) {
            return;
        }
        if (!this.isVisible()) {
            this.getGlassPane().setCursor(Cursor.getDefaultCursor());
            return;
        }
        if (this.isVisible() && (!this._allowDocking || this._floating)) {
            this.getGlassPane().setCursor(JideCursors.getPredefinedCursor(29));
        } else if (this.isVisible() && this._tabDocking) {
            this.getGlassPane().setCursor(JideCursors.getPredefinedCursor(28));
        } else if (this.getAttachedComponent() instanceof JideSplitPaneDivider) {
            if (((JideSplitPaneDivider)this.getAttachedComponent()).getJideSplitPane().getOrientation() == 1) {
                this.getGlassPane().setCursor(JideCursors.getPredefinedCursor(31));
            } else {
                this.getGlassPane().setCursor(JideCursors.getPredefinedCursor(30));
            }
        } else {
            switch (this._attachedSide) {
                case 1: {
                    this.getGlassPane().setCursor(JideCursors.getPredefinedCursor(24));
                    break;
                }
                case 2: {
                    this.getGlassPane().setCursor(JideCursors.getPredefinedCursor(25));
                    break;
                }
                case 4: {
                    this.getGlassPane().setCursor(JideCursors.getPredefinedCursor(26));
                    break;
                }
                case 8: {
                    this.getGlassPane().setCursor(JideCursors.getPredefinedCursor(27));
                    break;
                }
                default: {
                    this.getGlassPane().setCursor(Cursor.getDefaultCursor());
                }
            }
        }
    }

    @Override
    public boolean isSingle() {
        return this._single;
    }

    @Override
    public void setSingle(boolean bl) {
        this._single = bl;
    }

    @Override
    public boolean isAllowDocking() {
        return this._allowDocking;
    }

    @Override
    public void setAllowDocking(boolean bl) {
        this._allowDocking = bl;
        this.updateCursor();
    }

    @Override
    public Container getRelativeContainer() {
        return this._relativeContainer;
    }

    @Override
    public void setRelativeContainer(Container container) {
        this._relativeContainer = container;
    }

    @Override
    public int getSaveX() {
        return this._saveX;
    }

    @Override
    public int getSaveY() {
        return this._saveY;
    }

    @Override
    public int getSaveMouseModifier() {
        return this._saveMouseModifier;
    }

    @Override
    public JComponent getSaveDraggedComponent() {
        return this._saveDraggedComponent;
    }

    @Override
    public void setDraggingInformation(JComponent jComponent, int n2, int n3, int n4) {
        this._saveDraggedComponent = jComponent;
        this._saveX = n2;
        this._saveY = n3;
        this._saveMouseModifier = n4;
    }

    @Override
    public void cleanup() {
        if (this.getOutlineMode() != 0) {
            this._leftOutline.dispose();
            this._rightOutline.dispose();
            this._topOutline.dispose();
            this._bottomOutline.dispose();
            this._leftOutline = null;
            this._rightOutline = null;
            this._topOutline = null;
            this._bottomOutline = null;
        }
        if (this.getGlassPane() != null) {
            this.getGlassPane().setCursor(Cursor.getDefaultCursor());
        }
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        this.updateCursor();
        if (!bl && this.getOutlineMode() != 0) {
            this._leftOutline.setVisible(false);
            this._rightOutline.setVisible(false);
            this._topOutline.setVisible(false);
            this._bottomOutline.setVisible(false);
        }
    }

    @Override
    public boolean isVisible() {
        if (super.isVisible()) {
            return true;
        }
        return this.getOutlineMode() != 0 && (this._topOutline.isVisible() || this._bottomOutline.isVisible() || this._leftOutline.isVisible() || this._rightOutline.isVisible());
    }

    public int getOutlineMode() {
        return this._outlineMode;
    }

    public void setOutlineMode(int n2) {
        if (n2 != 0 && this._outlineMode == 0) {
            this.initOutline();
        }
        this._outlineMode = n2;
    }

    @Override
    public Component getGlassPane() {
        return this._glassPane;
    }

    @Override
    public void setGlassPane(Component component) {
        this._glassPane = component;
    }

    public boolean isChangeCursor() {
        return this._changeCursor;
    }

    @Override
    public void setChangeCursor(boolean bl) {
        this._changeCursor = bl;
    }

    class Outline
    extends JWindow {
        public Outline() {
            this.setVisible(false);
            this.setBackground(Contour.this._lineColor);
        }

        @Override
        public void paint(Graphics graphics) {
            graphics.setColor(Contour.this._lineColor);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }
}

