/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.SoftHashMap;
import java.awt.Font;
import java.util.Map;

public class FontUtils {
    private static Map<FontAttribute, Font> _fontCache;

    public static int getDerivedFontCacheSize() {
        return _fontCache != null ? _fontCache.size() : 0;
    }

    public static void clearDerivedFontCache() {
        if (_fontCache != null) {
            _fontCache.clear();
            _fontCache = null;
        }
    }

    public static Font getCachedDerivedFont(Font font, int n2, int n3) {
        FontAttribute fontAttribute;
        Font font2;
        if (_fontCache == null) {
            _fontCache = new SoftHashMap<FontAttribute, Font>();
        }
        if ((font2 = _fontCache.get(fontAttribute = new FontAttribute(font, n2, n3))) == null) {
            font2 = font.deriveFont(n2, n3);
            _fontCache.put(fontAttribute, font2);
        }
        return font2;
    }

    private static class FontAttribute {
        private Font _font;
        private int _style;
        private float _size;

        FontAttribute(Font font, int n2, float f2) {
            this._font = font;
            this._style = n2;
            this._size = f2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof FontAttribute)) {
                return false;
            }
            FontAttribute fontAttribute = (FontAttribute)object;
            if (Float.compare(fontAttribute._size, this._size) != 0) {
                return false;
            }
            if (this._style != fontAttribute._style) {
                return false;
            }
            return this._font != null && this._font.equals(fontAttribute._font);
        }

        public int hashCode() {
            int n2 = this._font.hashCode();
            n2 = 31 * n2 + this._style;
            n2 = 31 * n2 + (this._size != 0.0f ? Float.floatToIntBits(this._size) : 0);
            return n2;
        }
    }
}

