/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.border.MatteBorder;

public class IconBorder
extends MatteBorder {
    private static final long serialVersionUID = -5657747462265533365L;
    private int _horizontalIconAlignment = -1;
    private int _verticalIconAlignment = -1;

    public IconBorder(Icon icon) {
        super(0, 0, 0, icon.getIconWidth(), icon);
        this._verticalIconAlignment = 1;
    }

    public IconBorder(Icon icon, int n2) {
        super(0, 0, 0, icon.getIconWidth(), icon);
        this._verticalIconAlignment = n2;
    }

    public IconBorder(Insets insets, Icon icon) {
        super(insets, icon);
        if (insets.right > 0 || insets.left > 0) {
            this._verticalIconAlignment = 1;
        } else if (insets.top > 0 || insets.bottom > 0) {
            this._horizontalIconAlignment = 11;
        }
    }

    public IconBorder(int n2, int n3, int n4, int n5, Icon icon) {
        super(n2, n3, n4, n5, icon);
        if (n5 > 0 || n3 > 0) {
            this._verticalIconAlignment = 1;
        } else if (n2 > 0 || n4 > 0) {
            this._horizontalIconAlignment = 11;
        }
    }

    public int getHorizontalIconAlignment() {
        return this._horizontalIconAlignment;
    }

    public void setHorizontalIconAlignment(int n2) {
        this._horizontalIconAlignment = n2;
    }

    public int getVerticalIconAlignment() {
        return this._verticalIconAlignment;
    }

    public void setVerticalIconAlignment(int n2) {
        this._verticalIconAlignment = n2;
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
        if (this.getHorizontalIconAlignment() == -1 && this.getVerticalIconAlignment() == -1 || this.tileIcon == null) {
            super.paintBorder(component, graphics, n2, n3, n4, n5);
        } else {
            Insets insets = this.getBorderInsets(component);
            Color color = graphics.getColor();
            graphics.translate(n2, n3);
            if (this.tileIcon != null) {
                Color color2 = this.color = this.tileIcon.getIconWidth() == -1 ? Color.gray : null;
            }
            if (this.color != null) {
                graphics.setColor(this.color);
                graphics.fillRect(0, 0, n4 - insets.right, insets.top);
                graphics.fillRect(0, insets.top, insets.left, n5 - insets.top);
                graphics.fillRect(insets.left, n5 - insets.bottom, n4 - insets.left, insets.bottom);
                graphics.fillRect(n4 - insets.right, 0, insets.right, n5 - insets.bottom);
            } else if (this.tileIcon != null) {
                int n6;
                int n7;
                int n8;
                int n9;
                int n10;
                Graphics graphics2;
                int n11 = this.tileIcon.getIconWidth();
                int n12 = this.tileIcon.getIconHeight();
                if (insets.top > 0) {
                    graphics2 = graphics.create();
                    graphics2.setClip(0, 0, n4, insets.top);
                    n10 = insets.left;
                    n9 = 0;
                    n8 = this.getVerticalIconAlignment();
                    if (!component.getComponentOrientation().isLeftToRight()) {
                        if (n8 == 10) {
                            n8 = 4;
                        } else if (n8 == 11) {
                            n8 = 2;
                        }
                    }
                    switch (n8) {
                        case 2: 
                        case 10: {
                            n7 = n10;
                            n6 = n9;
                            break;
                        }
                        case 0: {
                            n7 = n10 + (n4 - n11) / 2;
                            n6 = n9;
                            break;
                        }
                        default: {
                            n7 = n10 + n4 - n11;
                            n6 = n9;
                        }
                    }
                    this.tileIcon.paintIcon(component, graphics2, n7, n6);
                    graphics2.dispose();
                }
                if (insets.left > 0) {
                    graphics2 = graphics.create();
                    graphics2.setClip(0, insets.top, insets.left, n5 - insets.top);
                    n9 = insets.top;
                    n10 = 0;
                    switch (this.getVerticalIconAlignment()) {
                        case 1: 
                        case 10: {
                            n7 = n10;
                            n6 = n9;
                            break;
                        }
                        case 0: {
                            n7 = n10;
                            n6 = n9 + (n5 - n12) / 2;
                            break;
                        }
                        default: {
                            n7 = n10;
                            n6 = n9 + n5 - n12;
                        }
                    }
                    this.tileIcon.paintIcon(component, graphics2, n7, n6);
                    graphics2.dispose();
                }
                if (insets.bottom > 0) {
                    graphics2 = graphics.create();
                    graphics2.setClip(insets.left, n5 - insets.bottom, n4 - insets.left, insets.bottom);
                    n9 = n5 - insets.bottom;
                    n10 = insets.left;
                    n8 = this.getHorizontalIconAlignment();
                    if (!component.getComponentOrientation().isLeftToRight()) {
                        if (n8 == 10) {
                            n8 = 4;
                        } else if (n8 == 11) {
                            n8 = 2;
                        }
                    }
                    switch (n8) {
                        case 2: 
                        case 10: {
                            n7 = n10;
                            n6 = n9;
                            break;
                        }
                        case 0: {
                            n7 = n10 + (n4 - n11) / 2;
                            n6 = n9;
                            break;
                        }
                        default: {
                            n7 = n10 + n4 - n11;
                            n6 = n9;
                        }
                    }
                    this.tileIcon.paintIcon(component, graphics2, n7, n6);
                    graphics2.dispose();
                }
                if (insets.right > 0) {
                    graphics2 = graphics.create();
                    graphics2.setClip(n4 - insets.right, insets.top, insets.right, n5 - insets.top - insets.bottom);
                    n9 = insets.top;
                    n10 = n4 - insets.right;
                    switch (this.getVerticalIconAlignment()) {
                        case 1: 
                        case 10: {
                            n7 = n10;
                            n6 = n9;
                            break;
                        }
                        case 0: {
                            n7 = n10;
                            n6 = n9 + (n5 - n12) / 2;
                            break;
                        }
                        default: {
                            n7 = n10;
                            n6 = n9 + n5 - n12;
                        }
                    }
                    this.tileIcon.paintIcon(component, graphics2, n7, n6);
                    graphics2.dispose();
                }
            }
            graphics.translate(-n2, -n3);
            graphics.setColor(color);
        }
    }
}

