/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.TristateButtonModel;
import com.jidesoft.swing.TristateCheckBox;
import java.awt.Component;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthConstants;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import sun.swing.plaf.synth.SynthIcon;

public class TristateCheckBoxIcon
implements Icon,
SynthConstants {
    private UIDefaults.LazyValue _originalIcon;
    private static Map<String, Boolean> _synthIconMap;

    public TristateCheckBoxIcon(UIDefaults.LazyValue lazyValue) {
        this._originalIcon = lazyValue;
    }

    protected boolean isSynthIconClassName(String string) {
        return string != null && string.contains("sun.swing.plaf.synth.SynthIcon");
    }

    private boolean isSynthIcon(Icon icon) {
        if (_synthIconMap == null) {
            _synthIconMap = new HashMap<String, Boolean>();
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        boolean bl = false;
        for (Class<?> clazz = icon.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            String string = clazz.getCanonicalName();
            if (string == null) continue;
            Object object = _synthIconMap.get(string);
            if (object != null) {
                return (Boolean)object;
            }
            arrayList.add(string);
            if (!this.isSynthIconClassName(string)) continue;
            bl = true;
            break;
        }
        for (Object object : arrayList) {
            _synthIconMap.put((String)object, bl);
        }
        return bl;
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
        Icon icon = (Icon)this._originalIcon.createValue(UIManager.getDefaults());
        if (this.isSynthIcon(icon)) {
            int n4 = this.getComponentState((JComponent)component);
            if (component instanceof TristateCheckBox && ((TristateCheckBox)component).getModel() instanceof TristateButtonModel && ((TristateButtonModel)((TristateCheckBox)component).getModel()).isMixed()) {
                n4 &= 0xFFFFFDFF;
            }
            SynthContext synthContext = new SynthContext((JComponent)component, Region.CHECK_BOX, SynthLookAndFeel.getStyle((JComponent)component, Region.CHECK_BOX), n4);
            int n5 = ((SynthIcon)icon).getIconWidth(synthContext);
            int n6 = ((SynthIcon)icon).getIconHeight(synthContext);
            ((SynthIcon)icon).paintIcon(synthContext, graphics, n2, n3, n5, n6);
        } else {
            if (component instanceof TristateCheckBox && ((TristateCheckBox)component).getModel() instanceof TristateButtonModel && ((TristateButtonModel)((TristateCheckBox)component).getModel()).isMixed()) {
                ((TristateButtonModel)((TristateCheckBox)component).getModel()).internalSetSelected(false);
            }
            icon.paintIcon(component, graphics, n2, n3);
            if (component instanceof TristateCheckBox && ((TristateCheckBox)component).getModel() instanceof TristateButtonModel && ((TristateButtonModel)((TristateCheckBox)component).getModel()).isMixed()) {
                ((TristateButtonModel)((TristateCheckBox)component).getModel()).internalSetSelected(true);
            }
        }
        graphics.setColor(UIManager.getColor("CheckBox.foreground"));
        if (component instanceof TristateCheckBox && ((TristateCheckBox)component).getModel() instanceof TristateButtonModel && ((TristateButtonModel)((TristateCheckBox)component).getModel()).isMixed()) {
            this.drawSquare(component, graphics, n2, n3);
        }
    }

    private int getComponentState(JComponent jComponent) {
        AbstractButton abstractButton;
        ButtonModel buttonModel;
        int n2 = 1;
        if (!jComponent.isEnabled()) {
            n2 = 8;
        }
        if ((buttonModel = (abstractButton = (AbstractButton)jComponent).getModel()).isPressed()) {
            n2 = buttonModel.isArmed() ? 4 : 2;
        }
        if (buttonModel.isRollover()) {
            n2 |= 2;
        }
        if (buttonModel.isSelected()) {
            n2 |= 0x200;
        }
        if (jComponent.isFocusOwner() && abstractButton.isFocusPainted()) {
            n2 |= 0x100;
        }
        if (jComponent instanceof JButton && ((JButton)jComponent).isDefaultButton()) {
            n2 |= 0x400;
        }
        return n2;
    }

    @Override
    public int getIconWidth() {
        Icon icon = (Icon)this._originalIcon.createValue(UIManager.getDefaults());
        return icon.getIconWidth();
    }

    @Override
    public int getIconHeight() {
        Icon icon = (Icon)this._originalIcon.createValue(UIManager.getDefaults());
        return icon.getIconHeight();
    }

    protected void drawSquare(Component component, Graphics graphics, int n2, int n3) {
        int n4 = Math.min(this.getIconWidth(), this.getIconHeight());
        int n5 = Math.min(this.getIconWidth(), this.getIconHeight());
        int n6 = n4 / 3;
        int n7 = n5 / 3;
        graphics.fillRect(n2 + n6, n3 + n7, n4 - n6 * 2, n5 - n7 * 2);
    }
}

