/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.chaos.audiosystem.impl;

import com.thinkbuzan.chaos.audiosystem.AudioCodec;
import com.thinkbuzan.chaos.audiosystem.AudioFactory;
import com.thinkbuzan.chaos.audiosystem.IAudioTools;
import com.thinkbuzan.chaos.audiosystem.impl.AudioTools;
import com.thinkbuzan.chaos.audiosystem.player.IAudioPlayer;
import com.thinkbuzan.chaos.audiosystem.player.impl.AudioPlayer;
import com.thinkbuzan.chaos.audiosystem.recorder.IAudioRecorder;
import com.thinkbuzan.chaos.audiosystem.recorder.impl.AudioRecorder;
import java.io.File;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AudioFactoryImpl
implements AudioFactory {
    @Override
    public IAudioPlayer createAudioPlayer(File file, AudioCodec codec) {
        this.validate(file, codec, Arrays.asList(AudioCodec.WAV, AudioCodec.HEADERLESS_WAV, AudioCodec.GSM));
        return new AudioPlayer(file, codec);
    }

    @Override
    public IAudioRecorder createAudioRecorder(File file, AudioCodec codec) {
        this.validate(file, codec, Arrays.asList(AudioCodec.HEADERLESS_WAV, AudioCodec.GSM));
        return new AudioRecorder(file, codec);
    }

    private void validate(File file, AudioCodec codec, List<AudioCodec> validCodecs) {
        if (file == null) {
            throw new IllegalArgumentException("file must not be null");
        }
        if (!validCodecs.contains((Object)codec)) {
            String message = "Expected codec to be in %s but was %s";
            throw new IllegalArgumentException(String.format("Expected codec to be in %s but was %s", new Object[]{validCodecs, codec}));
        }
    }

    @Override
    public IAudioTools createAudioTools() {
        return new AudioTools();
    }
}

