/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.chaos.audiosystem.impl;

import com.thinkbuzan.chaos.audiosystem.AudioCodec;
import com.thinkbuzan.chaos.audiosystem.IAudioTools;
import com.thinkbuzan.chaos.audiosystem.TranscodeException;
import com.thinkbuzan.chaos.audiosystem.constants.GsmConstants;
import com.thinkbuzan.chaos.audiosystem.constants.WavConstants;
import com.thinkbuzan.chaos.audiosystem.impl.JavaSoundHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import org.apache.log4j.Logger;

public class AudioTools
implements IAudioTools {
    private static final transient Logger LOGGER = Logger.getLogger(AudioTools.class);

    public double calculateDuration(File file, AudioCodec codec) {
        long frameCount;
        AudioFormat audioFormat;
        if (file == null) {
            throw new IllegalArgumentException("file must not be null");
        }
        List<AudioCodec> validCodecs = Arrays.asList(AudioCodec.WAV, AudioCodec.HEADERLESS_WAV, AudioCodec.GSM);
        if (!validCodecs.contains((Object)codec)) {
            LOGGER.error((Object)String.format("Expected codec to be in %s but was %s", new Object[]{validCodecs, codec}));
        }
        switch (codec) {
            case GSM: {
                audioFormat = GsmConstants.GSM_FORMAT;
                frameCount = this.calculateFrameCountHeaderless(file, audioFormat);
                break;
            }
            case WAV: {
                try {
                    AudioFileFormat fileFormat = AudioSystem.getAudioFileFormat(file);
                    audioFormat = fileFormat.getFormat();
                    frameCount = fileFormat.getFrameLength();
                    break;
                }
                catch (Exception exception) {
                    LOGGER.error((Object)"Could not calculate length of WAV", (Throwable)exception);
                    return 1.0;
                }
            }
            case HEADERLESS_WAV: {
                audioFormat = WavConstants.PCM_FORMAT;
                frameCount = this.calculateFrameCountHeaderless(file, audioFormat);
                break;
            }
            default: {
                LOGGER.error((Object)"Could not calculate length (Unexpected codec)");
                return 1.0;
            }
        }
        double framesPerSecond = audioFormat.getFrameRate() * (float)audioFormat.getChannels();
        double durationInSeconds = (double)frameCount / framesPerSecond;
        return durationInSeconds;
    }

    private long calculateFrameCountHeaderless(File file, AudioFormat audioFormat) {
        long byteCount = file.length();
        long frameCount = byteCount / (long)audioFormat.getFrameSize();
        return frameCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transcode(File input, AudioCodec inputCodec, File output, AudioCodec outputCodec) throws TranscodeException {
        if (input == null) {
            throw new IllegalArgumentException("input must not be null");
        }
        if (inputCodec != AudioCodec.GSM) {
            throw new IllegalArgumentException("inputCodec must be GSM");
        }
        if (output == null) {
            throw new IllegalArgumentException("output must not be null");
        }
        if (outputCodec != AudioCodec.WAV) {
            throw new IllegalArgumentException("outputCodec must be WAV");
        }
        if (LOGGER.isDebugEnabled()) {
            String message = "transcode(input=%s, inputCodec=%s, output=%s, outputCodec=%s)";
            LOGGER.debug((Object)String.format("transcode(input=%s, inputCodec=%s, output=%s, outputCodec=%s)", new Object[]{input, inputCodec, output, outputCodec}));
        }
        FileInputStream fileInput = null;
        FileOutputStream fileOutput = null;
        try {
            fileInput = new FileInputStream(input);
            long frameCount = this.calculateFrameCountHeaderless(input, GsmConstants.GSM_FORMAT);
            AudioInputStream gsmInput = new AudioInputStream(fileInput, GsmConstants.GSM_FORMAT, frameCount);
            AudioInputStream pcmInput = JavaSoundHelper.getAudioInputStream(GsmConstants.PCM_FORMAT, gsmInput);
            fileOutput = new FileOutputStream(output);
            AudioSystem.write(pcmInput, AudioFileFormat.Type.WAVE, fileOutput);
        }
        catch (Exception exception) {
            LOGGER.error((Object)"Caught Exception", (Throwable)exception);
        }
        finally {
            if (fileOutput != null) {
                try {
                    fileOutput.close();
                }
                catch (IOException exception) {
                    LOGGER.error((Object)("Could not close FileOutputStream on " + output));
                }
            }
            if (fileInput != null) {
                try {
                    fileInput.close();
                }
                catch (IOException exception) {
                    LOGGER.error((Object)("Could not close FileInputStream on " + input));
                }
            }
        }
    }

    public static void main(String[] args) throws TranscodeException {
        AudioTools tools = new AudioTools();
        tools.transcode(new File("C:\\Users\\Kevin\\Desktop\\AUDIO NOTES\\JAMES.gsm"), AudioCodec.GSM, new File("C:\\Users\\Kevin\\Desktop\\AUDIO NOTES\\JAMES.wav"), AudioCodec.WAV);
    }
}

