/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.chaos.audiosystem.impl;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;

public final class BlockBoolean {
    private static final transient Logger LOGGER = Logger.getLogger(BlockBoolean.class);
    private static final transient int TIME_OUT = 10;
    private transient boolean value;
    private final transient ReentrantLock lock = new ReentrantLock();
    private final transient Condition condition = this.lock.newCondition();
    private transient boolean cancelled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(boolean valueIn) {
        this.lock.lock();
        try {
            this.value = valueIn;
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean get() {
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void blockUntil(boolean required) {
        this.lock.lock();
        try {
            while (this.value != required && !this.cancelled) {
                try {
                    boolean success;
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)"Going to call await");
                    }
                    if (success = this.condition.await(10L, TimeUnit.SECONDS)) continue;
                    LOGGER.error((Object)"success == false (I.E. await timed out)", (Throwable)new StackTrace());
                    break;
                }
                catch (InterruptedException exception) {
                    LOGGER.error((Object)"Caught InterruptedException", (Throwable)exception);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        this.lock.lock();
        try {
            this.cancelled = true;
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    private class StackTrace
    extends Exception {
        private static final long serialVersionUID = 8159875783244169968L;

        private StackTrace() {
        }
    }
}

