/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.chaos.audiosystem.impl;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import org.apache.log4j.Logger;
import org.tritonus.sampled.convert.gsm.GSMFormatConversionProvider;

public class JavaSoundHelper {
    private static final transient Logger LOGGER = Logger.getLogger(JavaSoundHelper.class);

    private JavaSoundHelper() {
    }

    public static AudioInputStream getAudioInputStream(AudioFormat targetFormat, AudioInputStream sourceStream) {
        if (LOGGER.isDebugEnabled()) {
            String message = "getAudioInputStream(targetFormat=%s, sourceStream=%s)";
            LOGGER.debug((Object)String.format("getAudioInputStream(targetFormat=%s, sourceStream=%s)", targetFormat, sourceStream));
        }
        if (sourceStream.getFormat().matches(targetFormat)) {
            return sourceStream;
        }
        GSMFormatConversionProvider codec = new GSMFormatConversionProvider();
        if (codec.isConversionSupported(targetFormat, sourceStream.getFormat())) {
            return codec.getAudioInputStream(targetFormat, sourceStream);
        }
        return AudioSystem.getAudioInputStream(targetFormat, sourceStream);
    }
}

