/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.chaos.audiosystem.player.impl;

import com.thinkbuzan.chaos.audiosystem.AudioCodec;
import com.thinkbuzan.chaos.audiosystem.constants.GsmConstants;
import com.thinkbuzan.chaos.audiosystem.constants.WavConstants;
import com.thinkbuzan.chaos.audiosystem.impl.BlockBoolean;
import com.thinkbuzan.chaos.audiosystem.impl.JavaSoundHelper;
import com.thinkbuzan.chaos.audiosystem.player.AudioPlayerException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;
import org.apache.log4j.Logger;

public abstract class AbstractAudioPlayerThread
extends Thread {
    private static final transient Logger LOGGER = Logger.getLogger(AbstractAudioPlayerThread.class);
    private static final long POSITION_EVENT_FREQUENCY = 100L;
    private final transient BlockBoolean killed;
    private transient boolean killRequested;
    private transient boolean pauseRequested;
    private transient boolean paused;
    private final transient ReentrantLock pauseLock;
    private final transient Condition pauseCondition;
    private final transient File file;
    private transient SourceDataLine dataLine;
    private transient boolean seekRequested;
    private transient double seekRequest;
    private final transient AudioCodec codec;
    private AudioInputStream pcmInput;
    private FileInputStream fileInput;
    private FileChannel channel;
    private long headerByteCount;
    private AudioFormat fileAudioFormat;
    private long channelSize;
    private AudioFormat dataLineAudioFormat;
    private transient long positionDelta;

    public AbstractAudioPlayerThread(File fileIn, AudioCodec codecIn) throws AudioPlayerException {
        if (fileIn == null) {
            throw new IllegalArgumentException("fileIn must not be null");
        }
        List<AudioCodec> validCodecs = Arrays.asList(AudioCodec.WAV, AudioCodec.HEADERLESS_WAV, AudioCodec.GSM);
        if (!validCodecs.contains((Object)codecIn)) {
            String message = "Expected codecIn to be in %s but was %s";
            throw new IllegalArgumentException(String.format("Expected codecIn to be in %s but was %s", new Object[]{validCodecs, codecIn}));
        }
        this.setName(this.getClass().getName());
        this.setDaemon(true);
        this.file = fileIn;
        this.codec = codecIn;
        this.killed = new BlockBoolean();
        this.pauseLock = new ReentrantLock();
        this.pauseCondition = this.pauseLock.newCondition();
        try {
            this.init();
        }
        catch (Exception exception) {
            throw new AudioPlayerException("Caught Exception", exception);
        }
    }

    private void init() throws Exception {
        this.fileInput = new FileInputStream(this.file);
        this.channel = this.fileInput.getChannel();
        if (this.codec == AudioCodec.GSM) {
            this.dataLineAudioFormat = GsmConstants.PCM_FORMAT;
            this.fileAudioFormat = GsmConstants.GSM_FORMAT;
            long headerByteCount = 0L;
        } else if (this.codec == AudioCodec.HEADERLESS_WAV) {
            this.dataLineAudioFormat = WavConstants.PCM_FORMAT;
            this.fileAudioFormat = WavConstants.PCM_FORMAT;
            long headerByteCount = 0L;
        } else if (this.codec == AudioCodec.WAV) {
            BufferedInputStream temporaryBufferedInputStream = new BufferedInputStream(this.fileInput);
            AudioFileFormat audioFileFormat = AudioSystem.getAudioFileFormat(temporaryBufferedInputStream);
            this.dataLineAudioFormat = audioFileFormat.getFormat();
            this.fileAudioFormat = audioFileFormat.getFormat();
            long headerByteCount = this.calculateWAVHeaderByteCount(audioFileFormat);
            this.channel.position(headerByteCount);
        } else {
            throw new IllegalArgumentException("Expected codec to be GSM, HEADERLESS_WAV or WAV");
        }
        AudioInputStream input = new AudioInputStream(this.fileInput, this.fileAudioFormat, -1L);
        if (this.fileAudioFormat.getFrameSize() <= 0) {
            throw new IllegalStateException("Expected fileAudioFormat.getFrameSize() to be greater than 0 (Seeking code relies on this)");
        }
        this.channelSize = this.channel.size();
        DataLine.Info lineInfo = new DataLine.Info(SourceDataLine.class, this.dataLineAudioFormat);
        this.dataLine = (SourceDataLine)AudioSystem.getLine(lineInfo);
        this.pcmInput = JavaSoundHelper.getAudioInputStream(this.dataLineAudioFormat, input);
    }

    public void run() {
        try {
            this.mainLoop();
        }
        catch (Exception exception) {
            LOGGER.error((Object)"Caught Exception in mainLoop()", (Throwable)exception);
        }
        this.notifyPositionChanged(0.0);
        try {
            if (this.pcmInput != null) {
                this.pcmInput.close();
            }
        }
        catch (IOException exception) {
            LOGGER.error((Object)"Caught IOException when closing pcmInput", (Throwable)exception);
        }
        try {
            if (this.fileInput != null) {
                this.fileInput.close();
            }
        }
        catch (IOException exception) {
            LOGGER.error((Object)"Caught IOException when closing fileInput", (Throwable)exception);
        }
        try {
            if (this.channel != null) {
                this.channel.close();
            }
        }
        catch (IOException exception) {
            LOGGER.error((Object)"Caught IOException when closing channel", (Throwable)exception);
        }
        if (this.dataLine != null) {
            this.dataLine.close();
        }
        this.notifyPlayingStopped();
        this.killed.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mainLoop() throws Exception {
        this.dataLine.open();
        this.dataLine.start();
        int bufferSize = 8192;
        byte[] buffer = new byte[8192];
        boolean endOfStream = false;
        this.notifyPlayingStarted();
        long nextPositionEvent = System.currentTimeMillis();
        boolean loop = true;
        while (loop) {
            int bytesRead;
            long now;
            if (endOfStream) {
                boolean drained;
                boolean bl = drained = this.dataLine.available() == this.dataLine.getBufferSize();
                if (drained) {
                    loop = false;
                }
            }
            if (this.killRequested) {
                loop = false;
                this.dataLine.flush();
                break;
            }
            if (this.pauseRequested) {
                this.pauseRequested = false;
                this.dataLine.stop();
                this.notifyPaused();
                while (this.paused) {
                    this.pauseLock.lock();
                    try {
                        try {
                            this.pauseCondition.await();
                        }
                        catch (InterruptedException exception) {
                            LOGGER.error((Object)"Caught InterruptedException", (Throwable)exception);
                        }
                    }
                    finally {
                        this.pauseLock.unlock();
                    }
                }
                this.dataLine.start();
                this.notifyPlayingStarted();
            }
            if (this.seekRequested) {
                this.processSeekRequest();
            }
            if ((now = System.currentTimeMillis()) > nextPositionEvent) {
                nextPositionEvent = now + 100L;
                long framePosition = this.dataLine.getLongFramePosition() - this.positionDelta;
                double positionSeconds = (double)framePosition / (double)this.dataLineAudioFormat.getSampleRate();
                this.notifyPositionChanged(positionSeconds);
            }
            if ((bytesRead = this.pcmInput.read(buffer)) == -1) {
                endOfStream = true;
            }
            if (bytesRead <= 0) continue;
            this.dataLine.write(buffer, 0, bytesRead);
        }
    }

    private void processSeekRequest() throws IOException {
        this.seekRequested = false;
        this.dataLine.flush();
        long bytesPosition = this.headerByteCount;
        long offset = (bytesPosition += this.convertSecondsToByteCount(this.seekRequest, this.fileAudioFormat)) % (long)this.fileAudioFormat.getFrameSize();
        if (offset != 0L) {
            bytesPosition -= offset;
        }
        if (bytesPosition < this.headerByteCount) {
            bytesPosition = this.headerByteCount;
        } else if (bytesPosition > this.channelSize) {
            bytesPosition = this.channelSize;
        }
        this.channel.position(bytesPosition);
        this.positionDelta = (long)((float)this.dataLine.getLongFramePosition() - this.convertByteCountToFrameCount(bytesPosition, this.fileAudioFormat));
    }

    private int calculateWAVHeaderByteCount(AudioFileFormat audioFileFormat) {
        return audioFileFormat.getByteLength() - audioFileFormat.getFrameLength() * audioFileFormat.getFormat().getFrameSize();
    }

    private float convertByteCountToFrameCount(long byteCount, AudioFormat format) {
        return (float)(byteCount / (long)format.getFrameSize()) * (format.getSampleRate() / format.getFrameRate());
    }

    private long convertSecondsToByteCount(double seconds, AudioFormat format) {
        return (long)(seconds * (double)format.getFrameSize() * (double)format.getFrameRate() * (double)format.getChannels());
    }

    public final void killBlocking() {
        if (this.paused) {
            this.resumePlayback();
        }
        this.killRequested = true;
        if (Thread.currentThread().equals(this)) {
            String message = "The killBlocking method must not be called on this thread as it will result in a deadlock";
            throw new IllegalStateException("The killBlocking method must not be called on this thread as it will result in a deadlock");
        }
        this.killed.blockUntil(true);
    }

    public void pause() {
        this.paused = true;
        this.pauseRequested = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumePlayback() {
        this.pauseLock.lock();
        try {
            this.paused = false;
            this.pauseCondition.signal();
        }
        finally {
            this.pauseLock.unlock();
        }
    }

    public void seek(double position) {
        this.seekRequested = true;
        this.seekRequest = position;
    }

    protected abstract void notifyPlayingStarted();

    protected abstract void notifyPaused();

    protected abstract void notifyPlayingStopped();

    protected abstract void notifyPositionChanged(double var1);
}

