/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.chaos.audiosystem.player.impl;

import com.thinkbuzan.chaos.audiosystem.AudioCodec;
import com.thinkbuzan.chaos.audiosystem.IAudioTools;
import com.thinkbuzan.chaos.audiosystem.impl.AudioTools;
import com.thinkbuzan.chaos.audiosystem.player.AudioPlayerException;
import com.thinkbuzan.chaos.audiosystem.player.AudioPlayerState;
import com.thinkbuzan.chaos.audiosystem.player.IAudioPlayer;
import com.thinkbuzan.chaos.audiosystem.player.IAudioPlayerListener;
import com.thinkbuzan.chaos.audiosystem.player.impl.AbstractAudioPlayerThread;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AudioPlayer
implements IAudioPlayer {
    private static final transient Logger LOGGER = Logger.getLogger(AudioPlayer.class);
    private final transient File file;
    private transient AbstractAudioPlayerThread thread;
    private final transient List<IAudioPlayerListener> listeners = new CopyOnWriteArrayList<IAudioPlayerListener>();
    private transient AudioPlayerState state = AudioPlayerState.STOPPED;
    private transient double position;
    private transient double duration;
    private final transient AudioCodec codec;
    private final transient IAudioTools audioTools = new AudioTools();

    public AudioPlayer(File fileIn, AudioCodec codecIn) {
        if (fileIn == null) {
            throw new IllegalArgumentException("fileIn must not be null");
        }
        List<AudioCodec> audioCodecs = Arrays.asList(AudioCodec.GSM, AudioCodec.WAV, AudioCodec.HEADERLESS_WAV);
        if (!audioCodecs.contains((Object)codecIn)) {
            String message = "Expected codecIn to be in %s but was %s";
            throw new IllegalArgumentException(String.format("Expected codecIn to be in %s but was %s", new Object[]{audioCodecs, codecIn}));
        }
        this.file = fileIn;
        this.codec = codecIn;
        this.duration = this.calculateDuration();
    }

    @Override
    public synchronized void play() throws AudioPlayerException {
        this.checkState(Arrays.asList(AudioPlayerState.PAUSED, AudioPlayerState.STOPPED));
        AudioPlayerState state = this.getState();
        if (state == AudioPlayerState.PAUSED && this.thread == null) {
            throw new IllegalStateException("Since state is PAUSED, expected thread to be not null but was null");
        }
        if (state == AudioPlayerState.STOPPED && this.thread != null) {
            throw new IllegalStateException("Since state is STOPPED, expected thread to be null but was not null");
        }
        this.setState(AudioPlayerState.TRANSITIONING);
        if (this.thread == null) {
            try {
                this.thread = new AudioPlayerThreadImpl(this, this.getFile(), this.getCodec());
            }
            catch (AudioPlayerException exception) {
                this.setState(AudioPlayerState.STOPPED);
                throw exception;
            }
            this.thread.start();
        } else {
            this.thread.resumePlayback();
        }
    }

    @Override
    public synchronized void pause() {
        this.checkState(Arrays.asList(AudioPlayerState.PLAYING));
        if (this.thread == null) {
            throw new IllegalStateException("Since state is PLAYING, expected thread to be not null but was null");
        }
        this.setState(AudioPlayerState.TRANSITIONING);
        this.thread.pause();
    }

    @Override
    public synchronized void stop() {
        this.checkState(Arrays.asList(AudioPlayerState.PLAYING, AudioPlayerState.PAUSED));
        if (this.thread == null) {
            throw new IllegalStateException("Since state is PLAYING or PAUSED, expected thread to be not null but was null");
        }
        this.setState(AudioPlayerState.TRANSITIONING);
        this.thread.killBlocking();
        this.thread = null;
    }

    @Override
    public synchronized void seek(double position) {
        this.checkState(Arrays.asList(AudioPlayerState.PLAYING, AudioPlayerState.PAUSED));
        if (this.thread == null) {
            throw new IllegalStateException("Since state is PLAYING or PAUSED, expected thread to be not null but was null");
        }
        this.thread.seek(position);
    }

    private void checkState(List<AudioPlayerState> validStates) {
        this.waitForValidState(validStates);
        AudioPlayerState state = this.getState();
        if (!validStates.contains((Object)state)) {
            String message = "Expected state to be in %s but was %s";
            throw new IllegalStateException(String.format("Expected state to be in %s but was %s", new Object[]{validStates, state}));
        }
    }

    private void waitForValidState(List<AudioPlayerState> validStates) {
        AudioPlayerState state;
        long startTime = System.currentTimeMillis();
        long maximumWaitTime = 5000L;
        while (!validStates.contains((Object)(state = this.getState()))) {
            long now;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)String.format("state (%s) does not match validStates (%s). Waiting...", new Object[]{state, validStates}));
            }
            if ((now = System.currentTimeMillis()) - startTime > 5000L) {
                if (!LOGGER.isDebugEnabled()) break;
                LOGGER.debug((Object)"Waiting timed out");
                break;
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException exception) {
                LOGGER.error((Object)"Caught unexpected InterruptedException", (Throwable)exception);
            }
        }
    }

    private double calculateDuration() {
        if (this.getCodec() == AudioCodec.WAV) {
            return this.audioTools.calculateDuration(this.getFile(), AudioCodec.WAV);
        }
        if (this.getCodec() == AudioCodec.GSM) {
            return this.audioTools.calculateDuration(this.getFile(), AudioCodec.GSM);
        }
        if (this.getCodec() == AudioCodec.HEADERLESS_WAV) {
            return this.audioTools.calculateDuration(this.getFile(), AudioCodec.HEADERLESS_WAV);
        }
        throw new IllegalStateException("Expected getCodec() to be GSM, WAV or HEADERLESS_WAV");
    }

    protected final File getFile() {
        return this.file;
    }

    protected final void setPosition(double positionIn) {
        this.position = positionIn;
        this.firePositionChanged();
    }

    protected final void setState(AudioPlayerState stateIn) {
        this.state = stateIn;
        this.fireStateChanged();
    }

    @Override
    public final double getPosition() {
        return this.position;
    }

    @Override
    public final AudioPlayerState getState() {
        return this.state;
    }

    @Override
    public double getDuration() {
        return this.duration;
    }

    protected final AudioCodec getCodec() {
        return this.codec;
    }

    @Override
    public final void addListener(IAudioPlayerListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public final void removeListener(IAudioPlayerListener listener) {
        this.listeners.remove(listener);
    }

    private void fireStateChanged() {
        for (IAudioPlayerListener listener : this.listeners) {
            listener.stateChanged(this.state);
        }
    }

    private void firePositionChanged() {
        for (IAudioPlayerListener listener : this.listeners) {
            listener.positionChanged(this.position);
        }
    }

    private static class AudioPlayerThreadImpl
    extends AbstractAudioPlayerThread {
        private final transient AudioPlayer parent;

        public AudioPlayerThreadImpl(AudioPlayer parentIn, File file, AudioCodec codec) throws AudioPlayerException {
            super(file, codec);
            this.parent = parentIn;
        }

        protected void notifyPlayingStarted() {
            this.parent.setState(AudioPlayerState.PLAYING);
        }

        protected void notifyPaused() {
            this.parent.setState(AudioPlayerState.PAUSED);
        }

        protected void notifyPlayingStopped() {
            this.parent.setState(AudioPlayerState.STOPPED);
            this.parent.thread = null;
        }

        protected void notifyPositionChanged(double position) {
            this.parent.setPosition(position);
        }
    }
}

