/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.chaos.audiosystem.recorder.impl;

import com.thinkbuzan.chaos.audiosystem.recorder.AudioRecorderState;
import com.thinkbuzan.chaos.audiosystem.recorder.IAudioRecorder;
import com.thinkbuzan.chaos.audiosystem.recorder.IAudioRecorderListener;
import java.io.File;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.log4j.Logger;

public abstract class AbstractAudioRecorder
implements IAudioRecorder {
    private static final transient Logger LOGGER = Logger.getLogger(AbstractAudioRecorder.class);
    private final transient List<IAudioRecorderListener> listeners = new CopyOnWriteArrayList<IAudioRecorderListener>();
    private transient AudioRecorderState state = AudioRecorderState.STOPPED;
    private transient double volume;
    private final transient File file;
    private transient double amountRecorded;

    public AbstractAudioRecorder(File fileIn) {
        if (fileIn == null) {
            throw new IllegalArgumentException("fileIn must not be null");
        }
        this.file = fileIn;
    }

    protected final File getFile() {
        return this.file;
    }

    public final void addListener(IAudioRecorderListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        this.listeners.add(listener);
    }

    public final void removeListener(IAudioRecorderListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        this.listeners.remove(listener);
    }

    protected final void setState(AudioRecorderState stateIn) {
        if (stateIn == null) {
            throw new IllegalArgumentException("stateIn must not be null");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)String.format("setState(%s)", new Object[]{stateIn}));
        }
        this.state = stateIn;
        this.fireStateChanged();
    }

    protected final void setVolume(double volumeIn) {
        double clampedVolume = volumeIn;
        clampedVolume = Math.min(1.0, clampedVolume);
        this.volume = clampedVolume = Math.max(0.0, clampedVolume);
        this.fireVolumeChanged();
    }

    protected void setAmountRecorded(double amountRecordedIn) {
        if (amountRecordedIn < 0.0) {
            throw new IllegalArgumentException("amountRecordedIn must not be negative");
        }
        this.amountRecorded = amountRecordedIn;
        this.fireAmountRecordedChanged();
    }

    public final AudioRecorderState getState() {
        return this.state;
    }

    public final double getVolume() {
        return this.volume;
    }

    public double getAmountRecorded() {
        return this.amountRecorded;
    }

    private void fireVolumeChanged() {
        for (IAudioRecorderListener listener : this.listeners) {
            listener.volumeChanged(this.volume);
        }
    }

    private void fireStateChanged() {
        for (IAudioRecorderListener listener : this.listeners) {
            listener.stateChanged(this.state);
        }
    }

    private void fireAmountRecordedChanged() {
        for (IAudioRecorderListener listener : this.listeners) {
            listener.amountRecordedChanged(this.amountRecorded);
        }
    }

    protected void fireErrorOccurred() {
        for (IAudioRecorderListener listener : this.listeners) {
            listener.errorOccurred();
        }
    }
}

