/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.chaos.audiosystem.recorder.impl;

import com.thinkbuzan.chaos.audiosystem.AudioCodec;
import com.thinkbuzan.chaos.audiosystem.constants.GsmConstants;
import com.thinkbuzan.chaos.audiosystem.constants.WavConstants;
import com.thinkbuzan.chaos.audiosystem.impl.BlockBoolean;
import com.thinkbuzan.chaos.audiosystem.impl.JavaSoundHelper;
import com.thinkbuzan.chaos.audiosystem.recorder.AudioRecorderException;
import com.thinkbuzan.chaos.audiosystem.recorder.impl.VolumeMonitorFilterInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.TargetDataLine;
import org.apache.log4j.Logger;

public abstract class AbstractAudioRecorderThread
extends Thread {
    private static final transient Logger LOGGER = Logger.getLogger(AbstractAudioRecorderThread.class);
    private final transient BlockBoolean killed;
    private final transient File file;
    private final transient TargetDataLine dataLine;
    private transient boolean startRecordingRequested;
    private transient boolean stopRecordingRequested;
    private final transient BlockBoolean recording;
    private final transient BlockBoolean monitoringVolume;
    private VolumeMonitorFilterInputStream volumeFilterInput;
    private AudioInputStream encodedInput;
    private boolean endOfStream;
    private final transient AudioCodec codec;
    private final transient AudioFormat inputFormat;
    private final transient AudioFormat outputFormat;
    private transient FileOutputStream fileOutput;
    private long recordingStartTime;

    public AbstractAudioRecorderThread(File fileIn, AudioCodec codecIn) throws AudioRecorderException {
        if (fileIn == null) {
            throw new IllegalArgumentException("fileIn must not be null");
        }
        List<AudioCodec> validCodecs = Arrays.asList(AudioCodec.HEADERLESS_WAV, AudioCodec.GSM);
        if (!validCodecs.contains((Object)codecIn)) {
            throw new IllegalArgumentException(String.format("Expected codec to be one of %s", validCodecs));
        }
        this.codec = codecIn;
        this.file = fileIn;
        this.killed = new BlockBoolean();
        this.recording = new BlockBoolean();
        this.monitoringVolume = new BlockBoolean();
        if (this.codec == AudioCodec.GSM) {
            this.inputFormat = GsmConstants.PCM_FORMAT;
            this.outputFormat = GsmConstants.GSM_FORMAT;
        } else if (this.codec == AudioCodec.HEADERLESS_WAV) {
            this.inputFormat = WavConstants.PCM_FORMAT;
            this.outputFormat = WavConstants.PCM_FORMAT;
        } else {
            throw new IllegalArgumentException("Expected codec to be GSM or HEADERLESS_WAV");
        }
        try {
            DataLine.Info dataLineInfo = new DataLine.Info(TargetDataLine.class, this.inputFormat);
            this.dataLine = (TargetDataLine)AudioSystem.getLine(dataLineInfo);
        }
        catch (Exception exception) {
            throw new AudioRecorderException("Could not get TargetDataLine", exception);
        }
        this.setName(this.getClass().getName());
        this.setDaemon(true);
    }

    public void blockUntilMonitoringVolume() {
        if (Thread.currentThread().equals(this)) {
            String message = "The blockUntilMonitoringVolume method must not be called on this thread as it will result in a deadlock";
            throw new IllegalStateException("The blockUntilMonitoringVolume method must not be called on this thread as it will result in a deadlock");
        }
        this.monitoringVolume.blockUntil(true);
    }

    public void startRecording() {
        this.startRecordingRequested = true;
    }

    public void stopRecording() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"entering stopRecording()");
        }
        this.stopRecordingRequested = true;
        this.dataLine.stop();
        if (Thread.currentThread().equals(this)) {
            String message = "The stopRecording method must not be called on this thread as it will result in a deadlock";
            throw new IllegalStateException("The stopRecording method must not be called on this thread as it will result in a deadlock");
        }
        this.recording.blockUntil(false);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"exiting stopRecording()");
        }
    }

    public final void run() {
        try {
            this.dataLine.open(this.inputFormat);
            this.createInputStreams();
            this.mainLoop();
        }
        catch (Exception exception) {
            this.errorOccurred();
            this.monitoringVolume.cancel();
            LOGGER.error((Object)"Caught Exception", (Throwable)exception);
        }
        try {
            if (this.fileOutput != null) {
                this.fileOutput.close();
            }
        }
        catch (IOException exception) {
            LOGGER.error((Object)"Caught Exception", (Throwable)exception);
        }
        this.dataLine.close();
        try {
            if (this.encodedInput != null) {
                this.encodedInput.close();
            }
        }
        catch (IOException exception) {
            LOGGER.error((Object)"Caught Exception", (Throwable)exception);
        }
        this.volumeChanged(0.0);
        this.stoppedMonitoringVolume();
        this.killed.set(true);
    }

    private void mainLoop() throws FileNotFoundException, IOException {
        int bufferSize = 8192;
        byte[] buffer = new byte[8192];
        this.startedMonitoringVolume();
        this.monitoringVolume.set(true);
        int zeroCount = 0;
        while (!this.endOfStream) {
            int bytesRead;
            if (this.startRecordingRequested) {
                this.processStartRecordingRequest();
            }
            if ((bytesRead = this.encodedInput.read(buffer)) == -1) {
                this.endOfStream = true;
            }
            if (bytesRead == 0) {
                ++zeroCount;
            }
            if (zeroCount > 100) {
                this.endOfStream = true;
                zeroCount = 0;
            }
            if (this.endOfStream) {
                this.processEndOfStream();
            }
            if (this.volumeFilterInput.volumeAvailable()) {
                this.processVolumeAvailable();
            }
            if (!this.recording.get() || bytesRead <= 0 || this.fileOutput == null) continue;
            this.fileOutput.write(buffer, 0, bytesRead);
        }
    }

    private void processVolumeAvailable() {
        this.volumeFilterInput.clearVolumeAvailable();
        double volume = this.volumeFilterInput.getVolume();
        this.volumeChanged(volume);
        if (this.recording.get()) {
            long amountRecordedMicroseconds = this.dataLine.getMicrosecondPosition() - this.recordingStartTime;
            double amountRecorded = (double)amountRecordedMicroseconds / 1000000.0;
            this.amountRecordedChanged(amountRecorded);
        }
    }

    private void processStartRecordingRequest() throws FileNotFoundException {
        this.startRecordingRequested = false;
        if (!this.recording.get()) {
            this.recording.set(true);
            this.dataLine.stop();
            this.dataLine.flush();
            this.createInputStreams();
            this.fileOutput = new FileOutputStream(this.file);
            this.recordingStartTime = this.dataLine.getMicrosecondPosition();
            this.startedRecording();
        }
    }

    private void processEndOfStream() throws IOException {
        if (this.stopRecordingRequested) {
            this.stopRecordingRequested = false;
            if (this.recording.get()) {
                if (this.fileOutput != null) {
                    this.fileOutput.close();
                }
                this.amountRecordedChanged(0.0);
                this.stoppedRecording();
                this.createInputStreams();
                this.recording.set(false);
            }
        }
    }

    private void createInputStreams() {
        AudioInputStream pcmInput = new AudioInputStream(this.dataLine);
        this.volumeFilterInput = new VolumeMonitorFilterInputStream(pcmInput);
        AudioInputStream volumeFilterAudioInput = new AudioInputStream(this.volumeFilterInput, this.inputFormat, -1L);
        this.encodedInput = JavaSoundHelper.getAudioInputStream(this.outputFormat, volumeFilterAudioInput);
        this.endOfStream = false;
        this.dataLine.start();
    }

    public final void killBlocking() {
        this.dataLine.stop();
        this.dataLine.flush();
        if (Thread.currentThread().equals(this)) {
            String message = "The killBlocking method must not be called on this thread as it will result in a deadlock";
            throw new IllegalStateException("The killBlocking method must not be called on this thread as it will result in a deadlock");
        }
        this.killed.blockUntil(true);
    }

    public abstract void startedRecording();

    public abstract void stoppedRecording();

    public abstract void startedMonitoringVolume();

    public abstract void stoppedMonitoringVolume();

    public abstract void volumeChanged(double var1);

    public abstract void amountRecordedChanged(double var1);

    public abstract void errorOccurred();
}

