/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.chaos.audiosystem.recorder.impl;

import com.thinkbuzan.chaos.audiosystem.AudioCodec;
import com.thinkbuzan.chaos.audiosystem.recorder.AudioRecorderException;
import com.thinkbuzan.chaos.audiosystem.recorder.AudioRecorderState;
import com.thinkbuzan.chaos.audiosystem.recorder.impl.AbstractAudioRecorder;
import com.thinkbuzan.chaos.audiosystem.recorder.impl.AbstractAudioRecorderThread;
import java.io.File;
import org.apache.log4j.Logger;

public class AudioRecorder
extends AbstractAudioRecorder {
    private static final transient Logger LOGGER = Logger.getLogger(AudioRecorder.class);
    private transient AbstractAudioRecorderThread thread;
    private final transient AudioCodec codec;

    public AudioRecorder(File file, AudioCodec codecIn) {
        super(file);
        this.codec = codecIn;
    }

    public synchronized void startMonitoringVolume() throws AudioRecorderException {
        this.checkState(AudioRecorderState.STOPPED);
        if (this.thread != null) {
            throw new IllegalStateException("Since state is STOPPED, expected thread to be null");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"entering startMonitoringVolume()");
        }
        this.setState(AudioRecorderState.TRANSITIONING);
        try {
            this.thread = new AudioRecorderThreadImpl(this, this.getFile(), this.codec);
        }
        catch (AudioRecorderException exception) {
            this.setState(AudioRecorderState.STOPPED);
            throw exception;
        }
        this.thread.start();
        this.thread.blockUntilMonitoringVolume();
    }

    public synchronized void stopMonitoringVolume() {
        this.checkState(AudioRecorderState.MONITORING_VOLUME);
        if (this.thread == null) {
            throw new IllegalStateException("Since state is MONITORING_VOLUME, expected thread to be not null");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"entering stopMonitoringVolume()");
        }
        this.setState(AudioRecorderState.TRANSITIONING);
        this.thread.killBlocking();
        this.thread = null;
    }

    public synchronized void startRecording() {
        this.checkState(AudioRecorderState.MONITORING_VOLUME);
        if (this.thread == null) {
            throw new IllegalStateException("Since state is MONITORING_VOLUME, expected thread to be not null");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"entering startRecording()");
        }
        this.setState(AudioRecorderState.TRANSITIONING);
        this.thread.startRecording();
    }

    public synchronized void stopRecording() {
        this.checkState(AudioRecorderState.RECORDING);
        this.setState(AudioRecorderState.TRANSITIONING);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"entering stopRecording()");
        }
        this.thread.stopRecording();
    }

    private void checkState(AudioRecorderState validState) {
        this.waitForValidState(validState);
        AudioRecorderState state = this.getState();
        if (state != validState) {
            String message = "Expected state to be %s but was %s";
            throw new IllegalStateException(String.format("Expected state to be %s but was %s", new Object[]{validState, state}));
        }
    }

    private void waitForValidState(AudioRecorderState validState) {
        AudioRecorderState state;
        long startTime = System.currentTimeMillis();
        long maximumWaitTime = 5000L;
        while ((state = this.getState()) != validState) {
            long now;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)String.format("state (%s) does not match validState (%s). Waiting...", new Object[]{state, validState}));
            }
            if ((now = System.currentTimeMillis()) - startTime > 5000L) {
                if (!LOGGER.isDebugEnabled()) break;
                LOGGER.debug((Object)"Waiting timed out");
                break;
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException exception) {
                LOGGER.error((Object)"Caught unexpected InterruptedException", (Throwable)exception);
            }
        }
    }

    private static class AudioRecorderThreadImpl
    extends AbstractAudioRecorderThread {
        private final transient AudioRecorder parent;

        public AudioRecorderThreadImpl(AudioRecorder parentIn, File file, AudioCodec codec) throws AudioRecorderException {
            super(file, codec);
            this.parent = parentIn;
        }

        public void volumeChanged(double volume) {
            this.parent.setVolume(volume);
        }

        public void amountRecordedChanged(double amountRecorded) {
            this.parent.setAmountRecorded(amountRecorded);
        }

        public void startedRecording() {
            this.parent.setState(AudioRecorderState.RECORDING);
        }

        public void stoppedRecording() {
            this.parent.setState(AudioRecorderState.MONITORING_VOLUME);
        }

        public void startedMonitoringVolume() {
            this.parent.setState(AudioRecorderState.MONITORING_VOLUME);
        }

        public void stoppedMonitoringVolume() {
            this.parent.setState(AudioRecorderState.STOPPED);
            this.parent.thread = null;
        }

        public void errorOccurred() {
            this.parent.fireErrorOccurred();
        }
    }
}

