/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.chaos.audiosystem.recorder.impl;

import java.io.FilterInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;

public final class VolumeMonitorFilterInputStream
extends FilterInputStream {
    private static final transient double SAMPLE_SIZE = 0.06666666666666667;
    private final transient AudioFormat format;
    private transient byte[] buffer;
    private final transient ByteBuffer volumeByteBuffer;
    private transient ByteBuffer pcmByteBuffer;
    private transient boolean volumeAvailable;
    private transient double volume;

    protected VolumeMonitorFilterInputStream(AudioInputStream pcmInput) {
        super(pcmInput);
        this.format = pcmInput.getFormat();
        if (!AudioFormat.Encoding.PCM_SIGNED.equals(this.format.getEncoding())) {
            String message = "Expected the audio format encoding to be PCM_SIGNED but was ";
            throw new IllegalArgumentException("Expected the audio format encoding to be PCM_SIGNED but was " + this.format.getEncoding());
        }
        int numberOfBytes = this.calculateNumberOfBytes();
        int bufferSize = 8192;
        this.buffer = new byte[8192];
        this.volumeByteBuffer = ByteBuffer.wrap(new byte[numberOfBytes]);
        this.pcmByteBuffer = ByteBuffer.wrap(this.buffer);
    }

    private int calculateNumberOfBytes() {
        int numberOfBitsInAByte = 8;
        int sampleSizeInBytes = this.format.getSampleSizeInBits() / 8;
        int numberOfBytes = (int)(0.06666666666666667 * (double)this.format.getSampleRate() * (double)sampleSizeInBytes * (double)this.format.getChannels());
        return numberOfBytes;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int bytesRead = super.read(b, off, len);
        if (bytesRead > this.buffer.length) {
            this.buffer = new byte[bytesRead];
            this.pcmByteBuffer = ByteBuffer.wrap(this.buffer);
        }
        System.arraycopy(b, off, this.buffer, 0, bytesRead);
        this.processVolume(this.volumeByteBuffer, this.pcmByteBuffer, bytesRead);
        return bytesRead;
    }

    private void processVolume(ByteBuffer volumeByteBuffer, ByteBuffer pcmByteBuffer, int bytesRead) {
        pcmByteBuffer.rewind();
        pcmByteBuffer.limit(bytesRead);
        while (pcmByteBuffer.hasRemaining()) {
            if (volumeByteBuffer.hasRemaining()) {
                int oldLimit = pcmByteBuffer.limit();
                int newLimit = Math.min(pcmByteBuffer.position() + volumeByteBuffer.remaining(), oldLimit);
                pcmByteBuffer.limit(newLimit);
                volumeByteBuffer.put(pcmByteBuffer);
                pcmByteBuffer.limit(oldLimit);
                continue;
            }
            volumeByteBuffer.flip();
            this.processBuffer(volumeByteBuffer.array());
            volumeByteBuffer.clear();
        }
    }

    private void processBuffer(byte[] buffer) {
        int sampleSizeInBytes = this.format.getSampleSizeInBits() / 8;
        int samples = buffer.length / sampleSizeInBytes;
        int maxSample = 0;
        byte[] sampleBytes = new byte[sampleSizeInBytes];
        for (int i = 0; i < samples; ++i) {
            int j;
            if (this.format.isBigEndian()) {
                for (j = 0; j < sampleSizeInBytes; ++j) {
                    sampleBytes[j] = buffer[i * sampleSizeInBytes + j];
                }
            } else {
                for (j = 0; j < sampleSizeInBytes; ++j) {
                    sampleBytes[j] = buffer[i * sampleSizeInBytes + (sampleSizeInBytes - 1 - j)];
                }
            }
            int sample = 0;
            for (int j2 = 0; j2 < sampleSizeInBytes; ++j2) {
                sample += sampleBytes[j2];
                if (j2 >= sampleSizeInBytes - 1) continue;
                sample <<= 8;
            }
            int absoluteSample = Math.abs(sample);
            maxSample = Math.max(maxSample, absoluteSample);
        }
        int maximumPossible = Short.MAX_VALUE;
        this.volume = (double)maxSample / 32767.0;
        this.volume = Math.max(0.0, this.volume);
        this.volume = Math.min(1.0, this.volume);
        this.volumeAvailable = true;
    }

    public boolean volumeAvailable() {
        return this.volumeAvailable;
    }

    public double getVolume() {
        return this.volume;
    }

    public void clearVolumeAvailable() {
        this.volumeAvailable = false;
    }
}

