/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.pascal.services.skins.impl;

import com.thinkbuzan.chaos.utilities.edtutilities.EDTUtilities;
import com.thinkbuzan.pascal.services.skins.ISkin;
import com.thinkbuzan.pascal.services.skins.ISkinChangedListener;
import com.thinkbuzan.pascal.services.skins.ISkinManager;
import com.thinkbuzan.pascal.services.skins.ISkinnable;
import com.thinkbuzan.pascal.services.skins.SkinProperty;
import com.thinkbuzan.pascal.services.skins.impl.SkinPropertyDefaults;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SkinManager
implements ISkinManager {
    private final transient ReentrantLock a;
    private final transient List<ISkinChangedListener> b;
    private final transient List<ISkinnable> c;
    private final transient List<ISkin> d;
    private transient ISkin e;
    public static int f;

    public SkinManager() {
        int n = f;
        this.a = new ReentrantLock();
        this.b = new CopyOnWriteArrayList<ISkinChangedListener>();
        this.c = new CopyOnWriteArrayList<ISkinnable>();
        this.d = new CopyOnWriteArrayList<ISkin>();
        if (SkinProperty.b) {
            f = ++n;
        }
    }

    @Override
    public void addSkinChangedListener(ISkinChangedListener iSkinChangedListener) {
        if (iSkinChangedListener != null) {
            this.b.add(iSkinChangedListener);
        }
    }

    @Override
    public void removeSkinChangedListener(ISkinChangedListener iSkinChangedListener) {
        if (iSkinChangedListener != null) {
            this.b.remove(iSkinChangedListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ISkin getSkin() {
        ISkin iSkin;
        this.a.lock();
        try {
            iSkin = this.e;
        }
        finally {
            this.a.unlock();
        }
        return iSkin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ISkin> getRegisteredSkins() {
        ArrayList<ISkin> arrayList = new ArrayList<ISkin>();
        this.a.lock();
        try {
            arrayList.addAll(this.d);
        }
        finally {
            this.a.unlock();
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSkin(ISkin iSkin) {
        if (iSkin != null) {
            this.a.lock();
            try {
                this.e = iSkin;
            }
            finally {
                this.a.unlock();
            }
            this.a(iSkin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void nextSkin() {
        this.a.lock();
        try {
            if (this.d.size() > 0) {
                int n = (this.d.indexOf(this.e) + 1) % this.d.size();
                this.setSkin(this.d.get(n));
            }
        }
        finally {
            this.a.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerSkin(ISkin iSkin) {
        if (iSkin != null) {
            this.a.lock();
            try {
                this.d.add(iSkin);
                if (this.e == null) {
                    this.setSkin(iSkin);
                }
            }
            finally {
                this.a.unlock();
            }
        }
    }

    @Override
    public void registerSkinnable(ISkinnable iSkinnable) {
        if (iSkinnable != null) {
            this.c.add(iSkinnable);
        }
    }

    private void a(final ISkin iSkin) {
        EDTUtilities.runOnEDT((Runnable)new Runnable(){

            public void run() {
                int n = f;
                ArrayList arrayList = new ArrayList(SkinManager.this.c);
                for (ISkinChangedListener[] iSkinChangedListenerArray : arrayList) {
                    SkinManager.this.skin((ISkinnable)iSkinChangedListenerArray, iSkin);
                    if (n == 0) continue;
                    SkinProperty.b = !SkinProperty.b;
                    break;
                }
                ISkinChangedListener[] iSkinChangedListenerArray = new ISkinChangedListener[SkinManager.this.b.size()];
                for (ISkinChangedListener iSkinChangedListener : iSkinChangedListenerArray = SkinManager.this.b.toArray(iSkinChangedListenerArray)) {
                    iSkinChangedListener.skinChanged(iSkin);
                    if (n == 0) continue;
                }
            }
        });
    }

    @Override
    public void skin(ISkinnable iSkinnable) {
        this.skin(iSkinnable, this.e);
    }

    @Override
    public void skin(ISkinnable iSkinnable, ISkin iSkin) {
        ISkin iSkin2;
        int n;
        block6: {
            block5: {
                n = f;
                if (iSkin != null) break block5;
                iSkin2 = this.e;
                if (n == 0) break block6;
            }
            iSkin2 = iSkin;
        }
        if (iSkinnable != null) {
            for (SkinProperty skinProperty : SkinProperty.values()) {
                iSkinnable.setProperty(skinProperty, this.a(iSkin2, skinProperty));
                if (n == 0) continue;
            }
        }
    }

    @Override
    public Object getCurrentValue(SkinProperty skinProperty) {
        return this.a(this.getSkin(), skinProperty);
    }

    private Object a(ISkin iSkin, SkinProperty skinProperty) {
        Object object = null;
        if (iSkin != null) {
            object = iSkin.getProperty(skinProperty);
        }
        if (object == null) {
            object = SkinPropertyDefaults.getInstance().getDefaultValue(skinProperty);
        }
        return object;
    }
}

