/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.phoenix.audiomodel.components.record;

import com.thinkbuzan.chaos.audiosystem.recorder.AudioRecorderState;
import com.thinkbuzan.chaos.utilities.edtutilities.EDTUtilities;
import com.thinkbuzan.phoenix.audiomodel.components.TimeComponent;
import com.thinkbuzan.phoenix.audiomodel.components.UIConstants;
import com.thinkbuzan.phoenix.audiomodel.components.record.MessagesComponent;
import com.thinkbuzan.phoenix.audiomodel.components.record.RecordButton;
import com.thinkbuzan.phoenix.audiomodel.components.record.VolumeComponent;
import com.thinkbuzan.phoenix.audiomodel.controller.IAudioNotesController;
import com.thinkbuzan.phoenix.audiomodel.controller.IAudioNotesRecordListener;
import com.thinkbuzan.phoenix.audiomodel.controller.IRecordController;
import com.thinkbuzan.phoenix.audiomodel.resources.Resources;
import com.thinkbuzan.phoenix.audiomodel.util.ServiceManager;
import com.thinkbuzan.phoenix.audiomodel.validate.Validate;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;

public final class RecordPanel
extends JPanel {
    private static final transient long serialVersionUID = -2423782555572099552L;
    private static final transient Color a;
    private static final transient Color b;
    private static final transient Color c;
    private final transient TimeComponent d;
    private final transient RecordButton e;
    private final transient VolumeComponent f;
    private final transient MessagesComponent g;
    private final transient JButton h;
    private final transient String i;
    private transient JButton j;
    public static boolean k;
    private static final String[] z;

    public RecordPanel(IAudioNotesController iAudioNotesController) {
        boolean bl = k;
        Validate.notNull(iAudioNotesController, z[0]);
        this.setLayout(null);
        this.d = new TimeComponent(UIConstants.RECORD_BUTTON_FONT);
        this.d.setBackgroundImage(Resources.getImage(z[2]));
        this.e = new RecordButton();
        this.f = new VolumeComponent();
        this.g = new MessagesComponent();
        this.h = new JButton(new ImageIcon(Resources.getImage(z[3])));
        this.h.setVisible(false);
        this.h.setContentAreaFilled(false);
        this.h.setBorderPainted(false);
        this.h.setFocusable(false);
        this.h.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        IRecordController iRecordController = iAudioNotesController.getRecordController();
        iRecordController.addListener(this.b(iRecordController));
        this.a(iRecordController);
        if (this.j != null) {
            this.add(this.j);
        }
        this.add(this.h);
        this.add(this.g);
        this.add(this.d);
        this.add(this.e);
        this.add(this.f);
        this.i = ServiceManager.getI18nNotNull().getLocalizedText(z[1]);
        if (Validate.a) {
            k = !bl;
        }
    }

    public void setMoreButton(JButton jButton) {
        if (this.j != null) {
            this.remove(this.j);
        }
        this.j = jButton;
        if (this.j != null) {
            this.add((Component)this.j, 0);
        }
        this.revalidate();
    }

    public void setCloseButtonVisible(boolean bl) {
        this.h.setVisible(bl);
        this.revalidate();
    }

    public void addCloseButtonActionListener(ActionListener actionListener) {
        this.h.addActionListener(actionListener);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.e.setEnabled(bl);
        this.d.setEnabled(bl);
        this.f.setEnabled(bl);
    }

    private void a(final IRecordController iRecordController) {
        Validate.notNull(iRecordController, z[4]);
        this.e.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                block5: {
                    block4: {
                        if (iRecordController.getState() != AudioRecorderState.MONITORING_VOLUME) break block4;
                        iRecordController.startRecording();
                        if (!k) break block5;
                    }
                    if (iRecordController.getState() == AudioRecorderState.RECORDING) {
                        iRecordController.stopRecordingAndSave();
                    }
                }
            }
        });
    }

    private IAudioNotesRecordListener b(final IRecordController iRecordController) {
        return new IAudioNotesRecordListener(){
            private transient AudioRecorderState a;
            {
                this.a = iRecordController.getState();
            }

            public void volumeChanged(final double d) {
                EDTUtilities.runOnEDT((Runnable)new Runnable(){

                    public void run() {
                        RecordPanel.this.f.setVolume(d);
                    }
                });
            }

            public void stateChanged(final AudioRecorderState audioRecorderState) {
                EDTUtilities.runOnEDT((Runnable)new Runnable(){

                    public void run() {
                        block6: {
                            block8: {
                                boolean bl;
                                block7: {
                                    block5: {
                                        bl = k;
                                        if (audioRecorderState != AudioRecorderState.STOPPED) break block5;
                                        RecordPanel.this.e.setEnabled(false);
                                        if (!bl) break block6;
                                    }
                                    if (audioRecorderState != AudioRecorderState.MONITORING_VOLUME) break block7;
                                    RecordPanel.this.e.setDrawDisabled(true);
                                    RecordPanel.this.e.setEnabled(RecordPanel.this.isEnabled());
                                    RecordPanel.this.e.setRecording(false);
                                    if (!bl) break block6;
                                }
                                if (audioRecorderState != AudioRecorderState.RECORDING) break block8;
                                RecordPanel.this.e.setDrawDisabled(true);
                                RecordPanel.this.e.setEnabled(RecordPanel.this.isEnabled());
                                RecordPanel.this.e.setRecording(true);
                                if (!bl) break block6;
                            }
                            if (audioRecorderState == AudioRecorderState.TRANSITIONING) {
                                if (a == AudioRecorderState.MONITORING_VOLUME) {
                                    RecordPanel.this.e.setDrawDisabled(false);
                                }
                                RecordPanel.this.e.setEnabled(false);
                            }
                        }
                        a = audioRecorderState;
                    }
                });
            }

            public void amountRecordedChanged(final double d) {
                EDTUtilities.runOnEDT((Runnable)new Runnable(){

                    public void run() {
                        RecordPanel.this.d.setTime(d);
                    }
                });
            }

            public void errorOccurred() {
                RecordPanel.this.setShowNoInputDeviceMessage(true);
            }
        };
    }

    public void doLayout() {
        boolean bl = k;
        Dimension dimension = this.e.getPreferredSize();
        int n = (this.getWidth() - dimension.width) / 2;
        int n2 = 24;
        int n3 = dimension.width;
        int n4 = dimension.height;
        this.e.setBounds(n, n2, n3, n4);
        n2 = 87;
        dimension = this.f.getPreferredSize();
        n3 = dimension.width;
        n4 = dimension.height;
        this.f.setBounds(n, n2, n3, n4);
        n2 = 87;
        dimension = this.d.getPreferredSize();
        n3 = dimension.width;
        n4 = dimension.height;
        this.d.setBounds(n += 120, n2, n3, n4);
        dimension = this.g.getPreferredSize();
        int n5 = 87 + n4 + 24;
        n2 = Math.max(0, (n5 - dimension.height) / 2);
        n = 0;
        n3 = this.getWidth();
        n4 = dimension.height;
        this.g.setBounds(n, n2, n3, n4);
        dimension = this.h.getPreferredSize();
        n = this.getWidth() - dimension.width;
        n2 = 0;
        n3 = dimension.width;
        n4 = dimension.height;
        this.h.setBounds(n, n2, n3, n4);
        if (this.j != null) {
            dimension = this.j.getPreferredSize();
            n = this.getWidth() - dimension.width;
            n2 = this.getHeight() - dimension.height;
            n3 = dimension.width;
            n4 = dimension.height;
            this.j.setBounds(n, n2, n3, n4);
        }
        if (bl) {
            Validate.a = !Validate.a;
        }
    }

    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, a, 0.0f, this.getHeight(), b);
        graphics2D.setPaint(gradientPaint);
        graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        gradientPaint = new GradientPaint(0.0f, 0.0f, c, 0.0f, 10.0f, a);
        graphics2D.setPaint(gradientPaint);
        graphics2D.fillRect(0, 0, this.getWidth(), 10);
        graphics2D.dispose();
    }

    public TimeComponent getTimeComponent() {
        return this.d;
    }

    public RecordButton getRecordButton() {
        return this.e;
    }

    public VolumeComponent getVolumeComponent() {
        return this.f;
    }

    public void addMessage(String string) {
        this.g.addMessage(string);
        this.validate();
    }

    public void removeMessage(String string) {
        this.g.removeMessage(string);
        this.validate();
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.g.setWidth(n3);
        super.setBounds(n, n2, n3, n4);
    }

    public Dimension getPreferredSize() {
        int n = 135 + this.f.getPreferredSize().height;
        Dimension dimension = new Dimension(248, n);
        Dimension dimension2 = this.g.getPreferredSize();
        dimension.height = Math.max(dimension.height, dimension2.height);
        return dimension;
    }

    public void setShowNoInputDeviceMessage(boolean bl) {
        block3: {
            block2: {
                if (!bl) break block2;
                this.addMessage(this.i);
                if (!k) break block3;
            }
            this.removeMessage(this.i);
        }
        this.validate();
    }

    static {
        String[] stringArray = new String[5];
        Object var0 = null;
        stringArray[0] = RecordPanel.z(RecordPanel.z("K.ArTG-CcT"));
        var0 = null;
        stringArray[1] = RecordPanel.z(RecordPanel.z("K.B(R@(AmD];Nh\bAp\u0017h\bI4KoIF.[cU\u0006/@OHX4[BC^(Lc"));
        var0 = null;
        stringArray[2] = RecordPanel.z(RecordPanel.z("\\(BcTw#H(VF&"));
        var0 = null;
        stringArray[3] = RecordPanel.z(RecordPanel.z("K-@uC\u00061Aa"));
        var0 = null;
        stringArray[4] = RecordPanel.z(RecordPanel.z("Z$LiTL\u0002@hRZ.CjCZ"));
        z = stringArray;
        var0 = null;
        a = Color.decode(RecordPanel.z(RecordPanel.z("\u000bv\u001b1\u001e\u001f\u0003")));
        var0 = null;
        b = Color.decode(RecordPanel.z(RecordPanel.z("\u000bt\u001e3\u0015\u001du")));
        var0 = null;
        c = Color.decode(RecordPanel.z(RecordPanel.z("\u000bw\u001d0\u0013\u001ev")));
    }

    private static char[] z(String string) {
        char[] cArray;
        block1: {
            int n;
            char[] cArray2 = string.toCharArray();
            char[] cArray3 = cArray2;
            char[] cArray4 = cArray2;
            do {
                int n2 = cArray3.length;
                cArray = cArray4;
                n = n2;
                if (n2 >= 2) break block1;
                cArray4 = cArray;
                cArray3 = cArray;
            } while (n == 0);
            cArray = cArray4;
            n = 0;
            cArray3[0] = (char)(cArray3[0] ^ 0x26);
        }
        return cArray;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    private static String z(char[] cArray) {
        char[] cArray2;
        block10: {
            int n;
            int n2;
            char[] cArray3;
            int n3;
            block9: {
                n3 = 0;
                int n4 = cArray.length;
                cArray3 = cArray;
                n2 = n4;
                if (n4 <= 1) break block9;
                cArray2 = cArray3;
                n = n2;
                if (n2 <= n3) break block10;
            }
            do {
                char[] cArray4 = cArray3;
                char[] cArray5 = cArray3;
                int n5 = n3;
                while (true) {
                    int n6;
                    char c = cArray4[n5];
                    switch (n3 % 5) {
                        case 0: {
                            n6 = 40;
                            break;
                        }
                        case 1: {
                            n6 = 65;
                            break;
                        }
                        case 2: {
                            n6 = 47;
                            break;
                        }
                        case 3: {
                            n6 = 6;
                            break;
                        }
                        default: {
                            n6 = 38;
                        }
                    }
                    cArray4[n5] = (char)(c ^ n6);
                    ++n3;
                    cArray3 = cArray5;
                    n2 = n2;
                    if (n2 != 0) break;
                    cArray5 = cArray3;
                    n = n2;
                    n5 = n2;
                    cArray4 = cArray3;
                }
                cArray2 = cArray3;
                n = n2;
            } while (n2 > n3);
        }
        return new String(cArray2).intern();
    }
}

