/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.phoenix.audiomodel.controller.impl;

import com.thinkbuzan.chaos.audiosystem.AudioCodec;
import com.thinkbuzan.chaos.audiosystem.AudioFactory;
import com.thinkbuzan.chaos.audiosystem.player.AudioPlayerException;
import com.thinkbuzan.chaos.audiosystem.player.AudioPlayerState;
import com.thinkbuzan.chaos.audiosystem.player.IAudioPlayer;
import com.thinkbuzan.chaos.audiosystem.player.IAudioPlayerListener;
import com.thinkbuzan.phoenix.audiomodel.controller.IAudioNotesController;
import com.thinkbuzan.phoenix.audiomodel.controller.IAudioNotesPlayListener;
import com.thinkbuzan.phoenix.audiomodel.controller.IPlayController;
import com.thinkbuzan.phoenix.audiomodel.model.IAudioNote;
import com.thinkbuzan.phoenix.audiomodel.model.IAudioNoteList;
import com.thinkbuzan.phoenix.audiomodel.model.ModelAdapter;
import com.thinkbuzan.phoenix.audiomodel.util.ServiceManager;
import com.thinkbuzan.phoenix.audiomodel.validate.Validate;
import java.io.File;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.log4j.Logger;

public final class PlayController
implements IPlayController {
    private static final transient Logger a;
    private transient IAudioPlayer b;
    private transient IAudioNote c;
    private final transient List<IAudioNotesPlayListener> d;
    public static int e;
    private static final String[] z;

    public PlayController(IAudioNotesController iAudioNotesController) {
        Validate.notNull(iAudioNotesController, z[0]);
        iAudioNotesController.getModel().addListener(new ModelAdapter(){

            @Override
            public void audioNoteRemoved(IAudioNote iAudioNote) {
                if (iAudioNote.equals(PlayController.this.c)) {
                    PlayController.this.setActiveAudioNote(null);
                }
            }

            @Override
            public void audioNoteListsChanged(List<IAudioNoteList> list) {
                PlayController.this.setActiveAudioNote(null);
            }
        });
        this.d = new CopyOnWriteArrayList<IAudioNotesPlayListener>();
    }

    public void setActiveAudioNote(IAudioNote iAudioNote) {
        if (iAudioNote == null && this.c == null) {
            return;
        }
        if (iAudioNote != null && iAudioNote.equals(this.c)) {
            return;
        }
        if (this.c != null && this.b != null && !AudioPlayerState.STOPPED.equals((Object)this.b.getState())) {
            this.b.stop();
            this.b = null;
        }
        this.c = iAudioNote;
        this.a();
    }

    private void a() {
        int n = e;
        for (IAudioNotesPlayListener iAudioNotesPlayListener : this.d) {
            iAudioNotesPlayListener.activeAudioNoteChanged(this.c);
            if (n == 0) continue;
        }
    }

    public IAudioNote getActiveAudioNote() {
        return this.c;
    }

    public void play() throws AudioPlayerException {
        if (this.b == null) {
            File file = this.c.getFile();
            AudioFactory audioFactory = ServiceManager.getAudioFactoryNotNull();
            AudioCodec audioCodec = this.c.getCodec();
            this.b = audioFactory.createAudioPlayer(file, audioCodec);
            this.b.addListener(new IAudioPlayerListener(){

                public void stateChanged(AudioPlayerState audioPlayerState) {
                    int n = e;
                    for (IAudioNotesPlayListener iAudioNotesPlayListener : PlayController.this.d) {
                        iAudioNotesPlayListener.stateChanged(audioPlayerState);
                        if (n == 0) continue;
                    }
                    if (audioPlayerState == AudioPlayerState.STOPPED) {
                        PlayController.this.b = null;
                        PlayController.this.setActiveAudioNote(null);
                    }
                }

                public void positionChanged(double d) {
                    int n = e;
                    for (IAudioNotesPlayListener iAudioNotesPlayListener : PlayController.this.d) {
                        iAudioNotesPlayListener.positionChanged(d);
                        if (n == 0) continue;
                    }
                }
            });
        }
        this.b.play();
    }

    public void pause() {
        if (this.b == null) {
            a.error((Object)z[1]);
            return;
        }
        this.b.pause();
    }

    public void stop() {
        if (this.b == null) {
            a.error((Object)z[1]);
            return;
        }
        this.b.stop();
    }

    public void setPosition(double d) {
        if (this.b == null) {
            a.error((Object)z[1]);
            return;
        }
        this.b.seek(d);
    }

    public double getPosition() {
        if (this.b == null) {
            return 0.0;
        }
        return this.b.getPosition();
    }

    public AudioPlayerState getState() {
        if (this.b == null) {
            return AudioPlayerState.STOPPED;
        }
        return this.b.getState();
    }

    public void addListener(IAudioNotesPlayListener iAudioNotesPlayListener) {
        this.d.add(iAudioNotesPlayListener);
    }

    public void removeListener(IAudioNotesPlayListener iAudioNotesPlayListener) {
        this.d.remove(iAudioNotesPlayListener);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        String[] stringArray;
        block21: {
            int n;
            int n2;
            char[] cArray2;
            int n3;
            block20: {
                char[] cArray3;
                Object var0;
                block19: {
                    int n4;
                    int n5;
                    char[] cArray4;
                    block18: {
                        stringArray = new String[2];
                        var0 = null;
                        char[] cArray5 = "qWL/\u000e}TN>\u000e".toCharArray();
                        n3 = 0;
                        int n6 = cArray5.length;
                        cArray4 = cArray5;
                        n5 = n6;
                        if (n6 <= 1) break block18;
                        cArray3 = cArray4;
                        n4 = n5;
                        if (n5 <= n3) break block19;
                    }
                    do {
                        char[] cArray6 = cArray4;
                        char[] cArray7 = cArray4;
                        int n7 = n3;
                        while (true) {
                            int n8;
                            char c = cArray6[n7];
                            switch (n3 % 5) {
                                case 0: {
                                    n8 = 18;
                                    break;
                                }
                                case 1: {
                                    n8 = 56;
                                    break;
                                }
                                case 2: {
                                    n8 = 34;
                                    break;
                                }
                                case 3: {
                                    n8 = 91;
                                    break;
                                }
                                default: {
                                    n8 = 124;
                                }
                            }
                            cArray6[n7] = (char)(c ^ n8);
                            ++n3;
                            cArray4 = cArray7;
                            n5 = n5;
                            if (n5 != 0) break;
                            cArray7 = cArray4;
                            n4 = n5;
                            n7 = n5;
                            cArray6 = cArray4;
                        }
                        cArray3 = cArray4;
                        n4 = n5;
                    } while (n5 > n3);
                }
                stringArray[0] = new String(cArray3).intern();
                var0 = null;
                char[] cArray8 = "VQF{\u0012}L\u0002>\u0004b]A/\\bTC\"\u0019`\u0018V4\\p]\u00025\t~T".toCharArray();
                n3 = 0;
                int n9 = cArray8.length;
                cArray2 = cArray8;
                n2 = n9;
                if (n9 <= 1) break block20;
                cArray = cArray2;
                n = n2;
                if (n2 <= n3) break block21;
            }
            do {
                char[] cArray9 = cArray2;
                char[] cArray10 = cArray2;
                int n10 = n3;
                while (true) {
                    int n11;
                    char c = cArray9[n10];
                    switch (n3 % 5) {
                        case 0: {
                            n11 = 18;
                            break;
                        }
                        case 1: {
                            n11 = 56;
                            break;
                        }
                        case 2: {
                            n11 = 34;
                            break;
                        }
                        case 3: {
                            n11 = 91;
                            break;
                        }
                        default: {
                            n11 = 124;
                        }
                    }
                    cArray9[n10] = (char)(c ^ n11);
                    ++n3;
                    cArray2 = cArray10;
                    n2 = n2;
                    if (n2 != 0) break;
                    cArray10 = cArray2;
                    n = n2;
                    n10 = n2;
                    cArray9 = cArray2;
                }
                cArray = cArray2;
                n = n2;
            } while (n2 > n3);
        }
        stringArray[1] = new String(cArray).intern();
        z = stringArray;
        a = Logger.getLogger(PlayController.class);
    }
}

