/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.phoenix.audiomodel.controller.impl;

import com.thinkbuzan.chaos.audiosystem.AudioCodec;
import com.thinkbuzan.chaos.audiosystem.AudioFactory;
import com.thinkbuzan.chaos.audiosystem.IAudioTools;
import com.thinkbuzan.chaos.audiosystem.recorder.AudioRecorderException;
import com.thinkbuzan.chaos.audiosystem.recorder.AudioRecorderState;
import com.thinkbuzan.chaos.audiosystem.recorder.IAudioRecorder;
import com.thinkbuzan.chaos.audiosystem.recorder.IAudioRecorderListener;
import com.thinkbuzan.phoenix.audiomodel.controller.IAudioNotesController;
import com.thinkbuzan.phoenix.audiomodel.controller.IAudioNotesRecordListener;
import com.thinkbuzan.phoenix.audiomodel.controller.IRecordController;
import com.thinkbuzan.phoenix.audiomodel.controller.impl.PlayController;
import com.thinkbuzan.phoenix.audiomodel.model.IAudioNote;
import com.thinkbuzan.phoenix.audiomodel.model.IAudioNoteList;
import com.thinkbuzan.phoenix.audiomodel.model.impl.AudioNote;
import com.thinkbuzan.phoenix.audiomodel.util.ServiceManager;
import com.thinkbuzan.phoenix.audiomodel.util.TemporaryFilesHelper;
import com.thinkbuzan.phoenix.audiomodel.validate.Validate;
import java.io.File;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.log4j.Logger;

public final class RecordController
implements IRecordController {
    private static final transient Logger a;
    private final transient IAudioRecorder b;
    private final transient File c;
    private final transient IAudioNotesController d;
    private final transient List<IAudioNotesRecordListener> e;
    private final transient IAudioTools f;
    private final transient String g;
    private static final String[] z;

    public RecordController(IAudioNotesController iAudioNotesController) {
        int n = PlayController.e;
        this.e = new CopyOnWriteArrayList<IAudioNotesRecordListener>();
        Validate.notNull(iAudioNotesController, z[1]);
        this.d = iAudioNotesController;
        this.g = ServiceManager.getI18nNotNull().getLocalizedText(z[2]);
        this.c = new File(System.getProperty(z[0]), UUID.randomUUID().toString());
        TemporaryFilesHelper.getInstance().addTemporaryFile(this.c);
        AudioFactory audioFactory = ServiceManager.getAudioFactoryNotNull();
        this.f = audioFactory.createAudioTools();
        this.b = audioFactory.createAudioRecorder(this.c, AudioCodec.GSM);
        this.b.addListener(this.a());
        if (n != 0) {
            Validate.a = !Validate.a;
        }
    }

    private IAudioRecorderListener a() {
        return new IAudioRecorderListener(){

            public void volumeChanged(double d) {
                int n = PlayController.e;
                for (IAudioNotesRecordListener iAudioNotesRecordListener : RecordController.this.e) {
                    iAudioNotesRecordListener.volumeChanged(d);
                    if (n == 0) continue;
                }
            }

            public void stateChanged(AudioRecorderState audioRecorderState) {
                int n = PlayController.e;
                for (IAudioNotesRecordListener iAudioNotesRecordListener : RecordController.this.e) {
                    iAudioNotesRecordListener.stateChanged(audioRecorderState);
                    if (n == 0) continue;
                }
            }

            public void amountRecordedChanged(double d) {
                int n = PlayController.e;
                for (IAudioNotesRecordListener iAudioNotesRecordListener : RecordController.this.e) {
                    iAudioNotesRecordListener.amountRecordedChanged(d);
                    if (n == 0) continue;
                }
            }

            public void errorOccurred() {
                int n = PlayController.e;
                for (IAudioNotesRecordListener iAudioNotesRecordListener : RecordController.this.e) {
                    iAudioNotesRecordListener.errorOccurred();
                    if (n == 0) continue;
                }
            }
        };
    }

    public void startRecording() {
        try {
            this.b.startMonitoringVolume();
            this.b.startRecording();
        }
        catch (AudioRecorderException audioRecorderException) {
            audioRecorderException.printStackTrace();
        }
    }

    public void stopRecordingAndSave() {
        IAudioNote iAudioNote = this.stopRecordingAndReturn();
        List<IAudioNoteList> list = this.d.getModel().getAudioNoteLists();
        if (list.size() < 1) {
            a.error((Object)z[4]);
            return;
        }
        IAudioNoteList iAudioNoteList = list.get(0);
        this.d.addAudioNote(iAudioNote, iAudioNoteList, this.c);
    }

    public IAudioNote stopRecordingAndReturn() {
        int n = PlayController.e;
        this.b.stopRecording();
        this.b.stopMonitoringVolume();
        AudioNote audioNote = new AudioNote(UUID.randomUUID());
        audioNote.setName(this.g);
        audioNote.setCodec(AudioCodec.GSM);
        audioNote.setDuration(this.f.calculateDuration(this.c, AudioCodec.GSM));
        if (Validate.a) {
            PlayController.e = ++n;
        }
        return audioNote;
    }

    public double getVolume() {
        return this.b.getVolume();
    }

    public AudioRecorderState getState() {
        return this.b.getState();
    }

    public void addListener(IAudioNotesRecordListener iAudioNotesRecordListener) {
        Validate.notNull(iAudioNotesRecordListener, z[3]);
        this.e.add(iAudioNotesRecordListener);
    }

    public void removeListener(IAudioNotesRecordListener iAudioNotesRecordListener) {
        Validate.notNull(iAudioNotesRecordListener, z[3]);
        this.e.remove(iAudioNotesRecordListener);
    }

    public void startMonitoringVolume() throws AudioRecorderException {
        this.b.startMonitoringVolume();
    }

    public void stopMonitoringVolume() {
        this.b.stopMonitoringVolume();
    }

    public double getAmountRecorded() {
        return this.b.getAmountRecorded();
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        String[] stringArray;
        block54: {
            int n;
            int n2;
            char[] cArray2;
            int n3;
            block53: {
                char[] cArray3;
                Object var0;
                block52: {
                    int n4;
                    int n5;
                    char[] cArray4;
                    block51: {
                        char[] cArray5;
                        block50: {
                            int n6;
                            int n7;
                            char[] cArray6;
                            block49: {
                                char[] cArray7;
                                block48: {
                                    int n8;
                                    int n9;
                                    char[] cArray8;
                                    block47: {
                                        char[] cArray9;
                                        block46: {
                                            int n10;
                                            int n11;
                                            char[] cArray10;
                                            block45: {
                                                stringArray = new String[5];
                                                var0 = null;
                                                char[] cArray11 = "*\u0013KX\u001f)\u001d\u0013M\\0\u0016TK".toCharArray();
                                                n3 = 0;
                                                int n12 = cArray11.length;
                                                cArray10 = cArray11;
                                                n11 = n12;
                                                if (n12 <= 1) break block45;
                                                cArray9 = cArray10;
                                                n10 = n11;
                                                if (n11 <= n3) break block46;
                                            }
                                            do {
                                                char[] cArray12 = cArray10;
                                                char[] cArray13 = cArray10;
                                                int n13 = n3;
                                                while (true) {
                                                    int n14;
                                                    char c = cArray12[n13];
                                                    switch (n3 % 5) {
                                                        case 0: {
                                                            n14 = 64;
                                                            break;
                                                        }
                                                        case 1: {
                                                            n14 = 114;
                                                            break;
                                                        }
                                                        case 2: {
                                                            n14 = 61;
                                                            break;
                                                        }
                                                        case 3: {
                                                            n14 = 57;
                                                            break;
                                                        }
                                                        default: {
                                                            n14 = 49;
                                                        }
                                                    }
                                                    cArray12[n13] = (char)(c ^ n14);
                                                    ++n3;
                                                    cArray10 = cArray13;
                                                    n11 = n11;
                                                    if (n11 != 0) break;
                                                    cArray13 = cArray10;
                                                    n10 = n11;
                                                    n13 = n11;
                                                    cArray12 = cArray10;
                                                }
                                                cArray9 = cArray10;
                                                n10 = n11;
                                            } while (n11 > n3);
                                        }
                                        stringArray[0] = new String(cArray9).intern();
                                        var0 = null;
                                        char[] cArray14 = "#\u001dSMC/\u001eQ\\C\t\u001c".toCharArray();
                                        n3 = 0;
                                        int n15 = cArray14.length;
                                        cArray8 = cArray14;
                                        n9 = n15;
                                        if (n15 <= 1) break block47;
                                        cArray7 = cArray8;
                                        n8 = n9;
                                        if (n9 <= n3) break block48;
                                    }
                                    do {
                                        char[] cArray15 = cArray8;
                                        char[] cArray16 = cArray8;
                                        int n16 = n3;
                                        while (true) {
                                            int n17;
                                            char c = cArray15[n16];
                                            switch (n3 % 5) {
                                                case 0: {
                                                    n17 = 64;
                                                    break;
                                                }
                                                case 1: {
                                                    n17 = 114;
                                                    break;
                                                }
                                                case 2: {
                                                    n17 = 61;
                                                    break;
                                                }
                                                case 3: {
                                                    n17 = 57;
                                                    break;
                                                }
                                                default: {
                                                    n17 = 49;
                                                }
                                            }
                                            cArray15[n16] = (char)(c ^ n17);
                                            ++n3;
                                            cArray8 = cArray16;
                                            n9 = n9;
                                            if (n9 != 0) break;
                                            cArray16 = cArray8;
                                            n8 = n9;
                                            n16 = n9;
                                            cArray15 = cArray8;
                                        }
                                        cArray7 = cArray8;
                                        n8 = n9;
                                    } while (n9 > n3);
                                }
                                stringArray[1] = new String(cArray7).intern();
                                var0 = null;
                                char[] cArray17 = "#\u001dP\u0017E(\u001bSRS5\b\\W\u001f)C\u0005W\u001f!\u0007YP^.\u001dI\\Bn\u001cXNp5\u0016TV\u007f/\u0006X".toCharArray();
                                n3 = 0;
                                int n18 = cArray17.length;
                                cArray6 = cArray17;
                                n7 = n18;
                                if (n18 <= 1) break block49;
                                cArray5 = cArray6;
                                n6 = n7;
                                if (n7 <= n3) break block50;
                            }
                            do {
                                char[] cArray18 = cArray6;
                                char[] cArray19 = cArray6;
                                int n19 = n3;
                                while (true) {
                                    int n20;
                                    char c = cArray18[n19];
                                    switch (n3 % 5) {
                                        case 0: {
                                            n20 = 64;
                                            break;
                                        }
                                        case 1: {
                                            n20 = 114;
                                            break;
                                        }
                                        case 2: {
                                            n20 = 61;
                                            break;
                                        }
                                        case 3: {
                                            n20 = 57;
                                            break;
                                        }
                                        default: {
                                            n20 = 49;
                                        }
                                    }
                                    cArray18[n19] = (char)(c ^ n20);
                                    ++n3;
                                    cArray6 = cArray19;
                                    n7 = n7;
                                    if (n7 != 0) break;
                                    cArray19 = cArray6;
                                    n6 = n7;
                                    n19 = n7;
                                    cArray18 = cArray6;
                                }
                                cArray5 = cArray6;
                                n6 = n7;
                            } while (n7 > n3);
                        }
                        stringArray[2] = new String(cArray5).intern();
                        var0 = null;
                        char[] cArray20 = ",\u001bNMT.\u0017O".toCharArray();
                        n3 = 0;
                        int n21 = cArray20.length;
                        cArray4 = cArray20;
                        n5 = n21;
                        if (n21 <= 1) break block51;
                        cArray3 = cArray4;
                        n4 = n5;
                        if (n5 <= n3) break block52;
                    }
                    do {
                        char[] cArray21 = cArray4;
                        char[] cArray22 = cArray4;
                        int n22 = n3;
                        while (true) {
                            int n23;
                            char c = cArray21[n22];
                            switch (n3 % 5) {
                                case 0: {
                                    n23 = 64;
                                    break;
                                }
                                case 1: {
                                    n23 = 114;
                                    break;
                                }
                                case 2: {
                                    n23 = 61;
                                    break;
                                }
                                case 3: {
                                    n23 = 57;
                                    break;
                                }
                                default: {
                                    n23 = 49;
                                }
                            }
                            cArray21[n22] = (char)(c ^ n23);
                            ++n3;
                            cArray4 = cArray22;
                            n5 = n5;
                            if (n5 != 0) break;
                            cArray22 = cArray4;
                            n4 = n5;
                            n22 = n5;
                            cArray21 = cArray4;
                        }
                        cArray3 = cArray4;
                        n4 = n5;
                    } while (n5 > n3);
                }
                stringArray[3] = new String(cArray3).intern();
                var0 = null;
                char[] cArray23 = "\u0004\u001bY\u0019_/\u0006\u001d\\I0\u0017^M\u0011,\u001bNMBn\u0001TCTh[\u001dM^`\u0010X\u0019]%\u0001N\u0019E(\u0013S\u0019\u0000".toCharArray();
                n3 = 0;
                int n24 = cArray23.length;
                cArray2 = cArray23;
                n2 = n24;
                if (n24 <= 1) break block53;
                cArray = cArray2;
                n = n2;
                if (n2 <= n3) break block54;
            }
            do {
                char[] cArray24 = cArray2;
                char[] cArray25 = cArray2;
                int n25 = n3;
                while (true) {
                    int n26;
                    char c = cArray24[n25];
                    switch (n3 % 5) {
                        case 0: {
                            n26 = 64;
                            break;
                        }
                        case 1: {
                            n26 = 114;
                            break;
                        }
                        case 2: {
                            n26 = 61;
                            break;
                        }
                        case 3: {
                            n26 = 57;
                            break;
                        }
                        default: {
                            n26 = 49;
                        }
                    }
                    cArray24[n25] = (char)(c ^ n26);
                    ++n3;
                    cArray2 = cArray25;
                    n2 = n2;
                    if (n2 != 0) break;
                    cArray25 = cArray2;
                    n = n2;
                    n25 = n2;
                    cArray24 = cArray2;
                }
                cArray = cArray2;
                n = n2;
            } while (n2 > n3);
        }
        stringArray[4] = new String(cArray).intern();
        z = stringArray;
        a = Logger.getLogger(RecordController.class);
    }
}

