/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.dozer.sidepanels.tags;

import com.buzanonline.chaos.fileaccessservice.FileAccessService;
import com.jidesoft.utils.SystemInfo;
import com.thinkbuzan.chaos.osgiutilities.service.OSGiService;
import com.thinkbuzan.dozer.sidepanels.tags.license.BundleLicenser;
import com.thinkbuzan.dozer.sidepanels.tags.listeners.CategoriesChangedListener;
import com.thinkbuzan.dozer.sidepanels.tags.listeners.TagsChangedListener;
import com.thinkbuzan.dozer.sidepanels.tags.listeners.TagsObjectUpdatedListener;
import com.thinkbuzan.dozer.sidepanels.tags.model.TagsModel;
import com.thinkbuzan.dozer.sidepanels.tags.xml.TagResourcesManager;
import com.thinkbuzan.dozer.sidepanels.tags.xml.TagXMLCodec;
import com.thinkbuzan.dozer.sidepanels.tags.xml.TagXMLLoader;
import com.thinkbuzan.gaia.entities.Category;
import com.thinkbuzan.gaia.entities.Tag;
import com.thinkbuzan.gaia.entities.TagsObject;
import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;
import org.osgi.framework.BundleContext;

public class TagManager {
    private static final Logger LOGGER = Logger.getLogger(TagManager.class);
    private static final String CURRENT_VERSION = "10";
    private static final transient String TAG_PATH = "tags";
    private static final transient String TAG_XML = "tags.xml";
    private static final int WRITE_ATTEMPTS = 2;
    private final transient TagXMLCodec tagsCodec = new TagXMLCodec();
    private final transient File tagFile;
    private final transient TagsModel model;

    public TagManager(BundleContext bundleContext, BundleLicenser bundleLicenser, TagsModel tagsModel) {
        File file;
        OSGiService oSGiService = new OSGiService(bundleContext, FileAccessService.class);
        FileAccessService fileAccessService = (FileAccessService)oSGiService.get();
        this.tagFile = file = fileAccessService.getUserFile(TAG_PATH + File.separator + TAG_XML);
        this.model = tagsModel;
        this.initTags(bundleLicenser);
        this.model.addCategoriesChangedListener(new CategoriesChangedListener(){

            public void categoryRemoved(Category category) {
                TagManager.this.updateTagXMLFile();
            }

            public void categoryAdded(Category category) {
                TagManager.this.updateTagXMLFile();
            }
        });
        this.model.addTagsChangedListener(new TagsChangedListener(){

            public void tagRemoved(Category category, Tag tag) {
                TagManager.this.updateTagXMLFile();
            }

            public void tagAdded(Category category, Tag tag) {
                TagManager.this.updateTagXMLFile();
            }
        });
        this.model.addTagsObjectUpdatedListener(new TagsObjectUpdatedListener(){

            public void tagsObjectRenamed(TagsObject tagsObject, String string) {
                TagManager.this.updateTagXMLFile();
            }

            public void tagsObjectColourChanged(TagsObject tagsObject, Color color) {
                TagManager.this.updateTagXMLFile();
            }
        });
    }

    private void initTags(BundleLicenser bundleLicenser) {
        this.createTagsFile();
        TagXMLLoader tagXMLLoader = new TagXMLLoader();
        Document document = tagXMLLoader.getDocument(this.tagFile);
        String string = this.tagsCodec.decodeVersionOnly(document);
        if (!string.equalsIgnoreCase(CURRENT_VERSION)) {
            this.updateTagsFile();
        }
        this.loadModelFromFile(bundleLicenser);
    }

    private void createTagsFile() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("File " + this.tagFile + " does not exist, creating"));
        }
        if (!this.tagFile.getParentFile().exists() && !this.tagFile.getParentFile().mkdirs()) {
            throw new IllegalArgumentException("Could not create tag dir " + this.tagFile.getParentFile());
        }
        if (!this.tagFile.exists()) {
            this.updateTagsFile();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Created tag file successfully");
        }
    }

    private void updateTagsFile() {
        String string = TAG_XML;
        if (SystemInfo.isAnyMac()) {
            string = "tags_mac.xml";
        }
        try {
            this.writeInputToOutputStream(TagResourcesManager.getResourceAsStream(string), new FileOutputStream(this.tagFile));
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Could not create tag file " + this.tagFile, iOException);
        }
    }

    private void writeInputToOutputStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        for (int i = 1; i <= 2; ++i) {
            try {
                IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
                IOUtils.closeQuietly((InputStream)inputStream);
                IOUtils.closeQuietly((OutputStream)outputStream);
                break;
            }
            catch (IOException iOException) {
                LOGGER.warn((Object)("Attempt " + i + ": couldn't write output stream" + outputStream));
                if (i != 2) continue;
                LOGGER.error((Object)"Couldn't write output stream after 2 attempts.", (Throwable)iOException);
                throw iOException;
            }
        }
    }

    private void updateTagXMLFile() {
        Element element = this.tagsCodec.encode(this.model, CURRENT_VERSION);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.tagFile);
            XMLOutputter xMLOutputter = new XMLOutputter();
            xMLOutputter.output(element, (OutputStream)fileOutputStream);
            IOUtils.closeQuietly((OutputStream)fileOutputStream);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Could not store updated tags file " + this.tagFile, iOException);
        }
    }

    private void loadModelFromFile(BundleLicenser bundleLicenser) {
        TagXMLLoader tagXMLLoader = new TagXMLLoader();
        Document document = tagXMLLoader.getDocument(this.tagFile);
        if (tagXMLLoader.getValidateStatus() != 0 && tagXMLLoader.getValidateStatus() != 1 && tagXMLLoader.getValidateException() != null) {
            Logger.getLogger(TagManager.class).error((Object)"themLoader.getValidateException() is not null", (Throwable)tagXMLLoader.getValidateException());
        }
        this.tagsCodec.decode(document, bundleLicenser);
        this.model.setCategories(this.tagsCodec.getCategoryList());
    }
}

