/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.dozer.sidepanels.tags.model;

import com.mxgraph.mindmap.model.IncompatiblePropertyException;
import com.mxgraph.mindmap.model.mmBranchBoxCell;
import com.mxgraph.mindmap.model.mmBranchCell;
import com.mxgraph.mindmap.model.mmICell;
import com.mxgraph.mindmap.model.mmIStructureCell;
import com.thinkbuzan.dozer.sidepanels.tags.listeners.AppliedTagsChangedListener;
import com.thinkbuzan.dozer.sidepanels.tags.listeners.CategoriesChangedListener;
import com.thinkbuzan.dozer.sidepanels.tags.listeners.SelectedCategoryChangedListener;
import com.thinkbuzan.dozer.sidepanels.tags.listeners.SelectedTagChangedListener;
import com.thinkbuzan.dozer.sidepanels.tags.listeners.TagsChangedListener;
import com.thinkbuzan.dozer.sidepanels.tags.listeners.TagsMovedListener;
import com.thinkbuzan.dozer.sidepanels.tags.listeners.TagsObjectUpdatedListener;
import com.thinkbuzan.dozer.sidepanels.tags.osgi.ServiceManager;
import com.thinkbuzan.gaia.editor.actions.AbstractEditorAction;
import com.thinkbuzan.gaia.editor.actions.ListOperation;
import com.thinkbuzan.gaia.editor.actions.SetPropertyAction;
import com.thinkbuzan.gaia.entities.Category;
import com.thinkbuzan.gaia.entities.Tag;
import com.thinkbuzan.gaia.entities.TagsObject;
import com.thinkbuzan.gaia.model.properties.IProperty;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagsModel {
    public static final String TAGS_KEY = "com.thinkbuzan.gaia.cell.tags";
    public transient List<Category> categories;
    private final transient List<SelectedCategoryChangedListener> selectedCategoryChangedListeners;
    private final transient List<SelectedTagChangedListener> selectedTagChangedListeners;
    private final transient List<CategoriesChangedListener> categoriesChangedListeners;
    private final transient List<TagsChangedListener> tagsChangedListeners;
    private final transient List<AppliedTagsChangedListener> appliedTagsChangedListeners;
    private final transient List<TagsObjectUpdatedListener> tagsObjectUpdatedListeners;
    private final transient List<TagsMovedListener> tagsMovedListeners;
    private final transient ArrayList<mmICell> selectedCells = new ArrayList();
    private final transient HashMap<String, ArrayList<Tag>> cellIdToAppliedTagMap;
    private transient Category selectedCategory;
    private transient Category importedTagsCategory;
    private static final String IMPORTED_TAGS_ID = "importedTags";
    private static final String IMPORTED_TAGS = "Imported";
    private transient boolean filterMode = false;
    private transient HashSet<String> filteredTagIds = new HashSet();
    private static final transient HashMap<String, Tag> tagIndex = new HashMap();

    public TagsModel() {
        this.categories = new ArrayList<Category>();
        this.selectedCategoryChangedListeners = new ArrayList<SelectedCategoryChangedListener>();
        this.selectedTagChangedListeners = new ArrayList<SelectedTagChangedListener>();
        this.categoriesChangedListeners = new ArrayList<CategoriesChangedListener>();
        this.tagsChangedListeners = new ArrayList<TagsChangedListener>();
        this.appliedTagsChangedListeners = new ArrayList<AppliedTagsChangedListener>();
        this.tagsObjectUpdatedListeners = new ArrayList<TagsObjectUpdatedListener>();
        this.tagsMovedListeners = new ArrayList<TagsMovedListener>();
        this.cellIdToAppliedTagMap = new HashMap();
    }

    public boolean isFilterMode() {
        return this.filterMode;
    }

    public void setFilterMode(boolean bl) {
        this.filterMode = bl;
        if (!this.filterMode) {
            this.clearTagFilters();
        }
    }

    private void clearTagFilters() {
        for (Object object : this.filteredTagIds.toArray()) {
            this.toggleTagFiltered(tagIndex.get(object));
        }
    }

    public Category getImportedTagsCategory() {
        if (this.importedTagsCategory == null) {
            Category category = new Category(IMPORTED_TAGS);
            category.setId(IMPORTED_TAGS_ID);
            this.importedTagsCategory = category;
            this.categories.add(this.importedTagsCategory);
            this.fireCategoryAdded(this.importedTagsCategory);
        }
        return this.importedTagsCategory;
    }

    public boolean isTagInUse(Tag tag) {
        List list = ServiceManager.getEditorManager().getCurrentEditorComponent().getFloatingIdeas();
        Stack<mmIStructureCell> stack = new Stack<mmIStructureCell>();
        for (Object object2 : list) {
            stack.push((mmIStructureCell)object2);
        }
        while (!stack.isEmpty()) {
            mmIStructureCell mmIStructureCell2 = (mmIStructureCell)stack.pop();
            for (Object object : mmIStructureCell2.getChildStructures()) {
                stack.push((mmIStructureCell)object);
            }
            try {
                Object object;
                Object object2;
                object2 = mmIStructureCell2.getPropertyList(TAGS_KEY);
                if (object2 == null || object2.size() <= 0) continue;
                object = object2.iterator();
                while (object.hasNext()) {
                    Tag tag2;
                    IProperty iProperty = (IProperty)object.next();
                    if (!(iProperty instanceof Tag) || !(tag2 = (Tag)iProperty).getId().equals(tag.getId())) continue;
                    return true;
                }
            }
            catch (IncompatiblePropertyException incompatiblePropertyException) {
            }
        }
        return false;
    }

    public List<mmICell> getSelectedCells() {
        return this.selectedCells;
    }

    public void setCategories(List<Category> list) {
        this.categories = list;
        for (Category category : this.categories) {
            if (category.getId().equals(IMPORTED_TAGS_ID)) {
                this.importedTagsCategory = category;
            }
            this.fireCategoryAdded(category);
            for (Tag tag : category.getTags()) {
                tagIndex.put(tag.getId(), tag);
                this.fireTagAdded(category, tag);
            }
        }
    }

    public void selectCategory(Category category) {
        if (this.selectedCategory != category) {
            if (this.selectedCategory != null) {
                this.selectedCategory.setSelected(false);
            }
            this.selectedCategory = category;
            if (this.selectedCategory != null) {
                this.selectedCategory.setSelected(true);
            }
            this.fireSelectedCategoryChanged(this.selectedCategory);
        }
    }

    public Category getSelectedCategory() {
        return this.selectedCategory;
    }

    public List<Category> getCategories() {
        return this.categories;
    }

    public void selectTag(Tag tag) {
        tag.setSelected(!tag.isSelected());
        this.fireSelectedTagChanged(tag);
    }

    public void addSelectedCategoryChangedListener(SelectedCategoryChangedListener selectedCategoryChangedListener) {
        if (!this.selectedCategoryChangedListeners.contains(selectedCategoryChangedListener)) {
            this.selectedCategoryChangedListeners.add(selectedCategoryChangedListener);
        }
    }

    public void removeSelectedCategoryChangedListener(SelectedCategoryChangedListener selectedCategoryChangedListener) {
        this.selectedCategoryChangedListeners.remove(selectedCategoryChangedListener);
    }

    public void addSelectedTagChangedListener(SelectedTagChangedListener selectedTagChangedListener) {
        if (!this.selectedTagChangedListeners.contains(selectedTagChangedListener)) {
            this.selectedTagChangedListeners.add(selectedTagChangedListener);
        }
    }

    public void removeSelectedTagChangedListener(SelectedTagChangedListener selectedTagChangedListener) {
        this.selectedTagChangedListeners.remove(selectedTagChangedListener);
    }

    public void addCategoriesChangedListener(CategoriesChangedListener categoriesChangedListener) {
        if (!this.categoriesChangedListeners.contains(categoriesChangedListener)) {
            this.categoriesChangedListeners.add(categoriesChangedListener);
        }
    }

    public void removeCategoriesChangedListener(CategoriesChangedListener categoriesChangedListener) {
        this.categoriesChangedListeners.remove(categoriesChangedListener);
    }

    public void addTagsChangedListener(TagsChangedListener tagsChangedListener) {
        if (!this.tagsChangedListeners.contains(tagsChangedListener)) {
            this.tagsChangedListeners.add(tagsChangedListener);
        }
    }

    public void removeTagsChangedListener(TagsChangedListener tagsChangedListener) {
        this.tagsChangedListeners.remove(tagsChangedListener);
    }

    public void addTagsMovedListener(TagsMovedListener tagsMovedListener) {
        if (!this.tagsMovedListeners.contains(tagsMovedListener)) {
            this.tagsMovedListeners.add(tagsMovedListener);
        }
    }

    public void removeTagsMovedListener(TagsMovedListener tagsMovedListener) {
        this.tagsMovedListeners.remove(tagsMovedListener);
    }

    public void addAppliedTagsChangedListener(AppliedTagsChangedListener appliedTagsChangedListener) {
        if (!this.appliedTagsChangedListeners.contains(appliedTagsChangedListener)) {
            this.appliedTagsChangedListeners.add(appliedTagsChangedListener);
        }
    }

    public void removeTagAppliedChangedListener(AppliedTagsChangedListener appliedTagsChangedListener) {
        this.appliedTagsChangedListeners.remove(appliedTagsChangedListener);
    }

    public void addTagsObjectUpdatedListener(TagsObjectUpdatedListener tagsObjectUpdatedListener) {
        if (!this.tagsObjectUpdatedListeners.contains(tagsObjectUpdatedListener)) {
            this.tagsObjectUpdatedListeners.add(tagsObjectUpdatedListener);
        }
    }

    public void removeTagsObjectUpdatedListener(TagsObjectUpdatedListener tagsObjectUpdatedListener) {
        this.tagsObjectUpdatedListeners.remove(tagsObjectUpdatedListener);
    }

    private void fireSelectedCategoryChanged(Category category) {
        for (SelectedCategoryChangedListener selectedCategoryChangedListener : this.selectedCategoryChangedListeners) {
            selectedCategoryChangedListener.selectedCategoryChanged(category);
        }
    }

    private void fireSelectedTagChanged(Tag tag) {
        for (SelectedTagChangedListener selectedTagChangedListener : this.selectedTagChangedListeners) {
            selectedTagChangedListener.selectedTagChanged(tag);
        }
    }

    private void fireCategoryAdded(Category category) {
        for (CategoriesChangedListener categoriesChangedListener : this.categoriesChangedListeners) {
            categoriesChangedListener.categoryAdded(category);
        }
    }

    private void fireCategoryRemoved(Category category) {
        for (CategoriesChangedListener categoriesChangedListener : this.categoriesChangedListeners) {
            categoriesChangedListener.categoryRemoved(category);
        }
    }

    private void fireTagAdded(Category category, Tag tag) {
        for (TagsChangedListener tagsChangedListener : this.tagsChangedListeners) {
            tagsChangedListener.tagAdded(category, tag);
        }
    }

    private void fireTagMoved(Category category, Category category2, Tag tag) {
        for (TagsMovedListener tagsMovedListener : this.tagsMovedListeners) {
            tagsMovedListener.tagMoved(category, category2, tag);
        }
    }

    private void fireTagRemoved(Category category, Tag tag) {
        for (TagsChangedListener tagsChangedListener : this.tagsChangedListeners) {
            tagsChangedListener.tagRemoved(category, tag);
        }
    }

    public void fireTagApplied(mmICell mmICell2, Tag tag) {
        ArrayList<Object> arrayList = this.cellIdToAppliedTagMap.get(mmICell2.getId());
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        if (!arrayList.contains(tag)) {
            arrayList.add(tag);
        }
        this.cellIdToAppliedTagMap.put(mmICell2.getId(), arrayList);
        for (AppliedTagsChangedListener appliedTagsChangedListener : this.appliedTagsChangedListeners) {
            appliedTagsChangedListener.tagApplied(mmICell2, tag);
        }
    }

    public void fireTagUnapplied(mmICell mmICell2, Tag tag) {
        ArrayList<Tag> arrayList = this.cellIdToAppliedTagMap.get(mmICell2.getId());
        if (arrayList != null && arrayList.size() > 0 && arrayList.contains(tag)) {
            arrayList.remove(tag);
            this.cellIdToAppliedTagMap.put(mmICell2.getId(), arrayList);
        }
        for (AppliedTagsChangedListener appliedTagsChangedListener : this.appliedTagsChangedListeners) {
            appliedTagsChangedListener.tagUnapplied(mmICell2, tag);
        }
    }

    private void fireTagsObjectRenamed(TagsObject tagsObject, String string) {
        for (TagsObjectUpdatedListener tagsObjectUpdatedListener : this.tagsObjectUpdatedListeners) {
            tagsObjectUpdatedListener.tagsObjectRenamed(tagsObject, string);
        }
    }

    private void fireTagsObjectColourChanged(TagsObject tagsObject, Color color) {
        for (TagsObjectUpdatedListener tagsObjectUpdatedListener : this.tagsObjectUpdatedListeners) {
            tagsObjectUpdatedListener.tagsObjectColourChanged(tagsObject, color);
        }
    }

    public Category addCategory(String string) {
        boolean bl = false;
        for (Category category : this.categories) {
            if (!category.getName().equals(string)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            Category category = new Category(string);
            this.categories.add(category);
            this.fireCategoryAdded(category);
            return category;
        }
        return null;
    }

    public void removeCategory(Category category) {
        for (Category category2 : this.categories) {
            if (!category.equals(category2)) continue;
            this.categories.remove(category2);
            if (this.importedTagsCategory != null && category.getId().equals(this.importedTagsCategory.getId())) {
                this.importedTagsCategory = null;
            }
            for (int i = category.getTags().size() - 1; i >= 0; --i) {
                Tag tag = (Tag)category.getTags().get(i);
                this.removeTag(tag);
            }
            this.fireCategoryRemoved(category2);
            break;
        }
    }

    public Tag addTag(String string) {
        return this.addTag(this.selectedCategory, string);
    }

    public void addTag(Category category, Tag tag) {
        boolean bl = false;
        for (Tag tag2 : category.getTags()) {
            if (!tag2.getId().equals(tag.getId())) continue;
            bl = true;
            break;
        }
        if (!bl) {
            category.addTag(tag);
            this.fireTagAdded(category, tag);
        }
    }

    public Tag addTag(Category category, String string) {
        boolean bl = false;
        for (Tag tag : category.getTags()) {
            if (!tag.getName().equals(string)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            Tag tag = new Tag(string, category.getId());
            category.addTag(tag);
            this.fireTagAdded(category, tag);
            return tag;
        }
        return null;
    }

    public void addTag(String string, String string2) {
        for (Category category : this.categories) {
            if (!category.getName().equals(string)) continue;
            this.addTag(category, string2);
            break;
        }
    }

    public void removeTag(Tag tag) {
        this.removeTag(this.selectedCategory, tag);
    }

    public void removeTag(Category category, Tag tag) {
        category.removeTag(tag);
        this.fireTagRemoved(category, tag);
    }

    public void applyTagToCell(mmICell mmICell2, Tag tag) {
        Object object = mmICell2 instanceof mmBranchCell && ((mmBranchCell)mmICell2).getTarget() instanceof mmBranchBoxCell ? (mmBranchBoxCell)((mmBranchCell)mmICell2).getTarget() : mmICell2;
        List<Tag> list = this.getTagProperties((mmICell)object);
        list.add(tag);
        SetPropertyAction setPropertyAction = new SetPropertyAction(object, TAGS_KEY, list);
        ServiceManager.getEditorManager().getCurrentEditorComponent().runAction((AbstractEditorAction)setPropertyAction);
    }

    public List<Tag> getTagProperties(mmICell mmICell2) {
        Object object = mmICell2 instanceof mmBranchCell && ((mmBranchCell)mmICell2).getTarget() instanceof mmBranchBoxCell ? (mmBranchBoxCell)((mmBranchCell)mmICell2).getTarget() : mmICell2;
        ArrayList<Tag> arrayList = new ArrayList<Tag>();
        try {
            List list = object.getPropertyList(TAGS_KEY);
            for (IProperty iProperty : list) {
                Tag tag = (Tag)iProperty;
                Tag tag2 = tagIndex.get(tag.getId());
                if (tag2 == null) {
                    tagIndex.put(tag.getId(), tag);
                    arrayList.add(tag);
                    continue;
                }
                arrayList.add(tag2);
            }
        }
        catch (IncompatiblePropertyException incompatiblePropertyException) {
            // empty catch block
        }
        return arrayList;
    }

    public void unapplyTagFromCell(mmICell mmICell2, Tag tag) {
        Object object = mmICell2 instanceof mmBranchCell && ((mmBranchCell)mmICell2).getTarget() instanceof mmBranchBoxCell ? (mmBranchBoxCell)((mmBranchCell)mmICell2).getTarget() : mmICell2;
        SetPropertyAction setPropertyAction = new SetPropertyAction(object, TAGS_KEY, Arrays.asList(tag), ListOperation.REMOVE);
        ServiceManager.getEditorManager().getCurrentEditorComponent().runAction((AbstractEditorAction)setPropertyAction);
    }

    public void unapplyTagFromCells(List<mmICell> list, Tag tag) {
        for (mmICell mmICell2 : list) {
            this.unapplyTagFromCell(mmICell2, tag);
        }
    }

    public ArrayList<Tag> getTagsAppliedToCell(mmICell mmICell2) {
        List<Tag> list;
        Object object = mmICell2 instanceof mmBranchCell && ((mmBranchCell)mmICell2).getTarget() instanceof mmBranchBoxCell ? (mmBranchBoxCell)((mmBranchCell)mmICell2).getTarget() : mmICell2;
        ArrayList<Object> arrayList = this.cellIdToAppliedTagMap.get(object.getId());
        if (arrayList == null && (list = this.getTagProperties((mmICell)object)) != null) {
            arrayList = new ArrayList(list.size());
            for (Tag tag : list) {
                Tag tag2 = tagIndex.get(tag.getId());
                if (tag2 == null) {
                    tagIndex.put(tag.getId(), tag);
                    arrayList.add(tag);
                    continue;
                }
                if (arrayList.contains(tag2)) continue;
                arrayList.add(tag2);
            }
            this.cellIdToAppliedTagMap.put(object.getId(), arrayList);
        }
        return arrayList;
    }

    public void recolourModelObject(TagsObject tagsObject, Color color) {
        tagsObject.setColour(color);
        this.fireTagsObjectColourChanged(tagsObject, color);
    }

    public boolean renameModelObject(TagsObject tagsObject, String string) {
        Category category;
        boolean bl = false;
        if (tagsObject instanceof Category) {
            for (Category category2 : this.getCategories()) {
                if (!category2.getName().equals(string)) continue;
                bl = true;
                break;
            }
        } else if (tagsObject instanceof Tag && (category = this.getParent((Tag)tagsObject)) != null) {
            for (Tag tag : category.getTags()) {
                if (!tag.getName().equals(string)) continue;
                bl = true;
                break;
            }
        }
        if (!bl) {
            tagsObject.setName(string);
            this.fireTagsObjectRenamed(tagsObject, string);
        }
        return !bl;
    }

    public Category getParent(Tag tag) {
        for (Category category : this.getCategories()) {
            for (Tag tag2 : category.getTags()) {
                if (!tag.getId().equals(tag2.getId())) continue;
                return category;
            }
        }
        return null;
    }

    public void changeModelObjectColour(TagsObject tagsObject, Color color) {
        tagsObject.setColour(color);
        this.fireTagsObjectColourChanged(tagsObject, color);
    }

    public void moveTag(Tag tag, Category category) {
        Category category2 = null;
        for (Category category3 : this.getCategories()) {
            if (!category3.getId().equals(tag.getParentId())) continue;
            category2 = category3;
        }
        if (category2 != null) {
            category2.removeTag(tag);
        }
        category.addTag(tag);
        tag.setParentId(category.getId());
        this.fireTagMoved(category2, category, tag);
    }

    public void toggleTagFiltered(Tag tag) {
        if (tag == null || this.filteredTagIds == null) {
            return;
        }
        if (this.filteredTagIds.contains(tag.getId())) {
            this.unfilterTag(tag);
        } else {
            this.filterTag(tag);
        }
    }

    private void filterTag(Tag tag) {
        this.filteredTagIds.add(tag.getId());
        ServiceManager.getActionManager().runAction("com.thinkbuzan.gaia.actions.AddTagFilterAction", new Object[]{tag});
    }

    private void unfilterTag(Tag tag) {
        this.filteredTagIds.remove(tag.getId());
        ServiceManager.getActionManager().runAction("com.thinkbuzan.gaia.actions.RemoveTagFilterAction", new Object[]{tag});
    }

    public boolean isTagFiltered(Tag tag) {
        return this.filteredTagIds.contains(tag.getId());
    }
}

