/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.dozer.sidepanels.tags.osgi;

import actions.ApplyTagAction;
import com.buzanonline.chaos.action.ActionManager;
import com.buzanonline.chaos.action.IAction;
import com.buzanonline.chaos.preferences.PreferencesService;
import com.jidesoft.utils.SystemInfo;
import com.mxgraph.mindmap.model.mmBranchBoxCell;
import com.mxgraph.mindmap.model.mmICell;
import com.thinkbuzan.chaos.internationalization.I18n;
import com.thinkbuzan.chaos.osgiutilities.service.IServiceListener;
import com.thinkbuzan.chaos.osgiutilities.service.OSGiService;
import com.thinkbuzan.dozer.sidepanels.tags.TagManager;
import com.thinkbuzan.dozer.sidepanels.tags.license.BundleLicenser;
import com.thinkbuzan.dozer.sidepanels.tags.model.TagsModel;
import com.thinkbuzan.dozer.sidepanels.tags.osgi.ServiceManager;
import com.thinkbuzan.dozer.sidepanels.tags.ui.mac.MacTagsSidePanel;
import com.thinkbuzan.gaia.editor.EditorManager;
import com.thinkbuzan.gaia.editor.IEditorComponent;
import com.thinkbuzan.gaia.editor.listeners.EditorListener;
import com.thinkbuzan.gaia.editor.listeners.PropertyListener;
import com.thinkbuzan.gaia.editormodel.filter.FilterService;
import com.thinkbuzan.gaia.entities.Tag;
import com.thinkbuzan.gaia.ui.sidepanels.ISidePanel;
import com.thinkbuzan.gaia.ui.sidepanels.SidePanelManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSGiManager
implements BundleActivator {
    private static final String UNLICENSED_ACTION_ID = "com.thinkbuzan.gaia.actions.CreateUnlicensedActionAction";
    private static final String SHOW_TAGS_PANEL_ACTION_ID = "com.thinkbuzan.gaia.actions.ShowTagsPanelAction";
    private transient TagsModel model;
    private transient TagManager manager;
    private transient IEditorComponent oldEditor;
    private PropertyListener propertyListener;

    public final void start(BundleContext bundleContext) {
        BundleLicenser bundleLicenser = new BundleLicenser(bundleContext);
        I18n i18n = this.getService(bundleContext, I18n.class);
        ServiceManager.setI18nService(i18n);
        ActionManager actionManager = this.getService(bundleContext, ActionManager.class);
        ServiceManager.setActionManager(actionManager);
        if (bundleLicenser.isPanelLicensed()) {
            PreferencesService preferencesService = this.getService(bundleContext, PreferencesService.class);
            ServiceManager.setPreferencesService(preferencesService);
            EditorManager editorManager = this.getService(bundleContext, EditorManager.class);
            ServiceManager.setEditorManager(editorManager);
            ServiceManager.setupPendingServices(bundleContext);
            this.model = new TagsModel();
            this.manager = new TagManager(bundleContext, bundleLicenser, this.model);
            final MacTagsSidePanel macTagsSidePanel = SystemInfo.isAnyMac() ? new MacTagsSidePanel(this.model) : new MacTagsSidePanel(this.model);
            editorManager.addEditorListener(new EditorListener(){

                public void editorChanged(IEditorComponent iEditorComponent) {
                    if (OSGiManager.this.oldEditor != null) {
                        OSGiManager.this.oldEditor.removePropertyListener(OSGiManager.this.getPropertyListener(macTagsSidePanel));
                    }
                    if (iEditorComponent != null) {
                        iEditorComponent.addPropertyListener(OSGiManager.this.getPropertyListener(macTagsSidePanel), null);
                    }
                    OSGiManager.this.oldEditor = iEditorComponent;
                }
            });
            ServiceManager.addFilterServiceListener(new IServiceListener<FilterService>(){

                public void serviceRemoved(FilterService filterService) {
                }

                public void serviceAdded(FilterService filterService) {
                    ServiceManager.setFilterService(filterService);
                }
            });
            this.registerSidePanel(bundleContext, macTagsSidePanel);
            actionManager.addAction((IAction)new ApplyTagAction(this.model));
        } else {
            this.addUnlicensedActions(actionManager);
        }
    }

    private PropertyListener getPropertyListener(final ISidePanel iSidePanel) {
        if (this.propertyListener == null) {
            this.propertyListener = new PropertyListener(){

                public void propertyChanged(String string, Object ... objectArray) {
                    if (string.equals("com.thinkbuzan.gaia.entities.HTMLLabel") || string.equals("com.thinkbuzan.gaia.cell.text")) {
                        ((MacTagsSidePanel)iSidePanel).updateAppliedTagsPanel();
                    } else if (string.equals("com.thinkbuzan.gaia.cell.tags")) {
                        for (Object object : objectArray) {
                            if (!(object instanceof mmICell)) continue;
                            mmICell mmICell2 = ((mmICell)object).getTerminal(false) instanceof mmBranchBoxCell ? (mmICell)((mmICell)object).getTerminal(false) : (mmICell)object;
                            ArrayList<Tag> arrayList = OSGiManager.this.model.getTagsAppliedToCell(mmICell2);
                            List<Tag> list = OSGiManager.this.model.getTagProperties(mmICell2);
                            if (list.size() < arrayList.size()) {
                                ArrayList arrayList2 = new ArrayList();
                                for (Tag tag : arrayList) {
                                    boolean bl = false;
                                    for (Tag tag2 : list) {
                                        if (!tag2.getId().equals(tag.getId())) continue;
                                        bl = true;
                                        break;
                                    }
                                    if (bl) continue;
                                    arrayList2.add(tag);
                                }
                                Iterator iterator = arrayList2.iterator();
                                while (iterator.hasNext()) {
                                    Tag tag;
                                    tag = (Tag)iterator.next();
                                    OSGiManager.this.model.fireTagUnapplied(mmICell2, tag);
                                }
                                continue;
                            }
                            if (arrayList.size() >= list.size()) continue;
                            for (Tag tag : list) {
                                boolean bl = false;
                                for (Tag tag3 : arrayList) {
                                    if (!tag.getId().equals(tag3.getId())) continue;
                                    bl = true;
                                    break;
                                }
                                if (bl) continue;
                                OSGiManager.this.model.fireTagApplied(mmICell2, tag);
                            }
                        }
                    }
                }
            };
        }
        return this.propertyListener;
    }

    private void addActions(EditorManager editorManager, ActionManager actionManager) {
    }

    private void addUnlicensedActions(ActionManager actionManager) {
        actionManager.runAction(UNLICENSED_ACTION_ID, new Object[]{SHOW_TAGS_PANEL_ACTION_ID});
    }

    private void registerSidePanel(BundleContext bundleContext, ISidePanel iSidePanel) {
        OSGiService oSGiService = new OSGiService(bundleContext, SidePanelManager.class);
        ((SidePanelManager)oSGiService.get()).register(iSidePanel);
        oSGiService.close();
    }

    private <SERVICECLASS> SERVICECLASS getService(BundleContext bundleContext, Class<SERVICECLASS> clazz) {
        OSGiService oSGiService = new OSGiService(bundleContext, clazz);
        Object object = oSGiService.get();
        oSGiService.close();
        return (SERVICECLASS)object;
    }

    public void stop(BundleContext bundleContext) {
    }
}

