/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.dozer.sidepanels.tags.osgi;

import com.buzanonline.chaos.action.ActionManager;
import com.buzanonline.chaos.preferences.Preferences;
import com.buzanonline.chaos.preferences.PreferencesService;
import com.thinkbuzan.chaos.internationalization.I18n;
import com.thinkbuzan.chaos.osgiutilities.service.IServiceListener;
import com.thinkbuzan.chaos.osgiutilities.service.OSGiService;
import com.thinkbuzan.chaos.osgiutilities.service.PendingServiceManager;
import com.thinkbuzan.gaia.editor.EditorManager;
import com.thinkbuzan.gaia.editormodel.filter.FilterService;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ServiceManager {
    private static transient I18n i18n;
    private static transient ActionManager actionMan;
    private static transient PreferencesService prefsService;
    private static transient EditorManager editorManager;
    private static transient PendingServiceManager<EditorManager> editorService;
    private static transient PendingServiceManager<FilterService> filterService;
    private static FilterService filterServiceService;

    private ServiceManager() {
    }

    public static void setupPendingServices(BundleContext bundleContext) {
        editorService = new PendingServiceManager(new OSGiService(bundleContext, EditorManager.class));
        filterService = new PendingServiceManager(new OSGiService(bundleContext, FilterService.class));
    }

    public static void closePendingServices() {
        editorService.close();
        filterService.close();
    }

    public static void addEditorManagerServiceListener(IServiceListener<EditorManager> iServiceListener) {
        editorService.addListener(iServiceListener);
    }

    public static void addFilterServiceListener(IServiceListener<FilterService> iServiceListener) {
        filterService.addListener(iServiceListener);
    }

    public static ActionManager getActionManager() {
        return actionMan;
    }

    public static void setActionManager(ActionManager actionManager) {
        actionMan = actionManager;
    }

    public static PreferencesService getPreferencesService() {
        return prefsService;
    }

    public static void setPreferencesService(PreferencesService preferencesService) {
        prefsService = preferencesService;
    }

    public static I18n getI18n() {
        return i18n;
    }

    public static void setI18nService(I18n i18n) {
        ServiceManager.i18n = i18n;
    }

    public static EditorManager getEditorManager() {
        return editorManager;
    }

    public static void setEditorManager(EditorManager editorManager) {
        ServiceManager.editorManager = editorManager;
    }

    public static Preferences getUserPreferences() {
        if (prefsService != null) {
            Preferences preferences = prefsService.getSystemPreferences();
            String string = preferences.getDefault("user.name");
            String string2 = preferences.get("user.name", string);
            return prefsService.getUserPreferences(string2);
        }
        return null;
    }

    public static void setFilterService(FilterService filterService) {
        filterServiceService = filterService;
    }

    public static FilterService getFilterService() {
        return filterServiceService;
    }
}

