/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.dozer.sidepanels.tags.ui;

import com.thinkbuzan.apollo.ui.core.win.component.ModalDialog;
import com.thinkbuzan.apollo.ui.core.win.component.ModalOptionDialog;
import com.thinkbuzan.apollo.ui.core.win.font.ApplicationFont;
import com.thinkbuzan.dozer.sidepanels.tags.model.TagsModel;
import com.thinkbuzan.dozer.sidepanels.tags.osgi.ServiceManager;
import com.thinkbuzan.gaia.ui.MainFrameUtilities;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;

public class AddCategoryDialog
extends ModalDialog {
    private static final long serialVersionUID = 1L;
    private static Dimension DIALOG_SIZE = new Dimension(500, 300);
    private static final String TITLE_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.mapparts.category.add");
    private static final String MESSAGE_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.tags.category.enterName");
    private static final String OK_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.ok");
    private static final String CANCEL_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.cancel");
    private static final String FAILED_TO_ADD = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.tags.category.failedToAdd");
    private static final String CATEGORY = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.template.save.category");
    private static final String ALREADY_EXISTS = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.tags.category.alreadyExists");
    private static final String OK = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.ok");
    public static final Color FONT_COLOUR = Color.decode("#595A5C");
    public static final float SMALL_FONT_SIZE = 18.0f;
    public static final Color LIST_BORDER_COLOUR = Color.decode("#B3B3B3");
    private final transient JTextField textField = new JTextField();

    public AddCategoryDialog(final TagsModel tagsModel) {
        super(MainFrameUtilities.getMainFrame(), TITLE_TEXT, true, true, Dialog.ModalityType.DOCUMENT_MODAL);
        this.textField.setFont(ApplicationFont.getRegularFont((int)0, (float)18.0f));
        this.textField.setForeground(FONT_COLOUR);
        Border border = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        Border border2 = BorderFactory.createLineBorder(LIST_BORDER_COLOUR);
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(border2, border);
        this.textField.setBorder(compoundBorder);
        this.textField.setPreferredSize(new Dimension(300, this.textField.getPreferredSize().height));
        JLabel jLabel = new JLabel(MESSAGE_TEXT, 0);
        jLabel.setFont(ApplicationFont.getRegularFont((int)0, (float)18.0f));
        jLabel.setForeground(FONT_COLOUR);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setOpaque(false);
        JPanel jPanel2 = new JPanel(new FlowLayout(1, 0, 0));
        jPanel2.setOpaque(false);
        jPanel2.add(jLabel);
        JPanel jPanel3 = new JPanel(new FlowLayout(1, 0, 0));
        jPanel3.setOpaque(false);
        jPanel3.add(this.textField);
        this.textField.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10 && !AddCategoryDialog.this.textField.getText().equals("")) {
                    AddCategoryDialog.this.addCategory(tagsModel);
                }
            }
        });
        jPanel.add(jPanel2);
        jPanel.add(jPanel3);
        this.setContent(jPanel);
        this.addConfirmActionListener(OK_TEXT, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!AddCategoryDialog.this.textField.getText().equals("")) {
                    AddCategoryDialog.this.addCategory(tagsModel);
                }
            }
        });
        this.addCancelActionListener(CANCEL_TEXT, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AddCategoryDialog.this.setVisible(false);
            }
        });
        this.setMinimumSize(DIALOG_SIZE);
        this.setMaximumSize(DIALOG_SIZE);
        this.setPreferredSize(DIALOG_SIZE);
        this.setSize(DIALOG_SIZE);
    }

    private void addCategory(TagsModel tagsModel) {
        if (tagsModel.addCategory(this.textField.getText()) != null) {
            this.setVisible(false);
        } else {
            ModalOptionDialog.showMessageDialog((Frame)MainFrameUtilities.getMainFrame(), (String)FAILED_TO_ADD, (String)MessageFormat.format(ALREADY_EXISTS, CATEGORY), (String)OK);
            this.textField.setText("");
        }
    }
}

