/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.dozer.sidepanels.tags.ui;

import com.thinkbuzan.dozer.sidepanels.tags.model.TagsModel;
import com.thinkbuzan.dozer.sidepanels.tags.osgi.ServiceManager;
import com.thinkbuzan.dozer.sidepanels.tags.ui.TagLabel;
import com.thinkbuzan.gaia.entities.Category;
import com.thinkbuzan.gaia.entities.Tag;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class AppliedTagLabel
extends TagLabel {
    private static final String REMOVE_TAG = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.tags.remove");
    private static final String ADD_TAG_TO_CATEGORY = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.tags.addToCategory");
    private static final String MOVE_TAG_TO_CATEGORY = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.tags.moveToCategory");
    private static final long serialVersionUID = 1L;
    private final transient JPopupMenu popup;
    private final transient JMenu categoryMenu = new JMenu(MOVE_TAG_TO_CATEGORY);

    public AppliedTagLabel(TagsModel tagsModel, Tag tag) {
        super(tagsModel, tag, false);
        this.popup = this.createPopup();
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() != 1 && mouseEvent.getButton() == 3) {
                    AppliedTagLabel.this.updatePopup();
                    AppliedTagLabel.this.popup.show(AppliedTagLabel.this, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
    }

    private void updatePopup() {
        this.categoryMenu.removeAll();
        boolean bl = true;
        for (Category category : this.getModel().getCategories()) {
            if (category.getId().equals(((Tag)this.getModelObject()).getParentId())) {
                bl = false;
                continue;
            }
            this.categoryMenu.add(this.getMoveToCategoryMenuItem(category));
        }
        if (bl) {
            this.categoryMenu.setText(ADD_TAG_TO_CATEGORY);
        } else {
            this.categoryMenu.setText(MOVE_TAG_TO_CATEGORY);
        }
    }

    private JMenuItem getMoveToCategoryMenuItem(final Category category) {
        JMenuItem jMenuItem = new JMenuItem(category.getName());
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AppliedTagLabel.this.getModel().moveTag((Tag)AppliedTagLabel.this.getModelObject(), category);
            }
        });
        return jMenuItem;
    }

    private JPopupMenu createPopup() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(this.getUnapplyItem());
        jPopupMenu.add(this.categoryMenu);
        return jPopupMenu;
    }

    private JMenuItem getUnapplyItem() {
        JMenuItem jMenuItem = this.getMenuItem(REMOVE_TAG);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AppliedTagLabel.this.getModel().unapplyTagFromCells(AppliedTagLabel.this.getModel().getSelectedCells(), (Tag)AppliedTagLabel.this.getModelObject());
            }
        });
        return jMenuItem;
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(this.getModelObject().getColour());
        int n = this.getHeight();
        int n2 = this.getWidth();
        graphics2D.fillRoundRect(0, 0, n2 - 1, n - 1, 30, 30);
        graphics2D.setColor(Color.LIGHT_GRAY);
        graphics2D.drawRoundRect(0, 0, n2 - 1, n - 1, 30, 30);
        graphics2D.dispose();
    }
}

