/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.dozer.sidepanels.tags.ui;

import com.thinkbuzan.dozer.sidepanels.tags.model.TagsModel;
import com.thinkbuzan.dozer.sidepanels.tags.osgi.ServiceManager;
import com.thinkbuzan.dozer.sidepanels.tags.ui.CustomLabel;
import com.thinkbuzan.gaia.entities.Tag;
import com.thinkbuzan.gaia.entities.TagsObject;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class TagLabel
extends CustomLabel {
    private static final long serialVersionUID = 1L;
    private static final String DELETE = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.delete");
    private final transient JPopupMenu popup = this.createPopup();

    public TagLabel(TagsModel tagsModel, Tag tag) {
        this(tagsModel, tag, true);
    }

    protected TagLabel(final TagsModel tagsModel, final Tag tag, boolean bl) {
        super(tagsModel, (TagsObject)tag);
        if (bl) {
            this.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getButton() == 1) {
                        if (tagsModel.getSelectedCells().size() > 0) {
                            TagLabel.this.getModel().selectTag(tag);
                        }
                    } else if (mouseEvent.getButton() == 3) {
                        TagLabel.this.popup.show(TagLabel.this, mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            });
        }
    }

    private JPopupMenu createPopup() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(this.getColourItem());
        jPopupMenu.add(this.getRenameItem());
        jPopupMenu.add(this.getDeleteItem());
        return jPopupMenu;
    }

    private JMenuItem getDeleteItem() {
        JMenuItem jMenuItem = this.getMenuItem(DELETE);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TagLabel.this.getModel().removeTag((Tag)TagLabel.this.getModelObject());
            }
        });
        return jMenuItem;
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color color = this.getModelObject().getColour();
        graphics2D.setColor(color);
        int n = this.getHeight();
        int n2 = this.getWidth();
        if (color != null) {
            graphics2D.fillRoundRect(0, 0, n2 - 1, n - 1, 30, 30);
        }
        if (this.getModelObject().isSelected()) {
            graphics2D.setColor(Color.black);
            graphics2D.drawRoundRect(0, 0, n2 - 1, n - 1, 30, 30);
        } else {
            graphics2D.setColor(Color.LIGHT_GRAY);
            graphics2D.drawRoundRect(0, 0, n2 - 1, n - 1, 30, 30);
        }
        graphics2D.dispose();
    }
}

