/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.dozer.sidepanels.tags.ui.handlers;

import com.mxgraph.mindmap.model.mmICell;
import com.mxgraph.mindmap.model.mmIStructureCell;
import com.thinkbuzan.apollo.ui.core.win.component.ModalOptionDialog;
import com.thinkbuzan.chaos.osgiutilities.service.IServiceListener;
import com.thinkbuzan.dozer.sidepanels.tags.model.TagsModel;
import com.thinkbuzan.dozer.sidepanels.tags.osgi.ServiceManager;
import com.thinkbuzan.dozer.sidepanels.tags.ui.AbstractTagsSidePanel;
import com.thinkbuzan.gaia.editor.EditorManager;
import com.thinkbuzan.gaia.editor.IEditorComponent;
import com.thinkbuzan.gaia.editor.listeners.EditorListener;
import com.thinkbuzan.gaia.editor.listeners.ModelListener;
import com.thinkbuzan.gaia.editor.listeners.PropertyListener;
import com.thinkbuzan.gaia.entities.Category;
import com.thinkbuzan.gaia.entities.Tag;
import com.thinkbuzan.gaia.ui.MainFrameUtilities;
import com.thinkbuzan.pascal.services.editor.listeners.IViewListener;
import com.thinkbuzan.pascal.services.editor.listeners.SelectionListener;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EditorHandler
implements EditorListener {
    private static final List<String> PROPERTIES = Arrays.asList("com.thinkbuzan.gaia.cell.tags");
    private transient TagsModel model;
    private transient IEditorComponent currentEditorComp = null;
    private final transient List<SelectionListener> selectionListeners = new ArrayList<SelectionListener>();
    private final transient List<ModelListener> modelListeners = new ArrayList<ModelListener>();
    private final transient List<PropertyListener> propertyListeners = new ArrayList<PropertyListener>();
    private final transient List<IViewListener> viewListeners = new ArrayList<IViewListener>();
    private final transient HashSet<String> promptedImportTags = new HashSet();
    private static final String IMPORT_TAGS_TITLE = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.tags.import");
    private static final String IMPORT_TAGS_MESSAGE = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.tags.import.message");
    private static final String OK = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.yes");
    private static final String CANCEL = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.no");
    private final transient AbstractTagsSidePanel panel;

    public EditorHandler(TagsModel tagsModel, AbstractTagsSidePanel abstractTagsSidePanel) {
        this.model = tagsModel;
        this.panel = abstractTagsSidePanel;
        ServiceManager.addEditorManagerServiceListener(new IServiceListener<EditorManager>(){

            public void serviceRemoved(EditorManager editorManager) {
            }

            public void serviceAdded(EditorManager editorManager) {
                editorManager.addEditorListener((EditorListener)EditorHandler.this);
            }
        });
    }

    public IEditorComponent getCurrentEditorComponent() {
        return this.currentEditorComp;
    }

    public void addPropertyListener(PropertyListener propertyListener) {
        this.propertyListeners.add(propertyListener);
        if (this.currentEditorComp != null) {
            this.currentEditorComp.addPropertyListener(propertyListener, PROPERTIES);
        }
    }

    public void removePropertyListener(PropertyListener propertyListener) {
        this.propertyListeners.remove(propertyListener);
        if (this.currentEditorComp != null) {
            this.currentEditorComp.removePropertyListener(propertyListener);
        }
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.validateSelectionListener(selectionListener);
        this.selectionListeners.add(selectionListener);
        if (this.currentEditorComp != null) {
            this.currentEditorComp.addSelectionListener(selectionListener);
        }
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.validateSelectionListener(selectionListener);
        this.selectionListeners.remove(selectionListener);
        if (this.currentEditorComp != null) {
            this.currentEditorComp.removeSelectionListener(selectionListener);
        }
    }

    public void addModelListener(ModelListener modelListener) {
        this.modelListeners.add(modelListener);
        if (this.currentEditorComp != null) {
            this.currentEditorComp.addModelListener(modelListener);
        }
    }

    public void removeModelListener(ModelListener modelListener) {
        this.modelListeners.remove(modelListener);
        if (this.currentEditorComp != null) {
            this.currentEditorComp.removeModelListener(modelListener);
        }
    }

    private void validateSelectionListener(SelectionListener selectionListener) {
        if (selectionListener == null) {
            throw new IllegalArgumentException("The listener cannot be null");
        }
    }

    public void editorChanged(IEditorComponent iEditorComponent) {
        if (this.currentEditorComp != null) {
            for (SelectionListener selectionListener : this.selectionListeners) {
                this.currentEditorComp.removeSelectionListener(selectionListener);
            }
            for (ModelListener modelListener : this.modelListeners) {
                this.currentEditorComp.removeModelListener(modelListener);
            }
            for (PropertyListener propertyListener : this.propertyListeners) {
                this.currentEditorComp.removePropertyListener(propertyListener);
            }
            for (IViewListener iViewListener : this.viewListeners) {
                this.currentEditorComp.removeViewTypeListener(iViewListener);
            }
        }
        this.currentEditorComp = iEditorComponent;
        if (iEditorComponent == null) {
            for (SelectionListener selectionListener : this.selectionListeners) {
            }
            return;
        }
        for (SelectionListener selectionListener : this.selectionListeners) {
            iEditorComponent.addSelectionListener(selectionListener);
            selectionListener.selectionChanged(iEditorComponent.getAllSelectionCells().toArray());
        }
        for (ModelListener modelListener : this.modelListeners) {
            iEditorComponent.addModelListener(modelListener);
        }
        for (PropertyListener propertyListener : this.propertyListeners) {
            iEditorComponent.addPropertyListener(propertyListener, PROPERTIES);
        }
        Object object = this.viewListeners.iterator();
        while (object.hasNext()) {
            IViewListener iViewListener = (IViewListener)object.next();
            iEditorComponent.addViewTypeListener(iViewListener);
        }
        if (iEditorComponent != null && this.panel != null) {
            this.panel.viewChanged(iEditorComponent.getView().getId());
        }
        if (!this.currentEditorComp.isClosed() && !(object = this.getTagsToImport()).isEmpty()) {
            this.promptToImportTags((List<Tag>)object);
        }
    }

    private List<Tag> getTagsToImport() {
        List<Tag> list = this.getAllTagsInMap();
        ArrayList<Tag> arrayList = new ArrayList<Tag>();
        for (Tag tag : list) {
            if (this.isTagInModel(tag)) continue;
            arrayList.add(tag);
        }
        return arrayList;
    }

    private List<Tag> getAllTagsInMap() {
        ArrayList<Tag> arrayList = new ArrayList<Tag>();
        Stack<Object> stack = new Stack<Object>();
        for (Object object : this.currentEditorComp.getFloatingIdeas()) {
            stack.push(object);
        }
        while (!stack.isEmpty()) {
            Object object;
            mmIStructureCell mmIStructureCell2 = (mmIStructureCell)stack.pop();
            object = this.model.getTagProperties((mmICell)mmIStructureCell2);
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Tag tag = (Tag)iterator.next();
                arrayList.add(tag);
            }
            for (Tag tag : mmIStructureCell2.getChildStructures()) {
                stack.push(tag);
            }
        }
        return arrayList;
    }

    private boolean isTagInModel(Tag tag) {
        for (Category category : this.model.getCategories()) {
            for (Tag tag2 : category.getTags()) {
                if (!tag2.getId().equals(tag.getId())) continue;
                return true;
            }
        }
        return false;
    }

    private void promptToImportTags(List<Tag> list) {
        if (this.promptedImportTags.contains(this.currentEditorComp.getId().toString())) {
            return;
        }
        this.promptedImportTags.add(this.currentEditorComp.getId().toString());
        ModalOptionDialog.SelectedModalOptionDialogOption selectedModalOptionDialogOption = ModalOptionDialog.showAcceptCancelDialog((Frame)MainFrameUtilities.getMainFrame(), (String)IMPORT_TAGS_TITLE, (String)IMPORT_TAGS_MESSAGE, (String)OK, (String)CANCEL);
        if (selectedModalOptionDialogOption == ModalOptionDialog.SelectedModalOptionDialogOption.ACCEPT) {
            this.importTags(list);
        }
    }

    private void importTags(List<Tag> list) {
        for (Tag tag : list) {
            boolean bl = false;
            for (Category category : this.model.getCategories()) {
                if (!category.getId().equals(tag.getParentId())) continue;
                bl = true;
                this.model.addTag(category, tag);
            }
            if (bl) continue;
            tag.setParentId(this.model.getImportedTagsCategory().getId());
            this.model.addTag(this.model.getImportedTagsCategory(), tag);
        }
        this.model.selectCategory(this.model.getImportedTagsCategory());
    }

    public void addViewChangeListner(IViewListener iViewListener) {
        this.viewListeners.add(iViewListener);
        if (this.currentEditorComp != null) {
            this.currentEditorComp.addViewTypeListener(iViewListener);
        }
    }

    public void removeViewChangeListner(IViewListener iViewListener) {
        this.viewListeners.remove(iViewListener);
        if (this.currentEditorComp != null) {
            this.currentEditorComp.removeViewTypeListener(iViewListener);
        }
    }
}

