/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.dozer.sidepanels.tags.ui.mac;

import com.thinkbuzan.dozer.sidepanels.tags.listeners.SelectedCategoryChangedListener;
import com.thinkbuzan.dozer.sidepanels.tags.model.TagsModel;
import com.thinkbuzan.dozer.sidepanels.tags.osgi.ServiceManager;
import com.thinkbuzan.dozer.sidepanels.tags.ui.mac.CustomLabel;
import com.thinkbuzan.gaia.entities.Category;
import com.thinkbuzan.gaia.entities.TagsObject;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class CategoryLabel
extends CustomLabel {
    private static final long serialVersionUID = 1L;
    private static final Color COLOUR_TEXT_SELECTED = Color.decode("#fafeff");
    private static final Color COLOUR_TEXT_DESELECTED = Color.decode("#545454");
    private static final Color COLOUR_BACKGROUND_SELECTED = Color.decode("#009ffd");
    private static final Color COLOUR_BACKGROUND_DESELECTED = Color.decode("#fafafa");
    private static final String DELETE = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.delete");
    private final transient JPopupMenu popup = this.createPopup();

    public CategoryLabel(TagsModel tagsModel, Category category) {
        this(tagsModel, category, true);
    }

    public CategoryLabel(TagsModel tagsModel, final Category category, final boolean bl) {
        super(tagsModel, (TagsObject)category);
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1) {
                    CategoryLabel.this.getModel().selectCategory(category);
                } else if (bl && mouseEvent.getButton() == 3) {
                    CategoryLabel.this.popup.show(CategoryLabel.this, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        tagsModel.addSelectedCategoryChangedListener(new SelectedCategoryChangedListener(){

            public void selectedCategoryChanged(Category category) {
                if (CategoryLabel.this.getModelObject().isSelected()) {
                    CategoryLabel.this.getLabel().setForeground(COLOUR_TEXT_SELECTED);
                } else {
                    CategoryLabel.this.getLabel().setForeground(COLOUR_TEXT_DESELECTED);
                }
                CategoryLabel.this.repaint();
            }
        });
    }

    private JPopupMenu createPopup() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(this.getRenameItem());
        jPopupMenu.add(this.getDeleteItem());
        return jPopupMenu;
    }

    private JMenuItem getDeleteItem() {
        JMenuItem jMenuItem = this.getMenuItem(DELETE);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CategoryLabel.this.getModel().removeCategory((Category)CategoryLabel.this.getModelObject());
            }
        });
        return jMenuItem;
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(this.getModelObject().getColour());
        int n = this.getHeight();
        int n2 = this.getWidth();
        if (this.getModelObject().isSelected()) {
            graphics2D.setColor(COLOUR_BACKGROUND_SELECTED);
        } else {
            graphics2D.setColor(COLOUR_BACKGROUND_DESELECTED);
        }
        graphics2D.fillRoundRect(0, 0, n2 - 1, n - 1, 10, 10);
        graphics2D.dispose();
    }
}

