/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.dozer.sidepanels.tags.ui.mac;

import com.thinkbuzan.apollo.ui.core.win.font.ApplicationFont;
import com.thinkbuzan.dozer.sidepanels.tags.model.TagsModel;
import com.thinkbuzan.dozer.sidepanels.tags.osgi.ServiceManager;
import com.thinkbuzan.dozer.sidepanels.tags.ui.RenameDialog;
import com.thinkbuzan.gaia.entities.TagsObject;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;

public abstract class CustomLabel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final float MENU_ITEM_FONT_SIZE = 12.0f;
    protected static final int ARC = 10;
    private static final int VERTICAL_ADJUSTMENT = 2;
    private static final int PADDING = 7;
    private static final int MAX_CHARS = 10;
    private static final String ELLIPSE = "...";
    private static final String RENAME = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.rename");
    private final transient JLabel label;
    private final transient TagsModel model;
    private final transient TagsObject modelObject;

    public CustomLabel(TagsModel tagsModel, TagsObject tagsObject) {
        this.setOpaque(false);
        this.model = tagsModel;
        this.modelObject = tagsObject;
        String string = this.modelObject.getName().length() > 10 ? this.modelObject.getName().substring(0, 10) + ELLIPSE : this.modelObject.getName();
        this.label = this.getLabel(string);
        this.label.setBorder(BorderFactory.createEmptyBorder(0, 7, 2, 7));
        this.add((Component)this.label, "Center");
        this.setToolTipText(this.getModelObject().getName());
    }

    public TagsModel getModel() {
        return this.model;
    }

    public TagsObject getModelObject() {
        return this.modelObject;
    }

    public JLabel getLabel() {
        return this.label;
    }

    private JLabel getLabel(String string) {
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(ApplicationFont.getRegularFont((int)0, (float)14.0f));
        jLabel.setOpaque(false);
        return jLabel;
    }

    public String getText() {
        return this.label.getText();
    }

    public void setText(String string) {
        String string2 = string.length() > 10 ? string.substring(0, 10) + ELLIPSE : string;
        this.label.setText(string2);
        this.setToolTipText(string);
    }

    protected JMenuItem getMenuItem(String string) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.setOpaque(false);
        jMenuItem.setFont(ApplicationFont.getRegularFont((int)0, (float)12.0f));
        return jMenuItem;
    }

    protected void showRenameDialog(TagsModel tagsModel, TagsObject tagsObject) {
        RenameDialog renameDialog = new RenameDialog(tagsModel, tagsObject);
        renameDialog.setVisible(true);
    }

    protected JMenuItem getRenameItem() {
        JMenuItem jMenuItem = this.getMenuItem(RENAME);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomLabel.this.showRenameDialog(CustomLabel.this.getModel(), CustomLabel.this.getModelObject());
            }
        });
        return jMenuItem;
    }
}

