/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.dozer.sidepanels.tags.ui.mac;

import com.jidesoft.utils.SystemInfo;
import com.mxgraph.mindmap.model.IncompatiblePropertyException;
import com.mxgraph.mindmap.model.mmBranchBoxCell;
import com.mxgraph.mindmap.model.mmBranchCell;
import com.mxgraph.mindmap.model.mmCell;
import com.mxgraph.mindmap.model.mmICell;
import com.thinkbuzan.apollo.ui.core.mac.YosemiteCollapsibleTitledPanel;
import com.thinkbuzan.apollo.ui.core.win.component.CustomScrollBarUI;
import com.thinkbuzan.apollo.ui.core.win.component.LionScrollBarUI;
import com.thinkbuzan.apollo.ui.core.win.font.ApplicationFont;
import com.thinkbuzan.chaos.osgiutilities.service.IServiceListener;
import com.thinkbuzan.dozer.sidepanels.tags.listeners.AppliedTagsChangedListener;
import com.thinkbuzan.dozer.sidepanels.tags.listeners.CategoriesChangedListener;
import com.thinkbuzan.dozer.sidepanels.tags.listeners.SelectedCategoryChangedListener;
import com.thinkbuzan.dozer.sidepanels.tags.listeners.SelectedTagChangedListener;
import com.thinkbuzan.dozer.sidepanels.tags.listeners.TagsChangedListener;
import com.thinkbuzan.dozer.sidepanels.tags.listeners.TagsMovedListener;
import com.thinkbuzan.dozer.sidepanels.tags.listeners.TagsObjectUpdatedListener;
import com.thinkbuzan.dozer.sidepanels.tags.model.TagsModel;
import com.thinkbuzan.dozer.sidepanels.tags.osgi.ServiceManager;
import com.thinkbuzan.dozer.sidepanels.tags.resources.ResourceManager;
import com.thinkbuzan.dozer.sidepanels.tags.ui.AbstractTagsSidePanel;
import com.thinkbuzan.dozer.sidepanels.tags.ui.AddCategoryDialog;
import com.thinkbuzan.dozer.sidepanels.tags.ui.AddTagDialog;
import com.thinkbuzan.dozer.sidepanels.tags.ui.NoButtonComboBox;
import com.thinkbuzan.dozer.sidepanels.tags.ui.WrapLayout;
import com.thinkbuzan.dozer.sidepanels.tags.ui.handlers.EditorHandler;
import com.thinkbuzan.dozer.sidepanels.tags.ui.mac.AppliedLabel;
import com.thinkbuzan.dozer.sidepanels.tags.ui.mac.CategoryLabel;
import com.thinkbuzan.dozer.sidepanels.tags.ui.mac.CustomLabel;
import com.thinkbuzan.dozer.sidepanels.tags.ui.mac.TagLabel;
import com.thinkbuzan.gaia.editor.EditorManager;
import com.thinkbuzan.gaia.editor.IEditorComponent;
import com.thinkbuzan.gaia.editor.actionsupport.ViewTypeSupport;
import com.thinkbuzan.gaia.editor.listeners.EditorListener;
import com.thinkbuzan.gaia.entities.Category;
import com.thinkbuzan.gaia.entities.Tag;
import com.thinkbuzan.gaia.entities.TagsObject;
import com.thinkbuzan.gaia.ui.MainFrameUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.MatteBorder;
import javax.swing.plaf.ScrollBarUI;
import org.jdesktop.swingx.autocomplete.AutoCompleteDecorator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MacTagsSidePanel
extends AbstractTagsSidePanel {
    private static final int PANEL_PREF_HEIGHT = 330;
    private static final String TEXT_CATEGORY_ALL = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.all");
    private static final String TEXT_CATEGORIES = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.dozer.tags.categories");
    private static final String TEXT_TAGS = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.tags");
    private static final String TEXT_SELECTED_BRANCH = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.dozer.tags.selectedBranch");
    private static final String TEXT_ADD_TAG = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.dozer.tags.add");
    private static final String COLOUR_TAGS_CONTENT_PANEL_BACKGROUND = "#edeef3";
    private static final String COLOUR_TAGS_PANEL_SEPARATOR = "#cdcdd9";
    private static final String COLOUR_TAG_PANEL_BUTTON_BACKGROUND = "#fbfaff";
    private static final int INT_COLLAPSIBLE_TITLE_HORIZONTAL_PADDING = 10;
    private static final int INT_COLLAPSIBLE_TITLE_BOTTOM_PADDING = 14;
    private static final int INT_CATEGORY_CONTENT_PANEL_HORIZONTAL_PADDING = 20;
    private static final int INT_CATEGORY_CONTENT_PANEL_VERTICAL_PADDING = 0;
    private static final int INT_APPLIED_TAG_CONTENT_PANEL_HORIZONTAL_PADDING = 10;
    private static final int INT_APPLIED_TAG_CONTENT_PANEL_VERTICAL_PADDING = 5;
    private static final String NO_SELECTION = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.tags.selection.none");
    private static final String NO_TAGS_SELECTION = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.tags.selection.notags");
    private static final String NO_TAGS = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.tags.notags");
    private static final String TAGS = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.tags.selection.tags");
    private static final String NONE = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.none");
    private static final String NO_TEXT = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.tags.noText");
    private transient HashMap<String, CategoryLabel> idToCategoryObjectMap = new HashMap();
    private transient HashMap<String, TagLabel> idToTagObjectMap = new HashMap();
    private transient HashMap<String, AppliedLabel> idToAppliedObjectMap = new HashMap();
    private transient JPanel contentPanel;
    private transient YosemiteCollapsibleTitledPanel categoriesCollapsiblePanel;
    private transient YosemiteCollapsibleTitledPanel tagsCollapsiblePanel;
    private transient YosemiteCollapsibleTitledPanel appliedCollapsiblePanel;
    private transient JPanel categoriesPanel;
    private transient JPanel tagsPanel;
    private transient JPanel appliedPanel;
    private transient JComboBox<String> tagComboBox;
    private transient JLabel noTagsLabel;
    private transient JLabel noSelectionLabel;
    private transient JLabel noTagsOnSelectionLabel;
    private transient JButton addTagButton;
    private transient TagsModel model;
    private transient JScrollPane categoryScroller;
    private transient JScrollPane tagScroller;
    private transient JScrollPane appliedScroller;
    private transient JButton filterButton;
    private static final int PADDING_VERTICAL = 10;
    private static final int PANEL_BOTTOM_BORDER_THICKNESS = 1;
    private static final Color PANEL_BOTTOM_BORDER_COLOUR = Color.decode("#cecece");

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.setSize(800, 600);
        jFrame.setLocationRelativeTo(null);
        jFrame.setDefaultCloseOperation(3);
        TagsModel tagsModel = new TagsModel();
        Category category = tagsModel.addCategory("Design");
        tagsModel.addCategory("Video");
        tagsModel.addCategory("General");
        tagsModel.addCategory("Websites");
        tagsModel.addCategory("Home");
        tagsModel.addTag(category, "Mock-up");
        tagsModel.addTag(category, "Art Boards");
        tagsModel.addTag(category, "Affinity Designer");
        tagsModel.addTag(category, "Affinity Photo");
        tagsModel.addTag(category, "Research");
        tagsModel.addTag(category, "Review");
        tagsModel.addTag(category, "Visuals");
        tagsModel.addTag(category, "Finals");
        MacTagsSidePanel macTagsSidePanel = new MacTagsSidePanel(tagsModel);
        jFrame.setLayout(new BorderLayout());
        jFrame.add((Component)macTagsSidePanel.getComponent(), "East");
        jFrame.setVisible(true);
    }

    private JPanel getWrapLayoutPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        jPanel.setLayout(new WrapLayout(0));
        jPanel.setBorder(BorderFactory.createEmptyBorder());
        return jPanel;
    }

    private JPanel getBorderLayoutPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setOpaque(false);
        return jPanel;
    }

    private JLabel getLabel(String string) {
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(ApplicationFont.getRegularFont((int)0, (float)14.0f));
        jLabel.setForeground(Color.decode("#7e7e86"));
        return jLabel;
    }

    private void updateTagsPanel() {
        int n = MainFrameUtilities.getMainFrame().getSize().height;
        int n2 = n / 5;
        Dimension dimension = this.tagsPanel.getPreferredSize();
        dimension.height = Math.min(n2, dimension.height);
        if (this.tagScroller != null) {
            this.tagScroller.getViewport().setPreferredSize(dimension);
            this.tagScroller.getViewport().setMaximumSize(dimension);
            this.updateUI();
        }
    }

    public MacTagsSidePanel(final TagsModel tagsModel) {
        this.model = tagsModel;
        this.tagComboBox = new NoButtonComboBox<String>();
        AutoCompleteDecorator.decorate(this.tagComboBox);
        this.noTagsLabel = this.getLabel(NO_TAGS);
        this.noSelectionLabel = this.getLabel(NO_SELECTION);
        this.noTagsOnSelectionLabel = this.getLabel(NO_TAGS_SELECTION);
        EditorHandler editorHandler = new EditorHandler(this.model, this);
        editorHandler.addSelectionListener(this);
        editorHandler.addViewChangeListner(this);
        this.categoriesPanel = this.getWrapLayoutPanel();
        JPanel jPanel = this.getBorderLayoutPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 20));
        this.categoryScroller = this.getScroller(this.categoriesPanel);
        jPanel.add(this.categoryScroller);
        this.categoriesCollapsiblePanel = new YosemiteCollapsibleTitledPanel(TEXT_CATEGORIES, (JComponent)jPanel);
        this.categoriesCollapsiblePanel.getTitlePanel().setBorder(BorderFactory.createEmptyBorder(0, 10, 14, 0));
        this.tagsPanel = this.getWrapLayoutPanel();
        this.tagsPanel.addHierarchyListener(new HierarchyListener(){

            public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                MacTagsSidePanel.this.updateTagsPanel();
            }
        });
        JPanel jPanel2 = this.getBorderLayoutPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setOpaque(true);
        jPanel2.setBackground(Color.decode(COLOUR_TAGS_CONTENT_PANEL_BACKGROUND));
        Border border = BorderFactory.createEmptyBorder(5, 10, 5, 10);
        MatteBorder matteBorder = BorderFactory.createMatteBorder(1, 0, 0, 0, PANEL_BOTTOM_BORDER_COLOUR);
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(matteBorder, border);
        jPanel2.setBorder(compoundBorder);
        this.tagScroller = this.getScroller(this.tagsPanel);
        this.tagScroller.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        jPanel2.add(this.tagScroller);
        jPanel2.add(this.getAddTagsPanel());
        this.tagsCollapsiblePanel = new YosemiteCollapsibleTitledPanel(TEXT_TAGS, (JComponent)jPanel2, false);
        this.tagsCollapsiblePanel.getTitlePanel().setBorder(BorderFactory.createEmptyBorder(0, 10, 14, 0));
        this.appliedPanel = this.getWrapLayoutPanel();
        JPanel jPanel3 = this.getBorderLayoutPanel();
        jPanel3.setBorder(compoundBorder);
        this.appliedScroller = this.getScroller(this.appliedPanel);
        jPanel3.add(this.appliedScroller);
        this.appliedCollapsiblePanel = new YosemiteCollapsibleTitledPanel(TEXT_SELECTED_BRANCH, (JComponent)jPanel3, false);
        this.appliedCollapsiblePanel.getTitlePanel().setBorder(BorderFactory.createEmptyBorder(0, 10, 14, 0));
        final Category category = new Category(TEXT_CATEGORY_ALL);
        CategoryLabel categoryLabel = new CategoryLabel(tagsModel, category, false);
        this.idToCategoryObjectMap.put(category.getId(), categoryLabel);
        this.categoriesPanel.add(this.getAddCategoryButton());
        this.categoriesPanel.add(categoryLabel);
        for (Category category2 : this.model.getCategories()) {
            CategoryLabel categoryLabel2 = new CategoryLabel(tagsModel, category2);
            this.idToCategoryObjectMap.put(category2.getId(), categoryLabel2);
            this.categoriesPanel.add(categoryLabel2);
            for (Tag tag : category2.getTags()) {
                category.addTag(tag);
                this.tagComboBox.addItem(tag.getName());
            }
        }
        this.contentPanel = this.createContentPanel();
        this.model.addSelectedCategoryChangedListener(new SelectedCategoryChangedListener(){

            public void selectedCategoryChanged(Category category2) {
                MacTagsSidePanel.this.populateTags(category2);
                MacTagsSidePanel.this.addTagButton.setEnabled(!category2.equals(category));
                MacTagsSidePanel.this.updateTagsPanel();
            }
        });
        this.model.addSelectedTagChangedListener(new SelectedTagChangedListener(){

            public void selectedTagChanged(Tag tag) {
                if (tag.isSelected()) {
                    MacTagsSidePanel.this.addTagToSelectedCells(tag);
                } else {
                    MacTagsSidePanel.this.removeTagFromSelectedCells(tag);
                }
            }
        });
        this.model.addCategoriesChangedListener(new CategoriesChangedListener(){

            public void categoryAdded(Category category) {
                CategoryLabel categoryLabel = new CategoryLabel(tagsModel, category);
                MacTagsSidePanel.this.idToCategoryObjectMap.put(category.getId(), categoryLabel);
                MacTagsSidePanel.this.categoriesPanel.add(categoryLabel);
                MacTagsSidePanel.this.categoriesPanel.revalidate();
                MacTagsSidePanel.this.updateCategoryScroller();
                MacTagsSidePanel.this.categoriesPanel.repaint();
            }

            public void categoryRemoved(Category category) {
                CategoryLabel categoryLabel = (CategoryLabel)MacTagsSidePanel.this.idToCategoryObjectMap.remove(category.getId());
                if (categoryLabel != null) {
                    MacTagsSidePanel.this.categoriesPanel.remove(categoryLabel);
                    MacTagsSidePanel.this.categoriesPanel.revalidate();
                    MacTagsSidePanel.this.categoriesPanel.repaint();
                }
            }
        });
        this.model.addTagsChangedListener(new TagsChangedListener(){

            public void tagAdded(Category category, Tag tag) {
                MacTagsSidePanel.this.populateTags(category);
            }

            public void tagRemoved(Category category, Tag tag) {
                MacTagsSidePanel.this.populateTags(category);
            }
        });
        this.model.addAppliedTagsChangedListener(new AppliedTagsChangedListener(){

            public void tagApplied(mmICell mmICell2, Tag tag) {
                if (!MacTagsSidePanel.this.idToAppliedObjectMap.containsKey(tag.getId())) {
                    AppliedLabel appliedLabel = new AppliedLabel(MacTagsSidePanel.this.model, tag);
                    MacTagsSidePanel.this.idToAppliedObjectMap.put(tag.getId(), appliedLabel);
                    if (MacTagsSidePanel.this.model.getSelectedCells().contains(mmICell2)) {
                        MacTagsSidePanel.this.appliedPanel.add(appliedLabel);
                        MacTagsSidePanel.this.appliedPanel.remove(MacTagsSidePanel.this.noTagsOnSelectionLabel);
                        MacTagsSidePanel.this.updateAppliedScroller();
                        MacTagsSidePanel.this.updateUI();
                    }
                }
            }

            public void tagUnapplied(mmICell mmICell2, Tag tag) {
                AppliedLabel appliedLabel = (AppliedLabel)MacTagsSidePanel.this.idToAppliedObjectMap.remove(tag.getId());
                if (appliedLabel != null) {
                    MacTagsSidePanel.this.appliedPanel.remove(appliedLabel);
                    if (MacTagsSidePanel.this.appliedPanel.getComponentCount() == 0) {
                        MacTagsSidePanel.this.appliedPanel.add(MacTagsSidePanel.this.noTagsOnSelectionLabel);
                    }
                    MacTagsSidePanel.this.updateUI();
                }
            }
        });
        this.model.addTagsObjectUpdatedListener(new TagsObjectUpdatedListener(){

            public void tagsObjectRenamed(TagsObject tagsObject, String string) {
                CustomLabel customLabel = tagsObject instanceof Category ? (CustomLabel)MacTagsSidePanel.this.idToCategoryObjectMap.get(tagsObject.getId()) : (CustomLabel)MacTagsSidePanel.this.idToTagObjectMap.get(tagsObject.getId());
                if (customLabel != null) {
                    customLabel.setText(string);
                }
            }

            public void tagsObjectColourChanged(TagsObject tagsObject, Color color) {
            }
        });
        this.model.addTagsMovedListener(new TagsMovedListener(){

            public void tagMoved(Category category, Category category2, Tag tag) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        MacTagsSidePanel.this.populateTags(MacTagsSidePanel.this.model.getSelectedCategory());
                    }
                });
            }
        });
        if (this.model.getCategories() != null && this.model.getCategories().size() > 0) {
            this.model.selectCategory(this.model.getCategories().get(0));
        }
        ServiceManager.addEditorManagerServiceListener(new IServiceListener<EditorManager>(){

            public void serviceRemoved(EditorManager editorManager) {
            }

            public void serviceAdded(EditorManager editorManager) {
                editorManager.addEditorListener(new EditorListener(){

                    public void editorChanged(IEditorComponent iEditorComponent) {
                        if (MacTagsSidePanel.this.model.isFilterMode()) {
                            MacTagsSidePanel.this.toggleFilterMode();
                        }
                    }
                });
            }
        });
    }

    private void updateAppliedScroller() {
        int n = MainFrameUtilities.getMainFrame().getSize().height;
        int n2 = n / 6;
        Dimension dimension = this.appliedPanel.getPreferredSize();
        dimension.height = Math.min(n2, dimension.height);
        this.appliedScroller.getViewport().setPreferredSize(dimension);
        this.appliedScroller.getViewport().setMaximumSize(dimension);
    }

    private void updateCategoryScroller() {
        int n = MainFrameUtilities.getMainFrame().getSize().height;
        int n2 = n / 6;
        Dimension dimension = this.categoriesPanel.getPreferredSize();
        dimension.height = Math.min(n2, dimension.height);
        this.categoryScroller.getViewport().setPreferredSize(dimension);
        this.categoryScroller.getViewport().setMaximumSize(dimension);
    }

    private void updateUI() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (MacTagsSidePanel.this.contentPanel != null) {
                    MacTagsSidePanel.this.contentPanel.revalidate();
                    MacTagsSidePanel.this.contentPanel.repaint();
                }
            }
        });
    }

    private void stripJButton(JButton jButton) {
        jButton.setBorderPainted(false);
        jButton.setContentAreaFilled(false);
        jButton.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jButton.setFocusPainted(false);
        jButton.setOpaque(false);
        jButton.setFont(ApplicationFont.getRegularFont((int)0, (float)14.0f));
    }

    private JPanel getAddTagsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        jPanel.setLayout(new GridLayout(1, 2));
        Border border = BorderFactory.createEmptyBorder(15, 5, 10, 5);
        MatteBorder matteBorder = BorderFactory.createMatteBorder(1, 0, 0, 0, Color.decode(COLOUR_TAGS_PANEL_SEPARATOR));
        jPanel.setBorder(BorderFactory.createCompoundBorder(matteBorder, border));
        this.addTagButton = new JButton(TEXT_ADD_TAG){
            private static final long serialVersionUID = 1L;

            protected void paintComponent(Graphics graphics) {
                Graphics2D graphics2D = (Graphics2D)graphics.create();
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D.setColor(Color.decode(MacTagsSidePanel.COLOUR_TAG_PANEL_BUTTON_BACKGROUND));
                graphics2D.fillRoundRect(0, 0, this.getWidth() + 7, this.getHeight() - 1, 7, 7);
                graphics2D.setColor(Color.decode("#e0e0e0"));
                graphics2D.drawRoundRect(0, 0, this.getWidth() + 7, this.getHeight() - 1, 7, 7);
                graphics2D.drawLine(this.getWidth() - 1, 0, this.getWidth() - 1, this.getHeight());
                graphics2D.dispose();
                super.paintComponent(graphics);
            }
        };
        this.stripJButton(this.addTagButton);
        this.addTagButton.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        this.addTagButton.setForeground(Color.decode("#7e7e86"));
        this.addTagButton.setIconTextGap(15);
        this.addTagButton.setIcon((Icon)ResourceManager.getRetinaIcon("newtag.png"));
        this.addTagButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MacTagsSidePanel.this.showAddTagDialog();
            }
        });
        this.filterButton = new JButton(this.getFilterOffText()){
            private static final long serialVersionUID = 1L;

            protected void paintComponent(Graphics graphics) {
                Graphics2D graphics2D = (Graphics2D)graphics.create();
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                Color color = MacTagsSidePanel.this.model.isFilterMode() ? Color.decode("#9bdaf2") : Color.decode(MacTagsSidePanel.COLOUR_TAG_PANEL_BUTTON_BACKGROUND);
                graphics2D.setColor(color);
                graphics2D.fillRoundRect(-7, 0, this.getWidth() + 6, this.getHeight() - 1, 7, 7);
                Color color2 = MacTagsSidePanel.this.model.isFilterMode() ? color.darker() : Color.decode("#e0e0e0");
                graphics2D.setColor(color2);
                graphics2D.drawRoundRect(-7, 0, this.getWidth() + 6, this.getHeight() - 1, 7, 7);
                graphics2D.drawLine(0, 0, 0, this.getHeight());
                graphics2D.dispose();
                super.paintComponent(graphics);
            }
        };
        this.stripJButton(this.filterButton);
        this.filterButton.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        this.filterButton.setForeground(Color.decode("#7e7e86"));
        this.filterButton.setIconTextGap(15);
        this.filterButton.setIcon((Icon)ResourceManager.getRetinaIcon("filter.png"));
        this.filterButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MacTagsSidePanel.this.toggleFilterMode();
            }
        });
        jPanel.add(this.addTagButton);
        jPanel.add(this.filterButton);
        return jPanel;
    }

    private void toggleFilterMode() {
        this.model.setFilterMode(!this.model.isFilterMode());
        String string = this.model.isFilterMode() ? this.getFilterOnText() : this.getFilterOffText();
        this.filterButton.setText(string);
        this.tagsPanel.revalidate();
        this.tagsPanel.repaint();
    }

    private boolean isJapanese() {
        String string = Locale.getDefault().toString();
        String string2 = ServiceManager.getPreferencesService().getSystemPreferences().get("user.locale", string);
        return string2.toString().equals(Locale.JAPANESE.toString()) || string2.toString().equals(Locale.JAPAN.toString());
    }

    private String getFilterOnText() {
        String string = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.on");
        if (this.isJapanese()) {
            return string;
        }
        return MessageFormat.format(ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.filter") + ": {0}", string);
    }

    private String getFilterOffText() {
        String string = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.off");
        if (this.isJapanese()) {
            return string;
        }
        return MessageFormat.format(ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.filter") + ": {0}", string);
    }

    private JButton getAddCategoryButton() {
        JButton jButton = new JButton(){
            private static final long serialVersionUID = 1L;

            protected void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                Graphics2D graphics2D = (Graphics2D)graphics.create();
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D.setColor(Color.decode("#e0e0e0"));
                graphics2D.drawRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, 7, 7);
                graphics2D.dispose();
            }
        };
        this.stripJButton(jButton);
        jButton.setIcon((Icon)ResourceManager.getRetinaIcon("plus.png"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MacTagsSidePanel.this.showAddCategoryDialog();
            }
        });
        return jButton;
    }

    private void showAddCategoryDialog() {
        AddCategoryDialog addCategoryDialog = new AddCategoryDialog(this.model);
        addCategoryDialog.setVisible(true);
    }

    private void showAddTagDialog() {
        AddTagDialog addTagDialog = new AddTagDialog(this.model);
        addTagDialog.setVisible(true);
    }

    private void removeTagFromSelectedCells(Tag tag) {
        for (mmICell mmICell2 : this.model.getSelectedCells()) {
            this.model.unapplyTagFromCell(mmICell2, tag);
        }
    }

    private void addTagToSelectedCells(Tag tag) {
        for (mmICell mmICell2 : this.model.getSelectedCells()) {
            this.model.applyTagToCell(mmICell2, tag);
        }
    }

    private void populateTags(Category category) {
        this.tagsPanel.removeAll();
        if (category != null) {
            if (category.getTags().size() == 0) {
                this.tagsPanel.add(this.noTagsLabel);
            } else {
                for (Tag tag : category.getTags()) {
                    TagLabel tagLabel = this.idToTagObjectMap.get(tag.getId());
                    if (tagLabel == null) {
                        tagLabel = new TagLabel(this.model, tag);
                        this.idToTagObjectMap.put(tag.getId(), tagLabel);
                    }
                    this.tagsPanel.add(tagLabel);
                    tag.setSelected(false);
                    for (mmICell mmICell2 : this.model.getSelectedCells()) {
                        ArrayList<Tag> arrayList = this.model.getTagsAppliedToCell(mmICell2);
                        if (arrayList == null) continue;
                        for (Tag tag2 : arrayList) {
                            if (!tag2.getId().equals(tag.getId())) continue;
                            tag.setSelected(true);
                        }
                    }
                }
            }
        }
        this.updateTagsPanel();
        this.updateUI();
    }

    public JComponent getComponent(String string) {
        return null;
    }

    @Override
    public JComponent getComponent() {
        return this.contentPanel;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(300, 330);
    }

    private JPanel createContentPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(true);
        jPanel.setBackground(Color.decode("#fafafa"));
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setOpaque(false);
        jPanel2.setLayout(new BoxLayout(jPanel2, 3));
        jPanel2.add(this.wrap(this.categoriesCollapsiblePanel));
        jPanel2.add(this.wrap(this.tagsCollapsiblePanel));
        jPanel2.add(this.wrap(this.appliedCollapsiblePanel));
        jPanel.add((Component)jPanel2, "North");
        return jPanel;
    }

    private final JPanel wrap(YosemiteCollapsibleTitledPanel yosemiteCollapsibleTitledPanel) {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setOpaque(yosemiteCollapsibleTitledPanel.getContentPanel().isOpaque());
        jPanel.setBackground(yosemiteCollapsibleTitledPanel.getContentPanel().getBackground());
        Border border = BorderFactory.createEmptyBorder(10, 0, 0, 0);
        MatteBorder matteBorder = BorderFactory.createMatteBorder(0, 0, 1, 0, PANEL_BOTTOM_BORDER_COLOUR);
        jPanel.setBorder(BorderFactory.createCompoundBorder(matteBorder, border));
        jPanel.add((Component)yosemiteCollapsibleTitledPanel, "Center");
        return jPanel;
    }

    private JScrollPane getScroller(JComponent jComponent) {
        JScrollPane jScrollPane = new JScrollPane(jComponent);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(20);
        if (SystemInfo.isAnyMac()) {
            jScrollPane.getVerticalScrollBar().setUI((ScrollBarUI)new LionScrollBarUI(jScrollPane.getVerticalScrollBar()));
        } else {
            jScrollPane.getVerticalScrollBar().setUI((ScrollBarUI)new CustomScrollBarUI());
        }
        jScrollPane.setOpaque(false);
        jScrollPane.getViewport().setOpaque(false);
        Dimension dimension = jComponent.getPreferredSize();
        dimension.height = Math.max(dimension.height, 150);
        jScrollPane.getViewport().setPreferredSize(dimension);
        jScrollPane.getViewport().setMaximumSize(dimension);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder());
        jScrollPane.setMinimumSize(new Dimension(1, 1));
        return jScrollPane;
    }

    public void selectionChanged(Object ... objectArray) {
        this.model.getSelectedCells().clear();
        for (Object object : objectArray) {
            if (!(object instanceof mmCell)) continue;
            Object object2 = object instanceof mmBranchCell && ((mmBranchCell)object).getTarget() instanceof mmBranchBoxCell ? (mmBranchBoxCell)((mmBranchCell)object).getTarget() : (mmICell)object;
            this.model.getSelectedCells().add((mmICell)object2);
        }
        for (Category category : this.model.getCategories()) {
            for (Object object : category.getTags()) {
                object.setSelected(false);
            }
        }
        this.updateAppliedTagsPanel();
    }

    private List<Tag> getTagsForSelection() {
        ArrayList<Tag> arrayList = new ArrayList<Tag>();
        boolean bl = true;
        for (mmICell mmICell2 : this.model.getSelectedCells()) {
            ArrayList<Tag> arrayList2 = this.model.getTagsAppliedToCell(mmICell2);
            if (arrayList2 == null) continue;
            if (bl) {
                arrayList.addAll(arrayList2);
                bl = false;
                continue;
            }
            ArrayList<Tag> arrayList3 = new ArrayList<Tag>();
            for (Tag tag : arrayList) {
                tag.setSelected(false);
                boolean bl2 = false;
                for (Tag tag2 : arrayList2) {
                    if (!tag2.getId().equals(tag.getId())) continue;
                    bl2 = true;
                    break;
                }
                if (bl2) continue;
                arrayList3.add(tag);
            }
            for (Tag tag : arrayList3) {
                arrayList.remove(tag);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    public void updateAppliedTagsPanel() {
        List<Tag> list;
        this.appliedPanel.removeAll();
        this.idToAppliedObjectMap.clear();
        if (this.model.getSelectedCells().size() == 0) {
            this.appliedCollapsiblePanel.getTitleLabel().setText(TEXT_SELECTED_BRANCH + " " + NONE);
        } else if (this.model.getSelectedCells().size() == 1) {
            try {
                void var3_5;
                mmICell mmICell2 = this.model.getSelectedCells().get(0);
                if (mmICell2 instanceof mmBranchCell && ((mmBranchCell)mmICell2).getTarget() instanceof mmBranchBoxCell) {
                    mmBranchBoxCell object = (mmBranchBoxCell)((mmBranchCell)mmICell2).getTarget();
                } else {
                    mmICell mmICell3 = mmICell2;
                }
                list = var3_5.getPropertyString("com.thinkbuzan.gaia.cell.text");
                if (list == null || ((String)((Object)list)).equals("null")) {
                    list = NO_TEXT;
                }
                this.appliedCollapsiblePanel.getTitleLabel().setText(TEXT_SELECTED_BRANCH + " " + (String)((Object)list));
            }
            catch (IncompatiblePropertyException incompatiblePropertyException) {}
        } else {
            list = MessageFormat.format(TAGS, this.model.getSelectedCells().size());
            this.appliedCollapsiblePanel.getTitleLabel().setText(TEXT_SELECTED_BRANCH + " " + (String)((Object)list));
        }
        if (this.model.getSelectedCells().size() > 0) {
            list = this.getTagsForSelection();
            if (list.size() == 0) {
                this.appliedPanel.add(this.noTagsOnSelectionLabel);
            } else {
                for (Tag tag : list) {
                    AppliedLabel appliedLabel = new AppliedLabel(this.model, tag);
                    this.appliedPanel.add(appliedLabel);
                    this.idToAppliedObjectMap.put(tag.getId(), appliedLabel);
                    tag.setSelected(true);
                }
            }
        } else {
            this.appliedPanel.add(this.noSelectionLabel);
        }
        this.updateAppliedScroller();
        this.updateUI();
    }

    public void viewChanged(String string) {
        this.filterButton.setEnabled(ViewTypeSupport.MIND_MAP_VIEW_ID.equalsIgnoreCase(string));
    }
}

