/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.dozer.sidepanels.tags.ui.mac;

import com.mxgraph.mindmap.swing.util.mmGraphTransferable;
import com.thinkbuzan.dozer.sidepanels.tags.model.TagsModel;
import com.thinkbuzan.dozer.sidepanels.tags.osgi.ServiceManager;
import com.thinkbuzan.dozer.sidepanels.tags.ui.mac.CustomLabel;
import com.thinkbuzan.gaia.editor.IEditorComponent;
import com.thinkbuzan.gaia.entities.Category;
import com.thinkbuzan.gaia.entities.Tag;
import com.thinkbuzan.gaia.entities.TagsObject;
import com.thinkbuzan.pascal.services.editor.BasicITagTransferable;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.TransferHandler;

public class TagLabel
extends CustomLabel
implements DragGestureListener,
DragSourceListener {
    private static final long serialVersionUID = 1L;
    private static final Color BACKGROUND_COLOUR = Color.white;
    private static final Color EDGE_COLOUR = Color.decode("#c2c5d2");
    private static final String DELETE = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.delete");
    private static final String MOVE_TO = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.move");
    private transient JPopupMenu popup;
    private final transient DragSource dragSource;

    public TagLabel(TagsModel tagsModel, Tag tag) {
        this(tagsModel, tag, true);
    }

    protected TagLabel(final TagsModel tagsModel, final Tag tag, boolean bl) {
        super(tagsModel, (TagsObject)tag);
        this.getLabel().setFont(this.getLabel().getFont().deriveFont(12.0f));
        this.getLabel().setForeground(Color.decode("#82828e"));
        if (bl) {
            this.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getButton() == 1) {
                        if (tagsModel.isFilterMode()) {
                            tagsModel.toggleTagFiltered(tag);
                            TagLabel.this.repaint();
                        } else if (tagsModel.getSelectedCells().size() > 0) {
                            TagLabel.this.getModel().selectTag(tag);
                        }
                    } else if (mouseEvent.getButton() == 3) {
                        TagLabel.this.popup = TagLabel.this.createPopup();
                        TagLabel.this.popup.show(TagLabel.this, mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            });
        }
        this.setTransferHandler(new TransferHandler(){
            private static final long serialVersionUID = 1L;

            public boolean importData(JComponent jComponent, Transferable transferable) {
                return super.importData(jComponent, transferable);
            }

            public Transferable createTransferable(JComponent jComponent) {
                mmGraphTransferable mmGraphTransferable2;
                IEditorComponent iEditorComponent = ServiceManager.getEditorManager().getCurrentEditorComponent();
                if (iEditorComponent == null) {
                    mmGraphTransferable2 = null;
                } else {
                    iEditorComponent.getGraphComponent().getGraph().setSelectionCell(null);
                    iEditorComponent.getGraphComponent().getDndHandler().setIgnoreAutoScroll(true);
                    mmGraphTransferable mmGraphTransferable3 = new mmGraphTransferable(iEditorComponent.getGraphComponent(), null);
                    mmGraphTransferable3.setCustomRichTransferable((Transferable)new BasicITagTransferable((Tag)TagLabel.this.getModelObject()));
                    mmGraphTransferable2 = mmGraphTransferable3;
                }
                return mmGraphTransferable2;
            }
        });
        this.dragSource = new DragSource();
        this.dragSource.createDefaultDragGestureRecognizer(this, 1, this);
    }

    private JPopupMenu createPopup() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(this.getRenameItem());
        jPopupMenu.add(this.getDeleteItem());
        if (this.getModel().getCategories().size() > 1) {
            JMenu jMenu = new JMenu(MOVE_TO);
            boolean bl = false;
            for (Category category : this.getModel().getCategories()) {
                if (category.getTags().contains(this.getModelObject())) continue;
                jMenu.add(this.getCategoryItem(category));
                bl = true;
            }
            if (bl) {
                jPopupMenu.add(jMenu);
            }
        }
        return jPopupMenu;
    }

    private JMenuItem getDeleteItem() {
        JMenuItem jMenuItem = this.getMenuItem(DELETE);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TagLabel.this.getModel().removeTag((Tag)TagLabel.this.getModelObject());
            }
        });
        return jMenuItem;
    }

    private JMenuItem getCategoryItem(final Category category) {
        JMenuItem jMenuItem = this.getMenuItem(category.getName());
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (TagLabel.this.getModelObject() instanceof Tag) {
                    TagLabel.this.getModel().moveTag((Tag)TagLabel.this.getModelObject(), category);
                }
            }
        });
        return jMenuItem;
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n = this.getHeight();
        int n2 = this.getWidth();
        Color color = this.getModel().isFilterMode() ? (this.getModel().isTagInUse((Tag)this.getModelObject()) ? (this.getModel().isTagFiltered((Tag)this.getModelObject()) ? Color.decode("#9bdaf2") : BACKGROUND_COLOUR) : Color.decode("#cccccc")) : BACKGROUND_COLOUR;
        graphics2D.setColor(color);
        graphics2D.fillRoundRect(0, 0, n2 - 1, n - 1, 10, 10);
        graphics2D.setColor(EDGE_COLOUR);
        graphics2D.drawRoundRect(0, 0, n2 - 1, n - 1, 10, 10);
        graphics2D.dispose();
    }

    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragExit(DragSourceEvent dragSourceEvent) {
    }

    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
    }

    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        mmGraphTransferable mmGraphTransferable2 = new mmGraphTransferable(ServiceManager.getEditorManager().getCurrentEditorComponent().getGraphComponent(), null);
        mmGraphTransferable2.setCustomRichTransferable((Transferable)new BasicITagTransferable((Tag)this.getModelObject()));
        this.dragSource.startDrag(dragGestureEvent, DragSource.DefaultCopyDrop, (Transferable)mmGraphTransferable2, this);
    }
}

