/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.dozer.sidepanels.tags.ui.windows;

import com.mxgraph.mindmap.model.mmCell;
import com.mxgraph.mindmap.model.mmICell;
import com.mxgraph.mindmap.model.mmIStructureCell;
import com.thinkbuzan.apollo.ui.core.win.component.CustomScrollBarUI;
import com.thinkbuzan.apollo.ui.core.win.component.ModalOptionDialog;
import com.thinkbuzan.apollo.ui.core.win.font.ApplicationFont;
import com.thinkbuzan.dozer.sidepanels.tags.listeners.AppliedTagsChangedListener;
import com.thinkbuzan.dozer.sidepanels.tags.listeners.CategoriesChangedListener;
import com.thinkbuzan.dozer.sidepanels.tags.listeners.SelectedCategoryChangedListener;
import com.thinkbuzan.dozer.sidepanels.tags.listeners.SelectedTagChangedListener;
import com.thinkbuzan.dozer.sidepanels.tags.listeners.TagsChangedListener;
import com.thinkbuzan.dozer.sidepanels.tags.listeners.TagsMovedListener;
import com.thinkbuzan.dozer.sidepanels.tags.listeners.TagsObjectUpdatedListener;
import com.thinkbuzan.dozer.sidepanels.tags.model.TagsModel;
import com.thinkbuzan.dozer.sidepanels.tags.osgi.ServiceManager;
import com.thinkbuzan.dozer.sidepanels.tags.ui.AbstractTagsSidePanel;
import com.thinkbuzan.dozer.sidepanels.tags.ui.AppliedTagLabel;
import com.thinkbuzan.dozer.sidepanels.tags.ui.CategoryLabel;
import com.thinkbuzan.dozer.sidepanels.tags.ui.CustomLabel;
import com.thinkbuzan.dozer.sidepanels.tags.ui.TagLabel;
import com.thinkbuzan.dozer.sidepanels.tags.ui.WrapLayout;
import com.thinkbuzan.dozer.sidepanels.tags.ui.handlers.EditorHandler;
import com.thinkbuzan.gaia.entities.Category;
import com.thinkbuzan.gaia.entities.Tag;
import com.thinkbuzan.gaia.entities.TagsObject;
import com.thinkbuzan.gaia.ui.MainFrameUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.RenderingHints;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.ScrollBarUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WindowsTagsSidePanel
extends AbstractTagsSidePanel {
    private static final Color BORDER_COLOUR = Color.decode("#C6C6C6");
    private static final int PANEL_PREF_HEIGHT = 330;
    private static final int ROWS = 4;
    private static final int COLS = 1;
    private static final int PADDING = 10;
    private static final float HEADING_FONT_SIZE = 12.0f;
    private static final String REMOVE_INSTANCES_TITLE = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.dozer.tags.removeAll");
    private static final String REMOVE_INSTANCES_MESSAGE = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.dozer.tags.removeOccurrence");
    private static final String OK = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.ok");
    private static final String NO = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.no");
    private static final String NO_SELECTION = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.dozer.tags.noSelection");
    private static final String NO_TAGS = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.tags.selection.notags");
    private static final String TAGS = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.tags.selection.tags");
    private static final String APPLIED_TAGS = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.dozer.tags.appliedTags");
    private static final String TITLE = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.common.tags");
    private static final String ADD_TAG_TO_CATEGORY = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.dozer.tags.addTagToCategory");
    private static final String SELECT_A_CATEGORY = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.dozer.tags.selectCategory");
    private static final String ADD_NEW_CATEGORY = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.dozer.tags.addNewTag");
    private static final String CATEGORIES = ServiceManager.getI18n().getLocalizedText("com.thinkbuzan.i18n.dozer.tags.categories");
    private final transient JLabel appliedTagsMessageLabel;
    private transient HashMap<String, Component> idToUiObjectMap = new HashMap();
    private transient HashMap<String, Component> idToAppliedObjectMap = new HashMap();
    private transient JPanel tagsPanel;
    private transient JPanel existingCategoriesPanel;
    private transient JPanel existingTagsPanel;
    private transient JPanel existingAppliedTagsPanel;
    private transient JTextField tagTextField;
    private transient TagsModel model;

    public WindowsTagsSidePanel(TagsModel tagsModel) {
        this.model = tagsModel;
        this.appliedTagsMessageLabel = this.createAppliedTagsMessageLabel();
        this.createTagsPanel();
        final EditorHandler editorHandler = new EditorHandler(this.model, this);
        editorHandler.addSelectionListener(this);
        this.model.addSelectedCategoryChangedListener(new SelectedCategoryChangedListener(){

            public void selectedCategoryChanged(Category category) {
                if (WindowsTagsSidePanel.this.existingCategoriesPanel != null) {
                    WindowsTagsSidePanel.this.tagTextField.setEditable(category != null);
                    WindowsTagsSidePanel.this.tagTextField.repaint();
                    WindowsTagsSidePanel.this.existingCategoriesPanel.revalidate();
                    WindowsTagsSidePanel.this.existingCategoriesPanel.repaint();
                    WindowsTagsSidePanel.this.populateTags(category);
                }
            }
        });
        this.model.addSelectedTagChangedListener(new SelectedTagChangedListener(){

            public void selectedTagChanged(Tag tag) {
                if (tag.isSelected()) {
                    WindowsTagsSidePanel.this.addTagToSelectedCells(tag);
                } else {
                    WindowsTagsSidePanel.this.removeTagFromSelectedCells(tag);
                }
                WindowsTagsSidePanel.this.existingTagsPanel.repaint();
                WindowsTagsSidePanel.this.updateAppliedTagsPanel();
            }
        });
        this.model.addCategoriesChangedListener(new CategoriesChangedListener(){

            public void categoryAdded(Category category) {
                if (WindowsTagsSidePanel.this.existingCategoriesPanel != null && !WindowsTagsSidePanel.this.idToUiObjectMap.containsKey(category.getId())) {
                    CategoryLabel categoryLabel = new CategoryLabel(WindowsTagsSidePanel.this.model, category);
                    WindowsTagsSidePanel.this.idToUiObjectMap.put(category.getId(), categoryLabel);
                    WindowsTagsSidePanel.this.existingCategoriesPanel.add(categoryLabel);
                    WindowsTagsSidePanel.this.model.selectCategory(category);
                }
            }

            public void categoryRemoved(Category category) {
                Component component = (Component)WindowsTagsSidePanel.this.idToUiObjectMap.remove(category.getId());
                if (component != null) {
                    WindowsTagsSidePanel.this.existingCategoriesPanel.remove(component);
                    WindowsTagsSidePanel.this.existingCategoriesPanel.revalidate();
                    WindowsTagsSidePanel.this.existingCategoriesPanel.repaint();
                    WindowsTagsSidePanel.this.model.selectCategory(null);
                    WindowsTagsSidePanel.this.existingTagsPanel.removeAll();
                    WindowsTagsSidePanel.this.existingTagsPanel.revalidate();
                    WindowsTagsSidePanel.this.existingTagsPanel.repaint();
                }
            }
        });
        this.model.addTagsChangedListener(new TagsChangedListener(){

            public void tagAdded(Category category, Tag tag) {
                if (WindowsTagsSidePanel.this.model.getSelectedCategory() == null || category == null || WindowsTagsSidePanel.this.existingTagsPanel == null) {
                    return;
                }
                if (WindowsTagsSidePanel.this.model.getSelectedCategory().getId().equals(category.getId()) && !WindowsTagsSidePanel.this.idToUiObjectMap.containsKey(tag.getId())) {
                    TagLabel tagLabel = new TagLabel(WindowsTagsSidePanel.this.model, tag);
                    WindowsTagsSidePanel.this.idToUiObjectMap.put(tag.getId(), tagLabel);
                    WindowsTagsSidePanel.this.existingTagsPanel.add(tagLabel);
                    WindowsTagsSidePanel.this.existingTagsPanel.revalidate();
                    WindowsTagsSidePanel.this.existingTagsPanel.repaint();
                }
            }

            public void tagRemoved(Category category, Tag tag) {
                Component component = (Component)WindowsTagsSidePanel.this.idToUiObjectMap.remove(tag.getId());
                if (component != null) {
                    WindowsTagsSidePanel.this.existingTagsPanel.remove(component);
                    WindowsTagsSidePanel.this.existingTagsPanel.revalidate();
                    WindowsTagsSidePanel.this.existingTagsPanel.repaint();
                    if (WindowsTagsSidePanel.this.model.isTagInUse(tag)) {
                        this.promptToRemoveAllInstancesOfTag(tag);
                    }
                }
            }

            private void promptToRemoveAllInstancesOfTag(Tag tag) {
                ModalOptionDialog.SelectedModalOptionDialogOption selectedModalOptionDialogOption = ModalOptionDialog.showAcceptCancelDialog((Frame)MainFrameUtilities.getMainFrame(), (String)REMOVE_INSTANCES_TITLE, (String)MessageFormat.format(REMOVE_INSTANCES_MESSAGE, tag.getName()), (String)OK, (String)NO);
                if (selectedModalOptionDialogOption == ModalOptionDialog.SelectedModalOptionDialogOption.ACCEPT) {
                    this.removeAllInstanceOfTag(tag);
                }
            }

            private void removeAllInstanceOfTag(Tag tag) {
                Stack<mmIStructureCell> stack = new Stack<mmIStructureCell>();
                for (Object object : editorHandler.getCurrentEditorComponent().getFloatingIdeas()) {
                    stack.push((mmIStructureCell)object);
                    for (mmIStructureCell mmIStructureCell2 : object.getChildStructures()) {
                        stack.push(mmIStructureCell2);
                    }
                }
                while (!stack.isEmpty()) {
                    Object object;
                    mmIStructureCell mmIStructureCell3 = (mmIStructureCell)stack.pop();
                    object = WindowsTagsSidePanel.this.model.getTagProperties((mmICell)mmIStructureCell3);
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        mmIStructureCell mmIStructureCell2;
                        mmIStructureCell2 = (Tag)iterator.next();
                        if (!mmIStructureCell2.getId().equals(tag.getId())) continue;
                        WindowsTagsSidePanel.this.model.unapplyTagFromCell((mmICell)mmIStructureCell3, tag);
                    }
                    for (mmIStructureCell mmIStructureCell2 : mmIStructureCell3.getChildStructures()) {
                        stack.push(mmIStructureCell2);
                    }
                }
            }
        });
        this.model.addAppliedTagsChangedListener(new AppliedTagsChangedListener(){

            public void tagApplied(mmICell mmICell2, Tag tag) {
                if (WindowsTagsSidePanel.this.existingAppliedTagsPanel != null && !WindowsTagsSidePanel.this.idToAppliedObjectMap.containsKey(tag.getId())) {
                    AppliedTagLabel appliedTagLabel = new AppliedTagLabel(WindowsTagsSidePanel.this.model, tag);
                    WindowsTagsSidePanel.this.idToAppliedObjectMap.put(tag.getId(), appliedTagLabel);
                    WindowsTagsSidePanel.this.existingAppliedTagsPanel.add(appliedTagLabel);
                    WindowsTagsSidePanel.this.existingAppliedTagsPanel.revalidate();
                    WindowsTagsSidePanel.this.existingAppliedTagsPanel.repaint();
                }
            }

            public void tagUnapplied(mmICell mmICell2, Tag tag) {
                Component component = (Component)WindowsTagsSidePanel.this.idToAppliedObjectMap.remove(tag.getId());
                if (component != null) {
                    WindowsTagsSidePanel.this.existingAppliedTagsPanel.remove(component);
                    WindowsTagsSidePanel.this.existingAppliedTagsPanel.revalidate();
                    WindowsTagsSidePanel.this.existingAppliedTagsPanel.repaint();
                    tag.setSelected(false);
                    WindowsTagsSidePanel.this.existingTagsPanel.repaint();
                    WindowsTagsSidePanel.this.updateAppliedTagsPanel();
                }
            }
        });
        this.model.addTagsObjectUpdatedListener(new TagsObjectUpdatedListener(){

            public void tagsObjectRenamed(TagsObject tagsObject, String string) {
                CustomLabel customLabel = (CustomLabel)WindowsTagsSidePanel.this.idToUiObjectMap.get(tagsObject.getId());
                if (customLabel != null) {
                    customLabel.setText(string);
                    CustomLabel customLabel2 = (CustomLabel)WindowsTagsSidePanel.this.idToAppliedObjectMap.get(tagsObject.getId());
                    if (customLabel2 != null) {
                        customLabel2.setText(string);
                    }
                }
            }

            public void tagsObjectColourChanged(TagsObject tagsObject, Color color) {
                CustomLabel customLabel = (CustomLabel)WindowsTagsSidePanel.this.idToUiObjectMap.get(tagsObject.getId());
                if (customLabel != null) {
                    customLabel.repaint();
                    CustomLabel customLabel2 = (CustomLabel)WindowsTagsSidePanel.this.idToAppliedObjectMap.get(tagsObject.getId());
                    if (customLabel2 != null) {
                        customLabel2.repaint();
                    }
                }
            }
        });
        this.model.addTagsMovedListener(new TagsMovedListener(){

            public void tagMoved(Category category, Category category2, Tag tag) {
                Component component;
                if (category != null && WindowsTagsSidePanel.this.model.getSelectedCategory() != null && WindowsTagsSidePanel.this.model.getSelectedCategory().getId().equals(category.getId()) && (component = (Component)WindowsTagsSidePanel.this.idToUiObjectMap.remove(tag.getId())) != null) {
                    WindowsTagsSidePanel.this.existingTagsPanel.remove(component);
                    WindowsTagsSidePanel.this.existingTagsPanel.revalidate();
                    WindowsTagsSidePanel.this.existingTagsPanel.repaint();
                }
                if (WindowsTagsSidePanel.this.model.getSelectedCategory() != null && WindowsTagsSidePanel.this.model.getSelectedCategory().getId().equals(category2.getId()) && !WindowsTagsSidePanel.this.idToUiObjectMap.containsKey(tag.getId())) {
                    component = new TagLabel(WindowsTagsSidePanel.this.model, tag);
                    WindowsTagsSidePanel.this.idToUiObjectMap.put(tag.getId(), component);
                    WindowsTagsSidePanel.this.existingTagsPanel.add(component);
                    WindowsTagsSidePanel.this.existingTagsPanel.revalidate();
                    WindowsTagsSidePanel.this.existingTagsPanel.repaint();
                }
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (WindowsTagsSidePanel.this.existingCategoriesPanel != null) {
                    WindowsTagsSidePanel.this.existingCategoriesPanel.removeAll();
                    for (Category category : WindowsTagsSidePanel.this.model.getCategories()) {
                        if (WindowsTagsSidePanel.this.idToUiObjectMap.containsKey(category.getId())) continue;
                        CategoryLabel categoryLabel = new CategoryLabel(WindowsTagsSidePanel.this.model, category);
                        WindowsTagsSidePanel.this.idToUiObjectMap.put(category.getId(), categoryLabel);
                        WindowsTagsSidePanel.this.existingCategoriesPanel.add(categoryLabel);
                    }
                }
                if (WindowsTagsSidePanel.this.model.getCategories().size() > 0) {
                    WindowsTagsSidePanel.this.model.selectCategory(WindowsTagsSidePanel.this.model.getCategories().get(0));
                }
            }
        });
    }

    private void removeTagFromSelectedCells(Tag tag) {
        for (mmICell mmICell2 : this.model.getSelectedCells()) {
            this.model.unapplyTagFromCell(mmICell2, tag);
        }
    }

    private void addTagToSelectedCells(Tag tag) {
        for (mmICell mmICell2 : this.model.getSelectedCells()) {
            this.model.applyTagToCell(mmICell2, tag);
        }
    }

    private JLabel createAppliedTagsMessageLabel() {
        JLabel jLabel = new JLabel(NO_SELECTION);
        jLabel.setForeground(Color.LIGHT_GRAY);
        jLabel.setFont(jLabel.getFont().deriveFont(2, 10.0f));
        jLabel.setBorder(BorderFactory.createEmptyBorder(2, 3, 0, 0));
        return jLabel;
    }

    private void populateTags(Category category) {
        this.existingTagsPanel.removeAll();
        if (category != null) {
            for (Tag tag : category.getTags()) {
                TagLabel tagLabel = new TagLabel(this.model, tag);
                this.existingTagsPanel.add(tagLabel);
                this.idToUiObjectMap.put(tag.getId(), tagLabel);
                tag.setSelected(false);
                for (mmICell mmICell2 : this.model.getSelectedCells()) {
                    ArrayList<Tag> arrayList = this.model.getTagsAppliedToCell(mmICell2);
                    if (arrayList == null) continue;
                    for (Tag tag2 : arrayList) {
                        if (!tag2.getId().equals(tag.getId())) continue;
                        tag.setSelected(true);
                    }
                }
            }
        }
        this.existingTagsPanel.revalidate();
        this.existingTagsPanel.repaint();
    }

    public JComponent getComponent(String string) {
        return null;
    }

    @Override
    public JComponent getComponent() {
        return this.createTagsPanel();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(300, 330);
    }

    public JPanel createTagsPanel() {
        if (this.tagsPanel == null) {
            this.tagsPanel = new JPanel();
            this.tagsPanel.setLayout(new BorderLayout());
            this.tagsPanel.setBackground(Color.decode("#fafafa"));
            this.tagsPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            JLabel jLabel = new JLabel(TITLE.toUpperCase());
            jLabel.setFont(ApplicationFont.getRegularFont((int)0, (float)12.0f));
            jLabel.setHorizontalAlignment(0);
            this.tagsPanel.add((Component)jLabel, "North");
            JPanel jPanel = this.createContentPanel();
            this.tagsPanel.add((Component)jPanel, "Center");
        }
        return this.tagsPanel;
    }

    private JPanel createContentPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        jPanel.setLayout(new GridLayout(4, 1));
        JComponent jComponent = this.createCategoriesPanel();
        jPanel.add(jComponent);
        JComponent jComponent2 = this.createTagPanel();
        jPanel.add(jComponent2);
        JPanel jPanel2 = this.createAppliedTagsPanel();
        jPanel.add(jPanel2);
        return jPanel;
    }

    private JPanel createAppliedTagsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder());
        JLabel jLabel = new JLabel(APPLIED_TAGS);
        jLabel.setFont(ApplicationFont.getRegularFont((int)0, (float)12.0f));
        jPanel.add((Component)jLabel, "North");
        JPanel jPanel2 = new JPanel();
        jPanel2.setOpaque(false);
        jPanel2.setLayout(new BorderLayout());
        jPanel2.setBorder(BorderFactory.createLineBorder(BORDER_COLOUR));
        jPanel.add((Component)jPanel2, "Center");
        this.existingAppliedTagsPanel = new JPanel();
        this.existingAppliedTagsPanel.setOpaque(false);
        this.existingAppliedTagsPanel.setBorder(BorderFactory.createEmptyBorder());
        this.existingAppliedTagsPanel.setLayout(new WrapLayout(0));
        JScrollPane jScrollPane = this.getScroller(this.existingAppliedTagsPanel);
        jPanel2.add((Component)this.appliedTagsMessageLabel, "North");
        jPanel2.add((Component)jScrollPane, "Center");
        jPanel.add(Box.createVerticalStrut(10), "South");
        return jPanel;
    }

    private JComponent createCategoriesPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder());
        JLabel jLabel = new JLabel(CATEGORIES);
        jLabel.setFont(ApplicationFont.getRegularFont((int)0, (float)12.0f));
        jPanel.add((Component)jLabel, "North");
        JPanel jPanel2 = new JPanel();
        jPanel2.setOpaque(false);
        jPanel2.setLayout(new BorderLayout());
        jPanel2.setBorder(BorderFactory.createLineBorder(BORDER_COLOUR));
        jPanel.add((Component)jPanel2, "Center");
        final JTextField jTextField = new JTextField(){
            private static final long serialVersionUID = 1L;

            protected void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                if (this.getText().equals("")) {
                    Graphics2D graphics2D = (Graphics2D)graphics.create();
                    graphics2D.setColor(Color.LIGHT_GRAY);
                    graphics2D.setFont(graphics2D.getFont().deriveFont(2, 10.0f));
                    FontMetrics fontMetrics = graphics2D.getFontMetrics();
                    graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                    graphics2D.drawString(ADD_NEW_CATEGORY, this.getInsets().left, fontMetrics.getHeight());
                }
            }
        };
        jTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void removeUpdate(DocumentEvent documentEvent) {
                this.filterCategoryLabels();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                this.filterCategoryLabels();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                this.filterCategoryLabels();
            }

            private void filterCategoryLabels() {
                String string = jTextField.getText();
                for (Component component : WindowsTagsSidePanel.this.existingCategoriesPanel.getComponents()) {
                    if (!(component instanceof CategoryLabel)) continue;
                    CategoryLabel categoryLabel = (CategoryLabel)component;
                    if (!categoryLabel.getText().startsWith(string)) {
                        categoryLabel.setVisible(false);
                        continue;
                    }
                    categoryLabel.setVisible(true);
                }
            }
        });
        jTextField.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                String string;
                if (keyEvent.getKeyChar() == '\n' && !(string = jTextField.getText()).equals("")) {
                    jTextField.setText("");
                    for (Category category : WindowsTagsSidePanel.this.model.getCategories()) {
                        if (!category.getName().equals(string)) continue;
                        WindowsTagsSidePanel.this.model.selectCategory(category);
                        return;
                    }
                    WindowsTagsSidePanel.this.model.addCategory(string);
                }
            }
        });
        jTextField.setOpaque(false);
        jTextField.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 0));
        Dimension dimension = new Dimension(250, 20);
        jTextField.setPreferredSize(dimension);
        this.existingCategoriesPanel = new JPanel();
        this.existingCategoriesPanel.setOpaque(false);
        this.existingCategoriesPanel.setLayout(new WrapLayout(0));
        jPanel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                jTextField.requestFocus();
            }
        });
        JScrollPane jScrollPane = this.getScroller(this.existingCategoriesPanel);
        jScrollPane.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                jTextField.requestFocus();
            }
        });
        jPanel2.add((Component)jTextField, "North");
        jPanel2.add((Component)jScrollPane, "Center");
        jPanel.add(Box.createVerticalStrut(10), "South");
        return jPanel;
    }

    private JScrollPane getScroller(JComponent jComponent) {
        JScrollPane jScrollPane = new JScrollPane(jComponent);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.getVerticalScrollBar().setUI((ScrollBarUI)new CustomScrollBarUI());
        jScrollPane.setOpaque(false);
        jScrollPane.getViewport().setOpaque(false);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder());
        jScrollPane.setMinimumSize(new Dimension(1, 1));
        return jScrollPane;
    }

    private JComponent createTagPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder());
        JLabel jLabel = new JLabel(TITLE);
        jLabel.setFont(ApplicationFont.getRegularFont((int)0, (float)12.0f));
        jPanel.add((Component)jLabel, "North");
        JPanel jPanel2 = new JPanel();
        jPanel2.setOpaque(false);
        jPanel2.setBorder(BorderFactory.createLineBorder(BORDER_COLOUR));
        jPanel2.setLayout(new BorderLayout());
        jPanel.add((Component)jPanel2, "Center");
        this.tagTextField = new JTextField(){
            private static final long serialVersionUID = 1L;

            protected void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                if (this.getText().equals("")) {
                    Graphics2D graphics2D = (Graphics2D)graphics.create();
                    graphics2D.setColor(Color.LIGHT_GRAY);
                    graphics2D.setFont(graphics2D.getFont().deriveFont(2, 10.0f));
                    FontMetrics fontMetrics = graphics2D.getFontMetrics();
                    graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                    String string = WindowsTagsSidePanel.this.model.getSelectedCategory() == null ? SELECT_A_CATEGORY : ADD_TAG_TO_CATEGORY;
                    graphics2D.drawString(string, this.getInsets().left, fontMetrics.getHeight());
                }
            }
        };
        this.tagTextField.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                String string;
                if (keyEvent.getKeyChar() == '\n' && !(string = WindowsTagsSidePanel.this.tagTextField.getText()).equals("")) {
                    WindowsTagsSidePanel.this.tagTextField.setText("");
                    WindowsTagsSidePanel.this.model.addTag(string);
                }
            }
        });
        this.tagTextField.setOpaque(false);
        this.tagTextField.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 0));
        Dimension dimension = new Dimension(250, 20);
        this.tagTextField.setPreferredSize(dimension);
        this.existingTagsPanel = new JPanel();
        this.existingTagsPanel.setOpaque(false);
        this.existingTagsPanel.setBorder(BorderFactory.createEmptyBorder());
        this.existingTagsPanel.setLayout(new WrapLayout(0));
        jPanel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                WindowsTagsSidePanel.this.tagTextField.requestFocus();
            }
        });
        JScrollPane jScrollPane = this.getScroller(this.existingTagsPanel);
        jScrollPane.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                WindowsTagsSidePanel.this.tagTextField.requestFocus();
            }
        });
        jPanel2.add((Component)this.tagTextField, "North");
        jPanel2.add((Component)jScrollPane, "Center");
        jPanel.add(Box.createVerticalStrut(10), "South");
        return jPanel;
    }

    public void selectionChanged(Object ... objectArray) {
        this.model.getSelectedCells().clear();
        for (Object object : objectArray) {
            if (!(object instanceof mmCell)) continue;
            this.model.getSelectedCells().add((mmICell)((mmCell)object));
        }
        for (Category category : this.model.getCategories()) {
            for (Object object : category.getTags()) {
                object.setSelected(false);
            }
        }
        this.updateAppliedTagsPanel();
    }

    private List<Tag> getTagsForSelection() {
        ArrayList<Tag> arrayList = new ArrayList<Tag>();
        boolean bl = true;
        for (mmICell mmICell2 : this.model.getSelectedCells()) {
            ArrayList<Tag> arrayList2 = this.model.getTagsAppliedToCell(mmICell2);
            if (arrayList2 == null) continue;
            if (bl) {
                arrayList.addAll(arrayList2);
                bl = false;
                continue;
            }
            ArrayList<Tag> arrayList3 = new ArrayList<Tag>();
            for (Tag tag : arrayList) {
                tag.setSelected(false);
                boolean bl2 = false;
                for (Tag tag2 : arrayList2) {
                    if (!tag2.getId().equals(tag.getId())) continue;
                    bl2 = true;
                    break;
                }
                if (bl2) continue;
                arrayList3.add(tag);
            }
            for (Tag tag : arrayList3) {
                arrayList.remove(tag);
            }
        }
        return arrayList;
    }

    private void showNoSelectionLabel() {
        this.appliedTagsMessageLabel.setText(NO_SELECTION);
    }

    private void showNoTagsForSelectionLabel() {
        this.appliedTagsMessageLabel.setText(NO_TAGS);
    }

    private void showTagsForSelectionLabel(int n) {
        this.appliedTagsMessageLabel.setText(MessageFormat.format(TAGS, n));
    }

    private void updateAppliedTagsPanel() {
        this.existingAppliedTagsPanel.removeAll();
        if (this.model.getSelectedCells().size() == 0) {
            this.showNoSelectionLabel();
        } else {
            List<Tag> list = this.getTagsForSelection();
            if (list.size() == 0) {
                this.showNoTagsForSelectionLabel();
            } else {
                this.showTagsForSelectionLabel(list.size());
                for (Tag tag : list) {
                    AppliedTagLabel appliedTagLabel = new AppliedTagLabel(this.model, tag);
                    this.existingAppliedTagsPanel.add(appliedTagLabel);
                    this.idToAppliedObjectMap.put(tag.getId(), appliedTagLabel);
                    tag.setSelected(true);
                }
            }
        }
        this.existingTagsPanel.repaint();
        this.existingAppliedTagsPanel.revalidate();
        this.existingAppliedTagsPanel.repaint();
    }

    public void viewChanged(String string) {
    }
}

