/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.dozer.sidepanels.tags.xml;

import com.thinkbuzan.dozer.sidepanels.tags.license.BundleLicenser;
import com.thinkbuzan.dozer.sidepanels.tags.model.TagsModel;
import com.thinkbuzan.gaia.entities.Category;
import com.thinkbuzan.gaia.entities.Tag;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagXMLCodec {
    private static final transient Logger LOGGER = Logger.getLogger(TagXMLCodec.class);
    public static final String TAGS_ROOT = "Tags";
    private static final String NAMESPACE_URL = "http://www.thinkbuzan.org/TagSchema";
    private static final String CATEGORY = "Category";
    private static final String TAGS_VERSION = "TagsVersion";
    private static final String LEGACY_VERSION = "1.0";
    private transient List<Category> categoryList;
    private transient String tagsVersion;
    private final transient Element tagsElement;
    private final transient Namespace ns1 = Namespace.getNamespace((String)"http://www.thinkbuzan.org/TagSchema");

    public TagXMLCodec() {
        this.tagsElement = new Element(TAGS_ROOT, this.ns1);
    }

    public final Element encode(TagsModel tagsModel, String string) {
        this.tagsElement.removeContent();
        this.tagsElement.setAttribute(TAGS_VERSION, string);
        this.addCategories(tagsModel.getCategories());
        return this.tagsElement;
    }

    private void addCategories(List<Category> list) {
        for (Category category : list) {
            Element element = new Element(CATEGORY, this.ns1);
            element.setAttribute("id", category.getId());
            element.setAttribute("name", category.getName());
            element.setAttribute("colour", category.getColourString());
            for (Tag tag : category.getTags()) {
                Element element2 = new Element("Tag");
                element2.setAttribute("id", tag.getId());
                element2.setAttribute("name", tag.getName());
                element2.setAttribute("parentid", tag.getParentId());
                element2.setAttribute("colour", tag.getColourString());
                element.addContent((Content)element2);
            }
            this.tagsElement.addContent((Content)element);
        }
    }

    public final String decodeVersionOnly(Document document) {
        Element element = document.getRootElement();
        Attribute attribute = element.getAttribute(TAGS_VERSION);
        if (attribute != null) {
            return attribute.getValue();
        }
        return LEGACY_VERSION;
    }

    public final void decode(Document document, BundleLicenser bundleLicenser) {
        this.validateConvertTags(document);
        Element element = document.getRootElement();
        this.categoryList = this.generateCategoriesAndTags(element, bundleLicenser);
        this.tagsVersion = this.decodeVersionOnly(document);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"After decoding we have:");
            LOGGER.debug((Object)String.format("tags=%s", this.categoryList));
        }
    }

    private void validateConvertTags(Document document) {
        if (document == null) {
            throw new IllegalArgumentException("Tag doucument can't been null");
        }
    }

    private List<Category> generateCategoriesAndTags(Element element, BundleLicenser bundleLicenser) {
        ArrayList<Category> arrayList = new ArrayList<Category>();
        List list = element.getChildren(CATEGORY, this.ns1);
        for (Element element2 : list) {
            String string;
            String string2;
            String string3;
            Category category = new Category();
            try {
                string3 = element2.getAttributeValue("id");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                string3 = UUID.randomUUID().toString();
            }
            category.setId(string3);
            try {
                string2 = element2.getAttributeValue("name");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                string2 = UUID.randomUUID().toString();
            }
            category.setName(string2);
            try {
                string = element2.getAttributeValue("colour");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                string = "#aaaaaa";
            }
            category.setColour(string);
            for (Object e : element2.getChildren()) {
                String string4 = ((Element)e).getAttributeValue("id");
                String string5 = ((Element)e).getAttributeValue("name");
                String string6 = ((Element)e).getAttributeValue("parentid");
                String string7 = ((Element)e).getAttributeValue("colour");
                Tag tag = new Tag(string5, string6);
                tag.setId(string4);
                tag.setColour(string7);
                category.addTag(tag);
            }
            arrayList.add(category);
        }
        return arrayList;
    }

    public final List<Category> getCategoryList() {
        return this.categoryList;
    }

    public final String getTagsVersion() {
        return this.tagsVersion;
    }
}

