/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.dozer.sidepanels.tags.xml;

import com.thinkbuzan.dozer.sidepanels.tags.xml.TagResourcesManager;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class TagXMLLoader {
    public static final int VALIDATE_PASS = 0;
    public static final int VALIDATE_WARNING = 1;
    public static final int VALIDATE_ERROR = 2;
    public static final int VALIDATE_FATAL_ERROR = 3;
    public static final Logger LOG = Logger.getLogger(TagXMLLoader.class);
    private static final transient String TAG_NAMESPACE = "http://www.thinkbuzan.org/TagSchema";
    private static final transient String SCHEMA_CHECK_FEATURE = "http://apache.org/xml/features/validation/schema";
    private static final transient String SCHEMA_FULL_CHECK_FEATURE = "http://apache.org/xml/features/validation/schema-full-checking";
    private static final transient String SCHEMA_LOCATION_PROPERTY = "http://apache.org/xml/properties/schema/external-schemaLocation";
    private transient int validateStatus = 0;
    private transient SAXParseException validateException = null;

    public final Document getDocument(File file) {
        this.validateGetDocument(file);
        Document document = null;
        try {
            this.initValidateStatus();
            SAXBuilder sAXBuilder = new SAXBuilder(true);
            sAXBuilder.setFeature(SCHEMA_CHECK_FEATURE, true);
            sAXBuilder.setFeature(SCHEMA_FULL_CHECK_FEATURE, true);
            sAXBuilder.setProperty(SCHEMA_LOCATION_PROPERTY, (Object)("http://www.thinkbuzan.org/TagSchema " + TagResourcesManager.getTagXMLSchemaURLPath()));
            ValidateErrorHandler validateErrorHandler = new ValidateErrorHandler();
            sAXBuilder.setErrorHandler((ErrorHandler)validateErrorHandler);
            document = sAXBuilder.build(file);
        }
        catch (JDOMException jDOMException) {
            LOG.error((Object)"Parse tag XML error.", (Throwable)jDOMException);
        }
        catch (IOException iOException) {
            LOG.error((Object)" Read tag XML error.", (Throwable)iOException);
        }
        return document;
    }

    private void validateGetDocument(File file) {
        if (file == null) {
            throw new IllegalArgumentException("Tag file can't be null!");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("Tag file doesn't exist!");
        }
    }

    private void initValidateStatus() {
        this.validateStatus = 0;
        this.validateException = null;
    }

    public final int getValidateStatus() {
        return this.validateStatus;
    }

    public final SAXParseException getValidateException() {
        return this.validateException;
    }

    private class ValidateErrorHandler
    extends DefaultHandler {
        private ValidateErrorHandler() {
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            TagXMLLoader.this.validateStatus = 2;
            TagXMLLoader.this.validateException = sAXParseException;
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            TagXMLLoader.this.validateStatus = 3;
            TagXMLLoader.this.validateException = sAXParseException;
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            TagXMLLoader.this.validateStatus = 1;
            TagXMLLoader.this.validateException = sAXParseException;
        }
    }
}

