/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.pascal.cloud.model;

import com.google.gson.annotations.SerializedName;
import com.thinkbuzan.pascal.services.cloud.CloudDateFormat;
import com.thinkbuzan.pascal.services.cloud.ICloudData;
import java.io.Serializable;
import java.util.Date;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement
@XmlType(name="MapInfo")
public class CloudData
implements Serializable,
ICloudData {
    private static final long serialVersionUID = 6894856067729678235L;
    private static final CloudDateFormat FORMAT = new CloudDateFormat(CloudDateFormat.DATE_FORMAT);
    @SerializedName(value="id")
    private String fileId;
    @SerializedName(value="revision")
    private String revision;
    @SerializedName(value="filename")
    private String name;
    @SerializedName(value="state")
    private String state;
    @SerializedName(value="parent_folder_id")
    private String folderId;
    @SerializedName(value="created_date")
    private String createdDate;
    private Date createdDateObject;
    @SerializedName(value="file_size")
    private String size;
    @SerializedName(value="last_modified")
    private String lastModifiedTime;
    @SerializedName(value="preview_url")
    private String previewUrl;
    @SerializedName(value="hd_preview_url")
    private String hdPreviewUrl;
    @SerializedName(value="public_shared")
    private String publicShared;
    @SerializedName(value="owner")
    private String owner;
    @SerializedName(value="privilege")
    private String privilege;
    @SerializedName(value="private_share_count")
    private String shareCount;
    private Date modifiedDateObject;

    public final Long getRevision() {
        return Long.parseLong(this.revision);
    }

    public final String getMapId() {
        return this.fileId;
    }

    public final String getName() {
        return this.name;
    }

    public final Integer getStatus() {
        return Integer.parseInt(this.state);
    }

    public final String getFolderId() {
        return this.folderId;
    }

    public final Date getCreatedDate() {
        if (this.createdDateObject == null && this.createdDate != null) {
            this.createdDateObject = FORMAT.parseUTC(this.createdDate);
        }
        return this.createdDateObject;
    }

    public final String getFileSize() {
        return this.size;
    }

    public final Date getLastModifiedDate() {
        if (this.modifiedDateObject == null && this.lastModifiedTime != null) {
            this.modifiedDateObject = FORMAT.parseUTC(this.lastModifiedTime);
        }
        return this.modifiedDateObject;
    }

    public final String getOwner() {
        return this.owner;
    }

    public final String getPrivilege() {
        if (this.privilege == null) {
            return "0";
        }
        return this.privilege;
    }

    public final String getPreviewUrl() {
        return this.previewUrl;
    }

    public final String getHdPreviewUrl() {
        return this.hdPreviewUrl;
    }

    public final boolean isPubliclyShared() {
        return this.publicShared != null && Integer.parseInt(this.publicShared) == 1;
    }

    public final boolean isShared() {
        if (this.shareCount == null) {
            return false;
        }
        return Integer.parseInt(this.shareCount) > 0;
    }

    public final void setPubliclyShared(boolean bl) {
        this.publicShared = bl ? "1" : "2";
    }
}

