/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.pascal.cloud.model;

import com.thinkbuzan.pascal.services.cloud.ICloudData;
import com.thinkbuzan.pascal.services.cloud.ILocalData;
import com.thinkbuzan.pascal.services.cloud.ISynchronisationInfo;
import com.thinkbuzan.pascal.services.cloud.OpenState;
import com.thinkbuzan.pascal.services.cloud.SyncState;

public final class MindMapSyncInfo
implements ISynchronisationInfo {
    private boolean selected;
    private String mapName;
    private SyncState syncState;
    private SyncState previousState;
    private final String id;
    private final String folderId;
    private boolean enabledForSync = true;
    private ICloudData cloudData;
    private ILocalData local;
    private OpenState openState;
    private int deletionStatus;
    private String mapSize;

    public MindMapSyncInfo(ICloudData iCloudData, SyncState syncState) {
        this.selected = false;
        this.mapName = iCloudData.getName();
        this.id = iCloudData.getMapId();
        this.folderId = iCloudData.getFolderId();
        this.mapSize = iCloudData.getFileSize();
        this.syncState = syncState;
        this.cloudData = iCloudData;
        this.deletionStatus = iCloudData.getStatus();
    }

    public MindMapSyncInfo(ICloudData iCloudData, ILocalData iLocalData, SyncState syncState) {
        this.mapName = iCloudData.getName();
        this.id = iCloudData.getMapId();
        this.folderId = iCloudData.getFolderId();
        this.mapSize = iCloudData.getFileSize();
        this.syncState = syncState;
        this.cloudData = iCloudData;
        this.local = iLocalData;
        this.deletionStatus = iCloudData.getStatus();
    }

    public void setEnabledForSync(boolean bl) {
        this.enabledForSync = bl;
    }

    public boolean isEnabledForSync() {
        return this.enabledForSync;
    }

    public ILocalData getLocal() {
        return this.local;
    }

    public void setLocal(ILocalData iLocalData) {
        this.local = iLocalData;
    }

    public ICloudData getServer() {
        return this.cloudData;
    }

    public String getMapId() {
        return this.id;
    }

    public String getFolderId() {
        return this.folderId;
    }

    public SyncState getState() {
        return this.syncState;
    }

    public void setState(SyncState syncState) {
        if (this.syncState != SyncState.SYNCHRONISING && this.syncState != SyncState.IGNORE) {
            this.previousState = this.syncState;
        }
        this.syncState = syncState;
    }

    public String getMapName() {
        return this.mapName;
    }

    public void setOpenState(OpenState openState) {
        this.openState = openState;
    }

    public int getDeletionStatus() {
        return this.deletionStatus;
    }

    public SyncState getPreviousState() {
        return this.previousState;
    }
}

