/*
 * Decompiled with CFR 0.152.
 */
package com.thinkbuzan.pascal.cloud.synchroniser;

import com.thinkbuzan.pascal.cloud.files.SortManager;
import com.thinkbuzan.pascal.cloud.files.SortManagerImpl;
import com.thinkbuzan.pascal.cloud.synchroniser.IFileManager;
import com.thinkbuzan.pascal.cloud.synchroniser.LocalFileManagerImpl;
import com.thinkbuzan.pascal.cloud.synchroniser.MapHandler;
import com.thinkbuzan.pascal.services.cloud.ISynchronisationInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMapHandler
implements MapHandler {
    private final Map<String, ISynchronisationInfo> a = new ConcurrentHashMap<String, ISynchronisationInfo>();
    private final transient SortManager b;
    private final transient List<LocalFileManagerImpl.MapListener> c;
    private final IFileManager d;

    public AbstractMapHandler(IFileManager iFileManager) {
        this.d = iFileManager;
        this.b = new SortManagerImpl();
        this.c = new ArrayList<LocalFileManagerImpl.MapListener>();
    }

    @Override
    public final List<ISynchronisationInfo> getSafeSyncStates() {
        return new CopyOnWriteArrayList<ISynchronisationInfo>(this.a.values());
    }

    @Override
    public final List<ISynchronisationInfo> getSyncStates() {
        return new ArrayList<ISynchronisationInfo>(this.a.values());
    }

    @Override
    public final void removeFromMaps(String string) {
        this.a.remove(string);
        this.mapsUpdated();
    }

    @Override
    public final void addToMaps(ISynchronisationInfo iSynchronisationInfo) {
        this.a.put(iSynchronisationInfo.getMapId(), iSynchronisationInfo);
        this.mapsUpdated();
    }

    public abstract void mapsUpdated();

    @Override
    public final void addMapListener(LocalFileManagerImpl.MapListener mapListener) {
        this.c.add(mapListener);
    }

    public final List<LocalFileManagerImpl.MapListener> getMapListeners() {
        return this.c;
    }

    protected final SortManager a() {
        return this.b;
    }

    @Override
    public final ISynchronisationInfo getMap(String string) {
        if (string != null) {
            return this.a.get(string);
        }
        return null;
    }

    @Override
    public final void clearMaps() {
        this.a.clear();
    }

    @Override
    public final ISynchronisationInfo getMapFromSaveLocation(String string) {
        boolean bl = LocalFileManagerImpl.d;
        if (string != null) {
            for (ISynchronisationInfo iSynchronisationInfo : this.getSafeSyncStates()) {
                File file = this.d.getFile(iSynchronisationInfo);
                if (file != null && file.getAbsolutePath().contains(string)) {
                    return iSynchronisationInfo;
                }
                if (!bl) continue;
            }
        }
        return null;
    }
}

